/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.entity.Hanging;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.slf4j.Logger;

public abstract class BlockAttachedEntity
extends Entity {
    private static final Logger c = LogUtils.getLogger();
    private int d;
    protected BlockPosition b;

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> entitytypes, World world) {
        super(entitytypes, world);
    }

    protected BlockAttachedEntity(EntityTypes<? extends BlockAttachedEntity> entitytypes, World world, BlockPosition blockposition) {
        this(entitytypes, world);
        this.b = blockposition;
    }

    protected abstract void p();

    @Override
    public void l() {
        if (!this.dO().B) {
            this.ax();
            if (this.d++ == this.dO().spigotConfig.hangingTickFrequency) {
                this.d = 0;
                if (!this.dJ() && !this.s()) {
                    IBlockData material = this.dO().a_(this.do());
                    HangingBreakEvent.RemoveCause cause = !material.i() ? HangingBreakEvent.RemoveCause.OBSTRUCTION : HangingBreakEvent.RemoveCause.PHYSICS;
                    HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), cause);
                    this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                    if (this.dJ() || event.isCancelled()) {
                        return;
                    }
                    this.discard(EntityRemoveEvent.Cause.DROP);
                    this.b((Entity)null);
                }
            }
        }
    }

    public abstract boolean s();

    @Override
    public boolean bA() {
        return true;
    }

    @Override
    public boolean u(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return !this.dO().a(entityhuman, this.b) ? true : this.a(this.dP().a(entityhuman), 0.0f);
        }
        return false;
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        if (this.b(damagesource)) {
            return false;
        }
        if (!this.dJ() && !this.dO().B) {
            Entity damager;
            Entity entity = damager = damagesource.b() ? damagesource.c() : damagesource.d();
            Object event = damager != null ? new HangingBreakByEntityEvent((Hanging)this.getBukkitEntity(), (org.bukkit.entity.Entity)damager.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.ENTITY) : new HangingBreakEvent((Hanging)this.getBukkitEntity(), damagesource.a(DamageTypeTags.l) ? HangingBreakEvent.RemoveCause.EXPLOSION : HangingBreakEvent.RemoveCause.DEFAULT);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dJ() || event.isCancelled()) {
                return true;
            }
            this.ap();
            this.bw();
            this.b(damagesource.d());
        }
        return true;
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        if (!this.dO().B && !this.dJ() && vec3d.g() > 0.0) {
            if (this.dJ()) {
                return;
            }
            HangingBreakEvent event = new HangingBreakEvent((Hanging)this.getBukkitEntity(), HangingBreakEvent.RemoveCause.PHYSICS);
            this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
            if (this.dJ() || event.isCancelled()) {
                return;
            }
            this.ap();
            this.b((Entity)null);
        }
    }

    @Override
    public void j(double d0, double d1, double d2) {
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound nbttagcompound, boolean includeAll) {
        if (includeAll) {
            this.b(nbttagcompound);
        }
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition = this.t();
        nbttagcompound.a("TileX", blockposition.u());
        nbttagcompound.a("TileY", blockposition.v());
        nbttagcompound.a("TileZ", blockposition.w());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        BlockPosition blockposition = new BlockPosition(nbttagcompound.h("TileX"), nbttagcompound.h("TileY"), nbttagcompound.h("TileZ"));
        if (!blockposition.a(this.do(), 16.0)) {
            c.error("Block-attached entity at invalid position: {}", (Object)blockposition);
        } else {
            this.b = blockposition;
        }
    }

    public abstract void b(@Nullable Entity var1);

    @Override
    protected boolean bC() {
        return false;
    }

    @Override
    public void a_(double d0, double d1, double d2) {
        this.b = BlockPosition.a(d0, d1, d2);
        this.p();
        this.av = true;
    }

    public BlockPosition t() {
        return this.b;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
    }

    @Override
    public void i_() {
    }
}

