/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import com.mojang.logging.LogUtils;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.BlockConcretePowder;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.slf4j.Logger;

public class EntityFallingBlock
extends Entity {
    private static final Logger g = LogUtils.getLogger();
    private IBlockData h = Blocks.I.o();
    public int b;
    public boolean c = true;
    public boolean i;
    public boolean j;
    public int k = 40;
    public float l;
    @Nullable
    public NBTTagCompound d;
    public boolean e;
    protected static final DataWatcherObject<BlockPosition> f = DataWatcher.a(EntityFallingBlock.class, DataWatcherRegistry.o);

    public EntityFallingBlock(EntityTypes<? extends EntityFallingBlock> entitytypes, World world) {
        super(entitytypes, world);
    }

    private EntityFallingBlock(World world, double d0, double d1, double d2, IBlockData iblockdata) {
        this((EntityTypes<? extends EntityFallingBlock>)EntityTypes.O, world);
        this.h = iblockdata;
        this.J = true;
        this.a_(d0, d1, d2);
        this.i(Vec3D.b);
        this.L = d0;
        this.M = d1;
        this.N = d2;
        this.a(this.do());
    }

    public static EntityFallingBlock a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        return EntityFallingBlock.fall(world, blockposition, iblockdata, CreatureSpawnEvent.SpawnReason.DEFAULT);
    }

    public static EntityFallingBlock fall(World world, BlockPosition blockposition, IBlockData iblockdata, CreatureSpawnEvent.SpawnReason spawnReason) {
        EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)blockposition.u() + 0.5, blockposition.v(), (double)blockposition.w() + 0.5, iblockdata.b(BlockProperties.C) ? (IBlockData)iblockdata.a(BlockProperties.C, false) : iblockdata);
        if (!CraftEventFactory.callEntityChangeBlockEvent(entityfallingblock, blockposition, iblockdata.u().g())) {
            return entityfallingblock;
        }
        world.a(blockposition, iblockdata.u().g(), 3);
        world.addFreshEntity(entityfallingblock, spawnReason);
        return entityfallingblock;
    }

    @Override
    public boolean cu() {
        return false;
    }

    public void a(BlockPosition blockposition) {
        this.ao.a(f, blockposition);
    }

    public BlockPosition p() {
        return this.ao.a(f);
    }

    @Override
    protected Entity.MovementEmission bc() {
        return Entity.MovementEmission.a;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(f, BlockPosition.c);
    }

    @Override
    public boolean bA() {
        return !this.dJ();
    }

    @Override
    protected double aZ() {
        return 0.04;
    }

    @Override
    public void l() {
        if (this.h.i()) {
            this.discard(EntityRemoveEvent.Cause.DESPAWN);
        } else {
            Block block = this.h.b();
            ++this.b;
            this.bb();
            this.a(EnumMoveType.a, this.dr());
            this.bP();
            if (!this.dO().B && (this.bE() || this.e)) {
                MovingObjectPositionBlock movingobjectpositionblock;
                BlockPosition blockposition = this.do();
                boolean flag = this.h.b() instanceof BlockConcretePowder;
                boolean flag1 = flag && this.dO().b_(blockposition).a(TagsFluid.a);
                double d0 = this.dr().g();
                if (flag && d0 > 1.0 && (movingobjectpositionblock = this.dO().a(new RayTrace(new Vec3D(this.L, this.M, this.N), this.dm(), RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.b, this))).c() != MovingObjectPosition.EnumMovingObjectType.a && this.dO().b_(movingobjectpositionblock.a()).a(TagsFluid.a)) {
                    blockposition = movingobjectpositionblock.a();
                    flag1 = true;
                }
                if (!this.aF() && !flag1) {
                    if (!(this.dO().B || (this.b <= 100 || blockposition.v() > this.dO().I_() && blockposition.v() <= this.dO().am()) && this.b <= 600)) {
                        if (this.c && this.dO().ab().b(GameRules.i)) {
                            this.a(block);
                        }
                        this.discard(EntityRemoveEvent.Cause.DROP);
                    }
                } else {
                    IBlockData iblockdata = this.dO().a_(blockposition);
                    this.i(this.dr().d(0.7, -0.5, 0.7));
                    if (!iblockdata.a(Blocks.bQ)) {
                        if (!this.i) {
                            boolean flag4;
                            boolean flag2 = iblockdata.a(new BlockActionContextDirectional(this.dO(), blockposition, EnumDirection.a, ItemStack.l, EnumDirection.b));
                            boolean flag3 = BlockFalling.m(this.dO().a_(blockposition.e())) && (!flag || !flag1);
                            boolean bl = flag4 = this.h.a((IWorldReader)this.dO(), blockposition) && !flag3;
                            if (flag2 && flag4) {
                                if (this.h.b(BlockProperties.C) && this.dO().b_(blockposition).a() == FluidTypes.c) {
                                    this.h = (IBlockData)this.h.a(BlockProperties.C, true);
                                }
                                if (!CraftEventFactory.callEntityChangeBlockEvent(this, blockposition, this.h)) {
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    return;
                                }
                                if (this.dO().a(blockposition, this.h, 3)) {
                                    TileEntity tileentity;
                                    ((WorldServer)this.dO()).l().a.a(this, new PacketPlayOutBlockChange(blockposition, this.dO().a_(blockposition)));
                                    this.discard(EntityRemoveEvent.Cause.DESPAWN);
                                    if (block instanceof Fallable) {
                                        ((Fallable)((Object)block)).a(this.dO(), blockposition, this.h, iblockdata, this);
                                    }
                                    if (this.d != null && this.h.t() && (tileentity = this.dO().c_(blockposition)) != null) {
                                        NBTTagCompound nbttagcompound = tileentity.d(this.dO().H_());
                                        for (String s2 : this.d.e()) {
                                            nbttagcompound.a(s2, this.d.c(s2).d());
                                        }
                                        try {
                                            tileentity.c(nbttagcompound, this.dO().H_());
                                        }
                                        catch (Exception exception) {
                                            g.error("Failed to load block entity from falling block", (Throwable)exception);
                                        }
                                        tileentity.e();
                                    }
                                } else if (this.c && this.dO().ab().b(GameRules.i)) {
                                    this.discard(EntityRemoveEvent.Cause.DROP);
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            } else {
                                this.discard(EntityRemoveEvent.Cause.DROP);
                                if (this.c && this.dO().ab().b(GameRules.i)) {
                                    this.a(block, blockposition);
                                    this.a(block);
                                }
                            }
                        } else {
                            this.discard(EntityRemoveEvent.Cause.DESPAWN);
                            this.a(block, blockposition);
                        }
                    }
                }
            }
            this.i(this.dr().a(0.98));
        }
    }

    public void a(Block block, BlockPosition blockposition) {
        if (block instanceof Fallable) {
            ((Fallable)((Object)block)).a(this.dO(), blockposition, this);
        }
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        DamageSource damagesource1;
        if (!this.j) {
            return false;
        }
        int i2 = MathHelper.f(f2 - 1.0f);
        if (i2 < 0) {
            return false;
        }
        Predicate<Entity> predicate = IEntitySelector.e.and(IEntitySelector.b);
        Block block = this.h.b();
        if (block instanceof Fallable) {
            Fallable fallable = (Fallable)((Object)block);
            damagesource1 = fallable.a(this);
        } else {
            damagesource1 = this.dP().a(this);
        }
        DamageSource damagesource2 = damagesource1;
        float f22 = Math.min(MathHelper.d((float)i2 * this.l), this.k);
        this.dO().a((Entity)this, this.cK(), predicate).forEach(entity -> entity.a(damagesource2, f22));
        boolean flag = this.h.a(TagsBlock.N);
        if (flag && f22 > 0.0f && this.ah.i() < 0.05f + (float)i2 * 0.05f) {
            IBlockData iblockdata = BlockAnvil.e(this.h);
            if (iblockdata == null) {
                this.i = true;
            } else {
                this.h = iblockdata;
            }
        }
        return false;
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("BlockState", GameProfileSerializer.a(this.h));
        nbttagcompound.a("Time", this.b);
        nbttagcompound.a("DropItem", this.c);
        nbttagcompound.a("HurtEntities", this.j);
        nbttagcompound.a("FallHurtAmount", this.l);
        nbttagcompound.a("FallHurtMax", this.k);
        if (this.d != null) {
            nbttagcompound.a("TileEntityData", this.d);
        }
        nbttagcompound.a("CancelDrop", this.i);
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound) {
        this.h = GameProfileSerializer.a(this.dO().a(Registries.f), nbttagcompound.p("BlockState"));
        this.b = nbttagcompound.h("Time");
        if (nbttagcompound.b("HurtEntities", 99)) {
            this.j = nbttagcompound.q("HurtEntities");
            this.l = nbttagcompound.j("FallHurtAmount");
            this.k = nbttagcompound.h("FallHurtMax");
        } else if (this.h.a(TagsBlock.N)) {
            this.j = true;
        }
        if (nbttagcompound.b("DropItem", 99)) {
            this.c = nbttagcompound.q("DropItem");
        }
        if (nbttagcompound.b("TileEntityData", 10)) {
            this.d = nbttagcompound.p("TileEntityData").i();
        }
        this.i = nbttagcompound.q("CancelDrop");
        if (this.h.i()) {
            this.h = Blocks.I.o();
        }
    }

    public void b(float f2, int i2) {
        this.j = true;
        this.l = f2;
        this.k = i2;
    }

    public void s() {
        this.i = true;
    }

    @Override
    public boolean cy() {
        return false;
    }

    @Override
    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        super.a(crashreportsystemdetails);
        crashreportsystemdetails.a("Immitating BlockState", this.h.toString());
    }

    public IBlockData t() {
        return this.h;
    }

    @Override
    protected IChatBaseComponent cs() {
        return IChatBaseComponent.a("entity.minecraft.falling_block_type", this.h.b().f());
    }

    @Override
    public boolean cP() {
        return true;
    }

    @Override
    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return new PacketPlayOutSpawnEntity((Entity)this, entitytrackerentry, Block.i(this.t()));
    }

    @Override
    public void a(PacketPlayOutSpawnEntity packetplayoutspawnentity) {
        super.a(packetplayoutspawnentity);
        this.h = Block.a(packetplayoutspawnentity.p());
        this.J = true;
        double d0 = packetplayoutspawnentity.g();
        double d1 = packetplayoutspawnentity.h();
        double d2 = packetplayoutspawnentity.i();
        this.a_(d0, d1, d2);
        this.a(this.do());
    }

    @Override
    @Nullable
    public Entity a(DimensionTransition dimensiontransition) {
        ResourceKey<World> resourcekey = dimensiontransition.a().af();
        ResourceKey<World> resourcekey1 = this.dO().af();
        boolean flag = (resourcekey1 == World.j || resourcekey == World.j) && resourcekey1 != resourcekey;
        Entity entity = super.a(dimensiontransition);
        this.e = entity != null && flag;
        return entity;
    }
}

