/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSwell;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityOcelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.CreeperPowerEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;

public class EntityCreeper
extends EntityMonster
implements PowerableMob {
    private static final DataWatcherObject<Integer> b = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.b);
    private static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityCreeper.class, DataWatcherRegistry.k);
    private int e;
    public int cc;
    public int cd = 30;
    public int ce = 3;
    private int cf;
    public Entity entityIgniter;

    public EntityCreeper(EntityTypes<? extends EntityCreeper> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
    }

    @Override
    protected void B() {
        this.bW.a(1, new PathfinderGoalFloat(this));
        this.bW.a(2, new PathfinderGoalSwell(this));
        this.bW.a(3, new PathfinderGoalAvoidTarget<EntityOcelot>(this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.bW.a(3, new PathfinderGoalAvoidTarget<EntityCat>(this, EntityCat.class, 6.0f, 1.0, 1.2));
        this.bW.a(4, new PathfinderGoalMeleeAttack(this, 1.0, false));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 0.8));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(6, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bX.a(2, new PathfinderGoalHurtByTarget(this, new Class[0]));
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.v, 0.25);
    }

    @Override
    public int cx() {
        return this.p() == null ? this.w(0.0f) : this.w(this.ew() - 1.0f);
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        boolean flag = super.a(f2, f1, damagesource);
        this.cc += (int)(f2 * 1.5f);
        if (this.cc > this.cd - 5) {
            this.cc = this.cd - 5;
        }
        return flag;
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(b, -1);
        datawatcher_a.a(c, false);
        datawatcher_a.a(d, false);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        if (this.ao.a(c).booleanValue()) {
            nbttagcompound.a("powered", true);
        }
        nbttagcompound.a("Fuse", (short)this.cd);
        nbttagcompound.a("ExplosionRadius", (byte)this.ce);
        nbttagcompound.a("ignited", this.x());
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.ao.a(c, nbttagcompound.q("powered"));
        if (nbttagcompound.b("Fuse", 99)) {
            this.cd = nbttagcompound.g("Fuse");
        }
        if (nbttagcompound.b("ExplosionRadius", 99)) {
            this.ce = nbttagcompound.f("ExplosionRadius");
        }
        if (nbttagcompound.q("ignited")) {
            this.gk();
        }
    }

    @Override
    public void l() {
        if (this.bE()) {
            int i2;
            this.e = this.cc;
            if (this.x()) {
                this.b(1);
            }
            if ((i2 = this.t()) > 0 && this.cc == 0) {
                this.a(SoundEffects.gk, 1.0f, 0.5f);
                ((Entity)this).a(GameEvent.I);
            }
            this.cc += i2;
            if (this.cc < 0) {
                this.cc = 0;
            }
            if (this.cc >= this.cd) {
                this.cc = this.cd;
                this.gn();
            }
        }
        super.l();
    }

    @Override
    public void h(@Nullable EntityLiving entityliving) {
        if (!(entityliving instanceof Goat)) {
            super.h(entityliving);
        }
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.gj;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.gi;
    }

    @Override
    protected void a(WorldServer worldserver, DamageSource damagesource, boolean flag) {
        EntityCreeper entitycreeper;
        super.a(worldserver, damagesource, flag);
        Entity entity = damagesource.d();
        if (entity != this && entity instanceof EntityCreeper && (entitycreeper = (EntityCreeper)entity).gl()) {
            entitycreeper.gm();
            this.a((IMaterial)Items.up);
        }
    }

    @Override
    public boolean D(Entity entity) {
        return true;
    }

    @Override
    public boolean a() {
        return this.ao.a(c);
    }

    public float H(float f2) {
        return MathHelper.i(f2, this.e, this.cc) / (float)(this.cd - 2);
    }

    public int t() {
        return this.ao.a(b);
    }

    public void b(int i2) {
        this.ao.a(b, i2);
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        super.a(worldserver, entitylightning);
        if (CraftEventFactory.callCreeperPowerEvent(this, entitylightning, CreeperPowerEvent.PowerCause.LIGHTNING).isCancelled()) {
            return;
        }
        this.ao.a(c, true);
    }

    public void setPowered(boolean powered) {
        this.ao.a(c, powered);
    }

    @Override
    protected EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(TagsItem.be)) {
            SoundEffect soundeffect = itemstack.a(Items.tX) ? SoundEffects.iK : SoundEffects.iZ;
            this.dO().a(entityhuman, this.dt(), this.dv(), this.dz(), soundeffect, this.de(), 1.0f, this.ah.i() * 0.4f + 0.8f);
            if (!this.dO().B) {
                this.entityIgniter = entityhuman;
                this.gk();
                if (itemstack.o() == 0) {
                    itemstack.h(1);
                } else {
                    itemstack.a(1, (EntityLiving)entityhuman, EntityCreeper.d(enumhand));
                }
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(entityhuman, enumhand);
    }

    public void gn() {
        if (!this.dO().B) {
            float f2 = this.a() ? 2.0f : 1.0f;
            ExplosionPrimeEvent event = CraftEventFactory.callExplosionPrimeEvent(this, (float)this.ce * f2, false);
            if (!event.isCancelled()) {
                this.be = true;
                this.dO().a(this, Explosion.a(this.dO(), (Entity)this).customCausingEntityDamager(this.entityIgniter), null, this.dt(), this.dv(), this.dz(), event.getRadius(), event.getFire(), World.a.c);
                this.go();
                this.c(Entity.RemovalReason.a);
                this.discard(EntityRemoveEvent.Cause.EXPLODE);
            } else {
                this.cc = 0;
            }
        }
    }

    private void go() {
        Collection<MobEffect> collection = this.et();
        if (!collection.isEmpty()) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(this.dO(), this.dt(), this.dv(), this.dz());
            entityareaeffectcloud.a(this);
            entityareaeffectcloud.a(2.5f);
            entityareaeffectcloud.b(-0.5f);
            entityareaeffectcloud.c(10);
            entityareaeffectcloud.a(entityareaeffectcloud.j() / 2);
            entityareaeffectcloud.c(-entityareaeffectcloud.g() / (float)entityareaeffectcloud.j());
            for (MobEffect mobeffect : collection) {
                entityareaeffectcloud.a(new MobEffect(mobeffect));
            }
            this.dO().addFreshEntity(entityareaeffectcloud, CreatureSpawnEvent.SpawnReason.EXPLOSION);
        }
    }

    public boolean x() {
        return this.ao.a(d);
    }

    public void gk() {
        this.ao.a(d, true);
    }

    public boolean gl() {
        return this.a() && this.cf < 1;
    }

    public void gm() {
        ++this.cf;
    }
}

