/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBowShoot;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRestrictSun;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityShootBowEvent;

public abstract class EntitySkeletonAbstract
extends EntityMonster
implements IRangedEntity {
    private static final int b = 20;
    private static final int c = 40;
    private final PathfinderGoalBowShoot<EntitySkeletonAbstract> d = new PathfinderGoalBowShoot<EntitySkeletonAbstract>(this, 1.0, 20, 15.0f);
    private final PathfinderGoalMeleeAttack e = new PathfinderGoalMeleeAttack(this, 1.2, false){

        @Override
        public void e() {
            super.e();
            EntitySkeletonAbstract.this.w(false);
        }

        @Override
        public void d() {
            super.d();
            EntitySkeletonAbstract.this.w(true);
        }
    };

    protected EntitySkeletonAbstract(EntityTypes<? extends EntitySkeletonAbstract> entitytypes, World world) {
        super((EntityTypes<? extends EntityMonster>)entitytypes, world);
        this.x();
    }

    @Override
    protected void B() {
        this.bW.a(2, new PathfinderGoalRestrictSun(this));
        this.bW.a(3, new PathfinderGoalFleeSun(this, 1.0));
        this.bW.a(3, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 6.0f, 1.0, 1.2));
        this.bW.a(5, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.bW.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.bW.a(6, new PathfinderGoalRandomLookaround(this));
        this.bX.a(1, new PathfinderGoalHurtByTarget(this, new Class[0]));
        this.bX.a(2, new PathfinderGoalNearestAttackableTarget<EntityHuman>((EntityInsentient)this, EntityHuman.class, true));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
        this.bX.a(3, new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, true, false, EntityTurtle.cc));
    }

    public static AttributeProvider.Builder s() {
        return EntityMonster.gq().a(GenericAttributes.v, 0.25);
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        this.a(this.t(), 0.15f, 1.0f);
    }

    abstract SoundEffect t();

    @Override
    public void m_() {
        boolean flag = this.ge();
        if (flag) {
            ItemStack itemstack = this.a(EnumItemSlot.f);
            if (!itemstack.e()) {
                if (itemstack.l()) {
                    Item item = itemstack.g();
                    itemstack.b(itemstack.n() + this.ah.a(2));
                    if (itemstack.n() >= itemstack.o()) {
                        this.a(item, EnumItemSlot.f);
                        this.a(EnumItemSlot.f, ItemStack.l);
                    }
                }
                flag = false;
            }
            if (flag) {
                this.d(8.0f);
            }
        }
        super.m_();
    }

    @Override
    public void u() {
        super.u();
        Entity entity = this.dd();
        if (entity instanceof EntityCreature) {
            EntityCreature entitycreature = (EntityCreature)entity;
            this.aY = entitycreature.aY;
        }
    }

    @Override
    protected void a(RandomSource randomsource, DifficultyDamageScaler difficultydamagescaler) {
        super.a(randomsource, difficultydamagescaler);
        this.a(EnumItemSlot.a, new ItemStack(Items.ov));
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        groupdataentity = super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
        RandomSource randomsource = worldaccess.E_();
        this.a(randomsource, difficultydamagescaler);
        this.a(worldaccess, randomsource, difficultydamagescaler);
        this.x();
        this.a_(randomsource.i() < 0.55f * difficultydamagescaler.d());
        if (this.a(EnumItemSlot.f).e()) {
            LocalDate localdate = LocalDate.now();
            int i2 = localdate.get(ChronoField.DAY_OF_MONTH);
            int j2 = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j2 == 10 && i2 == 31 && randomsource.i() < 0.25f) {
                this.a(EnumItemSlot.f, new ItemStack(randomsource.i() < 0.1f ? Blocks.ef : Blocks.ee));
                this.bZ[EnumItemSlot.f.b()] = 0.0f;
            }
        }
        return groupdataentity;
    }

    public void x() {
        if (this.dO() != null && !this.dO().B) {
            this.bW.a(this.e);
            this.bW.a(this.d);
            ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.ov));
            if (itemstack.a(Items.ov)) {
                int i2 = this.gk();
                if (this.dO().al() != EnumDifficulty.d) {
                    i2 = this.gl();
                }
                this.d.c(i2);
                this.bW.a(4, this.d);
            } else {
                this.bW.a(4, this.e);
            }
        }
    }

    protected int gk() {
        return 20;
    }

    protected int gl() {
        return 40;
    }

    @Override
    public void a(EntityLiving entityliving, float f2) {
        ItemStack itemstack = this.b(ProjectileHelper.a(this, Items.ov));
        ItemStack itemstack1 = this.g(itemstack);
        EntityArrow entityarrow = this.a(itemstack1, f2, itemstack);
        double d0 = entityliving.dt() - this.dt();
        double d1 = entityliving.e(0.3333333333333333) - entityarrow.dv();
        double d2 = entityliving.dz() - this.dz();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        entityarrow.c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.dO().al().a() * 4);
        EntityShootBowEvent event = CraftEventFactory.callEntityShootBowEvent(this, this.eT(), null, entityarrow, EnumHand.a, 0.8f, true);
        if (event.isCancelled()) {
            event.getProjectile().remove();
            return;
        }
        if (event.getProjectile() == entityarrow.getBukkitEntity()) {
            this.dO().b(entityarrow);
        }
        this.a(SoundEffects.xn, 1.0f, 1.0f / (this.dR().i() * 0.4f + 0.8f));
    }

    protected EntityArrow a(ItemStack itemstack, float f2, @Nullable ItemStack itemstack1) {
        return ProjectileHelper.a(this, itemstack, f2, itemstack1);
    }

    @Override
    public boolean a(ItemProjectileWeapon itemprojectileweapon) {
        return itemprojectileweapon == Items.ov;
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.x();
    }

    @Override
    public void a(EnumItemSlot enumitemslot, ItemStack itemstack) {
        super.a(enumitemslot, itemstack);
        if (!this.dO().B) {
            this.x();
        }
    }

    public boolean gm() {
        return this.cp();
    }
}

