/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.monster.EntityZombie;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.slf4j.Logger;

public class EntityZombieVillager
extends EntityZombie
implements VillagerDataHolder {
    private static final Logger b = LogUtils.getLogger();
    public static final DataWatcherObject<Boolean> c = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> d = DataWatcher.a(EntityZombieVillager.class, DataWatcherRegistry.u);
    private static final int cf = 3600;
    private static final int cg = 6000;
    private static final int ch = 14;
    private static final int ci = 4;
    public int cj;
    @Nullable
    public UUID ck;
    @Nullable
    private NBTBase cl;
    @Nullable
    private MerchantRecipeList cm;
    private int cn;
    private int lastTick = MinecraftServer.currentTick;

    public EntityZombieVillager(EntityTypes<? extends EntityZombieVillager> entitytypes, World world) {
        super((EntityTypes<? extends EntityZombie>)entitytypes, world);
        BuiltInRegistries.x.a(this.ah).ifPresent(holder_c -> this.a(this.gv().a((VillagerProfession)holder_c.a())));
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(c, false);
        datawatcher_a.a(d, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gv());
        Logger logger = b;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("VillagerData", (NBTBase)nbtbase));
        if (this.cm != null) {
            nbttagcompound.a("Offers", (NBTBase)MerchantRecipeList.a.encodeStart(this.dQ().a(DynamicOpsNBT.a), (Object)this.cm).getOrThrow());
        }
        if (this.cl != null) {
            nbttagcompound.a("Gossips", this.cl);
        }
        nbttagcompound.a("ConversionTime", this.gu() ? this.cj : -1);
        if (this.ck != null) {
            nbttagcompound.a("ConversionPlayer", this.ck);
        }
        nbttagcompound.a("Xp", this.cn);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("VillagerData")));
            Logger logger = b;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(this::a);
        }
        if (nbttagcompound.e("Offers")) {
            DataResult dataresult1 = MerchantRecipeList.a.parse(this.dQ().a(DynamicOpsNBT.a), (Object)nbttagcompound.c("Offers"));
            Logger logger1 = b;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(SystemUtils.a("Failed to load offers: ", arg_0 -> ((Logger)logger1).warn(arg_0))).ifPresent(merchantrecipelist -> {
                this.cm = merchantrecipelist;
            });
        }
        if (nbttagcompound.b("Gossips", 9)) {
            this.cl = nbttagcompound.c("Gossips", 10);
        }
        if (nbttagcompound.b("ConversionTime", 99) && nbttagcompound.h("ConversionTime") > -1) {
            this.a(nbttagcompound.b("ConversionPlayer") ? nbttagcompound.a("ConversionPlayer") : null, nbttagcompound.h("ConversionTime"));
        }
        if (nbttagcompound.b("Xp", 3)) {
            this.cn = nbttagcompound.h("Xp");
        }
    }

    @Override
    public void l() {
        if (!this.dO().B && this.bE() && this.gu()) {
            int i2 = this.gx();
            int elapsedTicks = MinecraftServer.currentTick - this.lastTick;
            this.cj -= (i2 *= elapsedTicks);
            if (this.cj <= 0) {
                this.a((WorldServer)this.dO());
            }
        }
        super.l();
        this.lastTick = MinecraftServer.currentTick;
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (itemstack.a(Items.qa)) {
            if (this.b(MobEffects.r)) {
                itemstack.a(1, (EntityLiving)entityhuman);
                if (!this.dO().B) {
                    this.a(entityhuman.cz(), this.ah.a(2401) + 3600);
                }
                return EnumInteractionResult.a;
            }
            return EnumInteractionResult.c;
        }
        return super.b(entityhuman, enumhand);
    }

    @Override
    protected boolean gm() {
        return false;
    }

    @Override
    public boolean h(double d0) {
        return !this.gu() && this.cn == 0;
    }

    public boolean gu() {
        return this.ar().a(c);
    }

    public void a(@Nullable UUID uuid, int i2) {
        this.ck = uuid;
        this.cj = i2;
        this.ar().a(c, true);
        this.removeEffect(MobEffects.r, EntityPotionEffectEvent.Cause.CONVERSION);
        this.addEffect(new MobEffect(MobEffects.e, i2, Math.min(this.dO().al().a() - 1, 0)), EntityPotionEffectEvent.Cause.CONVERSION);
        this.dO().a((Entity)this, (byte)16);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 16) {
            if (!this.aX()) {
                this.dO().a(this.dt(), this.dx(), this.dz(), SoundEffects.DM, this.de(), 1.0f + this.ah.i(), this.ah.i() * 0.7f + 0.3f, false);
            }
        } else {
            super.b(b0);
        }
    }

    @Override
    private void a(WorldServer worldserver) {
        EntityVillager entityvillager = this.convertTo(EntityTypes.bj, false, EntityTransformEvent.TransformReason.CURED, CreatureSpawnEvent.SpawnReason.CURED);
        if (entityvillager == null) {
            ((ZombieVillager)this.getBukkitEntity()).setConversionTime(-1);
            return;
        }
        if (entityvillager != null) {
            EntityHuman entityhuman;
            this.forceDrops = true;
            Iterator<EnumItemSlot> iterator = this.c((ItemStack itemstack) -> !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.E)).iterator();
            this.forceDrops = false;
            while (iterator.hasNext()) {
                EnumItemSlot enumitemslot = iterator.next();
                SlotAccess slotaccess = entityvillager.a_(enumitemslot.b() + 300);
                slotaccess.a(this.a(enumitemslot));
            }
            entityvillager.a(this.gv());
            if (this.cl != null) {
                entityvillager.a(this.cl);
            }
            if (this.cm != null) {
                entityvillager.b(this.cm.a());
            }
            entityvillager.u(this.cn);
            entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.do()), EnumMobSpawn.i, (GroupDataEntity)null);
            entityvillager.a(worldserver);
            if (this.ck != null && (entityhuman = worldserver.b(this.ck)) instanceof EntityPlayer) {
                CriterionTriggers.s.a((EntityPlayer)entityhuman, this, entityvillager);
                worldserver.a(ReputationEvent.a, (Entity)entityhuman, entityvillager);
            }
            entityvillager.addEffect(new MobEffect(MobEffects.i, 200, 0), EntityPotionEffectEvent.Cause.CONVERSION);
            if (!this.aX()) {
                worldserver.a((EntityHuman)null, 1027, this.do(), 0);
            }
        }
    }

    private int gx() {
        int i2 = 1;
        if (this.ah.i() < 0.01f) {
            int j2 = 0;
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (int k2 = (int)this.dt() - 4; k2 < (int)this.dt() + 4 && j2 < 14; ++k2) {
                for (int l2 = (int)this.dv() - 4; l2 < (int)this.dv() + 4 && j2 < 14; ++l2) {
                    for (int i1 = (int)this.dz() - 4; i1 < (int)this.dz() + 4 && j2 < 14; ++i1) {
                        IBlockData iblockdata = this.dO().a_(blockposition_mutableblockposition.d(k2, l2, i1));
                        if (!iblockdata.a(Blocks.eW) && !(iblockdata.b() instanceof BlockBed)) continue;
                        if (this.ah.i() < 0.3f) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
        }
        return i2;
    }

    @Override
    public float fb() {
        return this.o_() ? (this.ah.i() - this.ah.i()) * 0.2f + 2.0f : (this.ah.i() - this.ah.i()) * 0.2f + 1.0f;
    }

    @Override
    public SoundEffect v() {
        return SoundEffects.DK;
    }

    @Override
    public SoundEffect d(DamageSource damagesource) {
        return SoundEffects.DO;
    }

    @Override
    public SoundEffect n_() {
        return SoundEffects.DN;
    }

    @Override
    public SoundEffect gk() {
        return SoundEffects.DP;
    }

    @Override
    protected ItemStack gl() {
        return ItemStack.l;
    }

    @Override
    public void a(MerchantRecipeList merchantrecipelist) {
        this.cm = merchantrecipelist;
    }

    @Override
    public void a(NBTBase nbtbase) {
        this.cl = nbtbase;
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        this.a(this.gv().a(VillagerType.a(worldaccess.t(this.do()))));
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gv();
        if (villagerdata1.b() != villagerdata.b()) {
            this.cm = null;
        }
        this.ao.a(d, villagerdata);
    }

    @Override
    public VillagerData gv() {
        return this.ao.a(d);
    }

    public int gw() {
        return this.cn;
    }

    @Override
    public void b(int i2) {
        this.cn = i2;
    }
}

