/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ReputationHandler;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.Behaviors;
import net.minecraft.world.entity.ai.gossip.Reputation;
import net.minecraft.world.entity.ai.gossip.ReputationType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEvent;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityWitch;
import net.minecraft.world.entity.npc.EntityVillagerAbstract;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTransformEvent;
import org.bukkit.event.entity.VillagerReplenishTradeEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class EntityVillager
extends EntityVillagerAbstract
implements ReputationHandler,
VillagerDataHolder {
    private static final Logger ci = LogUtils.getLogger();
    private static final DataWatcherObject<VillagerData> cj = DataWatcher.a(EntityVillager.class, DataWatcherRegistry.u);
    public static final int ce = 12;
    public static final Map<Item, Integer> cf = ImmutableMap.of((Object)Items.px, (Object)4, (Object)Items.ug, (Object)1, (Object)Items.uf, (Object)1, (Object)Items.vk, (Object)1);
    private static final int ck = 2;
    private static final Set<Item> cl = ImmutableSet.of((Object)Items.px, (Object)Items.ug, (Object)Items.uf, (Object)Items.pw, (Object)Items.pv, (Object)Items.vk, (Object[])new Item[]{Items.vl, Items.vi, Items.vj});
    private static final int cm = 10;
    private static final int cn = 1200;
    private static final int co = 24000;
    private static final int cp = 25;
    private static final int cq = 10;
    private static final int cr = 5;
    private static final long cs = 24000L;
    @VisibleForTesting
    public static final float cg = 0.5f;
    private int ct;
    private boolean cu;
    @Nullable
    private EntityHuman cv;
    private boolean cw;
    private int cx;
    private final Reputation cy = new Reputation();
    private long cz;
    private long cA;
    private int cB;
    private long cD;
    private int cE;
    private long cF;
    private boolean cG;
    private static final ImmutableList<MemoryModuleType<?>> cH = ImmutableList.of(MemoryModuleType.b, MemoryModuleType.c, MemoryModuleType.d, MemoryModuleType.e, MemoryModuleType.g, MemoryModuleType.h, MemoryModuleType.i, MemoryModuleType.j, MemoryModuleType.k, MemoryModuleType.l, MemoryModuleType.L, MemoryModuleType.aP, (Object[])new MemoryModuleType[]{MemoryModuleType.m, MemoryModuleType.n, MemoryModuleType.q, MemoryModuleType.r, MemoryModuleType.t, MemoryModuleType.v, MemoryModuleType.w, MemoryModuleType.x, MemoryModuleType.y, MemoryModuleType.A, MemoryModuleType.f, MemoryModuleType.C, MemoryModuleType.D, MemoryModuleType.E, MemoryModuleType.H, MemoryModuleType.I, MemoryModuleType.J, MemoryModuleType.F});
    private static final ImmutableList<SensorType<? extends Sensor<? super EntityVillager>>> cI = ImmutableList.of(SensorType.c, SensorType.d, SensorType.b, SensorType.e, SensorType.f, SensorType.g, SensorType.h, SensorType.i, SensorType.j);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<EntityVillager, Holder<VillagePlaceType>>> ch = ImmutableMap.of(MemoryModuleType.b, (entityvillager, holder) -> holder.a(PoiTypes.n), MemoryModuleType.c, (entityvillager, holder) -> entityvillager.gv().b().b().test((Holder<VillagePlaceType>)holder), MemoryModuleType.d, (entityvillager, holder) -> VillagerProfession.a.test((Holder<VillagePlaceType>)holder), MemoryModuleType.e, (entityvillager, holder) -> holder.a(PoiTypes.o));

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world) {
        this(entitytypes, world, VillagerType.c);
    }

    public EntityVillager(EntityTypes<? extends EntityVillager> entitytypes, World world, VillagerType villagertype) {
        super((EntityTypes<? extends EntityVillagerAbstract>)entitytypes, world);
        ((Navigation)this.N()).b(true);
        this.N().a(true);
        this.a_(true);
        this.a(this.gv().a(villagertype).a(VillagerProfession.b));
    }

    public BehaviorController<EntityVillager> dT() {
        return super.dT();
    }

    protected BehaviorController.b<EntityVillager> dU() {
        return BehaviorController.a(cH, cI);
    }

    @Override
    protected BehaviorController<?> a(Dynamic<?> dynamic) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dU().a(dynamic);
        this.a(behaviorcontroller);
        return behaviorcontroller;
    }

    @Override
    public void a(WorldServer worldserver) {
        BehaviorController<EntityVillager> behaviorcontroller = this.dT();
        behaviorcontroller.b(worldserver, this);
        this.bF = behaviorcontroller.i();
        this.a(this.dT());
    }

    @Override
    private void a(BehaviorController<EntityVillager> behaviorcontroller) {
        VillagerProfession villagerprofession = this.gv().b();
        if (this.o_()) {
            behaviorcontroller.a(Schedule.e);
            behaviorcontroller.a(Activity.d, Behaviors.a(0.5f));
        } else {
            behaviorcontroller.a(Schedule.f);
            behaviorcontroller.a(Activity.c, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.b(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.c, (Object)((Object)MemoryStatus.a))));
        }
        behaviorcontroller.a(Activity.a, Behaviors.a(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.f, (ImmutableList<Pair<Integer, BehaviorControl<EntityVillager>>>)Behaviors.d(villagerprofession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.e, (Object)((Object)MemoryStatus.a))));
        behaviorcontroller.a(Activity.e, Behaviors.c(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.b, Behaviors.e(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.g, Behaviors.f(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.i, Behaviors.g(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.h, Behaviors.h(villagerprofession, 0.5f));
        behaviorcontroller.a(Activity.j, Behaviors.i(villagerprofession, 0.5f));
        behaviorcontroller.a((Set<Activity>)ImmutableSet.of((Object)Activity.a));
        behaviorcontroller.b(Activity.b);
        behaviorcontroller.a(Activity.b);
        behaviorcontroller.a(this.dO().aa(), this.dO().Z());
    }

    @Override
    protected void k() {
        super.k();
        if (this.dO() instanceof WorldServer) {
            this.a((WorldServer)this.dO());
        }
    }

    public static AttributeProvider.Builder gt() {
        return EntityInsentient.C().a(GenericAttributes.v, 0.5).a(GenericAttributes.m, 48.0);
    }

    public boolean gu() {
        return this.cG;
    }

    @Override
    public void inactiveTick() {
        if (this.dO().spigotConfig.tickInactiveVillagers && this.db()) {
            this.ab();
        }
        super.inactiveTick();
    }

    @Override
    protected void ab() {
        Raid raid;
        this.dO().ag().a("villagerBrain");
        this.dT().a((WorldServer)this.dO(), this);
        this.dO().ag().c();
        if (this.cG) {
            this.cG = false;
        }
        if (!this.gl() && this.ct > 0) {
            --this.ct;
            if (this.ct <= 0) {
                if (this.cu) {
                    this.gR();
                    this.cu = false;
                }
                this.addEffect(new MobEffect(MobEffects.j, 200, 0), EntityPotionEffectEvent.Cause.VILLAGER_TRADE);
            }
        }
        if (this.cv != null && this.dO() instanceof WorldServer) {
            ((WorldServer)this.dO()).a(ReputationEvent.e, (Entity)this.cv, this);
            this.dO().a((Entity)this, (byte)14);
            this.cv = null;
        }
        if (!this.fZ() && this.ah.a(100) == 0 && (raid = ((WorldServer)this.dO()).d(this.do())) != null && raid.u() && !raid.a()) {
            this.dO().a((Entity)this, (byte)42);
        }
        if (this.gv().b() == VillagerProfession.b && this.gl()) {
            this.gq();
        }
        super.ab();
    }

    @Override
    public void l() {
        super.l();
        if (this.s() > 0) {
            this.s(this.s() - 1);
        }
        this.gT();
    }

    @Override
    public EnumInteractionResult b(EntityHuman entityhuman, EnumHand enumhand) {
        ItemStack itemstack = entityhuman.b(enumhand);
        if (!itemstack.a(Items.tJ) && this.bE() && !this.gl() && !this.fH()) {
            if (this.o_()) {
                this.gG();
                return EnumInteractionResult.a(this.dO().B);
            }
            if (!this.dO().B) {
                boolean flag = this.gm().isEmpty();
                if (enumhand == EnumHand.a) {
                    if (flag) {
                        this.gG();
                    }
                    entityhuman.a(StatisticList.S);
                }
                if (flag) {
                    return EnumInteractionResult.c;
                }
                this.g(entityhuman);
            }
            return EnumInteractionResult.a(this.dO().B);
        }
        return super.b(entityhuman, enumhand);
    }

    public void gG() {
        this.s(40);
        if (!this.dO().x_()) {
            this.b(SoundEffects.AW);
        }
    }

    private void g(EntityHuman entityhuman) {
        this.h(entityhuman);
        this.a(entityhuman);
        this.a(entityhuman, this.S_(), this.gv().c());
    }

    @Override
    public void a(@Nullable EntityHuman entityhuman) {
        boolean flag = this.gk() != null && entityhuman == null;
        super.a(entityhuman);
        if (flag) {
            this.gq();
        }
    }

    @Override
    protected void gq() {
        super.gq();
        this.gH();
    }

    private void gH() {
        if (!this.dO().x_()) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gm()) {
                merchantrecipe.n();
            }
        }
    }

    @Override
    public boolean gw() {
        return true;
    }

    @Override
    public boolean gs() {
        return this.dO().B;
    }

    public void gx() {
        this.gM();
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gm()) {
            VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            merchantrecipe.j();
        }
        this.gI();
        this.cD = this.dO().Z();
        ++this.cE;
    }

    private void gI() {
        MerchantRecipeList merchantrecipelist = this.gm();
        EntityHuman entityhuman = this.gk();
        if (entityhuman != null && !merchantrecipelist.isEmpty()) {
            entityhuman.a(entityhuman.cd.j, merchantrecipelist, this.gv().c(), this.t(), this.gn(), this.gw());
        }
    }

    private boolean gJ() {
        net.minecraft.world.item.trading.MerchantRecipe merchantrecipe;
        Iterator iterator = this.gm().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!(merchantrecipe = (net.minecraft.world.item.trading.MerchantRecipe)iterator.next()).t());
        return true;
    }

    private boolean gK() {
        return this.cE == 0 || this.cE < 2 && this.dO().Z() > this.cD + 2400L;
    }

    public boolean gy() {
        long i2 = this.cD + 12000L;
        long j2 = this.dO().Z();
        boolean flag = j2 > i2;
        long k2 = this.dO().aa();
        if (this.cF > 0L) {
            long i1 = k2 / 24000L;
            long l2 = this.cF / 24000L;
            flag |= i1 > l2;
        }
        this.cF = k2;
        if (flag) {
            this.cD = j2;
            this.gU();
        }
        return this.gK() && this.gJ();
    }

    private void gL() {
        int i2 = 2 - this.cE;
        if (i2 > 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gm()) {
                VillagerReplenishTradeEvent event = new VillagerReplenishTradeEvent((AbstractVillager)((Villager)this.getBukkitEntity()), (MerchantRecipe)merchantrecipe.asBukkit());
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) continue;
                merchantrecipe.j();
            }
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            this.gM();
        }
        this.gI();
    }

    private void gM() {
        for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gm()) {
            merchantrecipe.g();
        }
    }

    private void h(EntityHuman entityhuman) {
        int i2 = this.f(entityhuman);
        if (i2 != 0) {
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe : this.gm()) {
                merchantrecipe.a(-MathHelper.d((float)i2 * merchantrecipe.p()));
            }
        }
        if (entityhuman.b(MobEffects.F)) {
            MobEffect mobeffect = entityhuman.c(MobEffects.F);
            int j2 = mobeffect.e();
            for (net.minecraft.world.item.trading.MerchantRecipe merchantrecipe1 : this.gm()) {
                double d0 = 0.3 + 0.0625 * (double)j2;
                int k2 = (int)Math.floor(d0 * (double)merchantrecipe1.a().H());
                merchantrecipe1.a(-Math.max(k2, 1));
            }
        }
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(cj, new VillagerData(VillagerType.c, VillagerProfession.b, 1));
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        DataResult dataresult = VillagerData.c.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.gv());
        Logger logger = ci;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbttagcompound.a("VillagerData", (NBTBase)nbtbase));
        nbttagcompound.a("FoodLevel", (byte)this.cx);
        nbttagcompound.a("Gossips", this.cy.a(DynamicOpsNBT.a));
        nbttagcompound.a("Xp", this.cB);
        nbttagcompound.a("LastRestock", this.cD);
        nbttagcompound.a("LastGossipDecay", this.cA);
        nbttagcompound.a("RestocksToday", this.cE);
        if (this.cG) {
            nbttagcompound.a("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        if (nbttagcompound.b("VillagerData", 10)) {
            DataResult dataresult = VillagerData.c.parse(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("VillagerData")));
            Logger logger = ci;
            Objects.requireNonNull(logger);
            dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(villagerdata -> this.ao.a(cj, villagerdata));
        }
        if (nbttagcompound.b("FoodLevel", 1)) {
            this.cx = nbttagcompound.f("FoodLevel");
        }
        NBTTagList nbttaglist = nbttagcompound.c("Gossips", 10);
        this.cy.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbttaglist));
        if (nbttagcompound.b("Xp", 3)) {
            this.cB = nbttagcompound.h("Xp");
        }
        this.cD = nbttagcompound.i("LastRestock");
        this.cA = nbttagcompound.i("LastGossipDecay");
        this.a_(true);
        if (this.dO() instanceof WorldServer) {
            this.a((WorldServer)this.dO());
        }
        this.cE = nbttagcompound.h("RestocksToday");
        if (nbttagcompound.e("AssignProfessionWhenSpawned")) {
            this.cG = nbttagcompound.q("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean h(double d0) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEffect v() {
        return this.fH() ? null : (this.gl() ? SoundEffects.AX : SoundEffects.AS);
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return SoundEffects.AV;
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.AU;
    }

    public void gz() {
        this.b(this.gv().b().f());
    }

    @Override
    public void a(VillagerData villagerdata) {
        VillagerData villagerdata1 = this.gv();
        if (villagerdata1.b() != villagerdata.b()) {
            this.cd = null;
        }
        this.ao.a(cj, villagerdata);
    }

    @Override
    public VillagerData gv() {
        return this.ao.a(cj);
    }

    @Override
    protected void b(net.minecraft.world.item.trading.MerchantRecipe merchantrecipe) {
        int i2 = 3 + this.ah.a(4);
        this.cB += merchantrecipe.q();
        this.cv = this.gk();
        if (this.gQ()) {
            this.ct = 40;
            this.cu = true;
            i2 += 5;
        }
        if (merchantrecipe.u()) {
            this.dO().b(new EntityExperienceOrb(this.dO(), this.dt(), this.dv() + 0.5, this.dz(), i2));
        }
    }

    public void y(boolean flag) {
        this.cw = flag;
    }

    public boolean gA() {
        return this.cw;
    }

    @Override
    public void a(@Nullable EntityLiving entityliving) {
        if (entityliving != null && this.dO() instanceof WorldServer) {
            ((WorldServer)this.dO()).a(ReputationEvent.c, (Entity)entityliving, this);
            if (this.bE() && entityliving instanceof EntityHuman) {
                this.dO().a((Entity)this, (byte)13);
            }
        }
        super.a(entityliving);
    }

    @Override
    public void a(DamageSource damagesource) {
        Entity entity;
        if (SpigotConfig.logVillagerDeaths) {
            ci.info("Villager {} died, message: '{}'", (Object)this, (Object)damagesource.a(this).getString());
        }
        if ((entity = damagesource.d()) != null) {
            this.c(entity);
        }
        this.gN();
        super.a(damagesource);
    }

    public void gN() {
        this.a(MemoryModuleType.b);
        this.a(MemoryModuleType.c);
        this.a(MemoryModuleType.d);
        this.a(MemoryModuleType.e);
    }

    private void c(Entity entity) {
        World world = this.dO();
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            Optional<NearestVisibleLivingEntities> optional = this.bF.c(MemoryModuleType.h);
            if (!optional.isEmpty()) {
                NearestVisibleLivingEntities nearestvisiblelivingentities = optional.get();
                Objects.requireNonNull(ReputationHandler.class);
                nearestvisiblelivingentities.b(ReputationHandler.class::isInstance).forEach(entityliving -> worldserver.a(ReputationEvent.d, entity, (ReputationHandler)((Object)entityliving)));
            }
        }
    }

    @Override
    public void a(MemoryModuleType<GlobalPos> memorymoduletype) {
        if (this.dO() instanceof WorldServer) {
            MinecraftServer minecraftserver = ((WorldServer)this.dO()).o();
            this.bF.c(memorymoduletype).ifPresent(globalpos -> {
                WorldServer worldserver = minecraftserver.a(globalpos.a());
                if (worldserver != null) {
                    VillagePlace villageplace = worldserver.y();
                    Optional<Holder<VillagePlaceType>> optional = villageplace.c(globalpos.b());
                    BiPredicate<EntityVillager, Holder<VillagePlaceType>> bipredicate = ch.get(memorymoduletype);
                    if (optional.isPresent() && bipredicate.test(this, optional.get())) {
                        villageplace.b(globalpos.b());
                        PacketDebug.c(worldserver, globalpos.b());
                    }
                }
            });
        }
    }

    @Override
    public boolean ab_() {
        return this.cx + this.gS() >= 12 && !this.fH() && this.g() == 0;
    }

    private boolean gO() {
        return this.cx < 12;
    }

    private void gP() {
        if (this.gO() && this.gS() != 0) {
            for (int i2 = 0; i2 < this.x().b(); ++i2) {
                int j2;
                Integer integer;
                ItemStack itemstack = this.x().a(i2);
                if (itemstack.e() || (integer = cf.get(itemstack.g())) == null) continue;
                for (int k2 = j2 = itemstack.H(); k2 > 0; --k2) {
                    this.cx += integer.intValue();
                    this.x().a(i2, 1);
                    if (this.gO()) continue;
                    return;
                }
            }
        }
    }

    public int f(EntityHuman entityhuman) {
        return this.cy.a(entityhuman.cz(), (ReputationType reputationtype) -> true);
    }

    private void v(int i2) {
        this.cx -= i2;
    }

    public void gB() {
        this.gP();
        this.v(12);
    }

    public void b(MerchantRecipeList merchantrecipelist) {
        this.cd = merchantrecipelist;
    }

    private boolean gQ() {
        int i2 = this.gv().c();
        return VillagerData.d(i2) && this.cB >= VillagerData.c(i2);
    }

    public void gR() {
        this.a(this.gv().a(this.gv().c() + 1));
        this.gr();
    }

    @Override
    protected IChatBaseComponent cs() {
        String s2 = this.am().g();
        return IChatBaseComponent.c(s2 + "." + BuiltInRegistries.x.b(this.gv().b()).a());
    }

    @Override
    public void b(byte b0) {
        if (b0 == 12) {
            this.a(Particles.Q);
        } else if (b0 == 13) {
            this.a(Particles.a);
        } else if (b0 == 14) {
            this.a(Particles.O);
        } else if (b0 == 42) {
            this.a(Particles.am);
        } else {
            super.b(b0);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity a(WorldAccess worldaccess, DifficultyDamageScaler difficultydamagescaler, EnumMobSpawn enummobspawn, @Nullable GroupDataEntity groupdataentity) {
        if (enummobspawn == EnumMobSpawn.e) {
            this.a(this.gv().a(VillagerProfession.b));
        }
        if (enummobspawn == EnumMobSpawn.n || enummobspawn == EnumMobSpawn.m || EnumMobSpawn.a(enummobspawn) || enummobspawn == EnumMobSpawn.o) {
            this.a(this.gv().a(VillagerType.a(worldaccess.t(this.do()))));
        }
        if (enummobspawn == EnumMobSpawn.d) {
            this.cG = true;
        }
        return super.a(worldaccess, difficultydamagescaler, enummobspawn, groupdataentity);
    }

    @Nullable
    public EntityVillager b(WorldServer worldserver, EntityAgeable entityageable) {
        double d0 = this.ah.j();
        VillagerType villagertype = d0 < 0.5 ? VillagerType.a(worldserver.t(this.do())) : (d0 < 0.75 ? this.gv().a() : ((EntityVillager)entityageable).gv().a());
        EntityVillager entityvillager = new EntityVillager(EntityTypes.bj, worldserver, villagertype);
        entityvillager.a((WorldAccess)worldserver, worldserver.d_(entityvillager.do()), EnumMobSpawn.e, (GroupDataEntity)null);
        return entityvillager;
    }

    @Override
    public void a(WorldServer worldserver, EntityLightning entitylightning) {
        if (worldserver.al() != EnumDifficulty.a) {
            ci.info("Villager {} was struck by lightning {}.", (Object)this, (Object)entitylightning);
            EntityWitch entitywitch = EntityTypes.bo.a(worldserver);
            if (entitywitch != null) {
                entitywitch.b(this.dt(), this.dv(), this.dz(), this.dE(), this.dG());
                entitywitch.a((WorldAccess)worldserver, worldserver.d_(entitywitch.do()), EnumMobSpawn.i, (GroupDataEntity)null);
                entitywitch.u(this.fZ());
                if (this.ai()) {
                    entitywitch.b(this.aj());
                    entitywitch.p(this.cE());
                }
                entitywitch.fR();
                if (CraftEventFactory.callEntityTransformEvent((EntityLiving)this, entitywitch, EntityTransformEvent.TransformReason.LIGHTNING).isCancelled()) {
                    return;
                }
                worldserver.addFreshEntityWithPassengers(entitywitch, CreatureSpawnEvent.SpawnReason.LIGHTNING);
                this.gN();
                this.discard(EntityRemoveEvent.Cause.TRANSFORMATION);
            } else {
                super.a(worldserver, entitylightning);
            }
        } else {
            super.a(worldserver, entitylightning);
        }
    }

    @Override
    protected void b(EntityItem entityitem) {
        InventoryCarrier.a(this, this, entityitem);
    }

    @Override
    public boolean k(ItemStack itemstack) {
        Item item = itemstack.g();
        return (cl.contains(item) || this.gv().b().d().contains((Object)item)) && this.x().c(itemstack);
    }

    public boolean gC() {
        return this.gS() >= 24;
    }

    public boolean gD() {
        return this.gS() < 12;
    }

    private int gS() {
        InventorySubcontainer inventorysubcontainer = this.x();
        return cf.entrySet().stream().mapToInt(entry -> inventorysubcontainer.a_((Item)entry.getKey()) * (Integer)entry.getValue()).sum();
    }

    public boolean gE() {
        return this.x().a_((ItemStack itemstack) -> itemstack.a(TagsItem.bw));
    }

    @Override
    protected void gr() {
        VillagerTrades.IMerchantRecipeOption[] avillagertrades_imerchantrecipeoption;
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap1;
        VillagerData villagerdata = this.gv();
        Int2ObjectMap<VillagerTrades.IMerchantRecipeOption[]> int2objectmap = this.dO().J().b(FeatureFlags.c) ? ((int2objectmap1 = VillagerTrades.c.get(villagerdata.b())) != null ? int2objectmap1 : VillagerTrades.a.get(villagerdata.b())) : VillagerTrades.a.get(villagerdata.b());
        if (int2objectmap != null && !int2objectmap.isEmpty() && (avillagertrades_imerchantrecipeoption = (VillagerTrades.IMerchantRecipeOption[])int2objectmap.get(villagerdata.c())) != null) {
            MerchantRecipeList merchantrecipelist = this.gm();
            this.a(merchantrecipelist, avillagertrades_imerchantrecipeoption, 2);
        }
    }

    public void a(WorldServer worldserver, EntityVillager entityvillager, long i2) {
        if (!(i2 >= this.cz && i2 < this.cz + 1200L || i2 >= entityvillager.cz && i2 < entityvillager.cz + 1200L)) {
            this.cy.a(entityvillager.cy, this.ah, 10);
            this.cz = i2;
            entityvillager.cz = i2;
            this.a(worldserver, i2, 5);
        }
    }

    private void gT() {
        long i2 = this.dO().Z();
        if (this.cA == 0L) {
            this.cA = i2;
        } else if (i2 >= this.cA + 24000L) {
            this.cy.b();
            this.cA = i2;
        }
    }

    public void a(WorldServer worldserver, long i2, int j2) {
        AxisAlignedBB axisalignedbb;
        List<EntityVillager> list;
        List list1;
        if (this.a(i2) && (list1 = (list = worldserver.a(EntityVillager.class, axisalignedbb = this.cK().c(10.0, 10.0, 10.0))).stream().filter(entityvillager -> entityvillager.a(i2)).limit(5L).collect(Collectors.toList())).size() >= j2 && !SpawnUtil.trySpawnMob(EntityTypes.af, EnumMobSpawn.f, worldserver, this.do(), 10, 8, 6, SpawnUtil.a.a, CreatureSpawnEvent.SpawnReason.VILLAGE_DEFENSE).isEmpty()) {
            list.forEach(SensorGolemLastSeen::b);
        }
    }

    public boolean a(long i2) {
        return !this.b(this.dO().Z()) ? false : !this.bF.a(MemoryModuleType.F);
    }

    @Override
    public void a(ReputationEvent reputationevent, Entity entity) {
        if (reputationevent == ReputationEvent.a) {
            this.cy.a(entity.cz(), ReputationType.d, 20);
            this.cy.a(entity.cz(), ReputationType.c, 25);
        } else if (reputationevent == ReputationEvent.e) {
            this.cy.a(entity.cz(), ReputationType.e, 2);
        } else if (reputationevent == ReputationEvent.c) {
            this.cy.a(entity.cz(), ReputationType.b, 25);
        } else if (reputationevent == ReputationEvent.d) {
            this.cy.a(entity.cz(), ReputationType.a, 25);
        }
    }

    @Override
    public int t() {
        return this.cB;
    }

    public void u(int i2) {
        this.cB = i2;
    }

    private void gU() {
        this.gL();
        this.cE = 0;
    }

    public Reputation gF() {
        return this.cy;
    }

    @Override
    public void a(NBTBase nbtbase) {
        this.cy.a(new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbtbase));
    }

    @Override
    protected void aa() {
        super.aa();
        PacketDebug.a(this);
    }

    @Override
    public void b(BlockPosition blockposition) {
        super.b(blockposition);
        this.bF.a(MemoryModuleType.H, Long.valueOf(this.dO().Z()));
        this.bF.b(MemoryModuleType.m);
        this.bF.b(MemoryModuleType.E);
    }

    @Override
    public void fI() {
        super.fI();
        this.bF.a(MemoryModuleType.I, Long.valueOf(this.dO().Z()));
    }

    private boolean b(long i2) {
        Optional<Long> optional = this.bF.c(MemoryModuleType.H);
        return optional.isPresent() ? i2 - optional.get() < 24000L : false;
    }
}

