/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.Statistic;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsEntity;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.EntityAttachments;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.warden.WardenSpawnTracker;
import net.minecraft.world.entity.player.PlayerAbilities;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.food.FoodMetaData;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerPlayer;
import net.minecraft.world.inventory.InventoryEnderChest;
import net.minecraft.world.item.ItemCooldown;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.trading.MerchantRecipeList;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardTeam;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerVelocityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public abstract class EntityHuman
extends EntityLiving {
    private static final Logger b = LogUtils.getLogger();
    public static final EnumMainHand bH = EnumMainHand.b;
    public static final int bI = 0;
    public static final int bJ = 20;
    public static final int bK = 100;
    public static final int bL = 10;
    public static final int bM = 200;
    public static final int bN = 499;
    public static final int bO = 500;
    public static final float bP = 4.5f;
    public static final float bQ = 3.0f;
    public static final float bR = 1.5f;
    public static final float bS = 0.6f;
    public static final float bT = 0.6f;
    public static final float bU = 1.62f;
    private static final int c = 40;
    public static final Vec3D bV = new Vec3D(0.0, 0.6, 0.0);
    public static final EntitySize bW = EntitySize.b(0.6f, 1.8f).b(1.62f).a(EntityAttachments.a().a(EntityAttachment.b, bV));
    private static final Map<EntityPose, EntitySize> d = ImmutableMap.builder().put((Object)EntityPose.a, (Object)bW).put((Object)EntityPose.c, (Object)aF).put((Object)EntityPose.b, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.d, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.e, (Object)EntitySize.b(0.6f, 0.6f).b(0.4f)).put((Object)EntityPose.f, (Object)EntitySize.b(0.6f, 1.5f).b(1.27f).a(EntityAttachments.a().a(EntityAttachment.b, bV))).put((Object)EntityPose.h, (Object)EntitySize.c(0.2f, 0.2f).b(1.62f)).build();
    private static final DataWatcherObject<Float> e = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.d);
    private static final DataWatcherObject<Integer> f = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.b);
    protected static final DataWatcherObject<Byte> bX = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<Byte> bY = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.a);
    protected static final DataWatcherObject<NBTTagCompound> bZ = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    protected static final DataWatcherObject<NBTTagCompound> ca = DataWatcher.a(EntityHuman.class, DataWatcherRegistry.t);
    private long g;
    final PlayerInventory h = new PlayerInventory(this);
    protected InventoryEnderChest cb = new InventoryEnderChest(this);
    public final ContainerPlayer cc;
    public Container cd;
    protected FoodMetaData ce = new FoodMetaData(this);
    protected int cf;
    public float cg;
    public float ch;
    public int ci;
    public double cj;
    public double ck;
    public double cl;
    public double cm;
    public double cn;
    public double co;
    public int cz;
    protected boolean cp;
    private final PlayerAbilities cA = new PlayerAbilities();
    public int cq;
    public int cr;
    public float cs;
    public int ct;
    protected final float cu = 0.02f;
    private int cB;
    private final GameProfile cD;
    private boolean cE;
    private net.minecraft.world.item.ItemStack cF = net.minecraft.world.item.ItemStack.l;
    private final ItemCooldown cG = this.k();
    private Optional<GlobalPos> cH = Optional.empty();
    @Nullable
    public EntityFishingHook cv;
    protected float cw;
    @Nullable
    public Vec3D cx;
    @Nullable
    public Entity cy;
    private boolean cI;
    private int cJ;
    public boolean fauxSleeping;
    public int oldLevel = -1;

    @Override
    public CraftHumanEntity getBukkitEntity() {
        return (CraftHumanEntity)super.getBukkitEntity();
    }

    public EntityHuman(World world, BlockPosition blockposition, float f2, GameProfile gameprofile) {
        super((EntityTypes<? extends EntityLiving>)EntityTypes.by, world);
        this.a_(gameprofile.getId());
        this.cD = gameprofile;
        this.cc = new ContainerPlayer(this.h, !world.B, this);
        this.cd = this.cc;
        this.b((double)blockposition.u() + 0.5, blockposition.v() + 1, (double)blockposition.w() + 0.5, f2, 0.0f);
        this.bk = 180.0f;
    }

    public boolean a(World world, BlockPosition blockposition, EnumGamemode enumgamemode) {
        if (!enumgamemode.f()) {
            return false;
        }
        if (enumgamemode == EnumGamemode.d) {
            return true;
        }
        if (this.gk()) {
            return false;
        }
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        return itemstack.e() || !itemstack.b(new ShapeDetectorBlock(world, blockposition, false));
    }

    public static AttributeProvider.Builder fM() {
        return EntityLiving.dV().a(GenericAttributes.c, 1.0).a(GenericAttributes.v, 0.1f).a(GenericAttributes.e).a(GenericAttributes.q).a(GenericAttributes.g, 4.5).a(GenericAttributes.j, 3.0).a(GenericAttributes.f).a(GenericAttributes.C).a(GenericAttributes.z).a(GenericAttributes.t).a(GenericAttributes.D);
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        super.a(datawatcher_a);
        datawatcher_a.a(e, Float.valueOf(0.0f));
        datawatcher_a.a(f, 0);
        datawatcher_a.a(bX, (byte)0);
        datawatcher_a.a(bY, (byte)bH.a());
        datawatcher_a.a(bZ, new NBTTagCompound());
        datawatcher_a.a(ca, new NBTTagCompound());
    }

    @Override
    public void l() {
        this.ag = this.R_();
        if (this.R_()) {
            this.d(false);
        }
        if (this.ci > 0) {
            --this.ci;
        }
        if (this.fH()) {
            ++this.cz;
            if (this.cz > 100) {
                this.cz = 100;
            }
            if (!this.dO().B && this.dO().R()) {
                this.a(false, true);
            }
        } else if (this.cz > 0) {
            ++this.cz;
            if (this.cz >= 110) {
                this.cz = 0;
            }
        }
        this.fQ();
        super.l();
        if (!this.dO().B && this.cd != null && !this.cd.b(this)) {
            this.s();
            this.cd = this.cc;
        }
        this.x();
        if (!this.dO().B) {
            this.ce.a(this);
            this.a(StatisticList.k);
            this.a(StatisticList.l);
            if (this.bE()) {
                this.a(StatisticList.m);
            }
            if (this.bZ()) {
                this.a(StatisticList.o);
            }
            if (!this.fH()) {
                this.a(StatisticList.n);
            }
        }
        int i2 = 29999999;
        double d0 = MathHelper.a(this.dt(), -2.9999999E7, 2.9999999E7);
        double d1 = MathHelper.a(this.dz(), -2.9999999E7, 2.9999999E7);
        if (d0 != this.dt() || d1 != this.dz()) {
            this.a_(d0, this.dv(), d1);
        }
        ++this.aT;
        net.minecraft.world.item.ItemStack itemstack = this.eT();
        if (!net.minecraft.world.item.ItemStack.a(this.cF, itemstack)) {
            if (!net.minecraft.world.item.ItemStack.b(this.cF, itemstack)) {
                this.gs();
            }
            this.cF = itemstack.s();
        }
        this.v();
        this.cG.a();
        this.fR();
        if (this.cJ > 0) {
            --this.cJ;
        }
    }

    @Override
    protected float fk() {
        return this.fy() ? 15.0f : super.fk();
    }

    public boolean fN() {
        return this.bW();
    }

    protected boolean fO() {
        return this.bW();
    }

    protected boolean fP() {
        return this.bW();
    }

    protected boolean fQ() {
        this.cp = ((Entity)this).a(TagsFluid.a);
        return this.cp;
    }

    private void v() {
        net.minecraft.world.item.ItemStack itemstack = this.a(EnumItemSlot.f);
        if (itemstack.a(Items.oo) && !((Entity)this).a(TagsFluid.a)) {
            this.addEffect(new MobEffect(MobEffects.m, 200, 0, false, false, true), EntityPotionEffectEvent.Cause.TURTLE_HELMET);
        }
    }

    protected ItemCooldown k() {
        return new ItemCooldown();
    }

    private void x() {
        this.cj = this.cm;
        this.ck = this.cn;
        this.cl = this.co;
        double d0 = this.dt() - this.cm;
        double d1 = this.dv() - this.cn;
        double d2 = this.dz() - this.co;
        double d3 = 10.0;
        if (d0 > 10.0) {
            this.cj = this.cm = this.dt();
        }
        if (d2 > 10.0) {
            this.cl = this.co = this.dz();
        }
        if (d1 > 10.0) {
            this.ck = this.cn = this.dv();
        }
        if (d0 < -10.0) {
            this.cj = this.cm = this.dt();
        }
        if (d2 < -10.0) {
            this.cl = this.co = this.dz();
        }
        if (d1 < -10.0) {
            this.ck = this.cn = this.dv();
        }
        this.cm += d0 * 0.25;
        this.co += d2 * 0.25;
        this.cn += d1 * 0.25;
    }

    protected void fR() {
        if (this.h(EntityPose.d)) {
            EntityPose entitypose = this.fA() ? EntityPose.b : (this.fH() ? EntityPose.c : (this.cd() ? EntityPose.d : (this.fn() ? EntityPose.e : (this.bW() && !this.cA.b ? EntityPose.f : EntityPose.a))));
            EntityPose entitypose1 = !(this.R_() || this.bS() || this.h(entitypose)) ? (this.h(EntityPose.f) ? EntityPose.f : EntityPose.d) : entitypose;
            this.b(entitypose1);
        }
    }

    protected boolean h(EntityPose entitypose) {
        return this.dO().a((Entity)this, this.a(entitypose).a(this.dm()).h(1.0E-7));
    }

    @Override
    protected SoundEffect aQ() {
        return SoundEffects.uu;
    }

    @Override
    protected SoundEffect aR() {
        return SoundEffects.us;
    }

    @Override
    protected SoundEffect aS() {
        return SoundEffects.ut;
    }

    @Override
    public int bQ() {
        return 10;
    }

    @Override
    public void a(SoundEffect soundeffect, float f2, float f1) {
        this.dO().a(this, this.dt(), this.dv(), this.dz(), soundeffect, this.de(), f2, f1);
    }

    public void a(SoundEffect soundeffect, SoundCategory soundcategory, float f2, float f1) {
    }

    @Override
    public SoundCategory de() {
        return SoundCategory.h;
    }

    @Override
    public int df() {
        return 20;
    }

    @Override
    public void b(byte b0) {
        if (b0 == 9) {
            this.L_();
        } else if (b0 == 23) {
            this.cE = false;
        } else if (b0 == 22) {
            this.cE = true;
        } else {
            super.b(b0);
        }
    }

    public void s() {
        this.cd = this.cc;
    }

    protected void t() {
    }

    @Override
    public void u() {
        if (!this.dO().B && this.fO() && this.bS()) {
            this.ad();
            if (!this.bS()) {
                this.g(false);
                return;
            }
        }
        super.u();
        this.cg = this.ch;
        this.ch = 0.0f;
    }

    @Override
    protected void fm() {
        super.fm();
        this.eR();
        this.ba = this.dE();
    }

    @Override
    public void m_() {
        if (this.cf > 0) {
            --this.cf;
        }
        if (this.dO().al() == EnumDifficulty.a && this.dO().ab().b(GameRules.k)) {
            if (this.ew() < this.eN() && this.ai % 20 == 0) {
                this.heal(1.0f, EntityRegainHealthEvent.RegainReason.REGEN);
            }
            if (this.ce.e() < 20.0f && this.ai % 20 == 0) {
                this.ce.b(this.ce.e() + 1.0f);
            }
            if (this.ce.c() && this.ai % 10 == 0) {
                this.ce.a(this.ce.a() + 1);
            }
        }
        this.h.j();
        this.cg = this.ch;
        super.m_();
        this.A((float)this.g(GenericAttributes.v));
        float f2 = this.aF() && !this.ex() && !this.cd() ? Math.min(0.1f, (float)this.dr().h()) : 0.0f;
        this.ch += (f2 - this.ch) * 0.4f;
        if (this.ew() > 0.0f && !this.R_()) {
            AxisAlignedBB axisalignedbb = this.bS() && !this.dc().dJ() ? this.cK().b(this.dc().cK()).c(1.0, 0.0, 1.0) : this.cK().c(1.0, 0.5, 1.0);
            List<Entity> list = this.dO().a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.am() == EntityTypes.M) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dJ()) continue;
                this.d(entity);
            }
            if (!list1.isEmpty()) {
                this.d((Entity)SystemUtils.a(list1, this.ah));
            }
        }
        this.c(this.gp());
        this.c(this.gq());
        if (!this.dO().B && (this.ac > 0.5f || this.bf()) || this.cA.b || this.fH() || this.az) {
            this.gm();
        }
    }

    private void c(@Nullable NBTTagCompound nbttagcompound) {
        if (!(nbttagcompound == null || nbttagcompound.e("Silent") && nbttagcompound.q("Silent") || this.dO().z.a(200) != 0)) {
            String s2 = nbttagcompound.l("id");
            EntityTypes.a(s2).filter(entitytypes -> entitytypes == EntityTypes.ax).ifPresent(entitytypes -> {
                if (!EntityParrot.a(this.dO(), this)) {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), EntityParrot.a(this.dO(), this.dO().z), this.de(), 1.0f, EntityParrot.a(this.dO().z));
                }
            });
        }
    }

    private void d(Entity entity) {
        entity.b_(this);
    }

    public int fS() {
        return this.ao.a(f);
    }

    public void r(int i2) {
        this.ao.a(f, i2);
    }

    public void s(int i2) {
        int j2 = this.fS();
        this.ao.a(f, j2 + i2);
    }

    public void a(int i2, float f2, net.minecraft.world.item.ItemStack itemstack) {
        this.bC = i2;
        this.bD = f2;
        this.bE = itemstack;
        if (!this.dO().B) {
            this.gm();
            this.c(4, true);
        }
    }

    @Override
    @Nonnull
    public net.minecraft.world.item.ItemStack dS() {
        return this.fn() && this.bE != null ? this.bE : super.dS();
    }

    @Override
    public void a(DamageSource damagesource) {
        World world;
        super.a(damagesource);
        this.av();
        if (!this.R_() && (world = this.dO()) instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            this.a(worldserver, damagesource);
        }
        if (damagesource != null) {
            this.n(-MathHelper.b((this.eE() + this.dE()) * ((float)Math.PI / 180)) * 0.1f, 0.1f, -MathHelper.a((this.eE() + this.dE()) * ((float)Math.PI / 180)) * 0.1f);
        } else {
            this.n(0.0, 0.1, 0.0);
        }
        this.a(StatisticList.N);
        this.a(StatisticList.i.b(StatisticList.m));
        this.a(StatisticList.i.b(StatisticList.n));
        this.aD();
        this.c(false);
        this.a(Optional.of(GlobalPos.a(this.dO().af(), this.do())));
    }

    @Override
    protected void ez() {
        super.ez();
        if (!this.dO().ab().b(GameRules.d)) {
            this.fT();
            this.h.k();
        }
    }

    protected void fT() {
        for (int i2 = 0; i2 < this.h.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack = this.h.a(i2);
            if (itemstack.e() || !EnchantmentManager.a(itemstack, EnchantmentEffectComponents.D)) continue;
            this.h.b(i2);
        }
    }

    @Override
    protected SoundEffect d(DamageSource damagesource) {
        return damagesource.k().d().a();
    }

    @Override
    protected SoundEffect n_() {
        return SoundEffects.uk;
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack itemstack, boolean flag) {
        return this.a(itemstack, false, flag);
    }

    @Nullable
    public EntityItem a(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1) {
        return this.drop(itemstack, flag, flag1, true);
    }

    @Nullable
    public EntityItem drop(net.minecraft.world.item.ItemStack itemstack, boolean flag, boolean flag1, boolean callEvent) {
        if (itemstack.e()) {
            return null;
        }
        if (this.dO().B) {
            this.a(EnumHand.a);
        }
        double d0 = this.dx() - (double)0.3f;
        EntityItem entityitem = new EntityItem(this.dO(), this.dt(), d0, this.dz(), itemstack);
        entityitem.b(40);
        if (flag1) {
            entityitem.b((Entity)this);
        }
        if (flag) {
            float f2 = this.ah.i() * 0.5f;
            float f1 = this.ah.i() * ((float)Math.PI * 2);
            entityitem.n(-MathHelper.a(f1) * f2, 0.2f, MathHelper.b(f1) * f2);
        } else {
            float f3 = 0.3f;
            float f1 = MathHelper.a(this.dG() * ((float)Math.PI / 180));
            float f2 = MathHelper.b(this.dG() * ((float)Math.PI / 180));
            float f32 = MathHelper.a(this.dE() * ((float)Math.PI / 180));
            float f4 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
            float f5 = this.ah.i() * ((float)Math.PI * 2);
            float f6 = 0.02f * this.ah.i();
            entityitem.n((double)(-f32 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f1 * 0.3f + 0.1f + (this.ah.i() - this.ah.i()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        }
        if (!callEvent) {
            return entityitem;
        }
        Player player = (Player)this.getBukkitEntity();
        Item drop = (Item)entityitem.getBukkitEntity();
        PlayerDropItemEvent event = new PlayerDropItemEvent(player, drop);
        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            ItemStack cur = player.getInventory().getItemInHand();
            if (flag1 && (cur == null || cur.getAmount() == 0)) {
                player.getInventory().setItemInHand(drop.getItemStack());
            } else if (flag1 && cur.isSimilar(drop.getItemStack()) && cur.getAmount() < cur.getMaxStackSize() && drop.getItemStack().getAmount() == 1) {
                cur.setAmount(cur.getAmount() + 1);
                player.getInventory().setItemInHand(cur);
            } else {
                player.getInventory().addItem(new ItemStack[]{drop.getItemStack()});
            }
            return null;
        }
        return entityitem;
    }

    public float c(IBlockData iblockdata) {
        float f2 = this.h.a(iblockdata);
        if (f2 > 1.0f) {
            f2 += (float)this.g(GenericAttributes.t);
        }
        if (MobEffectUtil.a(this)) {
            f2 *= 1.0f + (float)(MobEffectUtil.b(this) + 1) * 0.2f;
        }
        if (this.b(MobEffects.d)) {
            f2 *= (switch (this.c(MobEffects.d).e()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            });
        }
        f2 *= (float)this.g(GenericAttributes.f);
        if (((Entity)this).a(TagsFluid.a)) {
            f2 *= (float)this.f(GenericAttributes.C).f();
        }
        if (!this.aF()) {
            f2 /= 5.0f;
        }
        return f2;
    }

    public boolean d(IBlockData iblockdata) {
        return !iblockdata.y() || this.h.f().b(iblockdata);
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.a_(this.cD.getId());
        NBTTagList nbttaglist = nbttagcompound.c("Inventory", 10);
        this.h.b(nbttaglist);
        this.h.k = nbttagcompound.h("SelectedItemSlot");
        this.cz = nbttagcompound.g("SleepTimer");
        this.cs = nbttagcompound.j("XpP");
        this.cq = nbttagcompound.h("XpLevel");
        this.cr = nbttagcompound.h("XpTotal");
        this.ct = nbttagcompound.h("XpSeed");
        if (this.ct == 0) {
            this.ct = this.ah.f();
        }
        this.r(nbttagcompound.h("Score"));
        this.ce.a(nbttagcompound);
        this.cA.b(nbttagcompound);
        this.f(GenericAttributes.v).a(this.cA.b());
        if (nbttagcompound.b("EnderItems", 9)) {
            this.cb.a(nbttagcompound.c("EnderItems", 10), this.dQ());
        }
        if (nbttagcompound.b("ShoulderEntityLeft", 10)) {
            this.i(nbttagcompound.p("ShoulderEntityLeft"));
        }
        if (nbttagcompound.b("ShoulderEntityRight", 10)) {
            this.j(nbttagcompound.p("ShoulderEntityRight"));
        }
        if (nbttagcompound.b("LastDeathLocation", 10)) {
            DataResult dataresult = GlobalPos.b.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("LastDeathLocation"));
            Logger logger = b;
            Objects.requireNonNull(logger);
            this.a(dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)));
        }
        if (nbttagcompound.b("current_explosion_impact_pos", 9)) {
            DataResult dataresult1 = Vec3D.a.parse((DynamicOps)DynamicOpsNBT.a, (Object)nbttagcompound.c("current_explosion_impact_pos"));
            Logger logger1 = b;
            Objects.requireNonNull(logger1);
            dataresult1.resultOrPartial(arg_0 -> ((Logger)logger1).error(arg_0)).ifPresent(vec3d -> {
                this.cx = vec3d;
            });
        }
        this.cI = nbttagcompound.q("ignore_fall_damage_from_current_explosion");
        this.cJ = nbttagcompound.h("current_impulse_context_reset_grace_time");
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        GameProfileSerializer.e(nbttagcompound);
        nbttagcompound.a("Inventory", this.h.a(new NBTTagList()));
        nbttagcompound.a("SelectedItemSlot", this.h.k);
        nbttagcompound.a("SleepTimer", (short)this.cz);
        nbttagcompound.a("XpP", this.cs);
        nbttagcompound.a("XpLevel", this.cq);
        nbttagcompound.a("XpTotal", this.cr);
        nbttagcompound.a("XpSeed", this.ct);
        nbttagcompound.a("Score", this.fS());
        this.ce.b(nbttagcompound);
        this.cA.a(nbttagcompound);
        nbttagcompound.a("EnderItems", this.cb.a(this.dQ()));
        if (!this.gp().g()) {
            nbttagcompound.a("ShoulderEntityLeft", this.gp());
        }
        if (!this.gq().g()) {
            nbttagcompound.a("ShoulderEntityRight", this.gq());
        }
        this.gx().flatMap(globalpos -> {
            DataResult dataresult = GlobalPos.b.encodeStart((DynamicOps)DynamicOpsNBT.a, globalpos);
            Logger logger = b;
            Objects.requireNonNull(logger);
            return dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0));
        }).ifPresent(nbtbase -> nbttagcompound.a("LastDeathLocation", (NBTBase)nbtbase));
        if (this.cx != null) {
            nbttagcompound.a("current_explosion_impact_pos", (NBTBase)Vec3D.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.cx).getOrThrow());
        }
        nbttagcompound.a("ignore_fall_damage_from_current_explosion", this.cI);
        nbttagcompound.a("current_impulse_context_reset_grace_time", this.cJ);
    }

    @Override
    public boolean b(DamageSource damagesource) {
        return super.b(damagesource) ? true : (damagesource.a(DamageTypeTags.n) ? !this.dO().ab().b(GameRules.G) : (damagesource.a(DamageTypeTags.m) ? !this.dO().ab().b(GameRules.H) : (damagesource.a(DamageTypeTags.i) ? !this.dO().ab().b(GameRules.I) : (damagesource.a(DamageTypeTags.o) ? !this.dO().ab().b(GameRules.J) : false))));
    }

    @Override
    public boolean a(DamageSource damagesource, float f2) {
        boolean damaged;
        if (this.b(damagesource)) {
            return false;
        }
        if (this.cA.a && !damagesource.a(DamageTypeTags.d)) {
            return false;
        }
        this.bf = 0;
        if (this.ex()) {
            return false;
        }
        if (!this.dO().B) {
            // empty if block
        }
        if (damagesource.g()) {
            if (this.dO().al() == EnumDifficulty.a) {
                return false;
            }
            if (this.dO().al() == EnumDifficulty.b) {
                f2 = Math.min(f2 / 2.0f + 1.0f, f2);
            }
            if (this.dO().al() == EnumDifficulty.d) {
                f2 = f2 * 3.0f / 2.0f;
            }
        }
        if (damaged = super.a(damagesource, f2)) {
            this.gm();
        }
        return damaged;
    }

    @Override
    protected void d(EntityLiving entityliving) {
        super.d(entityliving);
        if (entityliving.fK()) {
            this.fU();
        }
    }

    @Override
    public boolean ep() {
        return !this.fZ().a && super.ep();
    }

    public boolean a(EntityHuman entityhuman) {
        Team team;
        if (entityhuman instanceof EntityPlayer) {
            EntityPlayer thatPlayer = (EntityPlayer)entityhuman;
            team = thatPlayer.getBukkitEntity().getScoreboard().getPlayerTeam((OfflinePlayer)thatPlayer.getBukkitEntity());
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        } else {
            OfflinePlayer thisPlayer = entityhuman.dO().getCraftServer().getOfflinePlayer(entityhuman.cB());
            team = entityhuman.dO().getCraftServer().getScoreboardManager().getMainScoreboard().getPlayerTeam(thisPlayer);
            if (team == null || team.allowFriendlyFire()) {
                return true;
            }
        }
        if (this instanceof EntityPlayer) {
            return !team.hasPlayer((OfflinePlayer)((EntityPlayer)this).getBukkitEntity());
        }
        return !team.hasPlayer(this.dO().getCraftServer().getOfflinePlayer(this.cB()));
    }

    @Override
    protected void b(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.c, EnumItemSlot.d, EnumItemSlot.e, EnumItemSlot.f);
    }

    @Override
    protected void c(DamageSource damagesource, float f2) {
        this.a(damagesource, f2, EnumItemSlot.f);
    }

    @Override
    protected void x(float f2) {
        if (this.bz.a(Items.vs)) {
            if (!this.dO().B) {
                this.b(StatisticList.c.b(this.bz.g()));
            }
            if (f2 >= 3.0f) {
                int i2 = 1 + MathHelper.d(f2);
                EnumHand enumhand = this.fs();
                this.bz.a(i2, (EntityLiving)this, EntityHuman.d(enumhand));
                if (this.bz.e()) {
                    if (enumhand == EnumHand.a) {
                        this.a(EnumItemSlot.a, net.minecraft.world.item.ItemStack.l);
                    } else {
                        this.a(EnumItemSlot.b, net.minecraft.world.item.ItemStack.l);
                    }
                    this.bz = net.minecraft.world.item.ItemStack.l;
                    this.a(SoundEffects.wE, 0.8f, 0.8f + this.dO().z.i() * 0.4f);
                }
            }
        }
    }

    @Override
    protected boolean actuallyHurt(DamageSource damagesource, float f2, EntityDamageEvent event) {
        return super.actuallyHurt(damagesource, f2, event);
    }

    public boolean Z() {
        return false;
    }

    public void a(TileEntitySign tileentitysign, boolean flag) {
    }

    public void a(CommandBlockListenerAbstract commandblocklistenerabstract) {
    }

    public void a(TileEntityCommand tileentitycommand) {
    }

    public void a(TileEntityStructure tileentitystructure) {
    }

    public void a(TileEntityJigsaw tileentityjigsaw) {
    }

    public void a(EntityHorseAbstract entityhorseabstract, IInventory iinventory) {
    }

    public OptionalInt a(@Nullable ITileInventory itileinventory) {
        return OptionalInt.empty();
    }

    public void a(int i2, MerchantRecipeList merchantrecipelist, int j2, int k2, boolean flag, boolean flag1) {
    }

    public void a(net.minecraft.world.item.ItemStack itemstack, EnumHand enumhand) {
    }

    public EnumInteractionResult a(Entity entity, EnumHand enumhand) {
        if (this.R_()) {
            if (entity instanceof ITileInventory) {
                this.a((ITileInventory)((Object)entity));
            }
            return EnumInteractionResult.e;
        }
        net.minecraft.world.item.ItemStack itemstack = this.b(enumhand);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.s();
        EnumInteractionResult enuminteractionresult = entity.a(this, enumhand);
        if (enuminteractionresult.a()) {
            if (this.cA.d && itemstack == this.b(enumhand) && itemstack.H() < itemstack1.H()) {
                itemstack.e(itemstack1.H());
            }
            return enuminteractionresult;
        }
        if (!itemstack.e() && entity instanceof EntityLiving) {
            EnumInteractionResult enuminteractionresult1;
            if (this.cA.d) {
                itemstack = itemstack1;
            }
            if ((enuminteractionresult1 = itemstack.a(this, (EntityLiving)entity, enumhand)).a()) {
                this.dO().a(GameEvent.r, entity.dm(), GameEvent.a.a(this));
                if (itemstack.e() && !this.cA.d) {
                    this.a(enumhand, net.minecraft.world.item.ItemStack.l);
                }
                return enuminteractionresult1;
            }
        }
        return EnumInteractionResult.e;
    }

    @Override
    public void bJ() {
        super.bJ();
        this.K = 0;
    }

    @Override
    protected boolean fc() {
        return super.fc() || this.fH();
    }

    @Override
    public boolean ec() {
        return !this.cA.b;
    }

    @Override
    protected Vec3D a(Vec3D vec3d, EnumMoveType enummovetype) {
        float f2 = this.dI();
        if (!this.cA.b && vec3d.d <= 0.0 && (enummovetype == EnumMoveType.a || enummovetype == EnumMoveType.b) && this.fP() && this.G(f2)) {
            double d0;
            double d1 = vec3d.e;
            double d2 = 0.05;
            double d3 = Math.signum(d0) * 0.05;
            double d4 = Math.signum(d1) * 0.05;
            for (d0 = vec3d.c; d0 != 0.0 && this.b(d0, 0.0, f2); d0 -= d3) {
                if (!(Math.abs(d0) <= 0.05)) continue;
                d0 = 0.0;
                break;
            }
            while (d1 != 0.0 && this.b(0.0, d1, f2)) {
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    break;
                }
                d1 -= d4;
            }
            while (d0 != 0.0 && d1 != 0.0 && this.b(d0, d1, f2)) {
                d0 = Math.abs(d0) <= 0.05 ? 0.0 : (d0 -= d3);
                if (Math.abs(d1) <= 0.05) {
                    d1 = 0.0;
                    continue;
                }
                d1 -= d4;
            }
            return new Vec3D(d0, vec3d.d, d1);
        }
        return vec3d;
    }

    private boolean G(float f2) {
        return this.aF() || this.ac < f2 && !this.b(0.0, 0.0, f2 - this.ac);
    }

    private boolean b(double d0, double d1, float f2) {
        AxisAlignedBB axisalignedbb = this.cK();
        return this.dO().a((Entity)this, new AxisAlignedBB(axisalignedbb.a + d0, axisalignedbb.b - (double)f2 - (double)1.0E-5f, axisalignedbb.c + d1, axisalignedbb.d + d0, axisalignedbb.b, axisalignedbb.f + d1));
    }

    public void e(Entity entity) {
        if (entity.cu() && !entity.u(this)) {
            float f2 = this.fn() ? this.bD : (float)this.g(GenericAttributes.c);
            net.minecraft.world.item.ItemStack itemstack = this.dS();
            DamageSource damagesource = this.dP().a(this);
            float f1 = this.a(entity, f2, damagesource) - f2;
            float f22 = this.F(0.5f);
            f2 *= 0.2f + f22 * f22 * 0.8f;
            f1 *= f22;
            if (entity.am().a(TagsEntity.H) && entity instanceof IProjectile) {
                IProjectile iprojectile = (IProjectile)entity;
                if (CraftEventFactory.handleNonLivingEntityDamageEvent(entity, damagesource, f1, false)) {
                    return;
                }
                if (iprojectile.a(ProjectileDeflection.c, this, this, true)) {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ud, this.de());
                    return;
                }
            }
            if (f2 > 0.0f || f1 > 0.0f) {
                net.minecraft.world.item.ItemStack itemstack1;
                boolean flag2;
                boolean flag1;
                boolean flag;
                boolean bl = flag = f22 > 0.9f;
                if (this.cc() && flag) {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uc, this.de(), 1.0f, 1.0f);
                    flag1 = true;
                } else {
                    flag1 = false;
                }
                f2 += itemstack.g().a(entity, f2, damagesource);
                boolean bl2 = flag2 = flag && this.ac > 0.0f && !this.aF() && !this.p_() && !this.bf() && !this.b(MobEffects.o) && !this.bS() && entity instanceof EntityLiving && !this.cc();
                if (flag2) {
                    f2 *= 1.5f;
                }
                float f3 = f2 + f1;
                boolean flag3 = false;
                double d0 = this.Z - this.Y;
                if (flag && !flag2 && !flag1 && this.aF() && d0 < (double)this.fj() && (itemstack1 = this.b(EnumHand.a)).g() instanceof ItemSword) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                if (entity instanceof EntityLiving) {
                    EntityLiving entityliving = (EntityLiving)entity;
                    f4 = entityliving.ew();
                }
                Vec3D vec3d = entity.dr();
                boolean flag4 = entity.a(damagesource, f3);
                if (flag4) {
                    float f5 = this.a(entity, damagesource) + (flag1 ? 1.0f : 0.0f);
                    if (f5 > 0.0f) {
                        if (entity instanceof EntityLiving) {
                            EntityLiving entityliving1 = (EntityLiving)entity;
                            entityliving1.p(f5 * 0.5f, MathHelper.a(this.dE() * ((float)Math.PI / 180)), -MathHelper.b(this.dE() * ((float)Math.PI / 180)));
                        } else {
                            entity.j(-MathHelper.a(this.dE() * ((float)Math.PI / 180)) * f5 * 0.5f, 0.1, MathHelper.b(this.dE() * ((float)Math.PI / 180)) * f5 * 0.5f);
                        }
                        this.i(this.dr().d(0.6, 1.0, 0.6));
                        this.h(false);
                    }
                    if (flag3) {
                        float f6 = 1.0f + (float)this.g(GenericAttributes.D) * f2;
                        List<EntityLiving> list = this.dO().a(EntityLiving.class, entity.cK().c(1.0, 0.25, 1.0));
                        for (EntityLiving entityliving2 : list) {
                            if (entityliving2 == this || entityliving2 == entity || this.s(entityliving2) || entityliving2 instanceof EntityArmorStand && ((EntityArmorStand)entityliving2).z() || !(this.g((Entity)entityliving2) < 9.0)) continue;
                            float f7 = this.a((Entity)entityliving2, f6, damagesource) * f22;
                            if (!entityliving2.a(this.dP().a(this).sweep(), f7)) continue;
                            entityliving2.p(0.4f, MathHelper.a(this.dE() * ((float)Math.PI / 180)), -MathHelper.b(this.dE() * ((float)Math.PI / 180)));
                            World world = this.dO();
                            if (!(world instanceof WorldServer)) continue;
                            WorldServer worldserver = (WorldServer)world;
                            EnchantmentManager.a(worldserver, (Entity)entityliving2, damagesource);
                        }
                        this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uf, this.de(), 1.0f, 1.0f);
                        this.fV();
                    }
                    if (entity instanceof EntityPlayer && entity.U) {
                        boolean cancelled = false;
                        Player player = (Player)entity.getBukkitEntity();
                        Vector velocity = CraftVector.toBukkit(vec3d);
                        PlayerVelocityEvent event = new PlayerVelocityEvent(player, velocity.clone());
                        this.dO().getCraftServer().getPluginManager().callEvent((Event)event);
                        if (event.isCancelled()) {
                            cancelled = true;
                        } else if (!velocity.equals((Object)event.getVelocity())) {
                            player.setVelocity(event.getVelocity());
                        }
                        if (!cancelled) {
                            ((EntityPlayer)entity).c.b(new PacketPlayOutEntityVelocity(entity));
                            entity.U = false;
                            entity.i(vec3d);
                        }
                    }
                    if (flag2) {
                        this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ub, this.de(), 1.0f, 1.0f);
                        this.b(entity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ue, this.de(), 1.0f, 1.0f);
                        } else {
                            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ug, this.de(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        this.c(entity);
                    }
                    this.A(entity);
                    Entity object = entity;
                    if (entity instanceof EntityComplexPart) {
                        object = ((EntityComplexPart)entity).b;
                    }
                    boolean flag5 = false;
                    World world1 = this.dO();
                    if (world1 instanceof WorldServer) {
                        WorldServer worldserver1 = (WorldServer)world1;
                        if (object instanceof EntityLiving) {
                            EntityLiving entityliving2;
                            entityliving2 = (EntityLiving)object;
                            flag5 = itemstack.a(entityliving2, this);
                        }
                        EnchantmentManager.a(worldserver1, entity, damagesource);
                    }
                    if (!this.dO().B && !itemstack.e() && object instanceof EntityLiving) {
                        if (flag5) {
                            itemstack.b((EntityLiving)object, this);
                        }
                        if (itemstack.e()) {
                            if (itemstack == this.eT()) {
                                this.a(EnumHand.a, net.minecraft.world.item.ItemStack.l);
                            } else {
                                this.a(EnumHand.b, net.minecraft.world.item.ItemStack.l);
                            }
                        }
                    }
                    if (entity instanceof EntityLiving) {
                        float f8 = f4 - ((EntityLiving)entity).ew();
                        this.a(StatisticList.G, Math.round(f8 * 10.0f));
                        if (this.dO() instanceof WorldServer && f8 > 2.0f) {
                            int i2 = (int)((double)f8 * 0.5);
                            ((WorldServer)this.dO()).a(Particles.g, entity.dt(), entity.e(0.5), entity.dz(), i2, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    this.causeFoodExhaustion(this.dO().spigotConfig.combatExhaustion, EntityExhaustionEvent.ExhaustionReason.ATTACK);
                } else {
                    this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.ud, this.de(), 1.0f, 1.0f);
                    if (this instanceof EntityPlayer) {
                        ((EntityPlayer)this).getBukkitEntity().updateInventory();
                    }
                }
            }
        }
    }

    protected float a(Entity entity, float f2, DamageSource damagesource) {
        return f2;
    }

    @Override
    protected void g(EntityLiving entityliving) {
        this.e((Entity)entityliving);
    }

    public void fU() {
        this.gt().a(Items.vs, 100);
        this.fx();
        this.dO().a((Entity)this, (byte)30);
    }

    public void b(Entity entity) {
    }

    public void c(Entity entity) {
    }

    public void fV() {
        double d0 = -MathHelper.a(this.dE() * ((float)Math.PI / 180));
        double d1 = MathHelper.b(this.dE() * ((float)Math.PI / 180));
        if (this.dO() instanceof WorldServer) {
            ((WorldServer)this.dO()).a(Particles.aj, this.dt() + d0, this.e(0.5), this.dz() + d1, 0, d0, 0.0, d1, 0.0);
        }
    }

    public void fW() {
    }

    @Override
    public void a(Entity.RemovalReason entity_removalreason) {
        this.remove(entity_removalreason, null);
    }

    @Override
    public void remove(Entity.RemovalReason entity_removalreason, EntityRemoveEvent.Cause cause) {
        super.remove(entity_removalreason, cause);
        this.cc.a(this);
        if (this.cd != null && this.ga()) {
            this.t();
        }
    }

    public boolean g() {
        return false;
    }

    public GameProfile fX() {
        return this.cD;
    }

    public PlayerInventory fY() {
        return this.h;
    }

    public PlayerAbilities fZ() {
        return this.cA;
    }

    @Override
    public boolean fL() {
        return this.cA.d;
    }

    public void a(net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1, ClickAction clickaction) {
    }

    public boolean ga() {
        return this.cd != this.cc;
    }

    public Either<EnumBedResult, Unit> a(BlockPosition blockposition) {
        return this.startSleepInBed(blockposition, false);
    }

    public Either<EnumBedResult, Unit> startSleepInBed(BlockPosition blockposition, boolean force) {
        this.b(blockposition);
        this.cz = 0;
        return Either.right((Object)((Object)Unit.a));
    }

    public void a(boolean flag, boolean flag1) {
        super.fI();
        if (this.dO() instanceof WorldServer && flag1) {
            ((WorldServer)this.dO()).e();
        }
        this.cz = flag ? 0 : 100;
    }

    @Override
    public void fI() {
        this.a(true, true);
    }

    public boolean gb() {
        return this.fH() && this.cz >= 100;
    }

    public int gc() {
        return this.cz;
    }

    public void a(IChatBaseComponent ichatbasecomponent, boolean flag) {
    }

    public void a(MinecraftKey minecraftkey) {
        this.b(StatisticList.i.b(minecraftkey));
    }

    public void a(MinecraftKey minecraftkey, int i2) {
        this.a(StatisticList.i.b(minecraftkey), i2);
    }

    public void b(Statistic<?> statistic) {
        this.a(statistic, 1);
    }

    public void a(Statistic<?> statistic, int i2) {
    }

    public void a(Statistic<?> statistic) {
    }

    public int a(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    public void a(RecipeHolder<?> recipeholder, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void b(List<MinecraftKey> list) {
    }

    public int b(Collection<RecipeHolder<?>> collection) {
        return 0;
    }

    @Override
    public void ff() {
        super.ff();
        this.a(StatisticList.E);
        if (this.cc()) {
            this.causeFoodExhaustion(this.dO().spigotConfig.jumpSprintExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP_SPRINT);
        } else {
            this.causeFoodExhaustion(this.dO().spigotConfig.jumpWalkExhaustion, EntityExhaustionEvent.ExhaustionReason.JUMP);
        }
    }

    @Override
    public void a(Vec3D vec3d) {
        double d0;
        if (this.cd() && !this.bS()) {
            double d1;
            d0 = this.bM().d;
            double d2 = d1 = d0 < -0.2 ? 0.085 : 0.06;
            if (d0 <= 0.0 || this.bn || !this.dO().a_(BlockPosition.a(this.dt(), this.dv() + 1.0 - 0.1, this.dz())).u().c()) {
                Vec3D vec3d1 = this.dr();
                this.i(vec3d1.b(0.0, (d0 - vec3d1.d) * d1, 0.0));
            }
        }
        if (this.cA.b && !this.bS()) {
            d0 = this.dr().d;
            super.a(vec3d);
            Vec3D vec3d2 = this.dr();
            this.n(vec3d2.c, d0 * 0.6, vec3d2.e);
            this.n();
            if (this.i(7) && !CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
                this.b(7, false);
            }
        } else {
            super.a(vec3d);
        }
    }

    @Override
    public void bl() {
        if (this.cA.b) {
            this.i(false);
        } else {
            super.bl();
        }
    }

    protected boolean h(BlockPosition blockposition) {
        return !this.dO().a_(blockposition).o(this.dO(), blockposition);
    }

    @Override
    public float fj() {
        return (float)this.g(GenericAttributes.v);
    }

    @Override
    public boolean a(float f2, float f1, DamageSource damagesource) {
        boolean flag;
        if (this.cA.c) {
            return false;
        }
        if (f2 >= 2.0f) {
            this.a(StatisticList.t, (int)Math.round((double)f2 * 100.0));
        }
        if (this.cI && this.cx != null) {
            double d0 = this.cx.d;
            this.gB();
            if (d0 < this.dv()) {
                return false;
            }
            float f22 = Math.min(f2, (float)(d0 - this.dv()));
            flag = super.a(f22, f1, damagesource);
        } else {
            flag = super.a(f2, f1, damagesource);
        }
        if (flag) {
            this.gC();
        }
        return flag;
    }

    public boolean gd() {
        net.minecraft.world.item.ItemStack itemstack;
        if (!this.aF() && !this.fA() && !this.bf() && !this.b(MobEffects.y) && (itemstack = this.a(EnumItemSlot.e)).a(Items.nT) && ItemElytra.i(itemstack)) {
            this.ge();
            return true;
        }
        return false;
    }

    public void ge() {
        if (!CraftEventFactory.callToggleGlideEvent(this, true).isCancelled()) {
            this.b(7, true);
        } else {
            this.b(7, true);
            this.b(7, false);
        }
    }

    public void gf() {
        if (!CraftEventFactory.callToggleGlideEvent(this, false).isCancelled()) {
            this.b(7, true);
            this.b(7, false);
        }
    }

    @Override
    protected void bo() {
        if (!this.R_()) {
            super.bo();
        }
    }

    @Override
    protected void b(BlockPosition blockposition, IBlockData iblockdata) {
        if (this.bf()) {
            this.aU();
            this.b(iblockdata);
        } else {
            BlockPosition blockposition1 = this.e(blockposition);
            if (!blockposition.equals(blockposition1)) {
                IBlockData iblockdata1 = this.dO().a_(blockposition1);
                if (iblockdata1.a(TagsBlock.bp)) {
                    this.a(iblockdata1, iblockdata);
                } else {
                    super.b(blockposition1, iblockdata1);
                }
            } else {
                super.b(blockposition, iblockdata);
            }
        }
    }

    @Override
    public EntityLiving.a eH() {
        return new EntityLiving.a(SoundEffects.ur, SoundEffects.uh);
    }

    @Override
    public boolean a(WorldServer worldserver, EntityLiving entityliving) {
        this.b(StatisticList.g.b(entityliving.am()));
        return true;
    }

    @Override
    public void a(IBlockData iblockdata, Vec3D vec3d) {
        if (!this.cA.b) {
            super.a(iblockdata, vec3d);
        }
        this.gB();
    }

    public void d(int i2) {
        this.s(i2);
        this.cs += (float)i2 / (float)this.gh();
        this.cr = MathHelper.a(this.cr + i2, 0, Integer.MAX_VALUE);
        while (this.cs < 0.0f) {
            float f2 = this.cs * (float)this.gh();
            if (this.cq > 0) {
                this.c(-1);
                this.cs = 1.0f + f2 / (float)this.gh();
                continue;
            }
            this.c(-1);
            this.cs = 0.0f;
        }
        while (this.cs >= 1.0f) {
            this.cs = (this.cs - 1.0f) * (float)this.gh();
            this.c(1);
            this.cs /= (float)this.gh();
        }
    }

    public int gg() {
        return this.ct;
    }

    public void a(net.minecraft.world.item.ItemStack itemstack, int i2) {
        this.cq -= i2;
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        this.ct = this.ah.f();
    }

    public void c(int i2) {
        this.cq += i2;
        if (this.cq < 0) {
            this.cq = 0;
            this.cs = 0.0f;
            this.cr = 0;
        }
        if (i2 > 0 && this.cq % 5 == 0 && (float)this.cB < (float)this.ai - 100.0f) {
            float f2 = this.cq > 30 ? 1.0f : (float)this.cq / 30.0f;
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uq, this.de(), f2 * 0.75f, 1.0f);
            this.cB = this.ai;
        }
    }

    public int gh() {
        return this.cq >= 30 ? 112 + (this.cq - 30) * 9 : (this.cq >= 15 ? 37 + (this.cq - 15) * 5 : 7 + this.cq * 2);
    }

    public void E(float f2) {
        this.causeFoodExhaustion(f2, EntityExhaustionEvent.ExhaustionReason.UNKNOWN);
    }

    public void causeFoodExhaustion(float f2, EntityExhaustionEvent.ExhaustionReason reason) {
        EntityExhaustionEvent event;
        if (!(this.cA.a || this.dO().B || (event = CraftEventFactory.callPlayerExhaustionEvent(this, reason, f2)).isCancelled())) {
            this.ce.a(event.getExhaustion());
        }
    }

    public Optional<WardenSpawnTracker> ab() {
        return Optional.empty();
    }

    public FoodMetaData gi() {
        return this.ce;
    }

    public boolean u(boolean flag) {
        return this.cA.a || flag || this.ce.c();
    }

    public boolean gj() {
        return this.ew() > 0.0f && this.ew() < this.eN();
    }

    public boolean gk() {
        return this.cA.e;
    }

    public boolean a(BlockPosition blockposition, EnumDirection enumdirection, net.minecraft.world.item.ItemStack itemstack) {
        if (this.cA.e) {
            return true;
        }
        BlockPosition blockposition1 = blockposition.a(enumdirection.g());
        ShapeDetectorBlock shapedetectorblock = new ShapeDetectorBlock(this.dO(), blockposition1, false);
        return itemstack.a(shapedetectorblock);
    }

    @Override
    protected int eg() {
        if (!this.dO().ab().b(GameRules.d) && !this.R_()) {
            int i2 = this.cq * 7;
            return i2 > 100 ? 100 : i2;
        }
        return 0;
    }

    @Override
    protected boolean eh() {
        return true;
    }

    @Override
    public boolean cF() {
        return true;
    }

    @Override
    protected Entity.MovementEmission bc() {
        return !this.cA.b && (!this.aF() || !this.bZ()) ? Entity.MovementEmission.d : Entity.MovementEmission.a;
    }

    public void z() {
    }

    @Override
    public IChatBaseComponent ah() {
        return IChatBaseComponent.b(this.cD.getName());
    }

    public InventoryEnderChest gl() {
        return this.cb;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(EnumItemSlot enumitemslot) {
        return enumitemslot == EnumItemSlot.a ? this.h.f() : (enumitemslot == EnumItemSlot.b ? this.h.j.get(0) : (enumitemslot.a() == EnumItemSlot.Function.b ? this.h.i.get(enumitemslot.b()) : net.minecraft.world.item.ItemStack.l));
    }

    @Override
    protected boolean b(EnumItemSlot enumitemslot) {
        return enumitemslot.a() == EnumItemSlot.Function.b;
    }

    @Override
    public void a(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack) {
        this.setItemSlot(enumitemslot, itemstack, false);
    }

    @Override
    public void setItemSlot(EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        this.e(itemstack);
        if (enumitemslot == EnumItemSlot.a) {
            this.onEquipItem(enumitemslot, this.h.h.set(this.h.k, itemstack), itemstack, silent);
        } else if (enumitemslot == EnumItemSlot.b) {
            this.onEquipItem(enumitemslot, this.h.j.set(0, itemstack), itemstack, silent);
        } else if (enumitemslot.a() == EnumItemSlot.Function.b) {
            this.onEquipItem(enumitemslot, this.h.i.set(enumitemslot.b(), itemstack), itemstack, silent);
        }
    }

    public boolean i(net.minecraft.world.item.ItemStack itemstack) {
        return this.h.f(itemstack);
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eW() {
        return Lists.newArrayList((Object[])new net.minecraft.world.item.ItemStack[]{this.eT(), this.eU()});
    }

    @Override
    public Iterable<net.minecraft.world.item.ItemStack> eV() {
        return this.h.i;
    }

    @Override
    public boolean d(EnumItemSlot enumitemslot) {
        return enumitemslot != EnumItemSlot.g;
    }

    public boolean h(NBTTagCompound nbttagcompound) {
        if (!this.bS() && this.aF() && !this.bf() && !this.az) {
            if (this.gp().g()) {
                this.i(nbttagcompound);
                this.g = this.dO().Z();
                return true;
            }
            if (this.gq().g()) {
                this.j(nbttagcompound);
                this.g = this.dO().Z();
                return true;
            }
            return false;
        }
        return false;
    }

    protected void gm() {
        if (this.g + 20L < this.dO().Z()) {
            if (this.respawnEntityOnShoulder(this.gp())) {
                this.i(new NBTTagCompound());
            }
            if (this.respawnEntityOnShoulder(this.gq())) {
                this.j(new NBTTagCompound());
            }
        }
    }

    private boolean respawnEntityOnShoulder(NBTTagCompound nbttagcompound) {
        if (!this.dO().B && !nbttagcompound.g()) {
            return EntityTypes.a(nbttagcompound, this.dO()).map(entity -> {
                if (entity instanceof EntityTameableAnimal) {
                    ((EntityTameableAnimal)entity).b(this.ax);
                }
                entity.a_(this.dt(), this.dv() + (double)0.7f, this.dz());
                return ((WorldServer)this.dO()).addWithUUID((Entity)entity, CreatureSpawnEvent.SpawnReason.SHOULDER_ENTITY);
            }).orElse(true);
        }
        return true;
    }

    @Override
    public abstract boolean R_();

    @Override
    public boolean bz() {
        return !this.R_() && super.bz();
    }

    @Override
    public boolean cd() {
        return !this.cA.b && !this.R_() && super.cd();
    }

    public abstract boolean f();

    @Override
    public boolean cC() {
        return !this.cA.b;
    }

    public Scoreboard gn() {
        return this.dO().M();
    }

    @Override
    public IChatBaseComponent S_() {
        IChatMutableComponent ichatmutablecomponent = ScoreboardTeam.a(this.ck(), this.ah());
        return this.a(ichatmutablecomponent);
    }

    private IChatMutableComponent a(IChatMutableComponent ichatmutablecomponent) {
        String s2 = this.fX().getName();
        return ichatmutablecomponent.a(chatmodifier -> chatmodifier.a(new ChatClickable(ChatClickable.EnumClickAction.d, "/tell " + s2 + " ")).a(this.cJ()).a(s2));
    }

    @Override
    public String cB() {
        return this.fX().getName();
    }

    @Override
    protected void D(float f2) {
        this.ar().a(e, Float.valueOf(f2));
    }

    @Override
    public float fo() {
        return this.ar().a(e).floatValue();
    }

    public boolean a(PlayerModelPart playermodelpart) {
        return (this.ar().a(bX) & playermodelpart.a()) == playermodelpart.a();
    }

    @Override
    public SlotAccess a_(int i2) {
        if (i2 == 499) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cd.g();
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack itemstack) {
                    EntityHuman.this.cd.b(itemstack);
                    return true;
                }
            };
        }
        final int j2 = i2 - 500;
        if (j2 >= 0 && j2 < 4) {
            return new SlotAccess(){

                @Override
                public net.minecraft.world.item.ItemStack a() {
                    return EntityHuman.this.cc.r().a(j2);
                }

                @Override
                public boolean a(net.minecraft.world.item.ItemStack itemstack) {
                    EntityHuman.this.cc.r().a(j2, itemstack);
                    EntityHuman.this.cc.a(EntityHuman.this.h);
                    return true;
                }
            };
        }
        if (i2 >= 0 && i2 < this.h.h.size()) {
            return SlotAccess.a(this.h, i2);
        }
        int k2 = i2 - 200;
        return k2 >= 0 && k2 < this.cb.b() ? SlotAccess.a(this.cb, k2) : super.a_(i2);
    }

    public boolean go() {
        return this.cE;
    }

    public void v(boolean flag) {
        this.cE = flag;
    }

    @Override
    public void h(int i2) {
        super.h(this.cA.a ? Math.min(i2, 1) : i2);
    }

    @Override
    public EnumMainHand fq() {
        return this.ao.a(bY) == 0 ? EnumMainHand.a : EnumMainHand.b;
    }

    public void a(EnumMainHand enummainhand) {
        this.ao.a(bY, (byte)(enummainhand != EnumMainHand.a ? 1 : 0));
    }

    public NBTTagCompound gp() {
        return this.ao.a(bZ);
    }

    public void i(NBTTagCompound nbttagcompound) {
        this.ao.a(bZ, nbttagcompound);
    }

    public NBTTagCompound gq() {
        return this.ao.a(ca);
    }

    public void j(NBTTagCompound nbttagcompound) {
        this.ao.a(ca, nbttagcompound);
    }

    public float gr() {
        return (float)(1.0 / this.g(GenericAttributes.e) * 20.0);
    }

    public float F(float f2) {
        return MathHelper.a(((float)this.aT + f2) / this.gr(), 0.0f, 1.0f);
    }

    public void gs() {
        this.aT = 0;
    }

    public ItemCooldown gt() {
        return this.cG;
    }

    @Override
    protected float aO() {
        return !this.cA.b && !this.fA() ? super.aO() : 1.0f;
    }

    public float gu() {
        return (float)this.g(GenericAttributes.q);
    }

    public boolean gv() {
        return this.cA.d && this.G() >= 2;
    }

    @Override
    public boolean f(net.minecraft.world.item.ItemStack itemstack) {
        EnumItemSlot enumitemslot = this.h(itemstack);
        return this.a(enumitemslot).e();
    }

    @Override
    public EntitySize e(EntityPose entitypose) {
        return d.getOrDefault((Object)entitypose, bW);
    }

    @Override
    public ImmutableList<EntityPose> fE() {
        return ImmutableList.of((Object)((Object)EntityPose.a), (Object)((Object)EntityPose.f), (Object)((Object)EntityPose.d));
    }

    @Override
    public net.minecraft.world.item.ItemStack g(net.minecraft.world.item.ItemStack itemstack) {
        if (!(itemstack.g() instanceof ItemProjectileWeapon)) {
            return net.minecraft.world.item.ItemStack.l;
        }
        Predicate<net.minecraft.world.item.ItemStack> predicate = ((ItemProjectileWeapon)itemstack.g()).d();
        net.minecraft.world.item.ItemStack itemstack1 = ItemProjectileWeapon.a(this, predicate);
        if (!itemstack1.e()) {
            return itemstack1;
        }
        predicate = ((ItemProjectileWeapon)itemstack.g()).b();
        for (int i2 = 0; i2 < this.h.b(); ++i2) {
            net.minecraft.world.item.ItemStack itemstack2 = this.h.a(i2);
            if (!predicate.test(itemstack2)) continue;
            return itemstack2;
        }
        return this.cA.d ? new net.minecraft.world.item.ItemStack(Items.ow) : net.minecraft.world.item.ItemStack.l;
    }

    @Override
    public net.minecraft.world.item.ItemStack a(World world, net.minecraft.world.item.ItemStack itemstack, FoodInfo foodinfo) {
        this.gi().eat(itemstack, foodinfo);
        this.b(StatisticList.c.b(itemstack.g()));
        world.a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.uj, SoundCategory.h, 0.5f, world.z.i() * 0.1f + 0.9f);
        if (this instanceof EntityPlayer) {
            CriterionTriggers.A.a((EntityPlayer)this, itemstack);
        }
        net.minecraft.world.item.ItemStack itemstack1 = super.a(world, itemstack, foodinfo);
        Optional<net.minecraft.world.item.ItemStack> optional = foodinfo.f();
        if (optional.isPresent() && !this.fL()) {
            if (itemstack1.e()) {
                return optional.get().s();
            }
            if (!this.dO().x_()) {
                this.fY().f(optional.get().s());
            }
        }
        return itemstack1;
    }

    @Override
    public Vec3D s(float f2) {
        float f3;
        double d0 = 0.22 * (this.fq() == EnumMainHand.b ? -1.0 : 1.0);
        float f1 = MathHelper.i(f2 * 0.5f, this.dG(), this.P) * ((float)Math.PI / 180);
        float f22 = MathHelper.i(f2, this.aZ, this.aY) * ((float)Math.PI / 180);
        if (!this.fA() && !this.fn()) {
            if (this.ce()) {
                return this.m(f2).e(new Vec3D(d0, 0.2, -0.15).a(-f1).b(-f22));
            }
            double d2 = this.cK().c() - 1.0;
            double d1 = this.cb() ? -0.2 : 0.07;
            return this.m(f2).e(new Vec3D(d0, d2, d1).b(-f22));
        }
        Vec3D vec3d = this.g(f2);
        Vec3D vec3d1 = this.dr();
        double d1 = vec3d1.i();
        double d3 = vec3d.i();
        if (d1 > 0.0 && d3 > 0.0) {
            double d4 = (vec3d1.c * vec3d.c + vec3d1.e * vec3d.e) / Math.sqrt(d1 * d3);
            double d5 = vec3d1.c * vec3d.e - vec3d1.e * vec3d.c;
            f3 = (float)(Math.signum(d5) * Math.acos(d4));
        } else {
            f3 = 0.0f;
        }
        return this.m(f2).e(new Vec3D(d0, -0.11, 0.85).c(-f3).a(-f1).b(-f22));
    }

    @Override
    public boolean dN() {
        return true;
    }

    public boolean gw() {
        return this.fr() && this.ft().a(Items.qX);
    }

    @Override
    public boolean dM() {
        return false;
    }

    public Optional<GlobalPos> gx() {
        return this.cH;
    }

    public void a(Optional<GlobalPos> optional) {
        this.cH = optional;
    }

    @Override
    public float eE() {
        return this.cw;
    }

    @Override
    public void n(float f2) {
        super.n(f2);
        this.cw = f2;
    }

    @Override
    public boolean dH() {
        return true;
    }

    @Override
    protected float fi() {
        return this.cA.b && !this.bS() ? (this.cc() ? this.cA.a() * 2.0f : this.cA.a()) : (this.cc() ? 0.025999999f : 0.02f);
    }

    public double gy() {
        return this.g(GenericAttributes.g);
    }

    public double gz() {
        return this.g(GenericAttributes.j);
    }

    public boolean b(Entity entity, double d0) {
        return entity.dJ() ? false : this.a(entity.cK(), d0);
    }

    public boolean a(AxisAlignedBB axisalignedbb, double d0) {
        double d1 = this.gz() + d0;
        return axisalignedbb.e(this.by()) < d1 * d1;
    }

    public boolean a(BlockPosition blockposition, double d0) {
        double d1 = this.gy() + d0;
        return new AxisAlignedBB(blockposition).e(this.by()) < d1 * d1;
    }

    public void w(boolean flag) {
        this.cI = flag;
        this.cJ = flag ? 40 : 0;
    }

    public boolean gA() {
        return this.cI;
    }

    public void gB() {
        if (this.cJ == 0) {
            this.gC();
        }
    }

    public void gC() {
        this.cJ = 0;
        this.cy = null;
        this.cx = null;
        this.cI = false;
    }

    public static enum EnumBedResult {
        a,
        b(IChatBaseComponent.c("block.minecraft.bed.no_sleep")),
        c(IChatBaseComponent.c("block.minecraft.bed.too_far_away")),
        d(IChatBaseComponent.c("block.minecraft.bed.obstructed")),
        e,
        f(IChatBaseComponent.c("block.minecraft.bed.not_safe"));

        @Nullable
        private final IChatBaseComponent g;

        private EnumBedResult() {
            this.g = null;
        }

        private EnumBedResult(IChatBaseComponent ichatbasecomponent) {
            this.g = ichatbasecomponent;
        }

        @Nullable
        public IChatBaseComponent a() {
            return this.g;
        }
    }
}

