/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import it.unimi.dsi.fastutil.doubles.DoubleDoubleImmutablePair;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.entity.EntityRemoveEvent;

public class EntityFireworks
extends IProjectile
implements ItemSupplier {
    public static final DataWatcherObject<ItemStack> b = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.h);
    private static final DataWatcherObject<OptionalInt> c = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.v);
    public static final DataWatcherObject<Boolean> d = DataWatcher.a(EntityFireworks.class, DataWatcherRegistry.k);
    public int e;
    public int f;
    @Nullable
    public EntityLiving g;

    public EntityFireworks(EntityTypes<? extends EntityFireworks> entitytypes, World world) {
        super((EntityTypes<? extends IProjectile>)entitytypes, world);
    }

    public EntityFireworks(World world, double d0, double d1, double d2, ItemStack itemstack) {
        super((EntityTypes<? extends IProjectile>)EntityTypes.P, world);
        this.e = 0;
        this.a_(d0, d1, d2);
        this.ao.a(b, itemstack.s());
        int i2 = 1;
        Fireworks fireworks = itemstack.a(DataComponents.V);
        if (fireworks != null) {
            i2 += fireworks.a();
        }
        this.n(this.ah.a(0.0, 0.002297), 0.05, this.ah.a(0.0, 0.002297));
        this.f = 10 * i2 + this.ah.a(6) + this.ah.a(7);
    }

    public EntityFireworks(World world, @Nullable Entity entity, double d0, double d1, double d2, ItemStack itemstack) {
        this(world, d0, d1, d2, itemstack);
        this.c(entity);
    }

    public EntityFireworks(World world, ItemStack itemstack, EntityLiving entityliving) {
        this(world, entityliving, entityliving.dt(), entityliving.dv(), entityliving.dz(), itemstack);
        this.ao.a(c, OptionalInt.of(entityliving.an()));
        this.g = entityliving;
    }

    public EntityFireworks(World world, ItemStack itemstack, double d0, double d1, double d2, boolean flag) {
        this(world, d0, d1, d2, itemstack);
        this.ao.a(d, flag);
    }

    public EntityFireworks(World world, ItemStack itemstack, Entity entity, double d0, double d1, double d2, boolean flag) {
        this(world, itemstack, d0, d1, d2, flag);
        this.c(entity);
    }

    @Override
    public void inactiveTick() {
        ++this.e;
        if (!this.dO().B && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.v();
        }
        super.inactiveTick();
    }

    @Override
    protected void a(DataWatcher.a datawatcher_a) {
        datawatcher_a.a(b, EntityFireworks.A());
        datawatcher_a.a(c, OptionalInt.empty());
        datawatcher_a.a(d, false);
    }

    @Override
    public boolean a(double d0) {
        return d0 < 4096.0 && !this.y();
    }

    @Override
    public boolean k(double d0, double d1, double d2) {
        return super.k(d0, d1, d2) && !this.y();
    }

    @Override
    public void l() {
        super.l();
        if (this.y()) {
            if (this.g == null) {
                this.ao.a(c).ifPresent(i2 -> {
                    Entity entity = this.dO().a(i2);
                    if (entity instanceof EntityLiving) {
                        this.g = (EntityLiving)entity;
                    }
                });
            }
            if (this.g != null) {
                Vec3D vec3d;
                if (this.g.fA()) {
                    Vec3D vec3d1 = this.g.bM();
                    double d0 = 1.5;
                    double d1 = 0.1;
                    Vec3D vec3d2 = this.g.dr();
                    this.g.i(vec3d2.b(vec3d1.c * 0.1 + (vec3d1.c * 1.5 - vec3d2.c) * 0.5, vec3d1.d * 0.1 + (vec3d1.d * 1.5 - vec3d2.d) * 0.5, vec3d1.e * 0.1 + (vec3d1.e * 1.5 - vec3d2.e) * 0.5));
                    vec3d = this.g.a(Items.uu);
                } else {
                    vec3d = Vec3D.b;
                }
                this.a_(this.g.dt() + vec3d.c, this.g.dv() + vec3d.d, this.g.dz() + vec3d.e);
                this.i(this.g.dr());
            }
        } else {
            if (!this.t()) {
                double d2 = this.Q ? 1.0 : 1.15;
                this.i(this.dr().d(d2, 1.0, d2).b(0.0, 0.04, 0.0));
            }
            Vec3D vec3d = this.dr();
            this.a(EnumMoveType.a, vec3d);
            this.i(vec3d);
        }
        MovingObjectPosition movingobjectposition = ProjectileHelper.a((Entity)this, this::b);
        if (!this.ag) {
            this.preHitTargetOrDeflectSelf(movingobjectposition);
            this.av = true;
        }
        this.I();
        if (this.e == 0 && !this.aX()) {
            this.dO().a((EntityHuman)null, this.dt(), this.dv(), this.dz(), SoundEffects.iP, SoundCategory.i, 3.0f, 1.0f);
        }
        ++this.e;
        if (this.dO().B && this.e % 2 < 2) {
            this.dO().a(Particles.D, this.dt(), this.dv(), this.dz(), this.ah.k() * 0.05, -this.dr().d * 0.5, this.ah.k() * 0.05);
        }
        if (!this.dO().B && this.e > this.f && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.v();
        }
    }

    private void v() {
        this.dO().a((Entity)this, (byte)17);
        this.a(GameEvent.w, this.s());
        this.x();
        this.discard(EntityRemoveEvent.Cause.EXPLODE);
    }

    @Override
    protected void a(MovingObjectPositionEntity movingobjectpositionentity) {
        super.a(movingobjectpositionentity);
        if (!this.dO().B && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.v();
        }
    }

    @Override
    protected void a(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = new BlockPosition(movingobjectpositionblock.a());
        this.dO().a_(blockposition).a(this.dO(), blockposition, (Entity)this);
        if (!this.dO().x_() && this.w() && !CraftEventFactory.callFireworkExplodeEvent(this).isCancelled()) {
            this.v();
        }
        super.a(movingobjectpositionblock);
    }

    private boolean w() {
        return !this.z().isEmpty();
    }

    private void x() {
        float f2 = 0.0f;
        List<FireworkExplosion> list = this.z();
        if (!list.isEmpty()) {
            f2 = 5.0f + (float)(list.size() * 2);
        }
        if (f2 > 0.0f) {
            if (this.g != null) {
                this.g.a(this.dP().a(this, this.s()), 5.0f + (float)(list.size() * 2));
            }
            double d0 = 5.0;
            Vec3D vec3d = this.dm();
            List<EntityLiving> list1 = this.dO().a(EntityLiving.class, this.cK().g(5.0));
            for (EntityLiving entityliving : list1) {
                if (entityliving == this.g || !(this.g(entityliving) <= 25.0)) continue;
                boolean flag = false;
                for (int i2 = 0; i2 < 2; ++i2) {
                    Vec3D vec3d1 = new Vec3D(entityliving.dt(), entityliving.e(0.5 * (double)i2), entityliving.dz());
                    MovingObjectPositionBlock movingobjectpositionblock = this.dO().a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this));
                    if (movingobjectpositionblock.c() != MovingObjectPosition.EnumMovingObjectType.a) continue;
                    flag = true;
                    break;
                }
                if (!flag) continue;
                float f1 = f2 * (float)Math.sqrt((5.0 - (double)this.f(entityliving)) / 5.0);
                entityliving.a(this.dP().a(this, this.s()), f1);
            }
        }
    }

    private boolean y() {
        return this.ao.a(c).isPresent();
    }

    public boolean t() {
        return this.ao.a(d);
    }

    @Override
    public void b(byte b0) {
        if (b0 == 17 && this.dO().B) {
            Vec3D vec3d = this.dr();
            this.dO().a(this.dt(), this.dv(), this.dz(), vec3d.c, vec3d.d, vec3d.e, this.z());
        }
        super.b(b0);
    }

    @Override
    public void b(NBTTagCompound nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("Life", this.e);
        nbttagcompound.a("LifeTime", this.f);
        nbttagcompound.a("FireworksItem", this.p().a(this.dQ()));
        nbttagcompound.a("ShotAtAngle", this.ao.a(d));
    }

    @Override
    public void a(NBTTagCompound nbttagcompound) {
        super.a(nbttagcompound);
        this.e = nbttagcompound.h("Life");
        this.f = nbttagcompound.h("LifeTime");
        if (nbttagcompound.b("FireworksItem", 10)) {
            this.ao.a(b, ItemStack.a((HolderLookup.a)this.dQ(), (NBTBase)nbttagcompound.p("FireworksItem")).orElseGet(EntityFireworks::A));
        } else {
            this.ao.a(b, EntityFireworks.A());
        }
        if (nbttagcompound.e("ShotAtAngle")) {
            this.ao.a(d, nbttagcompound.q("ShotAtAngle"));
        }
    }

    private List<FireworkExplosion> z() {
        ItemStack itemstack = this.ao.a(b);
        Fireworks fireworks = itemstack.a(DataComponents.V);
        return fireworks != null ? fireworks.b() : List.of();
    }

    @Override
    public ItemStack p() {
        return this.ao.a(b);
    }

    @Override
    public boolean cu() {
        return false;
    }

    private static ItemStack A() {
        return new ItemStack(Items.uu);
    }

    @Override
    public DoubleDoubleImmutablePair a_(EntityLiving entityliving, DamageSource damagesource) {
        double d0 = entityliving.dm().c - this.dm().c;
        double d1 = entityliving.dm().e - this.dm().e;
        return DoubleDoubleImmutablePair.of((double)d0, (double)d1);
    }
}

