/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.raid.RaidStopEvent;

public class Raid {
    private static final int h = 2;
    private static final int i = 0;
    private static final int j = 1;
    private static final int k = 2;
    private static final int l = 32;
    private static final int m = 48000;
    private static final int n = 3;
    private static final IChatBaseComponent o = IChatBaseComponent.c("block.minecraft.ominous_banner").a(EnumChatFormat.g);
    private static final String p = "event.minecraft.raid.raiders_remaining";
    public static final int a = 16;
    private static final int q = 40;
    private static final int r = 300;
    public static final int b = 2400;
    public static final int c = 600;
    private static final int s = 30;
    public static final int d = 24000;
    public static final int e = 5;
    private static final int t = 2;
    private static final IChatBaseComponent u = IChatBaseComponent.c("event.minecraft.raid");
    private static final IChatBaseComponent v = IChatBaseComponent.c("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent w = IChatBaseComponent.c("event.minecraft.raid.defeat.full");
    private static final int x = 48000;
    public static final int f = 9216;
    public static final int g = 12544;
    private final Map<Integer, EntityRaider> y = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> z = Maps.newHashMap();
    public final Set<UUID> A = Sets.newHashSet();
    public long B;
    private BlockPosition C;
    private final WorldServer D;
    private boolean E;
    private final int F;
    public float G;
    public int H;
    private boolean I;
    private int J;
    private final BossBattleServer K = new BossBattleServer(u, BossBattle.BarColor.c, BossBattle.BarStyle.c);
    private int L;
    private int M;
    private final RandomSource N = RandomSource.a();
    public final int O;
    private Status P;
    private int Q;
    private Optional<BlockPosition> R = Optional.empty();

    public Raid(int i2, WorldServer worldserver, BlockPosition blockposition) {
        this.F = i2;
        this.D = worldserver;
        this.I = true;
        this.M = 300;
        this.K.a(0.0f);
        this.C = blockposition;
        this.O = this.a(worldserver.al());
        this.P = Status.a;
    }

    public Raid(WorldServer worldserver, NBTTagCompound nbttagcompound) {
        this.D = worldserver;
        this.F = nbttagcompound.h("Id");
        this.E = nbttagcompound.q("Started");
        this.I = nbttagcompound.q("Active");
        this.B = nbttagcompound.i("TicksActive");
        this.H = nbttagcompound.h("BadOmenLevel");
        this.J = nbttagcompound.h("GroupsSpawned");
        this.M = nbttagcompound.h("PreRaidTicks");
        this.L = nbttagcompound.h("PostRaidTicks");
        this.G = nbttagcompound.j("TotalHealth");
        this.C = new BlockPosition(nbttagcompound.h("CX"), nbttagcompound.h("CY"), nbttagcompound.h("CZ"));
        this.O = nbttagcompound.h("NumGroups");
        this.P = Status.a(nbttagcompound.l("Status"));
        this.A.clear();
        if (nbttagcompound.b("HeroesOfTheVillage", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("HeroesOfTheVillage", 11);
            for (NBTBase nbtbase : nbttaglist) {
                this.A.add(GameProfileSerializer.a(nbtbase));
            }
        }
    }

    public boolean a() {
        return this.e() || this.f();
    }

    public boolean b() {
        return this.c() && this.r() == 0 && this.M > 0;
    }

    public boolean c() {
        return this.J > 0;
    }

    public boolean d() {
        return this.P == Status.d;
    }

    public boolean e() {
        return this.P == Status.b;
    }

    public boolean f() {
        return this.P == Status.c;
    }

    public boolean isInProgress() {
        return this.P == Status.a;
    }

    public float g() {
        return this.G;
    }

    public Set<EntityRaider> h() {
        HashSet set = Sets.newHashSet();
        for (Set<EntityRaider> set1 : this.z.values()) {
            set.addAll(set1);
        }
        return set;
    }

    public World i() {
        return this.D;
    }

    public boolean j() {
        return this.E;
    }

    public int k() {
        return this.J;
    }

    private Predicate<EntityPlayer> w() {
        return entityplayer -> {
            BlockPosition blockposition = entityplayer.do();
            return entityplayer.bE() && this.D.d(blockposition) == this;
        };
    }

    private void x() {
        HashSet set = Sets.newHashSet(this.K.g());
        List<EntityPlayer> list = this.D.a(this.w());
        for (EntityPlayer entityplayer : list) {
            if (set.contains(entityplayer)) continue;
            this.K.a(entityplayer);
        }
        for (EntityPlayer entityplayer : set) {
            if (list.contains(entityplayer)) continue;
            this.K.b(entityplayer);
        }
    }

    public int l() {
        return 5;
    }

    public int m() {
        return this.H;
    }

    public void a(int i2) {
        this.H = i2;
    }

    public boolean a(EntityPlayer entityplayer) {
        MobEffect mobeffect = entityplayer.c(MobEffects.I);
        if (mobeffect == null) {
            return false;
        }
        this.H += mobeffect.e() + 1;
        this.H = MathHelper.a(this.H, 0, this.l());
        if (!this.c()) {
            entityplayer.a(StatisticList.aA);
            CriterionTriggers.J.a(entityplayer);
        }
        return true;
    }

    public void n() {
        this.I = false;
        this.K.b();
        this.P = Status.d;
    }

    public void o() {
        if (!this.d()) {
            if (this.P == Status.a) {
                boolean flag1;
                boolean flag = this.I;
                this.I = this.D.B(this.C);
                if (this.D.al() == EnumDifficulty.a) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.PEACE);
                    this.n();
                    return;
                }
                if (flag != this.I) {
                    this.K.d(this.I);
                }
                if (!this.I) {
                    return;
                }
                if (!this.D.c(this.C)) {
                    this.y();
                }
                if (!this.D.c(this.C)) {
                    if (this.J > 0) {
                        this.P = Status.c;
                        CraftEventFactory.callRaidFinishEvent(this, new ArrayList<Player>());
                    } else {
                        CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.NOT_IN_VILLAGE);
                        this.n();
                    }
                }
                ++this.B;
                if (this.B >= 48000L) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.TIMEOUT);
                    this.n();
                    return;
                }
                int i2 = this.r();
                if (i2 == 0 && this.z()) {
                    if (this.M > 0) {
                        boolean flag2;
                        flag1 = this.R.isPresent();
                        boolean bl = flag2 = !flag1 && this.M % 5 == 0;
                        if (flag1 && !this.D.f(this.R.get())) {
                            flag2 = true;
                        }
                        if (flag2) {
                            int b0 = 0;
                            if (this.M < 100) {
                                b0 = 1;
                            } else if (this.M < 40) {
                                b0 = 2;
                            }
                            this.R = this.d(b0);
                        }
                        if (this.M == 300 || this.M % 20 == 0) {
                            this.x();
                        }
                        --this.M;
                        this.K.a(MathHelper.a((float)(300 - this.M) / 300.0f, 0.0f, 1.0f));
                    } else if (this.M == 0 && this.J > 0) {
                        this.M = 300;
                        this.K.a(u);
                        return;
                    }
                }
                if (this.B % 20L == 0L) {
                    this.x();
                    this.E();
                    if (i2 > 0) {
                        if (i2 <= 2) {
                            this.K.a(u.f().f(" - ").b(IChatBaseComponent.a(p, i2)));
                        } else {
                            this.K.a(u);
                        }
                    } else {
                        this.K.a(u);
                    }
                }
                flag1 = false;
                int j2 = 0;
                while (this.F()) {
                    BlockPosition blockposition;
                    BlockPosition blockPosition = blockposition = this.R.isPresent() ? this.R.get() : this.a(j2, 20);
                    if (blockposition != null) {
                        this.E = true;
                        this.b(blockposition);
                        if (!flag1) {
                            this.a(blockposition);
                            flag1 = true;
                        }
                    } else {
                        ++j2;
                    }
                    if (j2 <= 3) continue;
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.UNSPAWNABLE);
                    this.n();
                    break;
                }
                if (this.j() && !this.z() && i2 == 0) {
                    if (this.L < 40) {
                        ++this.L;
                    } else {
                        this.P = Status.b;
                        Iterator<UUID> iterator = this.A.iterator();
                        ArrayList<Player> winners = new ArrayList<Player>();
                        while (iterator.hasNext()) {
                            UUID uuid = iterator.next();
                            Entity entity = this.D.a(uuid);
                            if (!(entity instanceof EntityLiving)) continue;
                            EntityLiving entityliving = (EntityLiving)entity;
                            if (entity.R_()) continue;
                            entityliving.b(new MobEffect(MobEffects.F, 48000, this.H - 1, false, false, true));
                            if (!(entityliving instanceof EntityPlayer)) continue;
                            EntityPlayer entityplayer = (EntityPlayer)entityliving;
                            entityplayer.a(StatisticList.aB);
                            CriterionTriggers.I.a(entityplayer);
                            winners.add(entityplayer.getBukkitEntity());
                        }
                        CraftEventFactory.callRaidFinishEvent(this, winners);
                    }
                }
                this.G();
            } else if (this.a()) {
                ++this.Q;
                if (this.Q >= 600) {
                    CraftEventFactory.callRaidStopEvent(this, RaidStopEvent.Reason.FINISHED);
                    this.n();
                    return;
                }
                if (this.Q % 20 == 0) {
                    this.x();
                    this.K.d(true);
                    if (this.e()) {
                        this.K.a(0.0f);
                        this.K.a(v);
                    } else {
                        this.K.a(w);
                    }
                }
            }
        }
    }

    private void y() {
        Stream<SectionPosition> stream = SectionPosition.a(SectionPosition.a(this.C), 2);
        WorldServer worldserver = this.D;
        Objects.requireNonNull(this.D);
        stream.filter(worldserver::a).map(SectionPosition::k).min(Comparator.comparingDouble(blockposition -> blockposition.j(this.C))).ifPresent(this::c);
    }

    private Optional<BlockPosition> d(int i2) {
        for (int j2 = 0; j2 < 3; ++j2) {
            BlockPosition blockposition = this.a(i2, 1);
            if (blockposition == null) continue;
            return Optional.of(blockposition);
        }
        return Optional.empty();
    }

    private boolean z() {
        return this.B() ? !this.C() : !this.A();
    }

    private boolean A() {
        return this.k() == this.O;
    }

    private boolean B() {
        return this.H > 1;
    }

    private boolean C() {
        return this.k() > this.O;
    }

    private boolean D() {
        return this.A() && this.r() == 0 && this.B();
    }

    private void E() {
        Iterator<Set<EntityRaider>> iterator = this.z.values().iterator();
        HashSet set = Sets.newHashSet();
        while (iterator.hasNext()) {
            Set<EntityRaider> set1 = iterator.next();
            for (EntityRaider entityraider : set1) {
                BlockPosition blockposition = entityraider.do();
                if (!entityraider.dJ() && entityraider.dO().af() == this.D.af() && this.C.j(blockposition) < 12544.0) {
                    if (entityraider.ai <= 600) continue;
                    if (this.D.a(entityraider.cz()) == null) {
                        set.add(entityraider);
                    }
                    if (!this.D.c(blockposition) && entityraider.em() > 2400) {
                        entityraider.c(entityraider.gE() + 1);
                    }
                    if (entityraider.gE() < 30) continue;
                    set.add(entityraider);
                    continue;
                }
                set.add(entityraider);
            }
        }
        for (EntityRaider entityraider1 : set) {
            this.a(entityraider1, true);
        }
    }

    private void a(BlockPosition blockposition) {
        float f2 = 13.0f;
        boolean flag = true;
        Collection<EntityPlayer> collection = this.K.g();
        long i2 = this.N.g();
        for (EntityPlayer entityplayer : this.D.x()) {
            Vec3D vec3d = entityplayer.dm();
            Vec3D vec3d1 = Vec3D.b(blockposition);
            double d0 = Math.sqrt((vec3d1.c - vec3d.c) * (vec3d1.c - vec3d.c) + (vec3d1.e - vec3d.e) * (vec3d1.e - vec3d.e));
            double d1 = vec3d.c + 13.0 / d0 * (vec3d1.c - vec3d.c);
            double d2 = vec3d.e + 13.0 / d0 * (vec3d1.e - vec3d.e);
            if (!(d0 <= 64.0) && !collection.contains(entityplayer)) continue;
            entityplayer.c.b(new PacketPlayOutNamedSoundEffect(SoundEffects.vc, SoundCategory.g, d1, entityplayer.dv(), d2, 64.0f, 1.0f, i2));
        }
    }

    private void b(BlockPosition blockposition) {
        boolean flag = false;
        int i2 = this.J + 1;
        this.G = 0.0f;
        DifficultyDamageScaler difficultydamagescaler = this.D.d_(blockposition);
        boolean flag1 = this.D();
        Wave[] araid_wave = Wave.f;
        int j2 = araid_wave.length;
        EntityRaider leader = null;
        ArrayList<EntityRaider> raiders = new ArrayList<EntityRaider>();
        for (int k2 = 0; k2 < j2; ++k2) {
            EntityRaider entityraider;
            Wave raid_wave = araid_wave[k2];
            int l2 = this.a(raid_wave, i2, flag1) + this.a(raid_wave, this.N, i2, difficultydamagescaler, flag1);
            int i1 = 0;
            for (int j1 = 0; j1 < l2 && (entityraider = raid_wave.g.a(this.D)) != null; ++j1) {
                if (!flag && entityraider.gl()) {
                    entityraider.x(true);
                    this.a(i2, entityraider);
                    flag = true;
                    leader = entityraider;
                }
                this.a(i2, entityraider, blockposition, false);
                raiders.add(entityraider);
                if (raid_wave.g != EntityTypes.aH) continue;
                EntityRaider entityraider1 = null;
                if (i2 == this.a(EnumDifficulty.c)) {
                    entityraider1 = EntityTypes.aC.a(this.D);
                } else if (i2 >= this.a(EnumDifficulty.d)) {
                    entityraider1 = i1 == 0 ? (EntityRaider)EntityTypes.J.a(this.D) : (EntityRaider)EntityTypes.bk.a(this.D);
                }
                ++i1;
                if (entityraider1 == null) continue;
                this.a(i2, entityraider1, blockposition, false);
                entityraider1.a(blockposition, 0.0f, 0.0f);
                entityraider1.n(entityraider);
                raiders.add(entityraider);
            }
        }
        this.R = Optional.empty();
        ++this.J;
        this.p();
        this.G();
        CraftEventFactory.callRaidSpawnWaveEvent(this, leader, raiders);
    }

    public void a(int i2, EntityRaider entityraider, @Nullable BlockPosition blockposition, boolean flag) {
        boolean flag1 = this.b(i2, entityraider);
        if (flag1) {
            entityraider.a(this);
            entityraider.b(i2);
            entityraider.A(true);
            entityraider.c(0);
            if (!flag && blockposition != null) {
                entityraider.a_((double)blockposition.u() + 0.5, (double)blockposition.v() + 1.0, (double)blockposition.w() + 0.5);
                entityraider.a((WorldAccess)this.D, this.D.d_(blockposition), EnumMobSpawn.h, (GroupDataEntity)null);
                entityraider.a(this.D, i2, false);
                entityraider.d(true);
                this.D.addFreshEntityWithPassengers(entityraider, CreatureSpawnEvent.SpawnReason.RAID);
            }
        }
    }

    public void p() {
        this.K.a(MathHelper.a(this.q() / this.G, 0.0f, 1.0f));
    }

    public float q() {
        float f2 = 0.0f;
        for (Set<EntityRaider> set : this.z.values()) {
            for (EntityRaider entityraider : set) {
                f2 += entityraider.ew();
            }
        }
        return f2;
    }

    private boolean F() {
        return this.M == 0 && (this.J < this.O || this.D()) && this.r() == 0;
    }

    public int r() {
        return this.z.values().stream().mapToInt(Set::size).sum();
    }

    public void a(EntityRaider entityraider, boolean flag) {
        boolean flag1;
        Set<EntityRaider> set = this.z.get(entityraider.gC());
        if (set != null && (flag1 = set.remove(entityraider))) {
            if (flag) {
                this.G -= entityraider.ew();
            }
            entityraider.a((Raid)null);
            this.p();
            this.G();
        }
    }

    private void G() {
        this.D.z().c();
    }

    public static ItemStack a(HolderGetter<EnumBannerPatternType> holdergetter) {
        ItemStack itemstack = new ItemStack(Items.uP);
        BannerPatternLayers bannerpatternlayers = new BannerPatternLayers.a().a(holdergetter, BannerPatterns.z, EnumColor.j).a(holdergetter, BannerPatterns.f, EnumColor.i).a(holdergetter, BannerPatterns.j, EnumColor.h).a(holdergetter, BannerPatterns.E, EnumColor.i).a(holdergetter, BannerPatterns.k, EnumColor.p).a(holdergetter, BannerPatterns.B, EnumColor.i).a(holdergetter, BannerPatterns.y, EnumColor.i).a(holdergetter, BannerPatterns.E, EnumColor.p).a();
        itemstack.b(DataComponents.Y, bannerpatternlayers);
        itemstack.b(DataComponents.p, Unit.a);
        itemstack.b(DataComponents.h, o);
        return itemstack;
    }

    @Nullable
    public EntityRaider b(int i2) {
        return this.y.get(i2);
    }

    @Nullable
    private BlockPosition a(int i2, int j2) {
        int k2 = i2 == 0 ? 2 : 2 - i2;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        SpawnPlacementType spawnplacementtype = EntityPositionTypes.a(EntityTypes.aH);
        for (int l2 = 0; l2 < j2; ++l2) {
            float f2 = this.D.z.i() * ((float)Math.PI * 2);
            int i1 = this.C.u() + MathHelper.d(MathHelper.b(f2) * 32.0f * (float)k2) + this.D.z.a(5);
            int j1 = this.C.w() + MathHelper.d(MathHelper.a(f2) * 32.0f * (float)k2) + this.D.z.a(5);
            int k1 = this.D.a(HeightMap.Type.b, i1, j1);
            blockposition_mutableblockposition.d(i1, k1, j1);
            if (this.D.c(blockposition_mutableblockposition) && i2 < 2) continue;
            boolean flag = true;
            if (!this.D.b(blockposition_mutableblockposition.u() - 10, blockposition_mutableblockposition.w() - 10, blockposition_mutableblockposition.u() + 10, blockposition_mutableblockposition.w() + 10) || !this.D.f(blockposition_mutableblockposition) || !spawnplacementtype.isSpawnPositionOk(this.D, blockposition_mutableblockposition, EntityTypes.aH) && (!this.D.a_(blockposition_mutableblockposition.e()).a(Blocks.dN) || !this.D.a_(blockposition_mutableblockposition).i())) continue;
            return blockposition_mutableblockposition;
        }
        return null;
    }

    private boolean b(int i2, EntityRaider entityraider) {
        return this.a(i2, entityraider, true);
    }

    public boolean a(int i2, EntityRaider entityraider, boolean flag) {
        this.z.computeIfAbsent(i2, integer -> Sets.newHashSet());
        Set<EntityRaider> set = this.z.get(i2);
        EntityRaider entityraider1 = null;
        for (EntityRaider entityraider2 : set) {
            if (!entityraider2.cz().equals(entityraider.cz())) continue;
            entityraider1 = entityraider2;
            break;
        }
        if (entityraider1 != null) {
            set.remove(entityraider1);
            set.add(entityraider);
        }
        set.add(entityraider);
        if (flag) {
            this.G += entityraider.ew();
        }
        this.p();
        this.G();
        return true;
    }

    public void a(int i2, EntityRaider entityraider) {
        this.y.put(i2, entityraider);
        entityraider.a(EnumItemSlot.f, Raid.a(entityraider.dQ().b(Registries.d)));
        entityraider.a(EnumItemSlot.f, 2.0f);
    }

    public void c(int i2) {
        this.y.remove(i2);
    }

    public BlockPosition s() {
        return this.C;
    }

    private void c(BlockPosition blockposition) {
        this.C = blockposition;
    }

    public int t() {
        return this.F;
    }

    private int a(Wave raid_wave, int i2, boolean flag) {
        return flag ? raid_wave.h[this.O] : raid_wave.h[i2];
    }

    private int a(Wave raid_wave, RandomSource randomsource, int i2, DifficultyDamageScaler difficultydamagescaler, boolean flag) {
        int j2;
        EnumDifficulty enumdifficulty = difficultydamagescaler.a();
        boolean flag1 = enumdifficulty == EnumDifficulty.b;
        boolean flag2 = enumdifficulty == EnumDifficulty.c;
        switch (raid_wave.ordinal()) {
            case 0: 
            case 2: {
                if (flag1) {
                    j2 = randomsource.a(2);
                    break;
                }
                if (flag2) {
                    j2 = 1;
                    break;
                }
                j2 = 2;
                break;
            }
            default: {
                return 0;
            }
            case 3: {
                if (flag1 || i2 <= 2 || i2 == 4) {
                    return 0;
                }
                j2 = 1;
                break;
            }
            case 4: {
                j2 = !flag1 && flag ? 1 : 0;
            }
        }
        return j2 > 0 ? randomsource.a(j2 + 1) : 0;
    }

    public boolean u() {
        return this.I;
    }

    public NBTTagCompound a(NBTTagCompound nbttagcompound) {
        nbttagcompound.a("Id", this.F);
        nbttagcompound.a("Started", this.E);
        nbttagcompound.a("Active", this.I);
        nbttagcompound.a("TicksActive", this.B);
        nbttagcompound.a("BadOmenLevel", this.H);
        nbttagcompound.a("GroupsSpawned", this.J);
        nbttagcompound.a("PreRaidTicks", this.M);
        nbttagcompound.a("PostRaidTicks", this.L);
        nbttagcompound.a("TotalHealth", this.G);
        nbttagcompound.a("NumGroups", this.O);
        nbttagcompound.a("Status", this.P.a());
        nbttagcompound.a("CX", this.C.u());
        nbttagcompound.a("CY", this.C.v());
        nbttagcompound.a("CZ", this.C.w());
        NBTTagList nbttaglist = new NBTTagList();
        for (UUID uuid : this.A) {
            nbttaglist.add(GameProfileSerializer.a(uuid));
        }
        nbttagcompound.a("HeroesOfTheVillage", nbttaglist);
        return nbttagcompound;
    }

    public int a(EnumDifficulty enumdifficulty) {
        switch (enumdifficulty) {
            case b: {
                return 3;
            }
            case c: {
                return 5;
            }
            case d: {
                return 7;
            }
        }
        return 0;
    }

    public float v() {
        int i2 = this.m();
        return i2 == 2 ? 0.1f : (i2 == 3 ? 0.25f : (i2 == 4 ? 0.5f : (i2 == 5 ? 0.75f : 0.0f)));
    }

    public void a(Entity entity) {
        this.A.add(entity.cz());
    }

    public Collection<EntityRaider> getRaiders() {
        return this.z.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static enum Status {
        a,
        b,
        c,
        d;

        private static final Status[] e;

        static Status a(String s2) {
            for (Status raid_status : e) {
                if (!s2.equalsIgnoreCase(raid_status.name())) continue;
                return raid_status;
            }
            return a;
        }

        public String a() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            e = Status.values();
        }
    }

    private static enum Wave {
        a(EntityTypes.bk, new int[]{0, 0, 2, 0, 1, 4, 2, 5}),
        b(EntityTypes.J, new int[]{0, 0, 0, 0, 0, 1, 1, 2}),
        c(EntityTypes.aC, new int[]{0, 4, 3, 3, 4, 4, 4, 2}),
        d(EntityTypes.bo, new int[]{0, 0, 0, 0, 3, 0, 0, 1}),
        e(EntityTypes.aH, new int[]{0, 0, 0, 1, 0, 1, 0, 2});

        static final Wave[] f;
        final EntityTypes<? extends EntityRaider> g;
        final int[] h;

        private Wave(EntityTypes entitytypes, int[] aint) {
            this.g = entitytypes;
            this.h = aint;
        }

        static {
            f = Wave.values();
        }
    }
}

