/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.decoration.EntityLeash;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R1.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.inventory.EquipmentSlot;

public class ItemLeash
extends Item {
    public ItemLeash(Item.Info item_info) {
        super(item_info);
    }

    @Override
    public EnumInteractionResult a(ItemActionContext itemactioncontext) {
        BlockPosition blockposition;
        World world = itemactioncontext.q();
        IBlockData iblockdata = world.a_(blockposition = itemactioncontext.a());
        if (iblockdata.a(TagsBlock.T)) {
            EntityHuman entityhuman = itemactioncontext.o();
            if (!world.B && entityhuman != null) {
                ItemLeash.bindPlayerMobs(entityhuman, world, blockposition, itemactioncontext.p());
            }
            return EnumInteractionResult.a(world.B);
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult bindPlayerMobs(EntityHuman entityhuman, World world, BlockPosition blockposition, EnumHand enumhand) {
        Entity entityleash = null;
        List<Leashable> list = ItemLeash.a(world, blockposition, (Leashable leashable) -> leashable.A() == entityhuman);
        Iterator<Leashable> iterator = list.iterator();
        while (iterator.hasNext()) {
            Entity leashed;
            Leashable leashable2 = iterator.next();
            if (entityleash == null) {
                entityleash = EntityLeash.b(world, blockposition);
                EquipmentSlot hand = CraftEquipmentSlot.getHand(enumhand);
                HangingPlaceEvent event = new HangingPlaceEvent((Hanging)entityleash.getBukkitEntity(), entityhuman != null ? (Player)entityhuman.getBukkitEntity() : null, (Block)CraftBlock.at(world, blockposition), BlockFace.SELF, hand);
                world.getCraftServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entityleash.discard(null);
                    return EnumInteractionResult.e;
                }
                ((EntityLeash)entityleash).v();
            }
            if (leashable2 instanceof Entity && CraftEventFactory.callPlayerLeashEntityEvent(leashed = (Entity)((Object)leashable2), entityleash, entityhuman, enumhand).isCancelled()) {
                iterator.remove();
                continue;
            }
            leashable2.b(entityleash, true);
        }
        if (!list.isEmpty()) {
            world.a(GameEvent.b, blockposition, GameEvent.a.a(entityhuman));
            return EnumInteractionResult.a;
        }
        if (entityleash != null) {
            entityleash.discard(null);
        }
        return EnumInteractionResult.e;
    }

    public static EnumInteractionResult a(EntityHuman entityhuman, World world, BlockPosition blockposition) {
        return ItemLeash.bindPlayerMobs(entityhuman, world, blockposition, EnumHand.a);
    }

    public static List<Leashable> a(World world, BlockPosition blockposition, Predicate<Leashable> predicate) {
        double d0 = 7.0;
        int i2 = blockposition.u();
        int j2 = blockposition.v();
        int k2 = blockposition.w();
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)i2 - 7.0, (double)j2 - 7.0, (double)k2 - 7.0, (double)i2 + 7.0, (double)j2 + 7.0, (double)k2 + 7.0);
        Stream stream = world.a(Entity.class, axisalignedbb, (? super T entity) -> {
            Leashable leashable;
            if (entity instanceof Leashable && predicate.test(leashable = (Leashable)((Object)entity))) {
                boolean flag = true;
                return flag;
            }
            boolean flag = false;
            return flag;
        }).stream();
        Objects.requireNonNull(Leashable.class);
        return stream.map(Leashable.class::cast).toList();
    }
}

