/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import org.slf4j.Logger;
import org.spigotmc.AsyncCatcher;

public class CraftingManager
extends ResourceDataJson {
    private static final Gson a = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger b = LogUtils.getLogger();
    private final HolderLookup.a c;
    public Multimap<Recipes<?>, RecipeHolder<?>> d = ImmutableMultimap.of();
    private Map<MinecraftKey, RecipeHolder<?>> e = ImmutableMap.of();
    private boolean f;

    public CraftingManager(HolderLookup.a holderlookup_a) {
        super(a, Registries.c(Registries.bg));
        this.c = holderlookup_a;
    }

    @Override
    protected void a(Map<MinecraftKey, JsonElement> map, IResourceManager iresourcemanager, GameProfilerFiller gameprofilerfiller) {
        this.f = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        RegistryOps registryops = this.c.a(JsonOps.INSTANCE);
        for (Map.Entry<MinecraftKey, JsonElement> entry : map.entrySet()) {
            MinecraftKey minecraftkey = entry.getKey();
            try {
                IRecipe irecipe = (IRecipe)IRecipe.h.parse(registryops, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                RecipeHolder<IRecipe> recipeholder = new RecipeHolder<IRecipe>(minecraftkey, irecipe);
                builder.put(irecipe.e(), recipeholder);
                com_google_common_collect_immutablemap_builder.put((Object)minecraftkey, recipeholder);
            }
            catch (JsonParseException | IllegalArgumentException jsonparseexception) {
                b.error("Parsing error loading recipe {}", (Object)minecraftkey, (Object)jsonparseexception);
            }
        }
        this.d = LinkedHashMultimap.create((Multimap)builder.build());
        this.e = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
        b.info("Loaded {} recipes", (Object)this.d.size());
    }

    public void addRecipe(RecipeHolder<?> irecipe) {
        AsyncCatcher.catchOp("Recipe Add");
        Collection map = this.d.get(irecipe.b().e());
        if (this.e.containsKey(irecipe.a())) {
            throw new IllegalStateException("Duplicate recipe ignored with ID " + String.valueOf(irecipe.a()));
        }
        map.add(irecipe);
        this.e.put(irecipe.a(), irecipe);
    }

    public boolean a() {
        return this.f;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world) {
        return this.a(recipes, i0, world, (RecipeHolder)null);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world, @Nullable MinecraftKey minecraftkey) {
        RecipeHolder<T> recipeholder = minecraftkey != null ? this.a(recipes, minecraftkey) : null;
        return this.a(recipes, i0, world, recipeholder);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> Optional<RecipeHolder<T>> a(Recipes<T> recipes, I i0, World world, @Nullable RecipeHolder<T> recipeholder) {
        List<RecipeHolder> list = this.c(recipes).stream().filter(recipeholder1 -> recipeholder1.b().a((RecipeInput)i0, world)).toList();
        Optional<RecipeHolder<T>> recipe = list.isEmpty() || i0.b() ? Optional.empty() : (recipeholder != null && recipeholder.b().a(i0, world) ? Optional.of(recipeholder) : Optional.of(list.getLast()));
        return recipe;
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> a(Recipes<T> recipes) {
        return List.copyOf(this.c(recipes));
    }

    public <I extends RecipeInput, T extends IRecipe<I>> List<RecipeHolder<T>> b(Recipes<T> recipes, I i0, World world) {
        return this.c(recipes).stream().filter(recipeholder -> recipeholder.b().a((RecipeInput)i0, world)).sorted(Comparator.comparing(recipeholder -> recipeholder.b().a(world.H_()).t())).collect(Collectors.toList());
    }

    private <I extends RecipeInput, T extends IRecipe<I>> Collection<RecipeHolder<T>> c(Recipes<T> recipes) {
        return this.d.get(recipes);
    }

    public <I extends RecipeInput, T extends IRecipe<I>> NonNullList<ItemStack> c(Recipes<T> recipes, I i0, World world) {
        Optional<RecipeHolder<T>> optional = this.a(recipes, i0, world);
        if (optional.isPresent()) {
            return optional.get().b().a(i0);
        }
        NonNullList<ItemStack> nonnulllist = NonNullList.a(i0.a(), ItemStack.l);
        for (int i2 = 0; i2 < nonnulllist.size(); ++i2) {
            nonnulllist.set(i2, i0.a(i2));
        }
        return nonnulllist;
    }

    public Optional<RecipeHolder<?>> a(MinecraftKey minecraftkey) {
        return Optional.ofNullable(this.e.get(minecraftkey));
    }

    @Nullable
    private <T extends IRecipe<?>> RecipeHolder<T> a(Recipes<T> recipes, MinecraftKey minecraftkey) {
        RecipeHolder<?> recipeholder = this.e.get(minecraftkey);
        return recipeholder != null && recipeholder.b().e().equals(recipes) ? recipeholder : null;
    }

    public Collection<RecipeHolder<?>> b() {
        return this.d.values();
    }

    public Collection<RecipeHolder<?>> d() {
        return this.e.values();
    }

    public Stream<MinecraftKey> e() {
        return this.e.keySet().stream();
    }

    @VisibleForTesting
    protected static RecipeHolder<?> a(MinecraftKey minecraftkey, JsonObject jsonobject, HolderLookup.a holderlookup_a) {
        IRecipe irecipe = (IRecipe)IRecipe.h.parse(holderlookup_a.a(JsonOps.INSTANCE), (Object)jsonobject).getOrThrow(JsonParseException::new);
        return new RecipeHolder<IRecipe>(minecraftkey, irecipe);
    }

    public void a(Iterable<RecipeHolder<?>> iterable) {
        this.f = false;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableMap.Builder com_google_common_collect_immutablemap_builder = ImmutableMap.builder();
        for (RecipeHolder<?> recipeholder : iterable) {
            Recipes<?> recipes = recipeholder.b().e();
            builder.put(recipes, recipeholder);
            com_google_common_collect_immutablemap_builder.put((Object)recipeholder.a(), recipeholder);
        }
        this.d = LinkedHashMultimap.create((Multimap)builder.build());
        this.e = Maps.newHashMap((Map)com_google_common_collect_immutablemap_builder.build());
    }

    public boolean removeRecipe(MinecraftKey mcKey) {
        Iterator iter = this.d.values().iterator();
        while (iter.hasNext()) {
            RecipeHolder recipe = (RecipeHolder)iter.next();
            if (!recipe.a().equals(mcKey)) continue;
            iter.remove();
        }
        return this.e.remove(mcKey) != null;
    }

    public void clearRecipes() {
        this.d = LinkedHashMultimap.create();
        this.e = Maps.newHashMap();
    }

    public static <I extends RecipeInput, T extends IRecipe<I>> a<I, T> b(final Recipes<T> recipes) {
        return new a<I, T>(){
            @Nullable
            private MinecraftKey b;

            @Override
            public Optional<RecipeHolder<T>> a(I i0, World world) {
                CraftingManager craftingmanager = world.r();
                Optional optional = craftingmanager.a(recipes, i0, world, this.b);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = optional.get();
                    this.b = recipeholder.a();
                    return Optional.of(recipeholder);
                }
                return Optional.empty();
            }
        };
    }

    public static interface a<I extends RecipeInput, T extends IRecipe<I>> {
        public Optional<RecipeHolder<T>> a(I var1, World var2);
    }
}

