/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments a = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(), true);
    private static final Codec<Integer> d = Codec.intRange((int)0, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<Enchantment>>> e = Codec.unboundedMap(Enchantment.c, d).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemEnchantments> f = RecordCodecBuilder.create(var02 -> var02.group((App)e.fieldOf("levels").forGetter(var0 -> var0.g), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(var0 -> var0.h)).apply((Applicative)var02, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> b = Codec.withAlternative(f, e, var0 -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)var0, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> c = StreamCodec.a(ByteBufCodecs.a(Object2IntOpenHashMap::new, Enchantment.d, ByteBufCodecs.g), var0 -> var0.g, ByteBufCodecs.b, var0 -> var0.h, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> g;
    public final boolean h;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> var0, boolean var1) {
        this.g = var0;
        this.h = var1;
        for (Object2IntMap.Entry var3 : var0.object2IntEntrySet()) {
            int var4 = var3.getIntValue();
            if (var4 >= 0 && var4 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf(var3.getKey()) + " has invalid level " + var4);
        }
    }

    public int a(Holder<Enchantment> var0) {
        return this.g.getInt(var0);
    }

    @Override
    public void a(Item.b var0, Consumer<IChatBaseComponent> var1, TooltipFlag var2) {
        if (!this.h) {
            return;
        }
        HolderLookup.a var3 = var0.a();
        HolderSet<Enchantment> var4 = ItemEnchantments.a(var3, Registries.aL, EnchantmentTags.a);
        for (Holder holder : var4) {
            int var7 = this.g.getInt((Object)holder);
            if (var7 <= 0) continue;
            var1.accept(Enchantment.a((Holder<Enchantment>)holder, var7));
        }
        for (Object2IntMap.Entry entry : this.g.object2IntEntrySet()) {
            Holder var7 = (Holder)entry.getKey();
            if (var4.a(var7)) continue;
            var1.accept(Enchantment.a((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> a(@Nullable HolderLookup.a var0, ResourceKey<IRegistry<T>> var1, TagKey<T> var2) {
        Optional<HolderSet.Named<T>> var3;
        if (var0 != null && (var3 = var0.b(var1).a(var2)).isPresent()) {
            return var3.get();
        }
        return HolderSet.a(new Holder[0]);
    }

    public ItemEnchantments a(boolean var0) {
        return new ItemEnchantments(this.g, var0);
    }

    public Set<Holder<Enchantment>> a() {
        return Collections.unmodifiableSet(this.g.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> b() {
        return Collections.unmodifiableSet(this.g.object2IntEntrySet());
    }

    public int c() {
        return this.g.size();
    }

    public boolean d() {
        return this.g.isEmpty();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof ItemEnchantments) {
            ItemEnchantments var1 = (ItemEnchantments)var0;
            return this.h == var1.h && this.g.equals(var1.g);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.g.hashCode();
        var0 = 31 * var0 + (this.h ? 1 : 0);
        return var0;
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.g) + ", showInTooltip=" + this.h + "}";
    }

    public static class a {
        private final Object2IntOpenHashMap<Holder<Enchantment>> a = new Object2IntOpenHashMap();
        public boolean b;

        public a(ItemEnchantments var0) {
            this.a.putAll(var0.g);
            this.b = var0.h;
        }

        public void a(Holder<Enchantment> var0, int var1) {
            if (var1 <= 0) {
                this.a.removeInt(var0);
            } else {
                this.a.put(var0, Math.min(var1, 255));
            }
        }

        public void b(Holder<Enchantment> var0, int var1) {
            if (var1 > 0) {
                this.a.merge(var0, Math.min(var1, 255), Integer::max);
            }
        }

        public void a(Predicate<Holder<Enchantment>> var0) {
            this.a.keySet().removeIf(var0);
        }

        public int a(Holder<Enchantment> var0) {
            return this.a.getOrDefault(var0, 0);
        }

        public Set<Holder<Enchantment>> a() {
            return this.a.keySet();
        }

        public ItemEnchantments b() {
            return new ItemEnchantments(this.a, this.b);
        }
    }
}

