/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityKnockbackEvent;

public class Explosion {
    private static final ExplosionDamageCalculator a = new ExplosionDamageCalculator();
    private static final int b = 16;
    private final boolean c;
    private final Effect d;
    private final RandomSource e = RandomSource.a();
    private final World f;
    private final double g;
    private final double h;
    private final double i;
    @Nullable
    public final Entity j;
    private final float k;
    private final DamageSource l;
    private final ExplosionDamageCalculator m;
    private final ParticleParam n;
    private final ParticleParam o;
    private final Holder<SoundEffect> p;
    private final ObjectArrayList<BlockPosition> q = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> r = Maps.newHashMap();
    public boolean wasCanceled = false;
    public float yield;

    public static DamageSource a(World world, @Nullable Entity entity) {
        return world.aj().d(entity, Explosion.b(entity));
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, List<BlockPosition> list, Effect explosion_effect, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        this(world, entity, Explosion.a(world, entity), null, d0, d1, d2, f2, false, explosion_effect, particleparam, particleparam1, holder);
        this.q.addAll(list);
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect, List<BlockPosition> list) {
        this(world, entity, d0, d1, d2, f2, flag, explosion_effect);
        this.q.addAll(list);
    }

    public Explosion(World world, @Nullable Entity entity, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect) {
        this(world, entity, Explosion.a(world, entity), null, d0, d1, d2, f2, flag, explosion_effect, Particles.w, Particles.v, SoundEffects.ke);
    }

    public Explosion(World world, @Nullable Entity entity, @Nullable DamageSource damagesource, @Nullable ExplosionDamageCalculator explosiondamagecalculator, double d0, double d1, double d2, float f2, boolean flag, Effect explosion_effect, ParticleParam particleparam, ParticleParam particleparam1, Holder<SoundEffect> holder) {
        this.f = world;
        this.j = entity;
        this.k = (float)Math.max((double)f2, 0.0);
        this.g = d0;
        this.h = d1;
        this.i = d2;
        this.c = flag;
        this.d = explosion_effect;
        this.l = damagesource == null ? world.aj().a(this) : damagesource;
        this.m = explosiondamagecalculator == null ? this.a(entity) : explosiondamagecalculator;
        this.n = particleparam;
        this.o = particleparam1;
        this.p = holder;
        this.yield = this.d == Effect.c ? 1.0f / this.k : 1.0f;
    }

    private ExplosionDamageCalculator a(@Nullable Entity entity) {
        return entity == null ? a : new ExplosionDamageCalculatorEntity(entity);
    }

    public static float a(Vec3D vec3d, Entity entity) {
        AxisAlignedBB axisalignedbb = entity.cK();
        double d0 = 1.0 / ((axisalignedbb.d - axisalignedbb.a) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.e - axisalignedbb.b) * 2.0 + 1.0);
        double d2 = 1.0 / ((axisalignedbb.f - axisalignedbb.c) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (d0 >= 0.0 && d1 >= 0.0 && d2 >= 0.0) {
            int i2 = 0;
            int j2 = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d8 = MathHelper.d(d5, axisalignedbb.a, axisalignedbb.d);
                        double d9 = MathHelper.d(d6, axisalignedbb.b, axisalignedbb.e);
                        double d10 = MathHelper.d(d7, axisalignedbb.c, axisalignedbb.f);
                        Vec3D vec3d1 = new Vec3D(d8 + d3, d9, d10 + d4);
                        if (entity.dO().a(new RayTrace(vec3d1, vec3d, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, entity)).c() == MovingObjectPosition.EnumMovingObjectType.a) {
                            ++i2;
                        }
                        ++j2;
                    }
                }
            }
            return (float)i2 / (float)j2;
        }
        return 0.0f;
    }

    public float a() {
        return this.k;
    }

    public Vec3D b() {
        return new Vec3D(this.g, this.h, this.i);
    }

    public void c() {
        int j2;
        int i2;
        if (this.k < 0.1f) {
            return;
        }
        this.f.a(this.j, GameEvent.w, new Vec3D(this.g, this.h, this.i));
        HashSet set = Sets.newHashSet();
        boolean flag = true;
        for (int k2 = 0; k2 < 16; ++k2) {
            for (i2 = 0; i2 < 16; ++i2) {
                block2: for (j2 = 0; j2 < 16; ++j2) {
                    if (k2 != 0 && k2 != 15 && i2 != 0 && i2 != 15 && j2 != 0 && j2 != 15) continue;
                    double d0 = (float)k2 / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)i2 / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)j2 / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.g;
                    double d5 = this.h;
                    double d6 = this.i;
                    float f1 = 0.3f;
                    for (float f2 = this.k * (0.7f + this.f.z.i() * 0.6f); f2 > 0.0f; f2 -= 0.22500001f) {
                        BlockPosition blockposition = BlockPosition.a(d4, d5, d6);
                        IBlockData iblockdata = this.f.a_(blockposition);
                        Fluid fluid = this.f.b_(blockposition);
                        if (!this.f.k(blockposition)) continue block2;
                        Optional<Float> optional = this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, fluid);
                        if (optional.isPresent()) {
                            f2 -= (optional.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (f2 > 0.0f && this.m.a(this, (IBlockAccess)this.f, blockposition, iblockdata, f2)) {
                            set.add(blockposition);
                        }
                        d4 += d0 * (double)0.3f;
                        d5 += d1 * (double)0.3f;
                        d6 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.q.addAll((Collection)set);
        float f2 = this.k * 2.0f;
        i2 = MathHelper.a(this.g - (double)f2 - 1.0);
        j2 = MathHelper.a(this.g + (double)f2 + 1.0);
        int l2 = MathHelper.a(this.h - (double)f2 - 1.0);
        int i1 = MathHelper.a(this.h + (double)f2 + 1.0);
        int j1 = MathHelper.a(this.i - (double)f2 - 1.0);
        int k1 = MathHelper.a(this.i + (double)f2 + 1.0);
        List<Entity> list = this.f.a_(this.j, new AxisAlignedBB(i2, l2, j1, j2, i1, k1));
        Vec3D vec3d = new Vec3D(this.g, this.h, this.i);
        for (Entity entity : list) {
            EntityHuman entityhuman;
            double d13;
            double d10;
            double d9;
            double d8;
            double d11;
            double d7;
            if (entity.a(this) || !((d7 = Math.sqrt(entity.g(vec3d)) / (double)f2) <= 1.0) || (d11 = Math.sqrt((d8 = entity.dt() - this.g) * d8 + (d9 = (entity instanceof EntityTNTPrimed ? entity.dv() : entity.dx()) - this.h) * d9 + (d10 = entity.dz() - this.i) * d10)) == 0.0) continue;
            d8 /= d11;
            d9 /= d11;
            d10 /= d11;
            if (this.m.a(this, entity)) {
                if (entity instanceof EntityComplexPart) continue;
                entity.lastDamageCancelled = false;
                if (entity instanceof EntityEnderDragon) {
                    for (EntityComplexPart entityComplexPart : ((EntityEnderDragon)entity).co) {
                        if (!list.contains(entityComplexPart)) continue;
                        entityComplexPart.a(this.l, this.m.b(this, entity));
                    }
                } else {
                    entity.a(this.l, this.m.b(this, entity));
                }
                if (entity.lastDamageCancelled) continue;
            }
            double d12 = (1.0 - d7) * (double)Explosion.a(vec3d, entity) * (double)this.m.a(entity);
            if (entity instanceof EntityLiving) {
                EntityLiving entityliving = (EntityLiving)entity;
                d13 = d12 * (1.0 - entityliving.g(GenericAttributes.i));
            } else {
                d13 = d12;
            }
            Vec3D vec3d1 = new Vec3D(d8 *= d13, d9 *= d13, d10 *= d13);
            if (entity instanceof EntityLiving) {
                Vec3D result = entity.dr().e(vec3d1);
                EntityKnockbackEvent event = CraftEventFactory.callEntityKnockbackEvent((CraftLivingEntity)entity.getBukkitEntity(), this.j, EntityKnockbackEvent.KnockbackCause.EXPLOSION, d13, vec3d1, result.c, result.d, result.e);
                vec3d1 = event.isCancelled() ? Vec3D.b : new Vec3D(event.getFinalKnockback().getX(), event.getFinalKnockback().getY(), event.getFinalKnockback().getZ()).d(entity.dr());
            }
            entity.i(entity.dr().e(vec3d1));
            if (!(!(entity instanceof EntityHuman) || (entityhuman = (EntityHuman)entity).R_() || entityhuman.f() && entityhuman.fZ().b)) {
                this.r.put(entityhuman, vec3d1);
            }
            entity.a(this.j);
        }
    }

    public void a(boolean flag) {
        if (this.f.B) {
            this.f.a(this.g, this.h, this.i, this.p.a(), SoundCategory.e, 4.0f, (1.0f + (this.f.z.i() - this.f.z.i()) * 0.2f) * 0.7f, false);
        }
        boolean flag1 = this.d();
        if (flag) {
            ParticleParam particleparam = this.k >= 2.0f && flag1 ? this.o : this.n;
            this.f.a(particleparam, this.g, this.h, this.i, 1.0, 0.0, 0.0);
        }
        if (flag1) {
            List bukkitBlocks;
            this.f.ag().a("explosion_blocks");
            ArrayList list = new ArrayList();
            SystemUtils.c(this.q, this.f.z);
            ObjectListIterator objectlistiterator = this.q.iterator();
            CraftWorld bworld = this.f.getWorld();
            Location location = new Location((org.bukkit.World)bworld, this.g, this.h, this.i);
            ObjectArrayList blockList = new ObjectArrayList();
            for (int i1 = this.q.size() - 1; i1 >= 0; --i1) {
                BlockPosition cpos = (BlockPosition)this.q.get(i1);
                org.bukkit.block.Block bblock = bworld.getBlockAt(cpos.u(), cpos.v(), cpos.w());
                if (bblock.getType().isAir()) continue;
                blockList.add(bblock);
            }
            if (this.j != null) {
                EntityExplodeEvent event = CraftEventFactory.callEntityExplodeEvent(this.j, (List<org.bukkit.block.Block>)blockList, this.yield, this.j());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            } else {
                org.bukkit.block.Block block = location.getBlock();
                BlockState blockState = this.l.getDirectBlockState() != null ? this.l.getDirectBlockState() : block.getState();
                BlockExplodeEvent event = CraftEventFactory.callBlockExplodeEvent(block, blockState, (List<org.bukkit.block.Block>)blockList, this.yield, this.j());
                this.wasCanceled = event.isCancelled();
                bukkitBlocks = event.blockList();
                this.yield = event.getYield();
            }
            this.q.clear();
            for (org.bukkit.block.Block bblock : bukkitBlocks) {
                BlockPosition coords = new BlockPosition(bblock.getX(), bblock.getY(), bblock.getZ());
                this.q.add((Object)coords);
            }
            if (this.wasCanceled) {
                return;
            }
            for (BlockPosition blockposition : this.q) {
                IBlockData iblockdata = this.f.a_(blockposition);
                Block block = iblockdata.b();
                if (block instanceof BlockTNT) {
                    BlockPosition sourceBlock;
                    Entity sourceEntity = this.j == null ? null : this.j;
                    BlockPosition blockPosition = sourceBlock = sourceEntity == null ? BlockPosition.a(this.g, this.h, this.i) : null;
                    if (!CraftEventFactory.callTNTPrimeEvent(this.f, blockposition, TNTPrimeEvent.PrimeCause.EXPLOSION, sourceEntity, sourceBlock)) {
                        this.f.a(blockposition, Blocks.a.o(), iblockdata, 3);
                        continue;
                    }
                }
                this.f.a_(blockposition).a(this.f, blockposition, this, (itemstack, blockposition1) -> Explosion.a(list, itemstack, blockposition1));
            }
            for (Pair pair : list) {
                Block.a(this.f, (BlockPosition)pair.getSecond(), (ItemStack)pair.getFirst());
            }
            this.f.ag().c();
        }
        if (this.c) {
            for (BlockPosition blockposition12 : this.q) {
                if (this.e.a(3) != 0 || !this.f.a_(blockposition12).i() || !this.f.a_(blockposition12.e()).i(this.f, blockposition12.e()) || CraftEventFactory.callBlockIgniteEvent(this.f, blockposition12, this).isCancelled()) continue;
                this.f.b(blockposition12, BlockFireAbstract.a(this.f, blockposition12));
            }
        }
    }

    private static void a(List<Pair<ItemStack, BlockPosition>> list, ItemStack itemstack, BlockPosition blockposition) {
        if (itemstack.e()) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Pair<ItemStack, BlockPosition> pair = list.get(i2);
            ItemStack itemstack1 = (ItemStack)pair.getFirst();
            if (!EntityItem.a(itemstack1, itemstack)) continue;
            list.set(i2, (Pair<ItemStack, BlockPosition>)Pair.of((Object)EntityItem.a(itemstack1, itemstack, 16), (Object)((BlockPosition)pair.getSecond())));
            if (!itemstack.e()) continue;
            return;
        }
        list.add((Pair<ItemStack, BlockPosition>)Pair.of((Object)itemstack, (Object)blockposition));
    }

    public boolean d() {
        return this.d != Effect.a;
    }

    public Map<EntityHuman, Vec3D> e() {
        return this.r;
    }

    @Nullable
    private static EntityLiving b(@Nullable Entity entity) {
        IProjectile iprojectile;
        Entity entity1;
        if (entity == null) {
            return null;
        }
        if (entity instanceof EntityTNTPrimed) {
            EntityTNTPrimed entitytntprimed = (EntityTNTPrimed)entity;
            return entitytntprimed.p();
        }
        if (entity instanceof EntityLiving) {
            EntityLiving entityliving = (EntityLiving)entity;
            return entityliving;
        }
        if (entity instanceof IProjectile && (entity1 = (iprojectile = (IProjectile)entity).s()) instanceof EntityLiving) {
            EntityLiving entityliving1 = (EntityLiving)entity1;
            return entityliving1;
        }
        return null;
    }

    @Nullable
    public EntityLiving f() {
        return Explosion.b(this.j);
    }

    @Nullable
    public Entity g() {
        return this.j;
    }

    public void h() {
        this.q.clear();
    }

    public List<BlockPosition> i() {
        return this.q;
    }

    public Effect j() {
        return this.d;
    }

    public ParticleParam k() {
        return this.n;
    }

    public ParticleParam l() {
        return this.o;
    }

    public Holder<SoundEffect> m() {
        return this.p;
    }

    public boolean n() {
        return this.d == Effect.d && !this.f.x_() ? (this.j != null && this.j.am() == EntityTypes.n ? this.f.ab().b(GameRules.c) : true) : false;
    }

    public static enum Effect {
        a,
        b,
        c,
        d;

    }
}

