/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BigDripleafStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.Tilt;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class BigDripleafBlock
extends BlockFacingHorizontal
implements IBlockFragilePlantElement,
IBlockWaterlogged {
    public static final MapCodec<BigDripleafBlock> a = BigDripleafBlock.b(BigDripleafBlock::new);
    private static final BlockStateBoolean b = BlockProperties.C;
    private static final BlockStateEnum<Tilt> c = BlockProperties.bl;
    private static final int d = -1;
    private static final Object2IntMap<Tilt> e = (Object2IntMap)SystemUtils.a(new Object2IntArrayMap(), (? super T object2intarraymap) -> {
        object2intarraymap.defaultReturnValue(-1);
        object2intarraymap.put((Object)Tilt.b, 10);
        object2intarraymap.put((Object)Tilt.c, 10);
        object2intarraymap.put((Object)Tilt.d, 100);
    });
    private static final int f = 5;
    private static final int g = 6;
    private static final int h = 11;
    private static final int i = 13;
    private static final Map<Tilt, VoxelShape> j = ImmutableMap.of((Object)Tilt.a, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.b, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 15.0, 16.0), (Object)Tilt.c, (Object)Block.a(0.0, 11.0, 0.0, 16.0, 13.0, 16.0), (Object)Tilt.d, (Object)VoxelShapes.a());
    private static final VoxelShape k = Block.a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);
    private static final Map<EnumDirection, VoxelShape> l = ImmutableMap.of((Object)EnumDirection.c, (Object)VoxelShapes.b(BigDripleafStemBlock.b, k, OperatorBoolean.e), (Object)EnumDirection.d, (Object)VoxelShapes.b(BigDripleafStemBlock.c, k, OperatorBoolean.e), (Object)EnumDirection.f, (Object)VoxelShapes.b(BigDripleafStemBlock.d, k, OperatorBoolean.e), (Object)EnumDirection.e, (Object)VoxelShapes.b(BigDripleafStemBlock.e, k, OperatorBoolean.e));
    private final Map<IBlockData, VoxelShape> m;

    public MapCodec<BigDripleafBlock> a() {
        return a;
    }

    protected BigDripleafBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(b, false)).a(aE, EnumDirection.c)).a(c, Tilt.a));
        this.m = this.a(BigDripleafBlock::m);
    }

    private static VoxelShape m(IBlockData iblockdata) {
        return VoxelShapes.a(j.get(iblockdata.c(c)), l.get(iblockdata.c(aE)));
    }

    public static void a(GeneratorAccess generatoraccess, RandomSource randomsource, BlockPosition blockposition, EnumDirection enumdirection) {
        int j2;
        int i2 = MathHelper.a(randomsource, 2, 5);
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = blockposition.k();
        for (j2 = 0; j2 < i2 && BigDripleafBlock.a((LevelHeightAccessor)generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.a_(blockposition_mutableblockposition)); ++j2) {
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        int k2 = blockposition.v() + j2 - 1;
        blockposition_mutableblockposition.q(blockposition.v());
        while (blockposition_mutableblockposition.v() < k2) {
            BigDripleafStemBlock.a(generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.b_(blockposition_mutableblockposition), enumdirection);
            blockposition_mutableblockposition.c(EnumDirection.b);
        }
        BigDripleafBlock.a(generatoraccess, (BlockPosition)blockposition_mutableblockposition, generatoraccess.b_(blockposition_mutableblockposition), enumdirection);
    }

    private static boolean n(IBlockData iblockdata) {
        return iblockdata.i() || iblockdata.a(Blocks.G) || iblockdata.a(Blocks.sF);
    }

    protected static boolean a(LevelHeightAccessor levelheightaccessor, BlockPosition blockposition, IBlockData iblockdata) {
        return !levelheightaccessor.s(blockposition) && BigDripleafBlock.n(iblockdata);
    }

    protected static boolean a(GeneratorAccess generatoraccess, BlockPosition blockposition, Fluid fluid, EnumDirection enumdirection) {
        IBlockData iblockdata = (IBlockData)((IBlockData)Blocks.sD.o().a(b, fluid.a(FluidTypes.c))).a(aE, enumdirection);
        return generatoraccess.a(blockposition, iblockdata, 3);
    }

    @Override
    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
        this.setTiltAndScheduleTick(iblockdata, world, movingobjectpositionblock.a(), Tilt.d, SoundEffects.hB, iprojectile);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(b) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        BlockPosition blockposition1 = blockposition.e();
        IBlockData iblockdata1 = iworldreader.a_(blockposition1);
        return iblockdata1.a(this) || iblockdata1.a(Blocks.sE) || iblockdata1.a(TagsBlock.bz);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (enumdirection == EnumDirection.a && !iblockdata.a(generatoraccess, blockposition)) {
            return Blocks.a.o();
        }
        if (iblockdata.c(b).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return enumdirection == EnumDirection.b && iblockdata1.a(this) ? Blocks.sE.l(iblockdata) : super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    public boolean b(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1 = iworldreader.a_(blockposition.d());
        return BigDripleafBlock.n(iblockdata1);
    }

    @Override
    public boolean a(World world, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        return true;
    }

    @Override
    public void a(WorldServer worldserver, RandomSource randomsource, BlockPosition blockposition, IBlockData iblockdata) {
        IBlockData iblockdata1;
        BlockPosition blockposition1 = blockposition.d();
        if (BigDripleafBlock.a((LevelHeightAccessor)worldserver, blockposition1, iblockdata1 = worldserver.a_(blockposition1))) {
            EnumDirection enumdirection = iblockdata.c(aE);
            BigDripleafStemBlock.a((GeneratorAccess)worldserver, blockposition, iblockdata.u(), enumdirection);
            BigDripleafBlock.a((GeneratorAccess)worldserver, blockposition1, iblockdata1.u(), enumdirection);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!world.B && iblockdata.c(c) == Tilt.a && BigDripleafBlock.a(blockposition, entity) && !world.C(blockposition)) {
            PlayerInteractEvent cancellable;
            if (entity instanceof EntityHuman) {
                cancellable = CraftEventFactory.callPlayerInteractEvent((EntityHuman)entity, Action.PHYSICAL, blockposition, null, null, null);
            } else {
                cancellable = new EntityInteractEvent((Entity)entity.getBukkitEntity(), world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w()));
                world.getCraftServer().getPluginManager().callEvent((Event)((EntityInteractEvent)cancellable));
            }
            if (cancellable.isCancelled()) {
                return;
            }
            this.setTiltAndScheduleTick(iblockdata, world, blockposition, Tilt.b, null, entity);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.C(blockposition)) {
            BigDripleafBlock.d(iblockdata, worldserver, blockposition);
        } else {
            Tilt tilt = iblockdata.c(c);
            if (tilt == Tilt.b) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.c, SoundEffects.hB, null);
            } else if (tilt == Tilt.c) {
                this.setTiltAndScheduleTick(iblockdata, worldserver, blockposition, Tilt.d, SoundEffects.hB, null);
            } else if (tilt == Tilt.d) {
                BigDripleafBlock.d(iblockdata, worldserver, blockposition);
            }
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (world.C(blockposition)) {
            BigDripleafBlock.d(iblockdata, world, blockposition);
        }
    }

    private static void a(World world, BlockPosition blockposition, SoundEffect soundeffect) {
        float f2 = MathHelper.b(world.z, 0.8f, 1.2f);
        world.a((EntityHuman)null, blockposition, soundeffect, SoundCategory.e, 1.0f, f2);
    }

    private static boolean a(BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        return entity.aF() && entity.dm().d > (double)((float)blockposition.v() + 0.6875f);
    }

    private void setTiltAndScheduleTick(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable SoundEffect soundeffect, @Nullable net.minecraft.world.entity.Entity entity) {
        int i2;
        if (!BigDripleafBlock.setTilt(iblockdata, world, blockposition, tilt, entity)) {
            return;
        }
        if (soundeffect != null) {
            BigDripleafBlock.a(world, blockposition, soundeffect);
        }
        if ((i2 = e.getInt((Object)tilt)) != -1) {
            world.a(blockposition, (Block)this, i2);
        }
    }

    private static void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        BigDripleafBlock.setTilt(iblockdata, world, blockposition, Tilt.a, null);
        if (iblockdata.c(c) != Tilt.a) {
            BigDripleafBlock.a(world, blockposition, SoundEffects.hC);
        }
    }

    private static boolean setTilt(IBlockData iblockdata, World world, BlockPosition blockposition, Tilt tilt, @Nullable net.minecraft.world.entity.Entity entity) {
        if (entity != null && !CraftEventFactory.callEntityChangeBlockEvent(entity, blockposition, (IBlockData)iblockdata.a(c, tilt))) {
            return false;
        }
        Tilt tilt1 = iblockdata.c(c);
        world.a(blockposition, (IBlockData)iblockdata.a(c, tilt), 2);
        if (tilt.a() && tilt != tilt1) {
            world.a((net.minecraft.world.entity.Entity)null, GameEvent.c, blockposition);
        }
        return true;
    }

    @Override
    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return j.get(iblockdata.c(c));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.m.get(iblockdata);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        IBlockData iblockdata = blockactioncontext.q().a_(blockactioncontext.a().e());
        Fluid fluid = blockactioncontext.q().b_(blockactioncontext.a());
        boolean flag = iblockdata.a(Blocks.sD) || iblockdata.a(Blocks.sE);
        return (IBlockData)((IBlockData)this.o().a(b, fluid.a(FluidTypes.c))).a(aE, flag ? iblockdata.c(aE) : blockactioncontext.g().g());
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, aE, c);
    }
}

