/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.event.entity.EntityExhaustionEvent;
import org.slf4j.Logger;

public class Block
extends BlockBase
implements IMaterial {
    public static final MapCodec<Block> p = Block.b(Block::new);
    private static final Logger a = LogUtils.getLogger();
    private final Holder.c<Block> b = BuiltInRegistries.e.f(this);
    public static final RegistryBlockID<IBlockData> q = new RegistryBlockID();
    private static final LoadingCache<VoxelShape, Boolean> c = CacheBuilder.newBuilder().maximumSize(512L).weakKeys().build((CacheLoader)new CacheLoader<VoxelShape, Boolean>(){

        public Boolean a(VoxelShape voxelshape) {
            return !VoxelShapes.c(VoxelShapes.b(), voxelshape, OperatorBoolean.g);
        }
    });
    public static final int r = 1;
    public static final int s = 2;
    public static final int t = 4;
    public static final int u = 8;
    public static final int v = 16;
    public static final int w = 32;
    public static final int x = 64;
    public static final int y = 4;
    public static final int z = 3;
    public static final int A = 11;
    public static final float B = -1.0f;
    public static final float C = 0.0f;
    public static final int D = 512;
    protected final BlockStateList<Block, IBlockData> E;
    private IBlockData d;
    @Nullable
    private String e;
    @Nullable
    private Item f;
    private static final int g = 2048;
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<a>> h = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<a>(2048, 0.25f){

            protected void rehash(int i2) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    @Override
    protected MapCodec<? extends Block> a() {
        return p;
    }

    public static int i(@Nullable IBlockData iblockdata) {
        if (iblockdata == null) {
            return 0;
        }
        int i2 = q.a(iblockdata);
        return i2 == -1 ? 0 : i2;
    }

    public static IBlockData a(int i2) {
        IBlockData iblockdata = q.a(i2);
        return iblockdata == null ? Blocks.a.o() : iblockdata;
    }

    public static Block a(@Nullable Item item) {
        return item instanceof ItemBlock ? ((ItemBlock)item).d() : Blocks.a;
    }

    public static IBlockData a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        VoxelShape voxelshape = VoxelShapes.b(iblockdata.k(generatoraccess, blockposition), iblockdata1.k(generatoraccess, blockposition), OperatorBoolean.c).a((double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w());
        if (voxelshape.c()) {
            return iblockdata1;
        }
        List<Entity> list = generatoraccess.a_(null, voxelshape.a());
        for (Entity entity : list) {
            double d0 = VoxelShapes.a(EnumDirection.EnumAxis.b, entity.cK().d(0.0, 1.0, 0.0), List.of(voxelshape), -1.0);
            entity.d(0.0, 1.0 + d0, 0.0);
        }
        return iblockdata1;
    }

    public static VoxelShape a(double d0, double d1, double d2, double d3, double d4, double d5) {
        return VoxelShapes.a(d0 / 16.0, d1 / 16.0, d2 / 16.0, d3 / 16.0, d4 / 16.0, d5 / 16.0);
    }

    public static IBlockData b(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition) {
        IBlockData iblockdata1 = iblockdata;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (EnumDirection enumdirection : aF) {
            blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection);
            iblockdata1 = iblockdata1.a(enumdirection, generatoraccess.a_(blockposition_mutableblockposition), generatoraccess, blockposition, blockposition_mutableblockposition);
        }
        return iblockdata1;
    }

    public static void a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
        Block.a(iblockdata, iblockdata1, generatoraccess, blockposition, i2, 512);
    }

    public static void a(IBlockData iblockdata, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
        if (iblockdata1 != iblockdata) {
            if (iblockdata1.i()) {
                if (!generatoraccess.x_()) {
                    generatoraccess.a(blockposition, (i2 & 0x20) == 0, (Entity)null, j2);
                }
            } else {
                generatoraccess.a(blockposition, iblockdata1, i2 & 0xFFFFFFDF, j2);
            }
        }
    }

    public Block(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        String s2;
        BlockStateList.a<Block, IBlockData> blockstatelist_a = new BlockStateList.a<Block, IBlockData>(this);
        this.a(blockstatelist_a);
        this.E = blockstatelist_a.a(Block::o, IBlockData::new);
        this.k(this.E.b());
        if (SharedConstants.aV && !(s2 = this.getClass().getSimpleName()).endsWith("Block")) {
            a.error("Block classes should end with Block and {} doesn't.", (Object)s2);
        }
    }

    public static boolean j(IBlockData iblockdata) {
        return iblockdata.b() instanceof BlockLeaves || iblockdata.a(Blocks.hW) || iblockdata.a(Blocks.ee) || iblockdata.a(Blocks.ef) || iblockdata.a(Blocks.fa) || iblockdata.a(Blocks.eZ) || iblockdata.a(TagsBlock.aS);
    }

    public static boolean a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, BlockPosition blockposition1) {
        IBlockData iblockdata1 = iblockaccess.a_(blockposition1);
        if (iblockdata.a(iblockdata1, enumdirection)) {
            return false;
        }
        if (iblockdata1.p()) {
            a block_a = new a(iblockdata, iblockdata1, enumdirection);
            Object2ByteLinkedOpenHashMap<a> object2bytelinkedopenhashmap = h.get();
            byte b0 = object2bytelinkedopenhashmap.getAndMoveToFirst((Object)block_a);
            if (b0 != 127) {
                return b0 != 0;
            }
            VoxelShape voxelshape = iblockdata.a(iblockaccess, blockposition, enumdirection);
            if (voxelshape.c()) {
                return true;
            }
            VoxelShape voxelshape1 = iblockdata1.a(iblockaccess, blockposition1, enumdirection.g());
            boolean flag = VoxelShapes.c(voxelshape, voxelshape1, OperatorBoolean.e);
            if (object2bytelinkedopenhashmap.size() == 2048) {
                object2bytelinkedopenhashmap.removeLastByte();
            }
            object2bytelinkedopenhashmap.putAndMoveToFirst((Object)block_a, (byte)(flag ? 1 : 0));
            return flag;
        }
        return true;
    }

    public static boolean c(IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockaccess.a_(blockposition).a(iblockaccess, blockposition, EnumDirection.b, EnumBlockSupport.c);
    }

    public static boolean a(IWorldReader iworldreader, BlockPosition blockposition, EnumDirection enumdirection) {
        IBlockData iblockdata = iworldreader.a_(blockposition);
        return enumdirection == EnumDirection.a && iblockdata.a(TagsBlock.ba) ? false : iblockdata.a((IBlockAccess)iworldreader, blockposition, enumdirection, EnumBlockSupport.b);
    }

    public static boolean a(VoxelShape voxelshape, EnumDirection enumdirection) {
        VoxelShape voxelshape1 = voxelshape.a(enumdirection);
        return Block.a(voxelshape1);
    }

    public static boolean a(VoxelShape voxelshape) {
        return (Boolean)c.getUnchecked((Object)voxelshape);
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
    }

    public void a(GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
    }

    public static List<ItemStack> a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, @Nullable TileEntity tileentity) {
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).b(LootContextParameters.h, tileentity);
        return iblockdata.a(lootparams_a);
    }

    public static List<ItemStack> a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, @Nullable TileEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, itemstack).b(LootContextParameters.a, entity).b(LootContextParameters.h, tileentity);
        return iblockdata.a(lootparams_a);
    }

    public static void c(IBlockData iblockdata, World world, BlockPosition blockposition) {
        if (world instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)world, blockposition, (TileEntity)null).forEach(itemstack -> Block.a(world, blockposition, itemstack));
            iblockdata.a((WorldServer)world, blockposition, ItemStack.l, true);
        }
    }

    public static void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, @Nullable TileEntity tileentity) {
        if (generatoraccess instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)generatoraccess, blockposition, tileentity).forEach(itemstack -> Block.a((World)((WorldServer)generatoraccess), blockposition, itemstack));
            iblockdata.a((WorldServer)generatoraccess, blockposition, ItemStack.l, true);
        }
    }

    public static void a(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable TileEntity tileentity, @Nullable Entity entity, ItemStack itemstack) {
        if (world instanceof WorldServer) {
            Block.a(iblockdata, (WorldServer)world, blockposition, tileentity, entity, itemstack).forEach(itemstack1 -> Block.a(world, blockposition, itemstack1));
            iblockdata.a((WorldServer)world, blockposition, itemstack, true);
        }
    }

    public static void a(World world, BlockPosition blockposition, ItemStack itemstack) {
        double d0 = (double)EntityTypes.ag.m() / 2.0;
        double d1 = (double)blockposition.u() + 0.5 + MathHelper.a(world.z, -0.25, 0.25);
        double d2 = (double)blockposition.v() + 0.5 + MathHelper.a(world.z, -0.25, 0.25) - d0;
        double d3 = (double)blockposition.w() + 0.5 + MathHelper.a(world.z, -0.25, 0.25);
        Block.a(world, () -> new EntityItem(world, d1, d2, d3, itemstack), itemstack);
    }

    public static void a(World world, BlockPosition blockposition, EnumDirection enumdirection, ItemStack itemstack) {
        int i2 = enumdirection.j();
        int j2 = enumdirection.k();
        int k2 = enumdirection.l();
        double d0 = (double)EntityTypes.ag.l() / 2.0;
        double d1 = (double)EntityTypes.ag.m() / 2.0;
        double d2 = (double)blockposition.u() + 0.5 + (i2 == 0 ? MathHelper.a(world.z, -0.25, 0.25) : (double)i2 * (0.5 + d0));
        double d3 = (double)blockposition.v() + 0.5 + (j2 == 0 ? MathHelper.a(world.z, -0.25, 0.25) : (double)j2 * (0.5 + d1)) - d1;
        double d4 = (double)blockposition.w() + 0.5 + (k2 == 0 ? MathHelper.a(world.z, -0.25, 0.25) : (double)k2 * (0.5 + d0));
        double d5 = i2 == 0 ? MathHelper.a(world.z, -0.1, 0.1) : (double)i2 * 0.1;
        double d6 = j2 == 0 ? MathHelper.a(world.z, 0.0, 0.1) : (double)j2 * 0.1 + 0.1;
        double d7 = k2 == 0 ? MathHelper.a(world.z, -0.1, 0.1) : (double)k2 * 0.1;
        Block.a(world, () -> new EntityItem(world, d2, d3, d4, itemstack, d5, d6, d7), itemstack);
    }

    private static void a(World world, Supplier<EntityItem> supplier, ItemStack itemstack) {
        if (!world.B && !itemstack.e() && world.ab().b(GameRules.h)) {
            EntityItem entityitem = supplier.get();
            entityitem.v();
            if (world.captureDrops != null) {
                world.captureDrops.add(entityitem);
            } else {
                world.b(entityitem);
            }
        }
    }

    public void a(WorldServer worldserver, BlockPosition blockposition, int i2) {
        if (worldserver.ab().b(GameRules.h)) {
            EntityExperienceOrb.a(worldserver, Vec3D.b(blockposition), i2);
        }
    }

    public float e() {
        return this.aH;
    }

    public void a(World world, BlockPosition blockposition, Explosion explosion) {
    }

    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity) {
    }

    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        return this.o();
    }

    public void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata, @Nullable TileEntity tileentity, ItemStack itemstack) {
        entityhuman.b(StatisticList.a.b(this));
        entityhuman.causeFoodExhaustion(0.005f, EntityExhaustionEvent.ExhaustionReason.BLOCK_MINED);
        Block.a(iblockdata, world, blockposition, tileentity, (Entity)entityhuman, itemstack);
    }

    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, @Nullable EntityLiving entityliving, ItemStack itemstack) {
    }

    public boolean a(IBlockData iblockdata) {
        return !iblockdata.e() && !iblockdata.k();
    }

    public IChatMutableComponent f() {
        return IChatBaseComponent.c(this.g());
    }

    public String g() {
        if (this.e == null) {
            this.e = SystemUtils.a("block", BuiltInRegistries.e.b(this));
        }
        return this.e;
    }

    public void a(World world, IBlockData iblockdata, BlockPosition blockposition, Entity entity, float f2) {
        entity.a(f2, 1.0f, entity.dP().l());
    }

    public void a(IBlockAccess iblockaccess, Entity entity) {
        entity.i(entity.dr().d(1.0, 0.0, 1.0));
    }

    public ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return new ItemStack(this);
    }

    public float h() {
        return this.aK;
    }

    public float j() {
        return this.aL;
    }

    public float k() {
        return this.aM;
    }

    protected void a(World world, EntityHuman entityhuman, BlockPosition blockposition, IBlockData iblockdata) {
        world.a(entityhuman, 2001, blockposition, Block.i(iblockdata));
    }

    public IBlockData a(World world, BlockPosition blockposition, IBlockData iblockdata, EntityHuman entityhuman) {
        this.a(world, entityhuman, blockposition, iblockdata);
        if (iblockdata.a(TagsBlock.aX)) {
            PiglinAI.a(entityhuman, false);
        }
        world.a(GameEvent.f, blockposition, GameEvent.a.a(entityhuman, iblockdata));
        return iblockdata;
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, BiomeBase.Precipitation biomebase_precipitation) {
    }

    public boolean a(Explosion explosion) {
        return true;
    }

    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
    }

    public BlockStateList<Block, IBlockData> l() {
        return this.E;
    }

    protected final void k(IBlockData iblockdata) {
        this.d = iblockdata;
    }

    public final IBlockData o() {
        return this.d;
    }

    public final IBlockData l(IBlockData iblockdata) {
        IBlockData iblockdata1 = this.o();
        for (IBlockState<?> iblockstate : iblockdata.b().l().d()) {
            if (!iblockdata1.b(iblockstate)) continue;
            iblockdata1 = Block.a(iblockdata, iblockdata1, iblockstate);
        }
        return iblockdata1;
    }

    private static <T extends Comparable<T>> IBlockData a(IBlockData iblockdata, IBlockData iblockdata1, IBlockState<T> iblockstate) {
        return (IBlockData)iblockdata1.a(iblockstate, iblockdata.c(iblockstate));
    }

    @Override
    public Item r() {
        if (this.f == null) {
            this.f = Item.a(this);
        }
        return this.f;
    }

    public boolean p() {
        return this.aN;
    }

    public String toString() {
        return "Block{" + BuiltInRegistries.e.e(this).g() + "}";
    }

    public void a(ItemStack itemstack, Item.b item_b, List<IChatBaseComponent> list, TooltipFlag tooltipflag) {
    }

    @Override
    protected Block q() {
        return this;
    }

    protected ImmutableMap<IBlockData, VoxelShape> a(Function<IBlockData, VoxelShape> function) {
        return (ImmutableMap)this.E.a().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), function));
    }

    @Deprecated
    public Holder.c<Block> s() {
        return this.b;
    }

    protected int tryDropExperience(WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, IntProvider intprovider) {
        int i2 = EnchantmentManager.b(worldserver, itemstack, intprovider.a(worldserver.E_()));
        if (i2 > 0) {
            return i2;
        }
        return 0;
    }

    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        return 0;
    }

    public static float range(float min, float value, float max) {
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static final class a {
        private final IBlockData a;
        private final IBlockData b;
        private final EnumDirection c;

        public a(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
            this.a = iblockdata;
            this.b = iblockdata1;
            this.c = enumdirection;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            a block_a = (a)object;
            return this.a == block_a.a && this.b == block_a.b && this.c == block_a.c;
        }

        public int hashCode() {
            int i2 = this.a.hashCode();
            i2 = 31 * i2 + this.b.hashCode();
            i2 = 31 * i2 + this.c.hashCode();
            return i2;
        }
    }
}

