/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockAttachable;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyAttachPosition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.entity.EntityInteractEvent;

public class BlockButtonAbstract
extends BlockAttachable {
    public static final MapCodec<BlockButtonAbstract> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.a.fieldOf("block_set_type").forGetter(blockbuttonabstract -> blockbuttonabstract.N), (App)Codec.intRange((int)1, (int)1024).fieldOf("ticks_to_stay_pressed").forGetter(blockbuttonabstract -> blockbuttonabstract.O), BlockButtonAbstract.u()).apply((Applicative)instance, BlockButtonAbstract::new));
    public static final BlockStateBoolean b = BlockProperties.w;
    private static final int L = 1;
    private static final int M = 2;
    protected static final int c = 2;
    protected static final int d = 3;
    protected static final VoxelShape e = Block.a(6.0, 14.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape f = Block.a(5.0, 14.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape g = Block.a(6.0, 0.0, 5.0, 10.0, 2.0, 11.0);
    protected static final VoxelShape h = Block.a(5.0, 0.0, 6.0, 11.0, 2.0, 10.0);
    protected static final VoxelShape i = Block.a(5.0, 6.0, 14.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape j = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 2.0);
    protected static final VoxelShape k = Block.a(14.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape l = Block.a(0.0, 6.0, 5.0, 2.0, 10.0, 11.0);
    protected static final VoxelShape m = Block.a(6.0, 15.0, 5.0, 10.0, 16.0, 11.0);
    protected static final VoxelShape n = Block.a(5.0, 15.0, 6.0, 11.0, 16.0, 10.0);
    protected static final VoxelShape o = Block.a(6.0, 0.0, 5.0, 10.0, 1.0, 11.0);
    protected static final VoxelShape F = Block.a(5.0, 0.0, 6.0, 11.0, 1.0, 10.0);
    protected static final VoxelShape G = Block.a(5.0, 6.0, 15.0, 11.0, 10.0, 16.0);
    protected static final VoxelShape H = Block.a(5.0, 6.0, 0.0, 11.0, 10.0, 1.0);
    protected static final VoxelShape I = Block.a(15.0, 6.0, 5.0, 16.0, 10.0, 11.0);
    protected static final VoxelShape J = Block.a(0.0, 6.0, 5.0, 1.0, 10.0, 11.0);
    private final BlockSetType N;
    private final int O;

    public MapCodec<BlockButtonAbstract> a() {
        return a;
    }

    protected BlockButtonAbstract(BlockSetType blocksettype, int i2, BlockBase.Info blockbase_info) {
        super(blockbase_info.a(blocksettype.g()));
        this.N = blocksettype;
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(aE, EnumDirection.c)).a(b, false)).a(K, BlockPropertyAttachPosition.b));
        this.O = i2;
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        EnumDirection enumdirection = iblockdata.c(aE);
        boolean flag = iblockdata.c(b);
        switch ((BlockPropertyAttachPosition)iblockdata.c(K)) {
            case a: {
                if (enumdirection.o() == EnumDirection.EnumAxis.a) {
                    return flag ? o : g;
                }
                return flag ? F : h;
            }
            case b: {
                return switch (enumdirection) {
                    case EnumDirection.f -> flag ? J : l;
                    case EnumDirection.e -> flag ? I : k;
                    case EnumDirection.d -> flag ? H : j;
                    case EnumDirection.c, EnumDirection.b, EnumDirection.a -> flag ? G : i;
                    default -> throw new MatchException(null, null);
                };
            }
        }
        return enumdirection.o() == EnumDirection.EnumAxis.a ? (flag ? m : e) : (flag ? n : f);
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (iblockdata.c(b).booleanValue()) {
            return EnumInteractionResult.c;
        }
        boolean powered = iblockdata.c(b);
        org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
        world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() > 0 != !powered) {
            return EnumInteractionResult.a;
        }
        this.a(iblockdata, world, blockposition, entityhuman);
        return EnumInteractionResult.a(world.B);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (explosion.n() && !iblockdata.c(b).booleanValue()) {
            this.a(iblockdata, world, blockposition, (EntityHuman)null);
        }
        super.a(iblockdata, world, blockposition, explosion, biconsumer);
    }

    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, @Nullable EntityHuman entityhuman) {
        world.a(blockposition, (IBlockData)iblockdata.a(b, true), 3);
        this.e(iblockdata, world, blockposition);
        world.a(blockposition, (Block)this, this.O);
        this.a(entityhuman, (GeneratorAccess)world, blockposition, true);
        world.a((net.minecraft.world.entity.Entity)entityhuman, GameEvent.a, blockposition);
    }

    protected void a(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition, boolean flag) {
        generatoraccess.a(flag ? entityhuman : null, blockposition, this.a(flag), SoundCategory.e);
    }

    protected SoundEffect a(boolean flag) {
        return flag ? this.N.o() : this.N.n();
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (!flag && !iblockdata.a(iblockdata1.b())) {
            if (iblockdata.c(b).booleanValue()) {
                this.e(iblockdata, world, blockposition);
            }
            super.a(iblockdata, world, blockposition, iblockdata1, flag);
        }
    }

    @Override
    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return iblockdata.c(b) != false && BlockButtonAbstract.m(iblockdata) == enumdirection ? 15 : 0;
    }

    @Override
    protected boolean e_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue()) {
            this.d(iblockdata, worldserver, blockposition);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (!world.B && this.N.e() && !iblockdata.c(b).booleanValue()) {
            this.d(iblockdata, world, blockposition);
        }
    }

    protected void d(IBlockData iblockdata, World world, BlockPosition blockposition) {
        EntityArrow entityarrow = this.N.e() ? (EntityArrow)world.a(EntityArrow.class, iblockdata.j(world, blockposition).a().a(blockposition)).stream().findFirst().orElse(null) : null;
        boolean flag = entityarrow != null;
        boolean flag1 = iblockdata.c(b);
        if (flag1 != flag && flag) {
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            EntityInteractEvent event = new EntityInteractEvent((Entity)entityarrow.getBukkitEntity(), block);
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        if (flag != flag1) {
            boolean powered = flag1;
            org.bukkit.block.Block block = world.getWorld().getBlockAt(blockposition.u(), blockposition.v(), blockposition.w());
            int old = powered ? 15 : 0;
            int current = !powered ? 15 : 0;
            BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(block, old, current);
            world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
            if (flag && eventRedstone.getNewCurrent() <= 0 || !flag && eventRedstone.getNewCurrent() > 0) {
                return;
            }
            world.a(blockposition, (IBlockData)iblockdata.a(b, flag), 3);
            this.e(iblockdata, world, blockposition);
            this.a((EntityHuman)null, (GeneratorAccess)world, blockposition, flag);
            world.a((net.minecraft.world.entity.Entity)entityarrow, flag ? GameEvent.a : GameEvent.e, blockposition);
        }
        if (flag) {
            world.a(new BlockPosition(blockposition), (Block)this, this.O);
        }
    }

    private void e(IBlockData iblockdata, World world, BlockPosition blockposition) {
        world.a(blockposition, this);
        world.a(blockposition.a(BlockButtonAbstract.m(iblockdata).g()), this);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(aE, b, K);
    }
}

