/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorProjectile;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityDispenser;
import net.minecraft.world.level.block.entity.TileEntityDropper;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class BlockDispenser
extends BlockTileEntity {
    private static final Logger e = LogUtils.getLogger();
    public static final MapCodec<BlockDispenser> a = BlockDispenser.b(BlockDispenser::new);
    public static final BlockStateDirection b = BlockDirectional.a;
    public static final BlockStateBoolean c = BlockProperties.A;
    private static final DispenseBehaviorItem f = new DispenseBehaviorItem();
    public static final Map<Item, IDispenseBehavior> d = (Map)SystemUtils.a(new Object2ObjectOpenHashMap(), (? super T object2objectopenhashmap) -> object2objectopenhashmap.defaultReturnValue((Object)f));
    private static final int g = 4;
    public static boolean eventFired = false;

    public MapCodec<? extends BlockDispenser> a() {
        return a;
    }

    public static void a(IMaterial imaterial, IDispenseBehavior idispensebehavior) {
        d.put(imaterial.r(), idispensebehavior);
    }

    public static void a(IMaterial imaterial) {
        d.put(imaterial.r(), new DispenseBehaviorProjectile(imaterial.r()));
    }

    protected BlockDispenser(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(b, EnumDirection.c)).a(c, false));
    }

    @Override
    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        if (world.B) {
            return EnumInteractionResult.a;
        }
        TileEntity tileentity = world.c_(blockposition);
        if (tileentity instanceof TileEntityDispenser) {
            entityhuman.a((TileEntityDispenser)tileentity);
            if (tileentity instanceof TileEntityDropper) {
                entityhuman.a(StatisticList.ac);
            } else {
                entityhuman.a(StatisticList.ae);
            }
        }
        return EnumInteractionResult.c;
    }

    public void a(WorldServer worldserver, IBlockData iblockdata, BlockPosition blockposition) {
        TileEntityDispenser tileentitydispenser = worldserver.a(blockposition, TileEntityTypes.f).orElse(null);
        if (tileentitydispenser == null) {
            e.warn("Ignoring dispensing attempt for Dispenser without matching block entity at {}", (Object)blockposition);
        } else {
            SourceBlock sourceblock = new SourceBlock(worldserver, blockposition, iblockdata, tileentitydispenser);
            int i2 = tileentitydispenser.a(worldserver.z);
            if (i2 < 0) {
                worldserver.c(1001, blockposition, 0);
                worldserver.a(GameEvent.a, blockposition, GameEvent.a.a(tileentitydispenser.n()));
            } else {
                ItemStack itemstack = tileentitydispenser.a(i2);
                IDispenseBehavior idispensebehavior = this.a((World)worldserver, itemstack);
                if (idispensebehavior != IDispenseBehavior.b) {
                    eventFired = false;
                    tileentitydispenser.a(i2, idispensebehavior.dispense(sourceblock, itemstack));
                }
            }
        }
    }

    protected IDispenseBehavior a(World world, ItemStack itemstack) {
        return !itemstack.a(world.J()) ? f : d.get(itemstack.g());
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        boolean flag1 = world.C(blockposition) || world.C(blockposition.d());
        boolean flag2 = iblockdata.c(c);
        if (flag1 && !flag2) {
            world.a(blockposition, (Block)this, 4);
            world.a(blockposition, (IBlockData)iblockdata.a(c, true), 2);
        } else if (!flag1 && flag2) {
            world.a(blockposition, (IBlockData)iblockdata.a(c, false), 2);
        }
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        this.a(worldserver, iblockdata, blockposition);
    }

    @Override
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new TileEntityDispenser(blockposition, iblockdata);
    }

    @Override
    public IBlockData a(BlockActionContext blockactioncontext) {
        return (IBlockData)this.o().a(b, blockactioncontext.d().g());
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        InventoryUtils.a(iblockdata, iblockdata1, world, blockposition);
        super.a(iblockdata, world, blockposition, iblockdata1, flag);
    }

    public static IPosition a(SourceBlock sourceblock) {
        return BlockDispenser.a(sourceblock, 0.7, Vec3D.b);
    }

    public static IPosition a(SourceBlock sourceblock, double d0, Vec3D vec3d) {
        EnumDirection enumdirection = sourceblock.d().c(b);
        return sourceblock.a().b(d0 * (double)enumdirection.j() + vec3d.a(), d0 * (double)enumdirection.k() + vec3d.b(), d0 * (double)enumdirection.l() + vec3d.c());
    }

    @Override
    protected boolean c_(IBlockData iblockdata) {
        return true;
    }

    @Override
    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return Container.a(world.c_(blockposition));
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return (IBlockData)iblockdata.a(b, enumblockrotation.a(iblockdata.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata.a(enumblockmirror.a(iblockdata.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(b, c);
    }
}

