/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;

public class BlockFluids
extends Block
implements IFluidSource {
    private static final Codec<FluidTypeFlowing> f = BuiltInRegistries.c.r().comapFlatMap(fluidtype -> {
        DataResult dataresult;
        if (fluidtype instanceof FluidTypeFlowing) {
            FluidTypeFlowing fluidtypeflowing = (FluidTypeFlowing)fluidtype;
            dataresult = DataResult.success((Object)fluidtypeflowing);
        } else {
            dataresult = DataResult.error(() -> "Not a flowing fluid: " + String.valueOf(fluidtype));
        }
        return dataresult;
    }, fluidtypeflowing -> fluidtypeflowing);
    public static final MapCodec<BlockFluids> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)f.fieldOf("fluid").forGetter(blockfluids -> blockfluids.c), BlockFluids.u()).apply((Applicative)instance, BlockFluids::new));
    public static final BlockStateInteger b = BlockProperties.aP;
    protected final FluidTypeFlowing c;
    private final List<Fluid> g;
    public static final VoxelShape d = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final ImmutableList<EnumDirection> e = ImmutableList.of((Object)EnumDirection.a, (Object)EnumDirection.d, (Object)EnumDirection.c, (Object)EnumDirection.f, (Object)EnumDirection.e);

    public MapCodec<BlockFluids> a() {
        return a;
    }

    protected BlockFluids(FluidTypeFlowing fluidtypeflowing, BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.c = fluidtypeflowing;
        this.g = Lists.newArrayList();
        this.g.add(fluidtypeflowing.a(false));
        for (int i2 = 1; i2 < 8; ++i2) {
            this.g.add(fluidtypeflowing.a(8 - i2, false));
        }
        this.g.add(fluidtypeflowing.a(8, true));
        this.k((IBlockData)((IBlockData)this.E.b()).a(b, 0));
    }

    @Override
    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return voxelshapecollision.a(d, blockposition, true) && iblockdata.c(b) == 0 && voxelshapecollision.a(iblockaccess.b_(blockposition.d()), iblockdata.u()) ? d : VoxelShapes.a();
    }

    @Override
    protected boolean d_(IBlockData iblockdata) {
        return iblockdata.u().f();
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        iblockdata.u().b(worldserver, blockposition, randomsource);
    }

    @Override
    protected boolean a_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return false;
    }

    @Override
    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        return !this.c.a(TagsFluid.b);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        int i2 = iblockdata.c(b);
        return this.g.get(Math.min(i2, 8));
    }

    @Override
    protected boolean a(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        return iblockdata1.u().a().a(this.c);
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.a;
    }

    @Override
    protected List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        return Collections.emptyList();
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return VoxelShapes.a();
    }

    @Override
    protected void b(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (this.a(world, blockposition, iblockdata)) {
            world.a(blockposition, iblockdata.u().a(), this.c.a((IWorldReader)world));
        }
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.u().b() || iblockdata1.u().b()) {
            generatoraccess.a(blockposition, iblockdata.u().a(), this.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        if (this.a(world, blockposition, iblockdata)) {
            world.a(blockposition, iblockdata.u().a(), this.c.a((IWorldReader)world));
        }
    }

    private boolean a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        if (this.c.a(TagsFluid.b)) {
            boolean flag = world.a_(blockposition.e()).a(Blocks.dX);
            for (EnumDirection enumdirection : e) {
                BlockPosition blockposition1 = blockposition.a(enumdirection.g());
                if (world.b_(blockposition1).a(TagsFluid.a)) {
                    Block block;
                    Block block2 = block = world.b_(blockposition).b() ? Blocks.co : Blocks.m;
                    if (CraftEventFactory.handleBlockFormEvent(world, blockposition, block.o())) {
                        this.a(world, blockposition);
                    }
                    return false;
                }
                if (!flag || !world.a_(blockposition1).a(Blocks.mW)) continue;
                if (CraftEventFactory.handleBlockFormEvent(world, blockposition, Blocks.dY.o())) {
                    this.a(world, blockposition);
                }
                return false;
            }
        }
        return true;
    }

    private void a(GeneratorAccess generatoraccess, BlockPosition blockposition) {
        generatoraccess.c(1501, blockposition, 0);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
    }

    @Override
    public ItemStack a(@Nullable EntityHuman entityhuman, GeneratorAccess generatoraccess, BlockPosition blockposition, IBlockData iblockdata) {
        if (iblockdata.c(b) == 0) {
            generatoraccess.a(blockposition, Blocks.a.o(), 11);
            return new ItemStack(this.c.a());
        }
        return ItemStack.l;
    }

    @Override
    public Optional<SoundEffect> aw_() {
        return this.c.j();
    }
}

