/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntityPigZombie;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.portal.BlockPortalShape;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.slf4j.Logger;

public class BlockPortal
extends Block
implements Portal {
    public static final MapCodec<BlockPortal> a = BlockPortal.b(BlockPortal::new);
    public static final BlockStateEnum<EnumDirection.EnumAxis> b = BlockProperties.H;
    private static final Logger f = LogUtils.getLogger();
    protected static final int c = 2;
    protected static final VoxelShape d = Block.a(0.0, 0.0, 6.0, 16.0, 16.0, 10.0);
    protected static final VoxelShape e = Block.a(6.0, 0.0, 0.0, 10.0, 16.0, 16.0);

    public MapCodec<BlockPortal> a() {
        return a;
    }

    public BlockPortal(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)this.E.b()).a(b, EnumDirection.EnumAxis.a));
    }

    @Override
    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        switch (iblockdata.c(b)) {
            case c: {
                return e;
            }
        }
        return d;
    }

    @Override
    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (worldserver.spigotConfig.enableZombiePigmenPortalSpawns && worldserver.D_().j() && worldserver.ab().b(GameRules.e) && randomsource.a(2000) < worldserver.al().a()) {
            EntityPigZombie entity;
            while (worldserver.a_(blockposition).a(this)) {
                blockposition = blockposition.e();
            }
            if (worldserver.a_(blockposition).a((IBlockAccess)worldserver, blockposition, EntityTypes.bx) && (entity = EntityTypes.bx.spawn(worldserver, blockposition.d(), EnumMobSpawn.d, CreatureSpawnEvent.SpawnReason.NETHER_PORTAL)) != null) {
                entity.ay();
            }
        }
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        EnumDirection.EnumAxis enumdirection_enumaxis = enumdirection.o();
        EnumDirection.EnumAxis enumdirection_enumaxis1 = iblockdata.c(b);
        boolean flag = enumdirection_enumaxis1 != enumdirection_enumaxis && enumdirection_enumaxis.d();
        return !flag && !iblockdata1.a(this) && !new BlockPortalShape(generatoraccess, blockposition, enumdirection_enumaxis1).c() ? Blocks.a.o() : super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, net.minecraft.world.entity.Entity entity) {
        if (entity.o(false)) {
            EntityPortalEnterEvent event = new EntityPortalEnterEvent((Entity)entity.getBukkitEntity(), new Location((org.bukkit.World)world.getWorld(), (double)blockposition.u(), (double)blockposition.v(), (double)blockposition.w()));
            world.getCraftServer().getPluginManager().callEvent((Event)event);
            entity.a(this, blockposition);
        }
    }

    @Override
    public int a(WorldServer worldserver, net.minecraft.world.entity.Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman entityhuman = (EntityHuman)entity;
            return Math.max(1, worldserver.ab().c(entityhuman.fZ().a ? GameRules.F : GameRules.E));
        }
        return 0;
    }

    @Override
    @Nullable
    public DimensionTransition a(WorldServer worldserver, net.minecraft.world.entity.Entity entity, BlockPosition blockposition) {
        ResourceKey<World> resourcekey = worldserver.getTypeKey() == WorldDimension.c ? World.h : World.i;
        WorldServer worldserver1 = worldserver.o().a(resourcekey);
        if (worldserver1 == null) {
            return new DimensionTransition(PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
        }
        boolean flag = worldserver1.getTypeKey() == WorldDimension.c;
        WorldBorder worldborder = worldserver1.C_();
        double d0 = DimensionManager.a(worldserver.D_(), worldserver1.D_());
        BlockPosition blockposition1 = worldborder.b(entity.dt() * d0, entity.dv(), entity.dz() * d0);
        CraftPortalEvent event = entity.callPortalEvent(entity, CraftLocation.toBukkit(blockposition1, (org.bukkit.World)worldserver1.getWorld()), PlayerTeleportEvent.TeleportCause.NETHER_PORTAL, flag ? 16 : 128, 16);
        if (event == null) {
            return null;
        }
        worldserver1 = ((CraftWorld)event.getTo().getWorld()).getHandle();
        worldborder = worldserver1.C_();
        blockposition1 = worldborder.b(event.getTo().getX(), event.getTo().getY(), event.getTo().getZ());
        return this.getExitPortal(worldserver1, entity, blockposition, blockposition1, flag, worldborder, event.getSearchRadius(), event.getCanCreatePortal(), event.getCreationRadius());
    }

    @Nullable
    private DimensionTransition getExitPortal(WorldServer worldserver, net.minecraft.world.entity.Entity entity, BlockPosition blockposition, BlockPosition blockposition1, boolean flag, WorldBorder worldborder, int searchRadius, boolean canCreatePortal, int createRadius) {
        DimensionTransition.a dimensiontransition_a;
        BlockUtil.Rectangle blockutil_rectangle;
        Optional<BlockPosition> optional = worldserver.p().findClosestPortalPosition(blockposition1, worldborder, searchRadius);
        if (optional.isPresent()) {
            BlockPosition blockposition2 = optional.get();
            IBlockData iblockdata = worldserver.a_(blockposition2);
            blockutil_rectangle = BlockUtil.a(blockposition2, iblockdata.c(BlockProperties.H), 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockposition3) -> worldserver.a_((BlockPosition)blockposition3) == iblockdata);
            dimensiontransition_a = DimensionTransition.b.then(entity1 -> entity1.f(blockposition2));
        } else if (canCreatePortal) {
            EnumDirection.EnumAxis enumdirection_enumaxis = entity.dO().a_(blockposition).d(b).orElse(EnumDirection.EnumAxis.a);
            Optional<BlockUtil.Rectangle> optional1 = worldserver.p().createPortal(blockposition1, enumdirection_enumaxis, entity, createRadius);
            if (optional1.isEmpty()) {
                return null;
            }
            blockutil_rectangle = optional1.get();
            dimensiontransition_a = DimensionTransition.b.then(DimensionTransition.c);
        } else {
            return null;
        }
        return BlockPortal.a(entity, blockposition, blockutil_rectangle, worldserver, dimensiontransition_a);
    }

    private static DimensionTransition a(net.minecraft.world.entity.Entity entity, BlockPosition blockposition, BlockUtil.Rectangle blockutil_rectangle, WorldServer worldserver, DimensionTransition.a dimensiontransition_a) {
        Vec3D vec3d;
        EnumDirection.EnumAxis enumdirection_enumaxis;
        IBlockData iblockdata = entity.dO().a_(blockposition);
        if (iblockdata.b(BlockProperties.H)) {
            enumdirection_enumaxis = iblockdata.c(BlockProperties.H);
            BlockUtil.Rectangle blockutil_rectangle1 = BlockUtil.a(blockposition, enumdirection_enumaxis, 21, EnumDirection.EnumAxis.b, 21, (BlockPosition blockposition1) -> entity.dO().a_((BlockPosition)blockposition1) == iblockdata);
            vec3d = entity.a(enumdirection_enumaxis, blockutil_rectangle1);
        } else {
            enumdirection_enumaxis = EnumDirection.EnumAxis.a;
            vec3d = new Vec3D(0.5, 0.0, 0.0);
        }
        return BlockPortal.a(worldserver, blockutil_rectangle, enumdirection_enumaxis, vec3d, entity, entity.dr(), entity.dE(), entity.dG(), dimensiontransition_a);
    }

    private static DimensionTransition a(WorldServer worldserver, BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, net.minecraft.world.entity.Entity entity, Vec3D vec3d1, float f2, float f1, DimensionTransition.a dimensiontransition_a) {
        BlockPosition blockposition = blockutil_rectangle.a;
        IBlockData iblockdata = worldserver.a_(blockposition);
        EnumDirection.EnumAxis enumdirection_enumaxis1 = iblockdata.d(BlockProperties.H).orElse(EnumDirection.EnumAxis.a);
        double d0 = blockutil_rectangle.b;
        double d1 = blockutil_rectangle.c;
        EntitySize entitysize = entity.a(entity.at());
        int i2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? 0 : 90;
        Vec3D vec3d2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? vec3d1 : new Vec3D(vec3d1.e, vec3d1.d, -vec3d1.c);
        double d2 = (double)entitysize.a() / 2.0 + (d0 - (double)entitysize.a()) * vec3d.a();
        double d3 = (d1 - (double)entitysize.b()) * vec3d.b();
        double d4 = 0.5 + vec3d.c();
        boolean flag = enumdirection_enumaxis1 == EnumDirection.EnumAxis.a;
        Vec3D vec3d3 = new Vec3D((double)blockposition.u() + (flag ? d2 : d4), (double)blockposition.v() + d3, (double)blockposition.w() + (flag ? d4 : d2));
        Vec3D vec3d4 = BlockPortalShape.a(vec3d3, worldserver, entity, entitysize);
        return new DimensionTransition(worldserver, vec3d4, vec3d2, f2 + (float)i2, f1, dimensiontransition_a, PlayerTeleportEvent.TeleportCause.NETHER_PORTAL);
    }

    @Override
    public Portal.a b() {
        return Portal.a.a;
    }

    @Override
    public void a(IBlockData iblockdata, World world, BlockPosition blockposition, RandomSource randomsource) {
        if (randomsource.a(100) == 0) {
            world.a((double)blockposition.u() + 0.5, (double)blockposition.v() + 0.5, (double)blockposition.w() + 0.5, SoundEffects.uH, SoundCategory.e, 0.5f, randomsource.i() * 0.4f + 0.8f, false);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            double d0 = (double)blockposition.u() + randomsource.j();
            double d1 = (double)blockposition.v() + randomsource.j();
            double d2 = (double)blockposition.w() + randomsource.j();
            double d3 = ((double)randomsource.i() - 0.5) * 0.5;
            double d4 = ((double)randomsource.i() - 0.5) * 0.5;
            double d5 = ((double)randomsource.i() - 0.5) * 0.5;
            int j2 = randomsource.a(2) * 2 - 1;
            if (!world.a_(blockposition.h()).a(this) && !world.a_(blockposition.i()).a(this)) {
                d0 = (double)blockposition.u() + 0.5 + 0.25 * (double)j2;
                d3 = randomsource.i() * 2.0f * (float)j2;
            } else {
                d2 = (double)blockposition.w() + 0.5 + 0.25 * (double)j2;
                d5 = randomsource.i() * 2.0f * (float)j2;
            }
            world.a(Particles.ac, d0, d1, d2, d3, d4, d5);
        }
    }

    @Override
    public ItemStack a(IWorldReader iworldreader, BlockPosition blockposition, IBlockData iblockdata) {
        return ItemStack.l;
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        switch (enumblockrotation) {
            case d: 
            case b: {
                switch (iblockdata.c(b)) {
                    case c: {
                        return (IBlockData)iblockdata.a(b, EnumDirection.EnumAxis.a);
                    }
                    case a: {
                        return (IBlockData)iblockdata.a(b, EnumDirection.EnumAxis.c);
                    }
                }
                return iblockdata;
            }
        }
        return iblockdata;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
    }
}

