/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.SculkShriekerBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.event.block.Action;

public class SculkShriekerBlock
extends BlockTileEntity
implements IBlockWaterlogged {
    public static final MapCodec<SculkShriekerBlock> a = SculkShriekerBlock.b(SculkShriekerBlock::new);
    public static final BlockStateBoolean b = BlockProperties.F;
    public static final BlockStateBoolean c = BlockProperties.C;
    public static final BlockStateBoolean d = BlockProperties.G;
    protected static final VoxelShape e = Block.a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0);
    public static final double f = e.c(EnumDirection.EnumAxis.b);

    public MapCodec<SculkShriekerBlock> a() {
        return a;
    }

    public SculkShriekerBlock(BlockBase.Info blockbase_info) {
        super(blockbase_info);
        this.k((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.E.b()).a(b, false)).a(c, false)).a(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> blockstatelist_a) {
        blockstatelist_a.a(new IBlockState[]{b});
        blockstatelist_a.a(new IBlockState[]{c});
        blockstatelist_a.a(new IBlockState[]{d});
    }

    @Override
    public void a(World world, BlockPosition blockposition, IBlockData iblockdata, Entity entity) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            EntityPlayer entityplayer = SculkShriekerBlockEntity.a(entity);
            if (entityplayer != null) {
                if (CraftEventFactory.callPlayerInteractEvent(entityplayer, Action.PHYSICAL, blockposition, null, null, null).isCancelled()) {
                    return;
                }
                worldserver.a(blockposition, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver, entityplayer));
            }
        }
        super.a(world, blockposition, iblockdata, entity);
    }

    @Override
    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        if (world instanceof WorldServer) {
            WorldServer worldserver = (WorldServer)world;
            if (iblockdata.c(b).booleanValue() && !iblockdata.a(iblockdata1.b())) {
                worldserver.a(blockposition, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver));
            }
        }
        super.a(iblockdata, world, blockposition, iblockdata1, flag);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
        if (iblockdata.c(b).booleanValue()) {
            worldserver.a(blockposition, (IBlockData)iblockdata.a(b, false), 3);
            worldserver.a(blockposition, TileEntityTypes.L).ifPresent(sculkshriekerblockentity -> sculkshriekerblockentity.a(worldserver));
        }
    }

    @Override
    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    @Override
    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return e;
    }

    @Override
    protected VoxelShape f(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return e;
    }

    @Override
    protected boolean f_(IBlockData iblockdata) {
        return true;
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition blockposition, IBlockData iblockdata) {
        return new SculkShriekerBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        if (iblockdata.c(c).booleanValue()) {
            generatoraccess.a(blockposition, FluidTypes.c, FluidTypes.c.a(generatoraccess));
        }
        return super.a(iblockdata, enumdirection, iblockdata1, generatoraccess, blockposition, blockposition1);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext blockactioncontext) {
        return (IBlockData)this.o().a(c, blockactioncontext.q().b_(blockactioncontext.a()).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData iblockdata) {
        return iblockdata.c(c) != false ? FluidTypes.c.a(false) : super.b_(iblockdata);
    }

    @Override
    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        super.a(iblockdata, worldserver, blockposition, itemstack, flag);
    }

    @Override
    public int getExpDrop(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
        if (flag) {
            return this.tryDropExperience(worldserver, blockposition, itemstack, ConstantInt.a(5));
        }
        return 0;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World world, IBlockData iblockdata, TileEntityTypes<T> tileentitytypes) {
        return !world.B ? BlockTileEntity.a(tileentitytypes, TileEntityTypes.L, (World world1, BlockPosition blockposition, IBlockData iblockdata1, ? super E sculkshriekerblockentity) -> VibrationSystem.c.a(world1, sculkshriekerblockentity.gm(), sculkshriekerblockentity.gn())) : null;
    }
}

