/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.SpigotTimings;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R1.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;
import org.spigotmc.CustomTimingsHandler;

public abstract class TileEntity {
    public CustomTimingsHandler tickTimer = SpigotTimings.getTileEntityTimings(this);
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer;
    private static final Logger d = LogUtils.getLogger();
    private final TileEntityTypes<?> e;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData f;
    private DataComponentMap g = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata) {
        this.e = tileentitytypes;
        this.o = blockposition.j();
        this.a(iblockdata);
        this.f = iblockdata;
    }

    private void a(IBlockData iblockdata) {
        if (!this.b(iblockdata)) {
            String s2 = this.k();
            throw new IllegalStateException("Invalid block entity " + s2 + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(iblockdata));
        }
    }

    public boolean b(IBlockData iblockdata) {
        return this.e.a(iblockdata);
    }

    public static BlockPosition b(NBTTagCompound nbttagcompound) {
        return new BlockPosition(nbttagcompound.h("x"), nbttagcompound.h("y"), nbttagcompound.h("z"));
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World world) {
        this.n = world;
    }

    public boolean m() {
        return this.n != null;
    }

    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
        NBTBase persistentDataTag = nbttagcompound.c("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.a(nbttagcompound, holderlookup_a);
        a.a.parse(holderlookup_a.a(DynamicOpsNBT.a), (Object)nbttagcompound).resultOrPartial(s2 -> d.warn("Failed to load components: {}", s2)).ifPresent(datacomponentmap -> {
            this.g = datacomponentmap;
        });
    }

    public final void d(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        this.a(nbttagcompound, holderlookup_a);
    }

    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
    }

    public final NBTTagCompound b(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.d(holderlookup_a);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound c(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.d(holderlookup_a);
        this.c(nbttagcompound);
        return nbttagcompound;
    }

    public final NBTTagCompound d(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, holderlookup_a);
        a.a.encodeStart(holderlookup_a.a(DynamicOpsNBT.a), (Object)this.g).resultOrPartial(s2 -> d.warn("Failed to save components: {}", s2)).ifPresent(nbtbase -> nbttagcompound.a((NBTTagCompound)nbtbase));
        if (this.persistentDataContainer != null && !this.persistentDataContainer.isEmpty()) {
            nbttagcompound.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return nbttagcompound;
    }

    public final NBTTagCompound e(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.b(nbttagcompound, holderlookup_a);
        return nbttagcompound;
    }

    public final NBTTagCompound f(HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.e(holderlookup_a);
        this.d(nbttagcompound);
        return nbttagcompound;
    }

    private void c(NBTTagCompound nbttagcompound) {
        MinecraftKey minecraftkey = TileEntityTypes.a(this.r());
        if (minecraftkey == null) {
            throw new RuntimeException(String.valueOf(this.getClass()) + " is missing a mapping! This is a bug!");
        }
        nbttagcompound.a("id", minecraftkey.toString());
    }

    public static void a(NBTTagCompound nbttagcompound, TileEntityTypes<?> tileentitytypes) {
        nbttagcompound.a("id", TileEntityTypes.a(tileentitytypes).toString());
    }

    public void a(ItemStack itemstack, HolderLookup.a holderlookup_a) {
        NBTTagCompound nbttagcompound = this.e(holderlookup_a);
        this.a(nbttagcompound);
        ItemBlock.a(itemstack, this.r(), nbttagcompound);
        itemstack.b(this.s());
    }

    private void d(NBTTagCompound nbttagcompound) {
        this.c(nbttagcompound);
        nbttagcompound.a("x", this.o.u());
        nbttagcompound.a("y", this.o.v());
        nbttagcompound.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition blockposition, IBlockData iblockdata, NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        String s2 = nbttagcompound.l("id");
        MinecraftKey minecraftkey = MinecraftKey.c(s2);
        if (minecraftkey == null) {
            d.error("Block entity has invalid type: {}", (Object)s2);
            return null;
        }
        return BuiltInRegistries.j.b(minecraftkey).map(tileentitytypes -> {
            try {
                return tileentitytypes.a(blockposition, iblockdata);
            }
            catch (Throwable throwable) {
                d.error("Failed to create block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).map(tileentity -> {
            try {
                tileentity.c(nbttagcompound, holderlookup_a);
                return tileentity;
            }
            catch (Throwable throwable) {
                d.error("Failed to load data for block entity {}", (Object)s2, (Object)throwable);
                return null;
            }
        }).orElseGet(() -> {
            d.warn("Skipping BlockEntity with id {}", (Object)s2);
            return null;
        });
    }

    public void e() {
        if (this.n != null) {
            TileEntity.a(this.n, this.o, this.f);
        }
    }

    protected static void a(World world, BlockPosition blockposition, IBlockData iblockdata) {
        world.q(blockposition);
        if (!iblockdata.i()) {
            world.c(blockposition, iblockdata.b());
        }
    }

    public BlockPosition aD_() {
        return this.o;
    }

    public IBlockData n() {
        return this.f;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> az_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a holderlookup_a) {
        return new NBTTagCompound();
    }

    public boolean o() {
        return this.p;
    }

    public void aA_() {
        this.p = true;
    }

    public void p() {
        this.p = false;
    }

    public boolean a_(int i2, int j2) {
        return false;
    }

    public void a(CrashReportSystemDetails crashreportsystemdetails) {
        crashreportsystemdetails.a("Name", this::k);
        if (this.n != null) {
            CrashReportSystemDetails.a(crashreportsystemdetails, this.n, this.o, this.n());
            CrashReportSystemDetails.a(crashreportsystemdetails, this.n, this.o, this.n.a_(this.o));
        }
    }

    private String k() {
        String s2 = String.valueOf(BuiltInRegistries.j.b(this.r()));
        return s2 + " // " + this.getClass().getCanonicalName();
    }

    public boolean q() {
        return false;
    }

    public TileEntityTypes<?> r() {
        return this.e;
    }

    @Deprecated
    public void c(IBlockData iblockdata) {
        this.a(iblockdata);
        this.f = iblockdata;
    }

    protected void a(b tileentity_b) {
    }

    public final void a(ItemStack itemstack) {
        this.a(itemstack.c(), itemstack.d());
    }

    public final void a(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        this.applyComponentsSet(datacomponentmap, datacomponentpatch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap datacomponentmap, DataComponentPatch datacomponentpatch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.O);
        final PatchedDataComponentMap patcheddatacomponentmap = PatchedDataComponentMap.a(datacomponentmap, datacomponentpatch);
        this.a(new b(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<T> datacomponenttype) {
                set.add(datacomponenttype);
                return patcheddatacomponentmap.a(datacomponenttype);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> datacomponenttype, T t0) {
                set.add(datacomponenttype);
                return patcheddatacomponentmap.a(datacomponenttype, t0);
            }
        });
        Objects.requireNonNull(set);
        DataComponentPatch datacomponentpatch1 = datacomponentpatch.a(set::contains);
        this.g = datacomponentpatch1.e().a();
        set.remove(DataComponents.O);
        return set;
    }

    protected void a(DataComponentMap.a datacomponentmap_a) {
    }

    @Deprecated
    public void a(NBTTagCompound nbttagcompound) {
    }

    public final DataComponentMap s() {
        DataComponentMap.a datacomponentmap_a = DataComponentMap.a();
        datacomponentmap_a.a(this.g);
        this.a(datacomponentmap_a);
        return datacomponentmap_a.a();
    }

    public DataComponentMap t() {
        return this.g;
    }

    public void a(DataComponentMap datacomponentmap) {
        this.g = datacomponentmap;
    }

    @Nullable
    public static IChatBaseComponent a(String s2, HolderLookup.a holderlookup_a) {
        try {
            return IChatBaseComponent.ChatSerializer.a(s2, holderlookup_a);
        }
        catch (Exception exception) {
            d.warn("Failed to parse custom name from string '{}', discarding", (Object)s2, (Object)exception);
            return null;
        }
    }

    public InventoryHolder getOwner() {
        if (this.n == null) {
            return null;
        }
        BlockState state = this.n.getWorld().getBlockAt(this.o.u(), this.o.v(), this.o.w()).getState();
        if (state instanceof InventoryHolder) {
            return (InventoryHolder)state;
        }
        return null;
    }

    private static class a {
        public static final Codec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a).codec();

        private a() {
        }
    }

    protected static interface b {
        @Nullable
        public <T> T a(DataComponentType<T> var1);

        public <T> T a(DataComponentType<? extends T> var1, T var2);
    }
}

