/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFurnace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceExtractEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.FurnaceStartSmeltEvent;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public abstract class TileEntityFurnace
extends TileEntityContainer
implements IWorldInventory,
RecipeCraftingHolder,
AutoRecipeOutput {
    protected static final int b = 0;
    protected static final int c = 1;
    protected static final int d = 2;
    public static final int e = 0;
    private static final int[] q = new int[]{0};
    private static final int[] r = new int[]{2, 1};
    private static final int[] s = new int[]{1};
    public static final int f = 1;
    public static final int g = 2;
    public static final int h = 3;
    public static final int i = 4;
    public static final int j = 200;
    public static final int k = 2;
    protected NonNullList<net.minecraft.world.item.ItemStack> l;
    public int t;
    int u;
    public int v;
    public int w;
    @Nullable
    private static volatile Map<Item, Integer> x;
    protected final IContainerProperties m;
    public final Object2IntOpenHashMap<MinecraftKey> y;
    private final CraftingManager.a<SingleRecipeInput, ? extends RecipeCooking> z;
    private int maxStack = 99;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();

    protected TileEntityFurnace(TileEntityTypes<?> tileentitytypes, BlockPosition blockposition, IBlockData iblockdata, Recipes<? extends RecipeCooking> recipes) {
        super(tileentitytypes, blockposition, iblockdata);
        this.l = NonNullList.a(3, net.minecraft.world.item.ItemStack.l);
        this.m = new IContainerProperties(){

            @Override
            public int a(int i2) {
                switch (i2) {
                    case 0: {
                        return TileEntityFurnace.this.t;
                    }
                    case 1: {
                        return TileEntityFurnace.this.u;
                    }
                    case 2: {
                        return TileEntityFurnace.this.v;
                    }
                    case 3: {
                        return TileEntityFurnace.this.w;
                    }
                }
                return 0;
            }

            @Override
            public void a(int i2, int j2) {
                switch (i2) {
                    case 0: {
                        TileEntityFurnace.this.t = j2;
                        break;
                    }
                    case 1: {
                        TileEntityFurnace.this.u = j2;
                        break;
                    }
                    case 2: {
                        TileEntityFurnace.this.v = j2;
                        break;
                    }
                    case 3: {
                        TileEntityFurnace.this.w = j2;
                    }
                }
            }

            @Override
            public int a() {
                return 4;
            }
        };
        this.y = new Object2IntOpenHashMap();
        this.z = CraftingManager.b(recipes);
    }

    public static void f() {
        x = null;
    }

    public static Map<Item, Integer> g() {
        Map<Item, Integer> map = x;
        if (map != null) {
            return map;
        }
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.qA, 20000);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.iB, 16000);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.sg, 2400);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ox, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oy, 1600);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.r, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.C, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.b, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.w, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.i, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.hU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.j, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.jC, 150);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.n, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.m, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.k, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.l, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.aY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cl, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cm, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.oa, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.dT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cv, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.gV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cA, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.gZ, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.E, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ov, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.qV, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.cO, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.aQ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.bd, 800);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oN, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oM, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oQ, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oP, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.oO, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.h, 200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.aN, 1200);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.a, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.d, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.pq, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.p, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.ot, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, TagsItem.g, 67);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.me, 4001);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Items.vW, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.mZ, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.bv, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nS, 50);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nT, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nU, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nX, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.nY, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.ob, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.pc, 300);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.sy, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.sz, 100);
        TileEntityFurnace.a((Map<Item, Integer>)map1, Blocks.ac, 300);
        x = map1;
        return map1;
    }

    @Override
    public List<net.minecraft.world.item.ItemStack> getContents() {
        return this.l;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add(who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public int al_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public Object2IntOpenHashMap<MinecraftKey> getRecipesUsed() {
        return this.y;
    }

    private static boolean b(Item item) {
        return item.o().a(TagsItem.aH);
    }

    private static void a(Map<Item, Integer> map, TagKey<Item> tagkey, int i2) {
        for (Holder<Item> holder : BuiltInRegistries.g.c(tagkey)) {
            if (TileEntityFurnace.b(holder.a())) continue;
            map.put(holder.a(), i2);
        }
    }

    private static void a(Map<Item, Integer> map, IMaterial imaterial, int i2) {
        Item item = imaterial.r();
        if (TileEntityFurnace.b(item)) {
            if (SharedConstants.aV) {
                throw SystemUtils.b(new IllegalStateException("A developer tried to explicitly make fire resistant item " + item.n(null).getString() + " a furnace fuel. That will not work!"));
            }
        } else {
            map.put(item, i2);
        }
    }

    private boolean l() {
        return this.t > 0;
    }

    @Override
    protected void a(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.a(nbttagcompound, holderlookup_a);
        this.l = NonNullList.a(this.b(), net.minecraft.world.item.ItemStack.l);
        ContainerUtil.b(nbttagcompound, this.l, holderlookup_a);
        this.t = nbttagcompound.g("BurnTime");
        this.v = nbttagcompound.g("CookTime");
        this.w = nbttagcompound.g("CookTimeTotal");
        this.u = this.b(this.l.get(1));
        NBTTagCompound nbttagcompound1 = nbttagcompound.p("RecipesUsed");
        for (String s2 : nbttagcompound1.e()) {
            this.y.put((Object)MinecraftKey.a(s2), nbttagcompound1.h(s2));
        }
    }

    @Override
    protected void b(NBTTagCompound nbttagcompound, HolderLookup.a holderlookup_a) {
        super.b(nbttagcompound, holderlookup_a);
        nbttagcompound.a("BurnTime", (short)this.t);
        nbttagcompound.a("CookTime", (short)this.v);
        nbttagcompound.a("CookTimeTotal", (short)this.w);
        ContainerUtil.a(nbttagcompound, this.l, holderlookup_a);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.y.forEach((minecraftkey, integer) -> nbttagcompound1.a(minecraftkey.toString(), (int)integer));
        nbttagcompound.a("RecipesUsed", nbttagcompound1);
    }

    public static void a(World world, BlockPosition blockposition, IBlockData iblockdata, TileEntityFurnace tileentityfurnace) {
        boolean flag3;
        boolean flag = tileentityfurnace.l();
        boolean flag1 = false;
        if (tileentityfurnace.l()) {
            --tileentityfurnace.t;
        }
        net.minecraft.world.item.ItemStack itemstack = tileentityfurnace.l.get(1);
        net.minecraft.world.item.ItemStack itemstack1 = tileentityfurnace.l.get(0);
        boolean flag2 = !itemstack1.e();
        boolean bl = flag3 = !itemstack.e();
        if (!(tileentityfurnace.l() || flag3 && flag2)) {
            if (!tileentityfurnace.l() && tileentityfurnace.v > 0) {
                tileentityfurnace.v = MathHelper.a(tileentityfurnace.v - 2, 0, tileentityfurnace.w);
            }
        } else {
            RecipeHolder recipeholder = flag2 ? (RecipeHolder)tileentityfurnace.z.a(new SingleRecipeInput(itemstack1), world).orElse(null) : null;
            int i2 = tileentityfurnace.al_();
            if (!tileentityfurnace.l() && TileEntityFurnace.a(world.H_(), recipeholder, tileentityfurnace.l, i2)) {
                CraftItemStack fuel = CraftItemStack.asCraftMirror(itemstack);
                FurnaceBurnEvent furnaceBurnEvent = new FurnaceBurnEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)fuel, tileentityfurnace.b(itemstack));
                world.getCraftServer().getPluginManager().callEvent((Event)furnaceBurnEvent);
                if (furnaceBurnEvent.isCancelled()) {
                    return;
                }
                tileentityfurnace.u = tileentityfurnace.t = furnaceBurnEvent.getBurnTime();
                if (tileentityfurnace.l() && furnaceBurnEvent.isBurning()) {
                    flag1 = true;
                    if (flag3) {
                        Item item = itemstack.g();
                        itemstack.h(1);
                        if (itemstack.e()) {
                            Item item1 = item.u();
                            tileentityfurnace.l.set(1, item1 == null ? net.minecraft.world.item.ItemStack.l : new net.minecraft.world.item.ItemStack(item1));
                        }
                    }
                }
            }
            if (tileentityfurnace.l() && TileEntityFurnace.a(world.H_(), recipeholder, tileentityfurnace.l, i2)) {
                if (recipeholder != null && tileentityfurnace.v == 0) {
                    CraftItemStack source = CraftItemStack.asCraftMirror(tileentityfurnace.l.get(0));
                    CookingRecipe recipe = (CookingRecipe)recipeholder.toBukkitRecipe();
                    FurnaceStartSmeltEvent event = new FurnaceStartSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, recipe);
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                    tileentityfurnace.w = event.getTotalCookTime();
                }
                ++tileentityfurnace.v;
                if (tileentityfurnace.v == tileentityfurnace.w) {
                    tileentityfurnace.v = 0;
                    tileentityfurnace.w = TileEntityFurnace.a(world, tileentityfurnace);
                    if (TileEntityFurnace.burn(tileentityfurnace.n, tileentityfurnace.o, world.H_(), recipeholder, tileentityfurnace.l, i2)) {
                        tileentityfurnace.a(recipeholder);
                    }
                    flag1 = true;
                }
            } else {
                tileentityfurnace.v = 0;
            }
        }
        if (flag != tileentityfurnace.l()) {
            flag1 = true;
            iblockdata = (IBlockData)iblockdata.a(BlockFurnace.b, tileentityfurnace.l());
            world.a(blockposition, iblockdata, 3);
        }
        if (flag1) {
            TileEntityFurnace.a(world, blockposition, iblockdata);
        }
    }

    private static boolean a(IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (!nonnulllist.get(0).e() && recipeholder != null) {
            net.minecraft.world.item.ItemStack itemstack = recipeholder.b().a(iregistrycustom);
            if (itemstack.e()) {
                return false;
            }
            net.minecraft.world.item.ItemStack itemstack1 = nonnulllist.get(2);
            return itemstack1.e() ? true : (!net.minecraft.world.item.ItemStack.c(itemstack1, itemstack) ? false : (itemstack1.H() < i2 && itemstack1.H() < itemstack1.j() ? true : itemstack1.H() < itemstack.j()));
        }
        return false;
    }

    private static boolean burn(World world, BlockPosition blockposition, IRegistryCustom iregistrycustom, @Nullable RecipeHolder<?> recipeholder, NonNullList<net.minecraft.world.item.ItemStack> nonnulllist, int i2) {
        if (recipeholder != null && TileEntityFurnace.a(iregistrycustom, recipeholder, nonnulllist, i2)) {
            net.minecraft.world.item.ItemStack itemstack = nonnulllist.get(0);
            net.minecraft.world.item.ItemStack itemstack1 = recipeholder.b().a(iregistrycustom);
            net.minecraft.world.item.ItemStack itemstack2 = nonnulllist.get(2);
            CraftItemStack source = CraftItemStack.asCraftMirror(itemstack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemstack1);
            FurnaceSmeltEvent furnaceSmeltEvent = new FurnaceSmeltEvent((Block)CraftBlock.at(world, blockposition), (ItemStack)source, result);
            world.getCraftServer().getPluginManager().callEvent((Event)furnaceSmeltEvent);
            if (furnaceSmeltEvent.isCancelled()) {
                return false;
            }
            result = furnaceSmeltEvent.getResult();
            itemstack1 = CraftItemStack.asNMSCopy(result);
            if (!itemstack1.e()) {
                if (itemstack2.e()) {
                    nonnulllist.set(2, itemstack1.s());
                } else if (CraftItemStack.asCraftMirror(itemstack2).isSimilar(result)) {
                    itemstack2.g(itemstack1.H());
                } else {
                    return false;
                }
            }
            if (itemstack.a(Blocks.aP.r()) && !nonnulllist.get(1).e() && nonnulllist.get(1).a(Items.qy)) {
                nonnulllist.set(1, new net.minecraft.world.item.ItemStack(Items.qz));
            }
            itemstack.h(1);
            return true;
        }
        return false;
    }

    protected int b(net.minecraft.world.item.ItemStack itemstack) {
        if (itemstack.e()) {
            return 0;
        }
        Item item = itemstack.g();
        return TileEntityFurnace.g().getOrDefault(item, 0);
    }

    private static int a(World world, TileEntityFurnace tileentityfurnace) {
        if (world == null) {
            return 200;
        }
        SingleRecipeInput singlerecipeinput = new SingleRecipeInput(tileentityfurnace.a(0));
        return tileentityfurnace.z.a(singlerecipeinput, world).map(recipeholder -> ((RecipeCooking)recipeholder.b()).d()).orElse(200);
    }

    public static boolean c(net.minecraft.world.item.ItemStack itemstack) {
        return TileEntityFurnace.g().containsKey(itemstack.g());
    }

    @Override
    public int[] a(EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a ? r : (enumdirection == EnumDirection.b ? q : s);
    }

    @Override
    public boolean a(int i2, net.minecraft.world.item.ItemStack itemstack, @Nullable EnumDirection enumdirection) {
        return this.b(i2, itemstack);
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack, EnumDirection enumdirection) {
        return enumdirection == EnumDirection.a && i2 == 1 ? itemstack.a(Items.qz) || itemstack.a(Items.qy) : true;
    }

    @Override
    public int b() {
        return this.l.size();
    }

    @Override
    protected NonNullList<net.minecraft.world.item.ItemStack> j() {
        return this.l;
    }

    @Override
    protected void a(NonNullList<net.minecraft.world.item.ItemStack> nonnulllist) {
        this.l = nonnulllist;
    }

    @Override
    public void a(int i2, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(i2);
        boolean flag = !itemstack.e() && net.minecraft.world.item.ItemStack.c(itemstack1, itemstack);
        this.l.set(i2, itemstack);
        itemstack.f(this.e_(itemstack));
        if (i2 == 0 && !flag) {
            this.w = TileEntityFurnace.a(this.n, this);
            this.v = 0;
            this.e();
        }
    }

    @Override
    public boolean b(int i2, net.minecraft.world.item.ItemStack itemstack) {
        if (i2 == 2) {
            return false;
        }
        if (i2 != 1) {
            return true;
        }
        net.minecraft.world.item.ItemStack itemstack1 = this.l.get(1);
        return TileEntityFurnace.c(itemstack) || itemstack.a(Items.qy) && !itemstack1.a(Items.qy);
    }

    @Override
    public void a(@Nullable RecipeHolder<?> recipeholder) {
        if (recipeholder != null) {
            MinecraftKey minecraftkey = recipeholder.a();
            this.y.addTo((Object)minecraftkey, 1);
        }
    }

    @Override
    @Nullable
    public RecipeHolder<?> d() {
        return null;
    }

    @Override
    public void a(EntityHuman entityhuman, List<net.minecraft.world.item.ItemStack> list) {
    }

    public void awardUsedRecipesAndPopExperience(EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience(entityplayer.A(), entityplayer.dm(), this.o, entityplayer, itemstack, amount);
        entityplayer.a((Collection<RecipeHolder<?>>)list);
        for (RecipeHolder<?> recipeholder : list) {
            if (recipeholder == null) continue;
            entityplayer.a(recipeholder, this.l);
        }
        this.y.clear();
    }

    public List<RecipeHolder<?>> a(WorldServer worldserver, Vec3D vec3d) {
        return this.getRecipesToAwardAndPopExperience(worldserver, vec3d, this.o, null, null, 0);
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(WorldServer worldserver, Vec3D vec3d, BlockPosition blockposition, EntityPlayer entityplayer, net.minecraft.world.item.ItemStack itemstack, int amount) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.y.object2IntEntrySet()) {
            worldserver.r().a((MinecraftKey)entry.getKey()).ifPresent(recipeholder -> {
                list.add(recipeholder);
                TileEntityFurnace.createExperience(worldserver, vec3d, entry.getIntValue(), ((RecipeCooking)recipeholder.b()).b(), blockposition, entityplayer, itemstack, amount);
            });
        }
        return list;
    }

    private static void createExperience(WorldServer worldserver, Vec3D vec3d, int i2, float f2, BlockPosition blockposition, EntityHuman entityhuman, net.minecraft.world.item.ItemStack itemstack, int amount) {
        int j2 = MathHelper.d((float)i2 * f2);
        float f1 = MathHelper.h((float)i2 * f2);
        if (f1 != 0.0f && Math.random() < (double)f1) {
            ++j2;
        }
        Object event = amount != 0 ? new FurnaceExtractEvent((Player)entityhuman.getBukkitEntity(), (Block)CraftBlock.at(worldserver, blockposition), CraftItemType.minecraftToBukkit(itemstack.g()), amount, j2) : new BlockExpEvent((Block)CraftBlock.at(worldserver, blockposition), j2);
        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        j2 = event.getExpToDrop();
        EntityExperienceOrb.a(worldserver, vec3d, j2);
    }

    @Override
    public void a(AutoRecipeStackManager autorecipestackmanager) {
        for (net.minecraft.world.item.ItemStack itemstack : this.l) {
            autorecipestackmanager.b(itemstack);
        }
    }
}

