/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.SoundEffectType;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.material.MaterialMapColor;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.spigotmc.AsyncCatcher;

public abstract class BlockBase
implements FeatureElement {
    protected static final EnumDirection[] aF = new EnumDirection[]{EnumDirection.e, EnumDirection.f, EnumDirection.c, EnumDirection.d, EnumDirection.a, EnumDirection.b};
    protected final boolean aG;
    protected final float aH;
    protected final boolean aI;
    protected final SoundEffectType aJ;
    protected final float aK;
    protected final float aL;
    protected final float aM;
    protected final boolean aN;
    protected final FeatureFlagSet aO;
    protected final Info aP;
    @Nullable
    protected ResourceKey<LootTable> aQ;

    public BlockBase(Info blockbase_info) {
        this.aG = blockbase_info.c;
        this.aQ = blockbase_info.m;
        this.aH = blockbase_info.f;
        this.aI = blockbase_info.i;
        this.aJ = blockbase_info.d;
        this.aK = blockbase_info.j;
        this.aL = blockbase_info.k;
        this.aM = blockbase_info.l;
        this.aN = blockbase_info.D;
        this.aO = blockbase_info.E;
        this.aP = blockbase_info;
    }

    public Info t() {
        return this.aP;
    }

    protected abstract MapCodec<? extends Block> a();

    protected static <B extends Block> RecordCodecBuilder<B, Info> u() {
        return Info.a.fieldOf("properties").forGetter(BlockBase::t);
    }

    public static <B extends Block> MapCodec<B> b(Function<Info, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(BlockBase.u()).apply((Applicative)instance, function));
    }

    protected void a(IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
    }

    protected boolean a(IBlockData iblockdata, PathMode pathmode) {
        switch (pathmode) {
            case a: {
                return !iblockdata.r(BlockAccessAir.a, BlockPosition.c);
            }
            case b: {
                return iblockdata.u().a(TagsFluid.a);
            }
            case c: {
                return !iblockdata.r(BlockAccessAir.a, BlockPosition.c);
            }
        }
        return false;
    }

    protected IBlockData a(IBlockData iblockdata, EnumDirection enumdirection, IBlockData iblockdata1, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
        return iblockdata;
    }

    protected boolean a(IBlockData iblockdata, IBlockData iblockdata1, EnumDirection enumdirection) {
        return false;
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
        PacketDebug.a(world, blockposition);
    }

    protected void b(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        AsyncCatcher.catchOp("block onPlace");
    }

    protected void onPlace(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag, @Nullable ItemActionContext context) {
        this.b(iblockdata, world, blockposition, iblockdata1, flag);
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, IBlockData iblockdata1, boolean flag) {
        AsyncCatcher.catchOp("block remove");
        if (iblockdata.t() && !iblockdata.a(iblockdata1.b())) {
            world.o(blockposition);
        }
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
        if (!iblockdata.i() && explosion.j() != Explosion.Effect.d) {
            Block block = iblockdata.b();
            boolean flag = explosion.f() instanceof EntityHuman;
            if (block.a(explosion) && world instanceof WorldServer) {
                WorldServer worldserver = (WorldServer)world;
                TileEntity tileentity = iblockdata.t() ? world.c_(blockposition) : null;
                LootParams.a lootparams_a = new LootParams.a(worldserver).a(LootContextParameters.f, Vec3D.b(blockposition)).a(LootContextParameters.i, ItemStack.l).b(LootContextParameters.h, tileentity).b(LootContextParameters.a, explosion.g());
                if (explosion.yield < 1.0f) {
                    lootparams_a.a(LootContextParameters.j, Float.valueOf(1.0f / explosion.yield));
                }
                iblockdata.a(worldserver, blockposition, ItemStack.l, flag);
                iblockdata.a(lootparams_a).forEach(itemstack -> biconsumer.accept((ItemStack)itemstack, blockposition));
            }
            world.a(blockposition, Blocks.a.o(), 3);
            block.a(world, blockposition, explosion);
        }
    }

    protected EnumInteractionResult a(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
        return EnumInteractionResult.e;
    }

    protected ItemInteractionResult a(ItemStack itemstack, IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
        return ItemInteractionResult.d;
    }

    protected boolean a(IBlockData iblockdata, World world, BlockPosition blockposition, int i2, int j2) {
        return false;
    }

    protected EnumRenderType a_(IBlockData iblockdata) {
        return EnumRenderType.c;
    }

    protected boolean f_(IBlockData iblockdata) {
        return false;
    }

    protected boolean e_(IBlockData iblockdata) {
        return false;
    }

    protected Fluid b_(IBlockData iblockdata) {
        return FluidTypes.a.g();
    }

    protected boolean c_(IBlockData iblockdata) {
        return false;
    }

    protected float av_() {
        return 0.25f;
    }

    protected float ax_() {
        return 0.2f;
    }

    @Override
    public FeatureFlagSet i() {
        return this.aO;
    }

    protected IBlockData a(IBlockData iblockdata, EnumBlockRotation enumblockrotation) {
        return iblockdata;
    }

    protected IBlockData a(IBlockData iblockdata, EnumBlockMirror enumblockmirror) {
        return iblockdata;
    }

    protected boolean a(IBlockData iblockdata, BlockActionContext blockactioncontext) {
        return iblockdata.r() && (blockactioncontext.n().e() || !blockactioncontext.n().a(this.r()));
    }

    protected boolean a(IBlockData iblockdata, FluidType fluidtype) {
        return iblockdata.r() || !iblockdata.e();
    }

    protected List<ItemStack> a(IBlockData iblockdata, LootParams.a lootparams_a) {
        ResourceKey<LootTable> resourcekey = this.v();
        if (resourcekey == LootTables.a) {
            return Collections.emptyList();
        }
        LootParams lootparams = lootparams_a.a(LootContextParameters.g, iblockdata).a(LootContextParameterSets.r);
        WorldServer worldserver = lootparams.a();
        LootTable loottable = worldserver.o().be().b(resourcekey);
        return loottable.a(lootparams);
    }

    protected long a(IBlockData iblockdata, BlockPosition blockposition) {
        return MathHelper.a(blockposition);
    }

    protected VoxelShape f(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.j(iblockaccess, blockposition);
    }

    protected VoxelShape b_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return this.b(iblockdata, iblockaccess, blockposition, VoxelShapeCollision.a());
    }

    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return VoxelShapes.a();
    }

    protected int g(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.i(iblockaccess, blockposition) ? iblockaccess.Q() : (iblockdata.a(iblockaccess, blockposition) ? 0 : 1);
    }

    @Nullable
    protected ITileInventory b(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return null;
    }

    protected boolean a(IBlockData iblockdata, IWorldReader iworldreader, BlockPosition blockposition) {
        return true;
    }

    protected float d(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return iblockdata.r(iblockaccess, blockposition) ? 0.2f : 1.0f;
    }

    protected int a(IBlockData iblockdata, World world, BlockPosition blockposition) {
        return 0;
    }

    protected VoxelShape a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return VoxelShapes.b();
    }

    protected VoxelShape b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.aG ? iblockdata.j(iblockaccess, blockposition) : VoxelShapes.a();
    }

    protected boolean c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return Block.a(iblockdata.k(iblockaccess, blockposition));
    }

    protected boolean h(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return Block.a(iblockdata.c(iblockaccess, blockposition));
    }

    protected VoxelShape c(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
        return this.b(iblockdata, iblockaccess, blockposition, voxelshapecollision);
    }

    protected void b(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
    }

    protected float a(IBlockData iblockdata, EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
        float f2 = iblockdata.h(iblockaccess, blockposition);
        if (f2 == -1.0f) {
            return 0.0f;
        }
        int i2 = entityhuman.d(iblockdata) ? 30 : 100;
        return entityhuman.c(iblockdata) / f2 / (float)i2;
    }

    protected void a(IBlockData iblockdata, WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
    }

    protected void a_(IBlockData iblockdata, World world, BlockPosition blockposition, EntityHuman entityhuman) {
    }

    protected int a(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    protected void a(IBlockData iblockdata, World world, BlockPosition blockposition, Entity entity) {
    }

    protected int b(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
        return 0;
    }

    public final ResourceKey<LootTable> v() {
        if (this.aQ == null) {
            MinecraftKey minecraftkey = BuiltInRegistries.e.b(this.q());
            this.aQ = ResourceKey.a(Registries.bc, minecraftkey.f("blocks/"));
        }
        return this.aQ;
    }

    protected void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
    }

    protected boolean a_(IBlockData iblockdata, IBlockAccess iblockaccess, BlockPosition blockposition) {
        return !Block.a(iblockdata.j(iblockaccess, blockposition)) && iblockdata.u().c();
    }

    protected boolean d_(IBlockData iblockdata) {
        return this.aI;
    }

    protected SoundEffectType g_(IBlockData iblockdata) {
        return this.aJ;
    }

    public abstract Item r();

    protected abstract Block q();

    public MaterialMapColor w() {
        return this.aP.b.apply(this.q().o());
    }

    public float x() {
        return this.aP.g;
    }

    public static class Info {
        public static final Codec<Info> a = Codec.unit(() -> Info.a());
        Function<IBlockData, MaterialMapColor> b = iblockdata -> MaterialMapColor.a;
        boolean c = true;
        SoundEffectType d = SoundEffectType.f;
        ToIntFunction<IBlockData> e = iblockdata -> 0;
        float f;
        float g;
        boolean h;
        boolean i;
        float j = 0.6f;
        float k = 1.0f;
        float l = 1.0f;
        ResourceKey<LootTable> m;
        boolean n = true;
        boolean o;
        boolean p;
        @Deprecated
        boolean q;
        @Deprecated
        boolean r;
        boolean s;
        EnumPistonReaction t = EnumPistonReaction.a;
        boolean u = true;
        BlockPropertyInstrument v = BlockPropertyInstrument.a;
        boolean w;
        e<EntityTypes<?>> x = (iblockdata, iblockaccess, blockposition, entitytypes) -> iblockdata.d(iblockaccess, blockposition, EnumDirection.b) && iblockdata.h() < 14;
        f y = (iblockdata, iblockaccess, blockposition) -> iblockdata.r(iblockaccess, blockposition);
        f z;
        f A = this.z = (iblockdata, iblockaccess, blockposition) -> iblockdata.d() && iblockdata.r(iblockaccess, blockposition);
        f B = (iblockdata, iblockaccess, blockposition) -> false;
        f C = (iblockdata, iblockaccess, blockposition) -> false;
        boolean D;
        FeatureFlagSet E = FeatureFlags.f;
        @Nullable
        b F;

        private Info() {
        }

        public static Info a() {
            return new Info();
        }

        public static Info a(BlockBase blockbase) {
            Info blockbase_info = Info.b(blockbase);
            Info blockbase_info1 = blockbase.aP;
            blockbase_info.l = blockbase_info1.l;
            blockbase_info.y = blockbase_info1.y;
            blockbase_info.x = blockbase_info1.x;
            blockbase_info.B = blockbase_info1.B;
            blockbase_info.z = blockbase_info1.z;
            blockbase_info.A = blockbase_info1.A;
            blockbase_info.m = blockbase_info1.m;
            return blockbase_info;
        }

        @Deprecated
        public static Info b(BlockBase blockbase) {
            Info blockbase_info = new Info();
            Info blockbase_info1 = blockbase.aP;
            blockbase_info.g = blockbase_info1.g;
            blockbase_info.f = blockbase_info1.f;
            blockbase_info.c = blockbase_info1.c;
            blockbase_info.i = blockbase_info1.i;
            blockbase_info.e = blockbase_info1.e;
            blockbase_info.b = blockbase_info1.b;
            blockbase_info.d = blockbase_info1.d;
            blockbase_info.j = blockbase_info1.j;
            blockbase_info.k = blockbase_info1.k;
            blockbase_info.D = blockbase_info1.D;
            blockbase_info.n = blockbase_info1.n;
            blockbase_info.o = blockbase_info1.o;
            blockbase_info.p = blockbase_info1.p;
            blockbase_info.q = blockbase_info1.q;
            blockbase_info.r = blockbase_info1.r;
            blockbase_info.s = blockbase_info1.s;
            blockbase_info.t = blockbase_info1.t;
            blockbase_info.h = blockbase_info1.h;
            blockbase_info.F = blockbase_info1.F;
            blockbase_info.u = blockbase_info1.u;
            blockbase_info.E = blockbase_info1.E;
            blockbase_info.C = blockbase_info1.C;
            blockbase_info.v = blockbase_info1.v;
            blockbase_info.w = blockbase_info1.w;
            return blockbase_info;
        }

        public Info a(EnumColor enumcolor) {
            this.b = iblockdata -> enumcolor.e();
            return this;
        }

        public Info a(MaterialMapColor materialmapcolor) {
            this.b = iblockdata -> materialmapcolor;
            return this;
        }

        public Info a(Function<IBlockData, MaterialMapColor> function) {
            this.b = function;
            return this;
        }

        public Info b() {
            this.c = false;
            this.n = false;
            return this;
        }

        public Info c() {
            this.n = false;
            return this;
        }

        public Info a(float f2) {
            this.j = f2;
            return this;
        }

        public Info b(float f2) {
            this.k = f2;
            return this;
        }

        public Info c(float f2) {
            this.l = f2;
            return this;
        }

        public Info a(SoundEffectType soundeffecttype) {
            this.d = soundeffecttype;
            return this;
        }

        public Info a(ToIntFunction<IBlockData> tointfunction) {
            this.e = tointfunction;
            return this;
        }

        public Info a(float f2, float f1) {
            return this.e(f2).f(f1);
        }

        public Info d() {
            return this.d(0.0f);
        }

        public Info d(float f2) {
            this.a(f2, f2);
            return this;
        }

        public Info e() {
            this.i = true;
            return this;
        }

        public Info f() {
            this.D = true;
            return this;
        }

        public Info g() {
            this.m = LootTables.a;
            return this;
        }

        public Info a(Block block) {
            this.m = block.v();
            return this;
        }

        public Info h() {
            this.p = true;
            return this;
        }

        public Info i() {
            this.q = true;
            return this;
        }

        public Info j() {
            this.s = true;
            return this;
        }

        @Deprecated
        public Info k() {
            this.r = true;
            return this;
        }

        public Info a(EnumPistonReaction enumpistonreaction) {
            this.t = enumpistonreaction;
            return this;
        }

        public Info l() {
            this.o = true;
            return this;
        }

        public Info a(e<EntityTypes<?>> blockbase_e) {
            this.x = blockbase_e;
            return this;
        }

        public Info a(f blockbase_f) {
            this.y = blockbase_f;
            return this;
        }

        public Info b(f blockbase_f) {
            this.z = blockbase_f;
            return this;
        }

        public Info c(f blockbase_f) {
            this.A = blockbase_f;
            return this;
        }

        public Info d(f blockbase_f) {
            this.B = blockbase_f;
            return this;
        }

        public Info e(f blockbase_f) {
            this.C = blockbase_f;
            return this;
        }

        public Info m() {
            this.h = true;
            return this;
        }

        public Info e(float f2) {
            this.g = f2;
            return this;
        }

        public Info f(float f2) {
            this.f = Math.max(0.0f, f2);
            return this;
        }

        public Info a(EnumRandomOffset blockbase_enumrandomoffset) {
            this.F = switch (blockbase_enumrandomoffset.ordinal()) {
                case 0 -> null;
                case 1 -> (iblockdata, iblockaccess, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    float f2 = block.av_();
                    double d0 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d1 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d0, 0.0, d1);
                };
                case 2 -> (iblockdata, iblockaccess, blockposition) -> {
                    Block block = iblockdata.b();
                    long i2 = MathHelper.b(blockposition.u(), 0, blockposition.w());
                    double d0 = ((double)((float)(i2 >> 4 & 0xFL) / 15.0f) - 1.0) * (double)block.ax_();
                    float f2 = block.av_();
                    double d1 = MathHelper.a(((double)((float)(i2 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    double d2 = MathHelper.a(((double)((float)(i2 >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5, (double)(-f2), (double)f2);
                    return new Vec3D(d1, d0, d2);
                };
                default -> throw new MatchException(null, null);
            };
            return this;
        }

        public Info n() {
            this.u = false;
            return this;
        }

        public Info a(FeatureFlag ... afeatureflag) {
            this.E = FeatureFlags.d.a(afeatureflag);
            return this;
        }

        public Info a(BlockPropertyInstrument blockpropertyinstrument) {
            this.v = blockpropertyinstrument;
            return this;
        }

        public Info o() {
            this.w = true;
            return this;
        }
    }

    public static enum EnumRandomOffset {
        a,
        b,
        c;

    }

    public static abstract class BlockData
    extends IBlockDataHolder<Block, IBlockData> {
        private final int b;
        private final boolean g;
        private final boolean h;
        private final boolean i;
        @Deprecated
        private final boolean j;
        @Deprecated
        private boolean k;
        private final EnumPistonReaction l;
        private final MaterialMapColor m;
        public final float n;
        private final boolean o;
        private final boolean p;
        private final f q;
        private final f r;
        private final f s;
        private final f t;
        private final f u;
        @Nullable
        private final b v;
        private final boolean w;
        private final BlockPropertyInstrument x;
        private final boolean y;
        @Nullable
        protected Cache a;
        private Fluid z = FluidTypes.a.g();
        private boolean A;

        protected BlockData(Block block, Reference2ObjectArrayMap<IBlockState<?>, Comparable<?>> reference2objectarraymap, MapCodec<IBlockData> mapcodec) {
            super(block, reference2objectarraymap, mapcodec);
            Info blockbase_info = block.aP;
            this.b = blockbase_info.e.applyAsInt(this.x());
            this.g = block.f_(this.x());
            this.h = blockbase_info.o;
            this.i = blockbase_info.p;
            this.j = blockbase_info.q;
            this.l = blockbase_info.t;
            this.m = blockbase_info.b.apply(this.x());
            this.n = blockbase_info.g;
            this.o = blockbase_info.h;
            this.p = blockbase_info.n;
            this.q = blockbase_info.y;
            this.r = blockbase_info.z;
            this.s = blockbase_info.A;
            this.t = blockbase_info.B;
            this.u = blockbase_info.C;
            this.v = blockbase_info.F;
            this.w = blockbase_info.u;
            this.x = blockbase_info.v;
            this.y = blockbase_info.w;
        }

        private boolean D() {
            if (((Block)this.e).aP.s) {
                return true;
            }
            if (((Block)this.e).aP.r) {
                return false;
            }
            if (this.a == null) {
                return false;
            }
            VoxelShape voxelshape = this.a.b;
            if (voxelshape.c()) {
                return false;
            }
            AxisAlignedBB axisalignedbb = voxelshape.a();
            return axisalignedbb.a() >= 0.7291666666666666 ? true : axisalignedbb.c() >= 1.0;
        }

        public void a() {
            this.z = ((Block)this.e).b_(this.x());
            this.A = ((Block)this.e).d_(this.x());
            if (!this.b().p()) {
                this.a = new Cache(this.x());
            }
            this.k = this.D();
        }

        public Block b() {
            return (Block)this.e;
        }

        public Holder<Block> c() {
            return ((Block)this.e).s();
        }

        @Deprecated
        public boolean d() {
            Block block = this.b();
            return block != Blocks.bs && block != Blocks.mY && this.e();
        }

        @Deprecated
        public boolean e() {
            return this.k;
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EntityTypes<?> entitytypes) {
            return this.b().aP.x.test(this.x(), iblockaccess, blockposition, entitytypes);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.g : this.b().a_(this.x(), iblockaccess, blockposition);
        }

        public int b(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.h : this.b().g(this.x(), iblockaccess, blockposition);
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.a != null && this.a.i != null ? this.a.i[enumdirection.ordinal()] : VoxelShapes.a(this.c(iblockaccess, blockposition), enumdirection);
        }

        public VoxelShape c(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().f(this.x(), iblockaccess, blockposition);
        }

        public boolean f() {
            return this.a == null || this.a.c;
        }

        public boolean g() {
            return this.g;
        }

        public int h() {
            return this.b;
        }

        public boolean i() {
            return this.h;
        }

        public boolean j() {
            return this.i;
        }

        @Deprecated
        public boolean k() {
            return this.j;
        }

        public MaterialMapColor d(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.m;
        }

        public IBlockData a(EnumBlockRotation enumblockrotation) {
            return this.b().a(this.x(), enumblockrotation);
        }

        public IBlockData a(EnumBlockMirror enumblockmirror) {
            return this.b().a(this.x(), enumblockmirror);
        }

        public EnumRenderType l() {
            return this.b().a_(this.x());
        }

        public boolean e(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.u.test(this.x(), iblockaccess, blockposition);
        }

        public float f(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().d(this.x(), iblockaccess, blockposition);
        }

        public boolean g(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.q.test(this.x(), iblockaccess, blockposition);
        }

        public boolean m() {
            return this.b().e_(this.x());
        }

        public int b(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().a(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public boolean n() {
            return this.b().c_(this.x());
        }

        public int a(World world, BlockPosition blockposition) {
            return this.b().a(this.x(), world, blockposition);
        }

        public float h(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.n;
        }

        public float a(EntityHuman entityhuman, IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.x(), entityhuman, iblockaccess, blockposition);
        }

        public int c(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.b().b(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public EnumPistonReaction o() {
            return this.l;
        }

        public boolean i(IBlockAccess iblockaccess, BlockPosition blockposition) {
            if (this.a != null) {
                return this.a.a;
            }
            IBlockData iblockdata = this.x();
            return iblockdata.p() ? Block.a(iblockdata.c(iblockaccess, blockposition)) : false;
        }

        public boolean p() {
            return this.p;
        }

        public boolean a(IBlockData iblockdata, EnumDirection enumdirection) {
            return this.b().a(this.x(), iblockdata, enumdirection);
        }

        public VoxelShape j(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape a(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().a(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape k(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.b : this.b(iblockaccess, blockposition, VoxelShapeCollision.a());
        }

        public VoxelShape b(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().b(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape l(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().b_(this.x(), iblockaccess, blockposition);
        }

        public VoxelShape c(IBlockAccess iblockaccess, BlockPosition blockposition, VoxelShapeCollision voxelshapecollision) {
            return this.b().c(this.x(), iblockaccess, blockposition, voxelshapecollision);
        }

        public VoxelShape m(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.b().a(this.x(), iblockaccess, blockposition);
        }

        public final boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity) {
            return this.a(iblockaccess, blockposition, entity, EnumDirection.b);
        }

        public final boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, Entity entity, EnumDirection enumdirection) {
            return Block.a(this.b(iblockaccess, blockposition, VoxelShapeCollision.a(entity)), enumdirection);
        }

        public Vec3D n(IBlockAccess iblockaccess, BlockPosition blockposition) {
            b blockbase_b = this.v;
            return blockbase_b != null ? blockbase_b.evaluate(this.x(), iblockaccess, blockposition) : Vec3D.b;
        }

        public boolean q() {
            return this.v != null;
        }

        public boolean a(World world, BlockPosition blockposition, int i2, int j2) {
            return this.b().a(this.x(), world, blockposition, i2, j2);
        }

        public void a(World world, BlockPosition blockposition, Block block, BlockPosition blockposition1, boolean flag) {
            this.b().a(this.x(), world, blockposition, block, blockposition1, flag);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.a(generatoraccess, blockposition, i2, 512);
        }

        public final void a(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
            for (EnumDirection enumdirection : aF) {
                blockposition_mutableblockposition.a((BaseBlockPosition)blockposition, enumdirection);
                generatoraccess.a(enumdirection.g(), this.x(), blockposition_mutableblockposition, blockposition, i2, j2);
            }
        }

        public final void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2) {
            this.b(generatoraccess, blockposition, i2, 512);
        }

        public void b(GeneratorAccess generatoraccess, BlockPosition blockposition, int i2, int j2) {
            this.b().a(this.x(), generatoraccess, blockposition, i2, j2);
        }

        public void a(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
            this.onPlace(world, blockposition, iblockdata, flag, null);
        }

        public void onPlace(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag, @Nullable ItemActionContext context) {
            this.b().onPlace(this.x(), world, blockposition, iblockdata, flag, context);
        }

        public void b(World world, BlockPosition blockposition, IBlockData iblockdata, boolean flag) {
            this.b().a(this.x(), world, blockposition, iblockdata, flag);
        }

        public void a(World world, BlockPosition blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPosition> biconsumer) {
            this.b().a(this.x(), world, blockposition, explosion, biconsumer);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().a(this.x(), worldserver, blockposition, randomsource);
        }

        public void b(WorldServer worldserver, BlockPosition blockposition, RandomSource randomsource) {
            this.b().b(this.x(), worldserver, blockposition, randomsource);
        }

        public void a(World world, BlockPosition blockposition, Entity entity) {
            this.b().a(this.x(), world, blockposition, entity);
        }

        public void a(WorldServer worldserver, BlockPosition blockposition, ItemStack itemstack, boolean flag) {
            this.b().a(this.x(), worldserver, blockposition, itemstack, flag);
        }

        public List<ItemStack> a(LootParams.a lootparams_a) {
            return this.b().a(this.x(), lootparams_a);
        }

        public ItemInteractionResult a(ItemStack itemstack, World world, EntityHuman entityhuman, EnumHand enumhand, MovingObjectPositionBlock movingobjectpositionblock) {
            return this.b().a(itemstack, this.x(), world, movingobjectpositionblock.a(), entityhuman, enumhand, movingobjectpositionblock);
        }

        public EnumInteractionResult a(World world, EntityHuman entityhuman, MovingObjectPositionBlock movingobjectpositionblock) {
            return this.b().a(this.x(), world, movingobjectpositionblock.a(), entityhuman, movingobjectpositionblock);
        }

        public void a(World world, BlockPosition blockposition, EntityHuman entityhuman) {
            this.b().a_(this.x(), world, blockposition, entityhuman);
        }

        public boolean o(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.r.test(this.x(), iblockaccess, blockposition);
        }

        public boolean p(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.s.test(this.x(), iblockaccess, blockposition);
        }

        public IBlockData a(EnumDirection enumdirection, IBlockData iblockdata, GeneratorAccess generatoraccess, BlockPosition blockposition, BlockPosition blockposition1) {
            return this.b().a(this.x(), enumdirection, iblockdata, generatoraccess, blockposition, blockposition1);
        }

        public boolean a(PathMode pathmode) {
            return this.b().a(this.x(), pathmode);
        }

        public boolean a(BlockActionContext blockactioncontext) {
            return this.b().a(this.x(), blockactioncontext);
        }

        public boolean a(FluidType fluidtype) {
            return this.b().a(this.x(), fluidtype);
        }

        public boolean r() {
            return this.y;
        }

        public boolean a(IWorldReader iworldreader, BlockPosition blockposition) {
            return this.b().a(this.x(), iworldreader, blockposition);
        }

        public boolean q(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.t.test(this.x(), iblockaccess, blockposition);
        }

        @Nullable
        public ITileInventory b(World world, BlockPosition blockposition) {
            return this.b().b(this.x(), world, blockposition);
        }

        @Override
        public boolean a(TagKey<Block> tagkey) {
            return this.b().s().a(tagkey);
        }

        @Override
        public boolean a(TagKey<Block> tagkey, Predicate<BlockData> predicate) {
            return this.a(tagkey) && predicate.test(this);
        }

        @Override
        public boolean a(HolderSet<Block> holderset) {
            return holderset.a(this.b().s());
        }

        @Override
        public boolean a(Holder<Block> holder) {
            return this.a(holder.a());
        }

        public Stream<TagKey<Block>> s() {
            return this.b().s().c();
        }

        public boolean t() {
            return this.b() instanceof ITileEntity;
        }

        @Nullable
        public <T extends TileEntity> BlockEntityTicker<T> a(World world, TileEntityTypes<T> tileentitytypes) {
            return this.b() instanceof ITileEntity ? ((ITileEntity)((Object)this.b())).a(world, this.x(), tileentitytypes) : null;
        }

        public boolean a(Block block) {
            return this.b() == block;
        }

        @Override
        public boolean a(ResourceKey<Block> resourcekey) {
            return this.b().s().a(resourcekey);
        }

        public Fluid u() {
            return this.z;
        }

        public boolean v() {
            return this.A;
        }

        public long a(BlockPosition blockposition) {
            return this.b().a(this.x(), blockposition);
        }

        public SoundEffectType w() {
            return this.b().g_(this.x());
        }

        public void a(World world, IBlockData iblockdata, MovingObjectPositionBlock movingobjectpositionblock, IProjectile iprojectile) {
            this.b().a(world, iblockdata, movingobjectpositionblock, iprojectile);
        }

        public boolean d(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection) {
            return this.a(iblockaccess, blockposition, enumdirection, EnumBlockSupport.a);
        }

        public boolean a(IBlockAccess iblockaccess, BlockPosition blockposition, EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
            return this.a != null ? this.a.a(enumdirection, enumblocksupport) : enumblocksupport.a(this.x(), iblockaccess, blockposition, enumdirection);
        }

        public boolean r(IBlockAccess iblockaccess, BlockPosition blockposition) {
            return this.a != null ? this.a.d : this.b().c(this.x(), iblockaccess, blockposition);
        }

        protected abstract IBlockData x();

        public boolean y() {
            return this.o;
        }

        public boolean z() {
            return this.w;
        }

        public BlockPropertyInstrument A() {
            return this.x;
        }

        private static final class Cache {
            private static final EnumDirection[] e = EnumDirection.values();
            private static final int f = EnumBlockSupport.values().length;
            protected final boolean a;
            final boolean g;
            final int h;
            @Nullable
            final VoxelShape[] i;
            protected final VoxelShape b;
            protected final boolean c;
            private final boolean[] j;
            protected final boolean d;

            Cache(IBlockData iblockdata) {
                Block block = iblockdata.b();
                this.a = iblockdata.i(BlockAccessAir.a, BlockPosition.c);
                this.g = block.a_(iblockdata, BlockAccessAir.a, BlockPosition.c);
                this.h = block.g(iblockdata, BlockAccessAir.a, BlockPosition.c);
                if (!iblockdata.p()) {
                    this.i = null;
                } else {
                    this.i = new VoxelShape[e.length];
                    VoxelShape voxelshape = block.f(iblockdata, BlockAccessAir.a, BlockPosition.c);
                    EnumDirection[] aenumdirection = e;
                    int i2 = aenumdirection.length;
                    for (int j2 = 0; j2 < i2; ++j2) {
                        EnumDirection enumdirection = aenumdirection[j2];
                        this.i[enumdirection.ordinal()] = VoxelShapes.a(voxelshape, enumdirection);
                    }
                }
                this.b = block.b(iblockdata, (IBlockAccess)BlockAccessAir.a, BlockPosition.c, VoxelShapeCollision.a());
                if (!this.b.c() && iblockdata.q()) {
                    throw new IllegalStateException(String.format(Locale.ROOT, "%s has a collision shape and an offset type, but is not marked as dynamicShape in its properties.", BuiltInRegistries.e.b(block)));
                }
                this.c = Arrays.stream(EnumDirection.EnumAxis.values()).anyMatch(enumdirection_enumaxis -> this.b.b((EnumDirection.EnumAxis)enumdirection_enumaxis) < 0.0 || this.b.c((EnumDirection.EnumAxis)enumdirection_enumaxis) > 1.0);
                this.j = new boolean[e.length * f];
                for (EnumDirection enumdirection1 : e) {
                    for (EnumBlockSupport enumblocksupport : EnumBlockSupport.values()) {
                        this.j[Cache.b((EnumDirection)enumdirection1, (EnumBlockSupport)enumblocksupport)] = enumblocksupport.a(iblockdata, BlockAccessAir.a, BlockPosition.c, enumdirection1);
                    }
                }
                this.d = Block.a(iblockdata.k(BlockAccessAir.a, BlockPosition.c));
            }

            public boolean a(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return this.j[Cache.b(enumdirection, enumblocksupport)];
            }

            private static int b(EnumDirection enumdirection, EnumBlockSupport enumblocksupport) {
                return enumdirection.ordinal() * f + enumblocksupport.ordinal();
            }
        }
    }

    public static interface f {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface b {
        public Vec3D evaluate(IBlockData var1, IBlockAccess var2, BlockPosition var3);
    }

    public static interface e<A> {
        public boolean test(IBlockData var1, IBlockAccess var2, BlockPosition var3, A var4);
    }
}

