/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftLimitedRegion;
import org.bukkit.craftbukkit.v1_21_R1.generator.structure.CraftStructure;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.event.Event;
import org.bukkit.event.world.AsyncStructureSpawnEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BoundingBox;
import org.spigotmc.SpigotWorldConfig;

public abstract class ChunkGenerator {
    public static final Codec<ChunkGenerator> a = BuiltInRegistries.aa.r().dispatchStable(ChunkGenerator::b, Function.identity());
    protected final WorldChunkManager b;
    private final Supplier<List<FeatureSorter.b>> c;
    public final Function<Holder<BiomeBase>, BiomeSettingsGeneration> d;

    public ChunkGenerator(WorldChunkManager worldchunkmanager) {
        this(worldchunkmanager, holder -> ((BiomeBase)holder.a()).d());
    }

    public ChunkGenerator(WorldChunkManager worldchunkmanager, Function<Holder<BiomeBase>, BiomeSettingsGeneration> function) {
        this.b = worldchunkmanager;
        this.d = function;
        this.c = Suppliers.memoize(() -> FeatureSorter.a(List.copyOf(worldchunkmanager.c()), holder -> ((BiomeSettingsGeneration)function.apply((Holder<BiomeBase>)holder)).b(), true));
    }

    public void a() {
        this.c.get();
    }

    protected abstract MapCodec<? extends ChunkGenerator> b();

    public ChunkGeneratorStructureState createState(HolderLookup<StructureSet> holderlookup, RandomState randomstate, long i2, SpigotWorldConfig conf) {
        return ChunkGeneratorStructureState.createForNormal(randomstate, i2, this.b, holderlookup, conf);
    }

    public Optional<ResourceKey<MapCodec<? extends ChunkGenerator>>> c() {
        return BuiltInRegistries.aa.d(this.b());
    }

    public CompletableFuture<IChunkAccess> a(RandomState randomstate, Blender blender, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        return CompletableFuture.supplyAsync(SystemUtils.a("init_biomes", () -> {
            ichunkaccess.a(this.b, randomstate.b());
            return ichunkaccess;
        }), SystemUtils.g());
    }

    public abstract void a(RegionLimitedWorldAccess var1, long var2, RandomState var4, BiomeManager var5, StructureManager var6, IChunkAccess var7, WorldGenStage.Features var8);

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Pair<BlockPosition, Holder<Structure>> a(WorldServer worldserver, HolderSet<Structure> holderset, BlockPosition blockposition, int i2, boolean flag) {
        void var9_13;
        ChunkGeneratorStructureState chunkgeneratorstructurestate = worldserver.l().h();
        Object2ObjectArrayMap map = new Object2ObjectArrayMap();
        for (Holder holder : holderset) {
            for (StructurePlacement structureplacement : chunkgeneratorstructurestate.a(holder)) {
                map.computeIfAbsent(structureplacement, structureplacement1 -> new ObjectArraySet()).add(holder);
            }
        }
        if (map.isEmpty()) {
            return null;
        }
        Object var9_10 = null;
        double d0 = Double.MAX_VALUE;
        StructureManager structuremanager = worldserver.a();
        ArrayList list = new ArrayList(map.size());
        for (Map.Entry entry : map.entrySet()) {
            StructurePlacement structureplacement12 = (StructurePlacement)entry.getKey();
            if (structureplacement12 instanceof ConcentricRingsStructurePlacement) {
                BlockPosition blockposition1;
                double d2;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)structureplacement12;
                Pair<BlockPosition, Holder<Structure>> pair1 = this.a((Set)entry.getValue(), worldserver, structuremanager, blockposition, flag, concentricringsstructureplacement);
                if (pair1 == null || !((d2 = blockposition.j(blockposition1 = (BlockPosition)pair1.getFirst())) < d0)) continue;
                d0 = d2;
                Pair<BlockPosition, Holder<Structure>> pair = pair1;
                continue;
            }
            if (!(structureplacement12 instanceof RandomSpreadStructurePlacement)) continue;
            list.add(entry);
        }
        if (!list.isEmpty()) {
            int j2 = SectionPosition.a(blockposition.u());
            int k2 = SectionPosition.a(blockposition.w());
            for (int l2 = 0; l2 <= i2; ++l2) {
                boolean flag1 = false;
                for (Map.Entry entry : list) {
                    RandomSpreadStructurePlacement randomspreadstructureplacement = (RandomSpreadStructurePlacement)entry.getKey();
                    Pair<BlockPosition, Holder<Structure>> pair2 = ChunkGenerator.a((Set)entry.getValue(), worldserver, structuremanager, j2, k2, l2, flag, chunkgeneratorstructurestate.d(), randomspreadstructureplacement);
                    if (pair2 == null) continue;
                    flag1 = true;
                    double d2 = blockposition.j((BaseBlockPosition)pair2.getFirst());
                    if (!(d2 < d0)) continue;
                    d0 = d2;
                    Pair<BlockPosition, Holder<Structure>> pair = pair2;
                }
                if (!flag1) continue;
                return var9_13;
            }
        }
        return var9_13;
    }

    @Nullable
    private Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, WorldServer worldserver, StructureManager structuremanager, BlockPosition blockposition, boolean flag, ConcentricRingsStructurePlacement concentricringsstructureplacement) {
        List<ChunkCoordIntPair> list = worldserver.l().h().a(concentricringsstructureplacement);
        if (list == null) {
            throw new IllegalStateException("Somehow tried to find structures for a placement that doesn't exist");
        }
        Pair<BlockPosition, Holder<Structure>> pair = null;
        double d0 = Double.MAX_VALUE;
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (ChunkCoordIntPair chunkcoordintpair : list) {
            Pair<BlockPosition, Holder<Structure>> pair1;
            blockposition_mutableblockposition.d(SectionPosition.a(chunkcoordintpair.e, 8), 32, SectionPosition.a(chunkcoordintpair.f, 8));
            double d1 = blockposition_mutableblockposition.j(blockposition);
            boolean flag1 = pair == null || d1 < d0;
            if (!flag1 || (pair1 = ChunkGenerator.a(set, worldserver, structuremanager, flag, concentricringsstructureplacement, chunkcoordintpair)) == null) continue;
            pair = pair1;
            d0 = d1;
        }
        return pair;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, int i2, int j2, int k2, boolean flag, long l2, RandomSpreadStructurePlacement randomspreadstructureplacement) {
        int i1 = randomspreadstructureplacement.a();
        for (int j1 = -k2; j1 <= k2; ++j1) {
            boolean flag1 = j1 == -k2 || j1 == k2;
            for (int k1 = -k2; k1 <= k2; ++k1) {
                int i22;
                int l1;
                ChunkCoordIntPair chunkcoordintpair;
                Pair<BlockPosition, Holder<Structure>> pair;
                boolean flag2;
                boolean bl = flag2 = k1 == -k2 || k1 == k2;
                if (!flag1 && !flag2 || (pair = ChunkGenerator.a(set, iworldreader, structuremanager, flag, randomspreadstructureplacement, chunkcoordintpair = randomspreadstructureplacement.a(l2, l1 = i2 + i1 * j1, i22 = j2 + i1 * k1))) == null) continue;
                return pair;
            }
        }
        return null;
    }

    @Nullable
    private static Pair<BlockPosition, Holder<Structure>> a(Set<Holder<Structure>> set, IWorldReader iworldreader, StructureManager structuremanager, boolean flag, StructurePlacement structureplacement, ChunkCoordIntPair chunkcoordintpair) {
        StructureStart structurestart;
        Holder<Structure> holder;
        Iterator<Holder<Structure>> iterator = set.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                return null;
            }
            holder = iterator.next();
            StructureCheckResult structurecheckresult = structuremanager.a(chunkcoordintpair, holder.a(), structureplacement, flag);
            if (structurecheckresult == StructureCheckResult.b) continue;
            if (!flag && structurecheckresult == StructureCheckResult.a) {
                return Pair.of((Object)structureplacement.a(chunkcoordintpair), holder);
            }
            IChunkAccess ichunkaccess = iworldreader.a(chunkcoordintpair.e, chunkcoordintpair.f, ChunkStatus.d);
            structurestart = structuremanager.a(SectionPosition.a(ichunkaccess), holder.a(), ichunkaccess);
            if (structurestart != null && structurestart.b() && (!flag || ChunkGenerator.a(structuremanager, structurestart))) break;
        }
        return Pair.of((Object)structureplacement.a(structurestart.c()), holder);
    }

    private static boolean a(StructureManager structuremanager, StructureStart structurestart) {
        if (structurestart.d()) {
            structuremanager.a(structurestart);
            return true;
        }
        return false;
    }

    public void addVanillaDecorations(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        if (!SharedConstants.a(chunkcoordintpair)) {
            SectionPosition sectionposition = SectionPosition.a(chunkcoordintpair, generatoraccessseed.ao());
            BlockPosition blockposition = sectionposition.j();
            IRegistry<Structure> iregistry = generatoraccessseed.H_().d(Registries.aR);
            Map<Integer, List<Structure>> map = iregistry.t().collect(Collectors.groupingBy(structure -> structure.c().ordinal()));
            List<FeatureSorter.b> list = this.c.get();
            SeededRandom seededrandom = new SeededRandom(new XoroshiroRandomSource(RandomSupport.a()));
            long i2 = seededrandom.a(generatoraccessseed.C(), blockposition.u(), blockposition.w());
            ObjectArraySet set = new ObjectArraySet();
            ChunkCoordIntPair.a(sectionposition.r(), 1).forEach(arg_0 -> ChunkGenerator.lambda$addVanillaDecorations$6(generatoraccessseed, (Set)set, arg_0));
            set.retainAll(this.b.c());
            int j2 = list.size();
            try {
                IRegistry<PlacedFeature> iregistry1 = generatoraccessseed.H_().d(Registries.aQ);
                int k2 = Math.max(WorldGenStage.Decoration.values().length, j2);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = 0;
                    if (structuremanager.a()) {
                        List list1 = map.getOrDefault(l2, Collections.emptyList());
                        for (Structure structure2 : list1) {
                            seededrandom.b(i2, i1, l2);
                            Supplier<String> supplier = () -> {
                                Optional<String> optional = iregistry.d(structure2).map(Object::toString);
                                Objects.requireNonNull(structure2);
                                return (String)optional.orElseGet(structure2::toString);
                            };
                            try {
                                generatoraccessseed.a(supplier);
                                structuremanager.a(sectionposition, structure2).forEach(structurestart -> structurestart.a(generatoraccessseed, structuremanager, this, seededrandom, ChunkGenerator.a(ichunkaccess), chunkcoordintpair));
                            }
                            catch (Exception exception) {
                                CrashReport crashreport = CrashReport.a(exception, "Feature placement");
                                CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Feature");
                                Objects.requireNonNull(supplier);
                                crashreportsystemdetails.a("Description", supplier::get);
                                throw new ReportedException(crashreport);
                            }
                            ++i1;
                        }
                    }
                    if (l2 >= j2) continue;
                    IntArraySet intarrayset = new IntArraySet();
                    for (Holder holder : set) {
                        List<HolderSet<PlacedFeature>> list2 = this.d.apply(holder).b();
                        if (l2 >= list2.size()) continue;
                        HolderSet<PlacedFeature> holderset = list2.get(l2);
                        FeatureSorter.b featuresorter_b = list.get(l2);
                        holderset.a().map(Holder::a).forEach(placedfeature -> intarrayset.add(featuresorter_b.b().applyAsInt((PlacedFeature)placedfeature)));
                    }
                    int j1 = intarrayset.size();
                    int[] aint = intarrayset.toIntArray();
                    Arrays.sort(aint);
                    FeatureSorter.b featuresorter_b1 = list.get(l2);
                    for (int k1 = 0; k1 < j1; ++k1) {
                        int l1 = aint[k1];
                        PlacedFeature placedfeature2 = featuresorter_b1.a().get(l1);
                        Supplier<String> supplier1 = () -> {
                            Optional<String> optional = iregistry1.d(placedfeature2).map(Object::toString);
                            Objects.requireNonNull(placedfeature2);
                            return (String)optional.orElseGet(placedfeature2::toString);
                        };
                        seededrandom.b(i2, l1, l2);
                        try {
                            generatoraccessseed.a(supplier1);
                            placedfeature2.b(generatoraccessseed, this, seededrandom, blockposition);
                            continue;
                        }
                        catch (Exception exception1) {
                            CrashReport crashreport1 = CrashReport.a(exception1, "Feature placement");
                            CrashReportSystemDetails crashreportsystemdetails = crashreport1.a("Feature");
                            Objects.requireNonNull(supplier1);
                            crashreportsystemdetails.a("Description", supplier1::get);
                            throw new ReportedException(crashreport1);
                        }
                    }
                }
                generatoraccessseed.a((Supplier<String>)null);
            }
            catch (Exception exception2) {
                CrashReport crashreport2 = CrashReport.a(exception2, "Biome decoration");
                crashreport2.a("Generation").a("CenterX", chunkcoordintpair.e).a("CenterZ", chunkcoordintpair.f).a("Decoration Seed", i2);
                throw new ReportedException(crashreport2);
            }
        }
    }

    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        this.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, true);
    }

    public void applyBiomeDecoration(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager, boolean vanilla) {
        CraftWorld world;
        if (vanilla) {
            this.addVanillaDecorations(generatoraccessseed, ichunkaccess, structuremanager);
        }
        if (!(world = generatoraccessseed.getMinecraftWorld().getWorld()).getPopulators().isEmpty()) {
            CraftLimitedRegion limitedRegion = new CraftLimitedRegion(generatoraccessseed, ichunkaccess.f());
            int x2 = ichunkaccess.f().e;
            int z2 = ichunkaccess.f().f;
            for (BlockPopulator populator : world.getPopulators()) {
                SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(generatoraccessseed.C()));
                seededrandom.a(generatoraccessseed.C(), x2, z2);
                populator.populate((WorldInfo)world, (Random)new RandomSourceWrapper.RandomWrapper(seededrandom), x2, z2, (LimitedRegion)limitedRegion);
            }
            limitedRegion.saveEntities();
            limitedRegion.breakLink();
        }
    }

    private static StructureBoundingBox a(IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        int i2 = chunkcoordintpair.d();
        int j2 = chunkcoordintpair.e();
        LevelHeightAccessor levelheightaccessor = ichunkaccess.z();
        int k2 = levelheightaccessor.I_() + 1;
        int l2 = levelheightaccessor.am() - 1;
        return new StructureBoundingBox(i2, k2, j2, i2 + 15, l2, j2 + 15);
    }

    public abstract void a(RegionLimitedWorldAccess var1, StructureManager var2, RandomState var3, IChunkAccess var4);

    public abstract void a(RegionLimitedWorldAccess var1);

    public int a(LevelHeightAccessor levelheightaccessor) {
        return 64;
    }

    public WorldChunkManager d() {
        return this.b;
    }

    public abstract int e();

    public WeightedRandomList<BiomeSettingsMobs.c> a(Holder<BiomeBase> holder, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        Map<Structure, LongSet> map = structuremanager.b(blockposition);
        for (Map.Entry<Structure, LongSet> entry : map.entrySet()) {
            Structure structure = entry.getKey();
            StructureSpawnOverride structurespawnoverride = structure.b().get(enumcreaturetype);
            if (structurespawnoverride == null) continue;
            MutableBoolean mutableboolean = new MutableBoolean(false);
            Predicate<StructureStart> predicate = structurespawnoverride.a() == StructureSpawnOverride.a.a ? structurestart -> structuremanager.a(blockposition, (StructureStart)structurestart) : structurestart -> structurestart.a().b(blockposition);
            structuremanager.a(structure, entry.getValue(), (StructureStart structurestart) -> {
                if (mutableboolean.isFalse() && predicate.test((StructureStart)structurestart)) {
                    mutableboolean.setTrue();
                }
            });
            if (!mutableboolean.isTrue()) continue;
            return structurespawnoverride.b();
        }
        return holder.a().b().a(enumcreaturetype);
    }

    public void a(IRegistryCustom iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        SectionPosition sectionposition = SectionPosition.a(ichunkaccess);
        RandomState randomstate = chunkgeneratorstructurestate.c();
        chunkgeneratorstructurestate.a().forEach(holder -> {
            StructurePlacement structureplacement = ((StructureSet)holder.a()).b();
            List<StructureSet.a> list = ((StructureSet)holder.a()).a();
            for (StructureSet.a structureset_a : list) {
                StructureStart structurestart = structuremanager.a(sectionposition, structureset_a.a().a(), ichunkaccess);
                if (structurestart == null || !structurestart.b()) continue;
                return;
            }
            if (structureplacement.b(chunkgeneratorstructurestate, chunkcoordintpair.e, chunkcoordintpair.f)) {
                if (list.size() == 1) {
                    this.a(list.get(0), structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ichunkaccess, chunkcoordintpair, sectionposition);
                } else {
                    ArrayList<StructureSet.a> arraylist = new ArrayList<StructureSet.a>(list.size());
                    arraylist.addAll(list);
                    SeededRandom seededrandom = new SeededRandom(new LegacyRandomSource(0L));
                    seededrandom.c(chunkgeneratorstructurestate.d(), chunkcoordintpair.e, chunkcoordintpair.f);
                    int i2 = 0;
                    for (StructureSet.a structureset_a1 : arraylist) {
                        i2 += structureset_a1.b();
                    }
                    while (!arraylist.isEmpty()) {
                        StructureSet.a structureset_a2;
                        int j2 = seededrandom.a(i2);
                        int k2 = 0;
                        Iterator iterator2 = arraylist.iterator();
                        while (iterator2.hasNext() && (j2 -= (structureset_a2 = (StructureSet.a)iterator2.next()).b()) >= 0) {
                            ++k2;
                        }
                        StructureSet.a structureset_a3 = (StructureSet.a)arraylist.get(k2);
                        if (this.a(structureset_a3, structuremanager, iregistrycustom, randomstate, structuretemplatemanager, chunkgeneratorstructurestate.d(), ichunkaccess, chunkcoordintpair, sectionposition)) {
                            return;
                        }
                        arraylist.remove(k2);
                        i2 -= structureset_a3.b();
                    }
                }
            }
        });
    }

    private boolean a(StructureSet.a structureset_a, StructureManager structuremanager, IRegistryCustom iregistrycustom, RandomState randomstate, StructureTemplateManager structuretemplatemanager, long i2, IChunkAccess ichunkaccess, ChunkCoordIntPair chunkcoordintpair, SectionPosition sectionposition) {
        Structure structure = structureset_a.a().a();
        int j2 = ChunkGenerator.a(structuremanager, ichunkaccess, sectionposition, structure);
        HolderSet<BiomeBase> holderset = structure.a();
        Objects.requireNonNull(holderset);
        Predicate<Holder<BiomeBase>> predicate = holderset::a;
        StructureStart structurestart = structure.a(iregistrycustom, this, this.b, randomstate, structuretemplatemanager, i2, chunkcoordintpair, j2, ichunkaccess, predicate);
        if (structurestart.b()) {
            StructureBoundingBox box = structurestart.a();
            AsyncStructureSpawnEvent event = new AsyncStructureSpawnEvent((World)structuremanager.a.getMinecraftWorld().getWorld(), CraftStructure.minecraftToBukkit(structure), new BoundingBox((double)box.h(), (double)box.i(), (double)box.j(), (double)box.k(), (double)box.l(), (double)box.m()), chunkcoordintpair.e, chunkcoordintpair.f);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return true;
            }
            structuremanager.a(sectionposition, structure, structurestart, (StructureAccess)ichunkaccess);
            return true;
        }
        return false;
    }

    private static int a(StructureManager structuremanager, IChunkAccess ichunkaccess, SectionPosition sectionposition, Structure structure) {
        StructureStart structurestart = structuremanager.a(sectionposition, structure, ichunkaccess);
        return structurestart != null ? structurestart.f() : 0;
    }

    public void a(GeneratorAccessSeed generatoraccessseed, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        boolean flag = true;
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        int i2 = chunkcoordintpair.e;
        int j2 = chunkcoordintpair.f;
        int k2 = chunkcoordintpair.d();
        int l2 = chunkcoordintpair.e();
        SectionPosition sectionposition = SectionPosition.a(ichunkaccess);
        for (int i1 = i2 - 8; i1 <= i2 + 8; ++i1) {
            for (int j1 = j2 - 8; j1 <= j2 + 8; ++j1) {
                long k1 = ChunkCoordIntPair.c(i1, j1);
                for (StructureStart structurestart : generatoraccessseed.a(i1, j1).g().values()) {
                    try {
                        if (!structurestart.b() || !structurestart.a().a(k2, l2, k2 + 15, l2 + 15)) continue;
                        structuremanager.a(sectionposition, structurestart.h(), k1, (StructureAccess)ichunkaccess);
                        PacketDebug.a(generatoraccessseed, structurestart);
                    }
                    catch (Exception exception) {
                        CrashReport crashreport = CrashReport.a(exception, "Generating structure reference");
                        CrashReportSystemDetails crashreportsystemdetails = crashreport.a("Structure");
                        Optional<IRegistry<Structure>> optional = generatoraccessseed.H_().c(Registries.aR);
                        crashreportsystemdetails.a("Id", () -> optional.map(iregistry -> iregistry.b(structurestart.h()).toString()).orElse("UNKNOWN"));
                        crashreportsystemdetails.a("Name", () -> BuiltInRegistries.R.b(structurestart.h().e()).toString());
                        crashreportsystemdetails.a("Class", () -> structurestart.h().getClass().getCanonicalName());
                        throw new ReportedException(crashreport);
                    }
                }
            }
        }
    }

    public abstract CompletableFuture<IChunkAccess> a(Blender var1, RandomState var2, StructureManager var3, IChunkAccess var4);

    public abstract int f();

    public abstract int g();

    public abstract int a(int var1, int var2, HeightMap.Type var3, LevelHeightAccessor var4, RandomState var5);

    public abstract BlockColumn a(int var1, int var2, LevelHeightAccessor var3, RandomState var4);

    public int b(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i2, j2, heightmap_type, levelheightaccessor, randomstate);
    }

    public int c(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.a(i2, j2, heightmap_type, levelheightaccessor, randomstate) - 1;
    }

    public abstract void a(List<String> var1, RandomState var2, BlockPosition var3);

    @Deprecated
    public BiomeSettingsGeneration a(Holder<BiomeBase> holder) {
        return this.d.apply(holder);
    }

    private static /* synthetic */ void lambda$addVanillaDecorations$6(GeneratorAccessSeed generatoraccessseed, Set set, ChunkCoordIntPair chunkcoordintpair1) {
        IChunkAccess ichunkaccess1 = generatoraccessseed.a(chunkcoordintpair1.e, chunkcoordintpair1.f);
        for (ChunkSection chunksection : ichunkaccess1.d()) {
            PalettedContainerRO<Holder<BiomeBase>> palettedcontainerro = chunksection.i();
            Objects.requireNonNull(set);
            palettedcontainerro.a(set::add);
        }
    }
}

