/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.status;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ChunkTaskQueueSorter;
import net.minecraft.server.level.GenerationChunkHolder;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.StaticCache2D;
import net.minecraft.util.thread.Mailbox;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityWaterAnimal;
import net.minecraft.world.entity.npc.NPC;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkStep;
import net.minecraft.world.level.chunk.status.WorldGenContext;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkStatusTasks {
    private static boolean a(IChunkAccess ichunkaccess) {
        return ichunkaccess.j().a(ChunkStatus.l) && ichunkaccess.v();
    }

    static CompletableFuture<IChunkAccess> a(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> b(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        if (worldserver.K.y().c()) {
            worldgencontext.b().a(worldserver.H_(), worldserver.l().h(), worldserver.a(), ichunkaccess, worldgencontext.c());
        }
        worldserver.a(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> c(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        worldgencontext.a().a(ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> d(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.b().a((GeneratorAccessSeed)regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> e(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.b().a(worldserver.l().i(), Blender.a(regionlimitedworldaccess), worldserver.a().a(regionlimitedworldaccess), ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> f(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        return worldgencontext.b().a(Blender.a(regionlimitedworldaccess), worldserver.l().i(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess).thenApply(ichunkaccess1 -> {
            ProtoChunk protochunk;
            BelowZeroRetrogen belowzeroretrogen;
            if (ichunkaccess1 instanceof ProtoChunk && (belowzeroretrogen = (protochunk = (ProtoChunk)ichunkaccess1).x()) != null) {
                BelowZeroRetrogen.a(protochunk);
                if (belowzeroretrogen.b()) {
                    belowzeroretrogen.b(protochunk);
                }
            }
            return ichunkaccess1;
        });
    }

    static CompletableFuture<IChunkAccess> g(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.b().a(regionlimitedworldaccess, worldserver.a().a(regionlimitedworldaccess), worldserver.l().i(), ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> h(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        if (ichunkaccess instanceof ProtoChunk) {
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            Blender.a((GeneratorAccessSeed)regionlimitedworldaccess, protochunk);
        }
        worldgencontext.b().a(regionlimitedworldaccess, worldserver.C(), worldserver.l().i(), worldserver.F_(), worldserver.a().a(regionlimitedworldaccess), ichunkaccess, WorldGenStage.Features.a);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> i(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        WorldServer worldserver = worldgencontext.a();
        HeightMap.a(ichunkaccess, EnumSet.of(HeightMap.Type.e, HeightMap.Type.f, HeightMap.Type.d, HeightMap.Type.b));
        RegionLimitedWorldAccess regionlimitedworldaccess = new RegionLimitedWorldAccess(worldserver, staticcache2d, chunkstep, ichunkaccess);
        worldgencontext.b().a((GeneratorAccessSeed)regionlimitedworldaccess, ichunkaccess, worldserver.a().a(regionlimitedworldaccess));
        Blender.a(regionlimitedworldaccess, ichunkaccess);
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> j(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        LightEngineThreaded lightenginethreaded = worldgencontext.d();
        ichunkaccess.A();
        ((ProtoChunk)ichunkaccess).a(lightenginethreaded);
        boolean flag = ChunkStatusTasks.a(ichunkaccess);
        return lightenginethreaded.a(ichunkaccess, flag);
    }

    static CompletableFuture<IChunkAccess> k(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        boolean flag = ChunkStatusTasks.a(ichunkaccess);
        return worldgencontext.d().b(ichunkaccess, flag);
    }

    static CompletableFuture<IChunkAccess> l(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        if (!ichunkaccess.y()) {
            worldgencontext.b().a(new RegionLimitedWorldAccess(worldgencontext.a(), staticcache2d, chunkstep, ichunkaccess));
        }
        return CompletableFuture.completedFuture(ichunkaccess);
    }

    static CompletableFuture<IChunkAccess> m(WorldGenContext worldgencontext, ChunkStep chunkstep, StaticCache2D<GenerationChunkHolder> staticcache2d, IChunkAccess ichunkaccess) {
        ChunkCoordIntPair chunkcoordintpair = ichunkaccess.f();
        GenerationChunkHolder generationchunkholder = staticcache2d.a(chunkcoordintpair.e, chunkcoordintpair.f);
        return CompletableFuture.supplyAsync(() -> {
            Chunk chunk;
            ProtoChunk protochunk = (ProtoChunk)ichunkaccess;
            WorldServer worldserver = worldgencontext.a();
            if (protochunk instanceof ProtoChunkExtension) {
                chunk = ((ProtoChunkExtension)protochunk).C();
            } else {
                chunk = new Chunk(worldserver, protochunk, chunk1 -> ChunkStatusTasks.a(worldserver, protochunk.E()));
                generationchunkholder.a(new ProtoChunkExtension(chunk, false));
            }
            Objects.requireNonNull(generationchunkholder);
            chunk.b(generationchunkholder::s);
            chunk.E();
            chunk.c(true);
            chunk.J();
            chunk.a(worldserver);
            return chunk;
        }, runnable -> {
            Mailbox<ChunkTaskQueueSorter.a<Runnable>> mailbox = worldgencontext.e();
            long i2 = chunkcoordintpair.a();
            Objects.requireNonNull(generationchunkholder);
            mailbox.a(ChunkTaskQueueSorter.a(runnable, i2, generationchunkholder::i));
        });
    }

    private static void a(WorldServer worldserver, List<NBTTagCompound> list) {
        if (!list.isEmpty()) {
            worldserver.b(EntityTypes.a(list, (World)worldserver).filter(entity -> {
                boolean needsRemoval = false;
                DedicatedServer server = worldserver.getCraftServer().getServer();
                if (!server.ac() && entity instanceof NPC) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                if (!server.ab() && (entity instanceof EntityAnimal || entity instanceof EntityWaterAnimal)) {
                    entity.discard(null);
                    needsRemoval = true;
                }
                return !needsRemoval;
            }));
        }
    }
}

