/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R1.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.f e = (iblockdata, iblockaccess, blockposition) -> iblockdata.a(Blocks.co);
    private static final float f = 4.0f;
    private static final double g = 1.0;
    private final GeneratorAccess h;
    private final EnumDirection.EnumAxis i;
    private final EnumDirection j;
    private int k;
    @Nullable
    private BlockPosition l;
    private int m;
    private final int n;
    BlockStateListPopulator blocks;

    public static Optional<BlockPortalShape> a(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        return BlockPortalShape.a(generatoraccess, blockposition, (BlockPortalShape blockportalshape) -> blockportalshape.a() && blockportalshape.k == 0, enumdirection_enumaxis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess generatoraccess, BlockPosition blockposition, Predicate<BlockPortalShape> predicate, EnumDirection.EnumAxis enumdirection_enumaxis) {
        Optional<BlockPortalShape> optional = Optional.of(new BlockPortalShape(generatoraccess, blockposition, enumdirection_enumaxis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(new BlockPortalShape(generatoraccess, blockposition, enumdirection_enumaxis1)).filter(predicate);
    }

    public BlockPortalShape(GeneratorAccess generatoraccess, BlockPosition blockposition, EnumDirection.EnumAxis enumdirection_enumaxis) {
        this.blocks = new BlockStateListPopulator(generatoraccess.getMinecraftWorld());
        this.h = generatoraccess;
        this.i = enumdirection_enumaxis;
        this.j = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        this.l = this.a(blockposition);
        if (this.l == null) {
            this.l = blockposition;
            this.n = 1;
            this.m = 1;
        } else {
            this.n = this.d();
            if (this.n > 0) {
                this.m = this.e();
            }
        }
    }

    @Nullable
    private BlockPosition a(BlockPosition blockposition) {
        int i2 = Math.max(this.h.I_(), blockposition.v() - 21);
        while (blockposition.v() > i2 && BlockPortalShape.a(this.h.a_(blockposition.e()))) {
            blockposition = blockposition.e();
        }
        EnumDirection enumdirection = this.j.g();
        int j2 = this.a(blockposition, enumdirection) - 1;
        return j2 < 0 ? null : blockposition.a(enumdirection, j2);
    }

    private int d() {
        int i2 = this.a(this.l, this.j);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private int a(BlockPosition blockposition, EnumDirection enumdirection) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.g(blockposition).c(enumdirection, i2);
            IBlockData iblockdata = this.h.a_(blockposition_mutableblockposition);
            if (!BlockPortalShape.a(iblockdata)) {
                if (!e.test(iblockdata, this.h, blockposition_mutableblockposition)) break;
                this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = this.h.a_(blockposition_mutableblockposition.c(EnumDirection.a));
            if (!e.test(iblockdata1, this.h, blockposition_mutableblockposition)) break;
            this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private int e() {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i2 = this.a(blockposition_mutableblockposition);
        return i2 >= 3 && i2 <= 21 && this.a(blockposition_mutableblockposition, i2) ? i2 : 0;
    }

    private boolean a(BlockPosition.MutableBlockPosition blockposition_mutableblockposition, int i2) {
        for (int j2 = 0; j2 < this.n; ++j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, j2);
            if (!e.test(this.h.a_(blockposition_mutableblockposition1), this.h, blockposition_mutableblockposition1)) {
                return false;
            }
            this.blocks.a((BlockPosition)blockposition_mutableblockposition1, this.h.a_(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private int a(BlockPosition.MutableBlockPosition blockposition_mutableblockposition) {
        for (int i2 = 0; i2 < 21; ++i2) {
            blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, -1);
            if (!e.test(this.h.a_(blockposition_mutableblockposition), this.h, blockposition_mutableblockposition)) {
                return i2;
            }
            blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, this.n);
            if (!e.test(this.h.a_(blockposition_mutableblockposition), this.h, blockposition_mutableblockposition)) {
                return i2;
            }
            for (int j2 = 0; j2 < this.n; ++j2) {
                blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, j2);
                IBlockData iblockdata = this.h.a_(blockposition_mutableblockposition);
                if (!BlockPortalShape.a(iblockdata)) {
                    return i2;
                }
                if (!iblockdata.a(Blocks.ed)) continue;
                ++this.k;
            }
            this.blocks.a((BlockPosition)blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, -1), this.h.a_(blockposition_mutableblockposition), 18);
            this.blocks.a((BlockPosition)blockposition_mutableblockposition.g(this.l).c(EnumDirection.b, i2).c(this.j, this.n), this.h.a_(blockposition_mutableblockposition), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData iblockdata) {
        return iblockdata.i() || iblockdata.a(TagsBlock.aL) || iblockdata.a(Blocks.ed);
    }

    public boolean a() {
        return this.l != null && this.n >= 2 && this.n <= 21 && this.m >= 3 && this.m <= 21;
    }

    public boolean createPortalBlocks(net.minecraft.world.entity.Entity entity) {
        CraftWorld bworld = this.h.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.ed.o().a(BlockPortal.b, this.i);
        BlockPosition.c(this.l, this.l.a(EnumDirection.b, this.m - 1).a(this.j, this.n - 1)).forEach(blockposition -> this.blocks.a((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, (Entity)(entity == null ? null : entity.getBukkitEntity()), PortalCreateEvent.CreateReason.FIRE);
        this.h.getMinecraftWorld().o().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.c(this.l, this.l.a(EnumDirection.b, this.m - 1).a(this.j, this.n - 1)).forEach(blockposition -> this.h.a((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean c() {
        return this.a() && this.k == this.n * this.m;
    }

    public static Vec3D a(BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, EntitySize entitysize) {
        EnumDirection.EnumAxis enumdirection_enumaxis1;
        double d3;
        double d2;
        double d0 = (double)blockutil_rectangle.b - (double)entitysize.a();
        double d1 = (double)blockutil_rectangle.c - (double)entitysize.b();
        BlockPosition blockposition = blockutil_rectangle.a;
        if (d0 > 0.0) {
            d2 = (double)blockposition.a(enumdirection_enumaxis) + (double)entitysize.a() / 2.0;
            d3 = MathHelper.a(MathHelper.c(vec3d.a(enumdirection_enumaxis) - d2, 0.0, d0), 0.0, 1.0);
        } else {
            d3 = 0.5;
        }
        if (d1 > 0.0) {
            enumdirection_enumaxis1 = EnumDirection.EnumAxis.b;
            d2 = MathHelper.a(MathHelper.c(vec3d.a(enumdirection_enumaxis1) - (double)blockposition.a(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d2 = 0.0;
        }
        enumdirection_enumaxis1 = enumdirection_enumaxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d4 = vec3d.a(enumdirection_enumaxis1) - ((double)blockposition.a(enumdirection_enumaxis1) + 0.5);
        return new Vec3D(d3, d2, d4);
    }

    public static Vec3D a(Vec3D vec3d, WorldServer worldserver, net.minecraft.world.entity.Entity entity, EntitySize entitysize) {
        if (entitysize.a() <= 4.0f && entitysize.b() <= 4.0f) {
            double d0 = (double)entitysize.b() / 2.0;
            Vec3D vec3d1 = vec3d.b(0.0, d0, 0.0);
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, entitysize.a(), 0.0, entitysize.a()).b(0.0, 1.0, 0.0).g(1.0E-6));
            Optional<Vec3D> optional = worldserver.a(entity, voxelshape, vec3d1, (double)entitysize.a(), (double)entitysize.b(), (double)entitysize.a());
            Optional<Vec3D> optional1 = optional.map(vec3d2 -> vec3d2.a(0.0, d0, 0.0));
            return optional1.orElse(vec3d);
        }
        return vec3d;
    }
}

