/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.bukkit.craftbukkit.v1_21_R1.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.world.LootGenerateEvent;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger f = LogUtils.getLogger();
    public static final LootTable a = new LootTable(LootContextParameterSets.b, Optional.empty(), List.of(), List.of());
    public static final LootContextParameterSet b = LootContextParameterSets.q;
    public static final long c = 0L;
    public static final Codec<LootTable> d = RecordCodecBuilder.create(instance -> instance.group((App)LootContextParameterSets.a.lenientOptionalFieldOf("type", (Object)b).forGetter(loottable -> loottable.g), (App)MinecraftKey.a.optionalFieldOf("random_sequence").forGetter(loottable -> loottable.h), (App)LootSelector.a.listOf().optionalFieldOf("pools", List.of()).forGetter(loottable -> loottable.i), (App)LootItemFunctions.c.listOf().optionalFieldOf("functions", List.of()).forGetter(loottable -> loottable.j)).apply((Applicative)instance, LootTable::new));
    public static final Codec<Holder<LootTable>> e = RegistryFileCodec.a(Registries.bc, d);
    private final LootContextParameterSet g;
    private final Optional<MinecraftKey> h;
    private final List<LootSelector> i;
    private final List<LootItemFunction> j;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> k;
    public CraftLootTable craftLootTable;

    LootTable(LootContextParameterSet lootcontextparameterset, Optional<MinecraftKey> optional, List<LootSelector> list, List<LootItemFunction> list1) {
        this.g = lootcontextparameterset;
        this.h = optional;
        this.i = list;
        this.j = list1;
        this.k = LootItemFunctions.a(list1);
    }

    public static Consumer<ItemStack> a(WorldServer worldserver, Consumer<ItemStack> consumer) {
        return itemstack -> {
            if (itemstack.a(worldserver.J())) {
                if (itemstack.H() < itemstack.j()) {
                    consumer.accept((ItemStack)itemstack);
                } else {
                    ItemStack itemstack1;
                    for (int i2 = itemstack.H(); i2 > 0; i2 -= itemstack1.H()) {
                        itemstack1 = itemstack.c(Math.min(itemstack.j(), i2));
                        consumer.accept(itemstack1);
                    }
                }
            }
        };
    }

    public void a(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.a(new LootTableInfo.Builder(lootparams).a(this.h), consumer);
    }

    public void a(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        LootTableInfo.c<LootTable> loottableinfo_c = LootTableInfo.a(this);
        if (loottableinfo.b(loottableinfo_c)) {
            Consumer<ItemStack> consumer1 = LootItemFunction.a(this.k, consumer, loottableinfo);
            for (LootSelector lootselector : this.i) {
                lootselector.a(consumer1, loottableinfo);
            }
            loottableinfo.c(loottableinfo_c);
        } else {
            f.warn("Detected infinite loop in loot tables");
        }
    }

    public void a(LootParams lootparams, long i2, Consumer<ItemStack> consumer) {
        this.a(new LootTableInfo.Builder(lootparams).a(i2).a(this.h), LootTable.a(lootparams.a(), consumer));
    }

    public void b(LootParams lootparams, Consumer<ItemStack> consumer) {
        this.a(lootparams, LootTable.a(lootparams.a(), consumer));
    }

    public void b(LootTableInfo loottableinfo, Consumer<ItemStack> consumer) {
        this.a(loottableinfo, LootTable.a(loottableinfo.d(), consumer));
    }

    public ObjectArrayList<ItemStack> a(LootParams lootparams, RandomSource randomsource) {
        return this.a(new LootTableInfo.Builder(lootparams).a(randomsource).a(this.h));
    }

    public ObjectArrayList<ItemStack> a(LootParams lootparams, long i2) {
        return this.a(new LootTableInfo.Builder(lootparams).a(i2).a(this.h));
    }

    public ObjectArrayList<ItemStack> a(LootParams lootparams) {
        return this.a(new LootTableInfo.Builder(lootparams).a(this.h));
    }

    private ObjectArrayList<ItemStack> a(LootTableInfo loottableinfo) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        Objects.requireNonNull(objectarraylist);
        this.b(loottableinfo, arg_0 -> ((ObjectArrayList)objectarraylist).add(arg_0));
        return objectarraylist;
    }

    public LootContextParameterSet a() {
        return this.g;
    }

    public void a(LootCollector lootcollector) {
        int i2;
        for (i2 = 0; i2 < this.i.size(); ++i2) {
            this.i.get(i2).a(lootcollector.a(".pools[" + i2 + "]"));
        }
        for (i2 = 0; i2 < this.j.size(); ++i2) {
            this.j.get(i2).a(lootcollector.a(".functions[" + i2 + "]"));
        }
    }

    public void a(IInventory iinventory, LootParams lootparams, long i2) {
        this.fillInventory(iinventory, lootparams, i2, false);
    }

    public void fillInventory(IInventory iinventory, LootParams lootparams, long i2, boolean plugin) {
        LootTableInfo loottableinfo = new LootTableInfo.Builder(lootparams).a(i2).a(this.h);
        ObjectArrayList objectarraylist = this.a(loottableinfo);
        RandomSource randomsource = loottableinfo.b();
        LootGenerateEvent event = CraftEventFactory.callLootGenerateEvent(iinventory, this, loottableinfo, objectarraylist, plugin);
        if (event.isCancelled()) {
            return;
        }
        objectarraylist = (ObjectArrayList)event.getLoot().stream().map(CraftItemStack::asNMSCopy).collect(ObjectArrayList.toList());
        List<Integer> list = this.a(iinventory, randomsource);
        this.a((ObjectArrayList<ItemStack>)objectarraylist, list.size(), randomsource);
        for (ItemStack itemstack : objectarraylist) {
            if (list.isEmpty()) {
                f.warn("Tried to over-fill a container");
                return;
            }
            if (itemstack.e()) {
                iinventory.a((int)list.remove(list.size() - 1), ItemStack.l);
                continue;
            }
            iinventory.a((int)list.remove(list.size() - 1), itemstack);
        }
    }

    private void a(ObjectArrayList<ItemStack> objectarraylist, int i2, RandomSource randomsource) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = objectarraylist.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.e()) {
                iterator.remove();
                continue;
            }
            if (itemstack.H() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (i2 - objectarraylist.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack1 = (ItemStack)list.remove(MathHelper.a(randomsource, 0, list.size() - 1));
            int j2 = MathHelper.a(randomsource, 1, itemstack1.H() / 2);
            ItemStack itemstack2 = itemstack1.a(j2);
            if (itemstack1.H() > 1 && randomsource.h()) {
                list.add(itemstack1);
            } else {
                objectarraylist.add((Object)itemstack1);
            }
            if (itemstack2.H() > 1 && randomsource.h()) {
                list.add(itemstack2);
                continue;
            }
            objectarraylist.add((Object)itemstack2);
        }
        objectarraylist.addAll((Collection)list);
        SystemUtils.c(objectarraylist, randomsource);
    }

    private List<Integer> a(IInventory iinventory, RandomSource randomsource) {
        ObjectArrayList objectarraylist = new ObjectArrayList();
        for (int i2 = 0; i2 < iinventory.b(); ++i2) {
            if (!iinventory.a(i2).e()) continue;
            objectarraylist.add((Object)i2);
        }
        SystemUtils.c(objectarraylist, randomsource);
        return objectarraylist;
    }

    public static a b() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> a = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> b = ImmutableList.builder();
        private LootContextParameterSet c = b;
        private Optional<MinecraftKey> d = Optional.empty();

        public a a(LootSelector.a lootselector_a) {
            this.a.add((Object)lootselector_a.b());
            return this;
        }

        public a a(LootContextParameterSet lootcontextparameterset) {
            this.c = lootcontextparameterset;
            return this;
        }

        public a a(MinecraftKey minecraftkey) {
            this.d = Optional.of(minecraftkey);
            return this;
        }

        public a a(LootItemFunction.a lootitemfunction_a) {
            this.b.add((Object)lootitemfunction_a.b());
            return this;
        }

        public a a() {
            return this;
        }

        public LootTable b() {
            return new LootTable(this.c, this.d, (List<LootSelector>)this.a.build(), (List<LootItemFunction>)this.b.build());
        }
    }
}

