/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;
import org.slf4j.Logger;

public class PersistentScoreboard
extends PersistentBase {
    private static final Logger b = LogUtils.getLogger();
    public static final String a = "scoreboard";
    private final Scoreboard c;

    public PersistentScoreboard(Scoreboard var0) {
        this.c = var0;
    }

    public PersistentScoreboard b(NBTTagCompound var0, HolderLookup.a var1) {
        this.b(var0.c("Objectives", 10), var1);
        this.c.a(var0.c("PlayerScores", 10), var1);
        if (var0.b("DisplaySlots", 10)) {
            this.a(var0.p("DisplaySlots"));
        }
        if (var0.b("Teams", 9)) {
            this.a(var0.c("Teams", 10), var1);
        }
        return this;
    }

    private void a(NBTTagList var0, HolderLookup.a var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            Object var7;
            NBTTagCompound var3 = var0.a(var2);
            String var4 = var3.l("Name");
            ScoreboardTeam var5 = this.c.c(var4);
            IChatMutableComponent var6 = IChatBaseComponent.ChatSerializer.a(var3.l("DisplayName"), var1);
            if (var6 != null) {
                var5.a(var6);
            }
            if (var3.b("TeamColor", 8)) {
                var5.a(EnumChatFormat.b(var3.l("TeamColor")));
            }
            if (var3.b("AllowFriendlyFire", 99)) {
                var5.a(var3.q("AllowFriendlyFire"));
            }
            if (var3.b("SeeFriendlyInvisibles", 99)) {
                var5.b(var3.q("SeeFriendlyInvisibles"));
            }
            if (var3.b("MemberNamePrefix", 8) && (var7 = IChatBaseComponent.ChatSerializer.a(var3.l("MemberNamePrefix"), var1)) != null) {
                var5.b((IChatBaseComponent)var7);
            }
            if (var3.b("MemberNameSuffix", 8) && (var7 = IChatBaseComponent.ChatSerializer.a(var3.l("MemberNameSuffix"), var1)) != null) {
                var5.c((IChatBaseComponent)var7);
            }
            if (var3.b("NameTagVisibility", 8) && (var7 = ScoreboardTeamBase.EnumNameTagVisibility.a(var3.l("NameTagVisibility"))) != null) {
                var5.a((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var7));
            }
            if (var3.b("DeathMessageVisibility", 8) && (var7 = ScoreboardTeamBase.EnumNameTagVisibility.a(var3.l("DeathMessageVisibility"))) != null) {
                var5.b((ScoreboardTeamBase.EnumNameTagVisibility)((Object)var7));
            }
            if (var3.b("CollisionRule", 8) && (var7 = ScoreboardTeamBase.EnumTeamPush.a(var3.l("CollisionRule"))) != null) {
                var5.a((ScoreboardTeamBase.EnumTeamPush)((Object)var7));
            }
            this.a(var5, var3.c("Players", 8));
        }
    }

    private void a(ScoreboardTeam var0, NBTTagList var1) {
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.c.a(var1.j(var2), var0);
        }
    }

    private void a(NBTTagCompound var0) {
        for (String var2 : var0.e()) {
            DisplaySlot var3 = DisplaySlot.t.a(var2);
            if (var3 == null) continue;
            String var4 = var0.l(var2);
            ScoreboardObjective var5 = this.c.a(var4);
            this.c.a(var3, var5);
        }
    }

    private void b(NBTTagList var0, HolderLookup.a var1) {
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            NBTTagCompound var3 = var0.a(var2);
            String var4 = var3.l("CriteriaName");
            IScoreboardCriteria var5 = IScoreboardCriteria.a(var4).orElseGet(() -> {
                b.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)var4, (Object)IScoreboardCriteria.b.d());
                return IScoreboardCriteria.b;
            });
            String var6 = var3.l("Name");
            IChatMutableComponent var7 = IChatBaseComponent.ChatSerializer.a(var3.l("DisplayName"), var1);
            IScoreboardCriteria.EnumScoreboardHealthDisplay var8 = IScoreboardCriteria.EnumScoreboardHealthDisplay.a(var3.l("RenderType"));
            boolean var9 = var3.q("display_auto_update");
            NumberFormat var10 = NumberFormatTypes.b.parse(var1.a(DynamicOpsNBT.a), (Object)var3.c("format")).result().orElse(null);
            this.c.a(var6, var5, var7, var8, var9, var10);
        }
    }

    @Override
    public NBTTagCompound a(NBTTagCompound var0, HolderLookup.a var1) {
        var0.a("Objectives", this.b(var1));
        var0.a("PlayerScores", this.c.a(var1));
        var0.a("Teams", this.a(var1));
        this.b(var0);
        return var0;
    }

    private NBTTagList a(HolderLookup.a var0) {
        NBTTagList var1 = new NBTTagList();
        Collection<ScoreboardTeam> var2 = this.c.g();
        for (ScoreboardTeam var4 : var2) {
            NBTTagCompound var5 = new NBTTagCompound();
            var5.a("Name", var4.b());
            var5.a("DisplayName", IChatBaseComponent.ChatSerializer.a(var4.c(), var0));
            if (var4.n().b() >= 0) {
                var5.a("TeamColor", var4.n().g());
            }
            var5.a("AllowFriendlyFire", var4.h());
            var5.a("SeeFriendlyInvisibles", var4.i());
            var5.a("MemberNamePrefix", IChatBaseComponent.ChatSerializer.a(var4.e(), var0));
            var5.a("MemberNameSuffix", IChatBaseComponent.ChatSerializer.a(var4.f(), var0));
            var5.a("NameTagVisibility", var4.j().e);
            var5.a("DeathMessageVisibility", var4.k().e);
            var5.a("CollisionRule", var4.l().e);
            NBTTagList var6 = new NBTTagList();
            for (String var8 : var4.g()) {
                var6.add(NBTTagString.a(var8));
            }
            var5.a("Players", var6);
            var1.add(var5);
        }
        return var1;
    }

    private void b(NBTTagCompound var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        for (DisplaySlot var5 : DisplaySlot.values()) {
            ScoreboardObjective var6 = this.c.a(var5);
            if (var6 == null) continue;
            var1.a(var5.c(), var6.b());
        }
        if (!var1.g()) {
            var0.a("DisplaySlots", var1);
        }
    }

    private NBTTagList b(HolderLookup.a var0) {
        NBTTagList var12 = new NBTTagList();
        Collection<ScoreboardObjective> var2 = this.c.c();
        for (ScoreboardObjective var4 : var2) {
            NBTTagCompound var5 = new NBTTagCompound();
            var5.a("Name", var4.b());
            var5.a("CriteriaName", var4.c().d());
            var5.a("DisplayName", IChatBaseComponent.ChatSerializer.a(var4.d(), var0));
            var5.a("RenderType", var4.h().a());
            var5.a("display_auto_update", var4.e());
            NumberFormat var6 = var4.f();
            if (var6 != null) {
                NumberFormatTypes.b.encodeStart(var0.a(DynamicOpsNBT.a), (Object)var6).ifSuccess(var1 -> var5.a("format", (NBTBase)var1));
            }
            var12.add(var5);
        }
        return var12;
    }
}

