/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.block;

import com.google.common.base.Preconditions;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.BiomeBase;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R1.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftNamespacedKey;

public class CraftBiome {
    public static Biome minecraftToBukkit(BiomeBase minecraft) {
        Preconditions.checkArgument((minecraft != null ? 1 : 0) != 0);
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aF);
        Biome bukkit = (Biome)Registry.BIOME.get(CraftNamespacedKey.fromMinecraft(registry.d(minecraft).orElseThrow().a()));
        if (bukkit == null) {
            return Biome.CUSTOM;
        }
        return bukkit;
    }

    public static Biome minecraftHolderToBukkit(Holder<BiomeBase> minecraft) {
        return CraftBiome.minecraftToBukkit(minecraft.a());
    }

    public static BiomeBase bukkitToMinecraft(Biome bukkit) {
        if (bukkit == null || bukkit == Biome.CUSTOM) {
            return null;
        }
        return (BiomeBase)CraftRegistry.getMinecraftRegistry(Registries.aF).b(CraftNamespacedKey.toMinecraft(bukkit.getKey())).orElseThrow();
    }

    public static Holder<BiomeBase> bukkitToMinecraftHolder(Biome bukkit) {
        if (bukkit == null || bukkit == Biome.CUSTOM) {
            return null;
        }
        IRegistry registry = CraftRegistry.getMinecraftRegistry(Registries.aF);
        Holder<BiomeBase> holder = registry.e(CraftBiome.bukkitToMinecraft(bukkit));
        if (holder instanceof Holder.c) {
            Holder.c holder2 = (Holder.c)holder;
            return holder2;
        }
        throw new IllegalArgumentException("No Reference holder found for " + String.valueOf(bukkit) + ", this can happen if a plugin creates its own biome base with out properly registering it.");
    }
}

