/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.item.EntityFallingBlock;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntity;
import org.bukkit.entity.FallingBlock;

public class CraftFallingBlock
extends CraftEntity
implements FallingBlock {
    public CraftFallingBlock(CraftServer server, EntityFallingBlock entity) {
        super(server, entity);
    }

    @Override
    public EntityFallingBlock getHandle() {
        return (EntityFallingBlock)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFallingBlock";
    }

    public Material getMaterial() {
        return this.getBlockData().getMaterial();
    }

    public BlockData getBlockData() {
        return CraftBlockData.fromData(this.getHandle().t());
    }

    public boolean getDropItem() {
        return this.getHandle().c;
    }

    public void setDropItem(boolean drop) {
        this.getHandle().c = drop;
    }

    public boolean getCancelDrop() {
        return this.getHandle().i;
    }

    public void setCancelDrop(boolean cancelDrop) {
        this.getHandle().i = cancelDrop;
    }

    public boolean canHurtEntities() {
        return this.getHandle().j;
    }

    public void setHurtEntities(boolean hurtEntities) {
        this.getHandle().j = hurtEntities;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        this.getHandle().b = value;
    }

    public float getDamagePerBlock() {
        return this.getHandle().l;
    }

    public void setDamagePerBlock(float damage) {
        Preconditions.checkArgument(((double)damage >= 0.0 ? 1 : 0) != 0, (String)"damage must be >= 0.0, given %s", (Object)Float.valueOf(damage));
        this.getHandle().l = damage;
        if ((double)damage > 0.0) {
            this.setHurtEntities(true);
        }
    }

    public int getMaxDamage() {
        return this.getHandle().k;
    }

    public void setMaxDamage(int damage) {
        Preconditions.checkArgument((damage >= 0 ? 1 : 0) != 0, (String)"damage must be >= 0, given %s", (int)damage);
        this.getHandle().k = damage;
        if (damage > 0) {
            this.setHurtEntities(true);
        }
    }
}

