/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartMobSpawner;
import net.minecraft.world.level.MobSpawnerData;
import org.bukkit.block.spawner.SpawnRule;
import org.bukkit.block.spawner.SpawnerEntry;
import org.bukkit.craftbukkit.v1_21_R1.CraftServer;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntitySnapshot;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftEntityType;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftMinecart;
import org.bukkit.entity.EntitySnapshot;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.SpawnerMinecart;

final class CraftMinecartMobSpawner
extends CraftMinecart
implements SpawnerMinecart {
    CraftMinecartMobSpawner(CraftServer server, EntityMinecartMobSpawner entity) {
        super(server, entity);
    }

    public EntityType getSpawnedType() {
        MobSpawnerData spawnData = this.getHandle().B().f;
        if (spawnData == null) {
            return null;
        }
        Optional<EntityTypes<?>> type = EntityTypes.a(spawnData.a());
        return type.map(CraftEntityType::minecraftToBukkit).orElse(null);
    }

    public void setSpawnedType(EntityType entityType) {
        if (entityType == null) {
            this.getHandle().B().e = SimpleWeightedRandomList.b();
            this.getHandle().B().f = new MobSpawnerData();
            return;
        }
        Preconditions.checkArgument((entityType != EntityType.UNKNOWN ? 1 : 0) != 0, (String)"Can't spawn EntityType %s from mob spawners!", (Object)entityType);
        RandomSource rand = this.getHandle().dO().E_();
        this.getHandle().B().a(CraftEntityType.bukkitToMinecraft(entityType), this.getHandle().dO(), rand, this.getHandle().do());
    }

    public EntitySnapshot getSpawnedEntity() {
        MobSpawnerData spawnData = this.getHandle().B().f;
        if (spawnData == null) {
            return null;
        }
        return CraftEntitySnapshot.create(spawnData.a());
    }

    public void setSpawnedEntity(EntitySnapshot snapshot) {
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().B(), snapshot, null, null);
    }

    public void setSpawnedEntity(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.setSpawnedEntity(this.getHandle().B(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void addPotentialSpawn(EntitySnapshot snapshot, int weight, SpawnRule spawnRule) {
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().B(), snapshot, weight, spawnRule, null);
    }

    public void addPotentialSpawn(SpawnerEntry spawnerEntry) {
        Preconditions.checkArgument((spawnerEntry != null ? 1 : 0) != 0, (Object)"Entry cannot be null");
        CraftCreatureSpawner.addPotentialSpawn(this.getHandle().B(), spawnerEntry.getSnapshot(), spawnerEntry.getSpawnWeight(), spawnerEntry.getSpawnRule(), spawnerEntry.getEquipment());
    }

    public void setPotentialSpawns(Collection<SpawnerEntry> entries) {
        CraftCreatureSpawner.setPotentialSpawns(this.getHandle().B(), entries);
    }

    public List<SpawnerEntry> getPotentialSpawns() {
        return CraftCreatureSpawner.getPotentialSpawns(this.getHandle().B());
    }

    public int getDelay() {
        return this.getHandle().B().d;
    }

    public void setDelay(int delay) {
        this.getHandle().B().d = delay;
    }

    public int getMinSpawnDelay() {
        return this.getHandle().B().i;
    }

    public void setMinSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay <= this.getMaxSpawnDelay() ? 1 : 0) != 0, (Object)"Minimum Spawn Delay must be less than or equal to Maximum Spawn Delay");
        this.getHandle().B().i = spawnDelay;
    }

    public int getMaxSpawnDelay() {
        return this.getHandle().B().j;
    }

    public void setMaxSpawnDelay(int spawnDelay) {
        Preconditions.checkArgument((spawnDelay > 0 ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than 0.");
        Preconditions.checkArgument((spawnDelay >= this.getMinSpawnDelay() ? 1 : 0) != 0, (Object)"Maximum Spawn Delay must be greater than or equal to Minimum Spawn Delay");
        this.getHandle().B().j = spawnDelay;
    }

    public int getMaxNearbyEntities() {
        return this.getHandle().B().m;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.getHandle().B().m = maxNearbyEntities;
    }

    public int getSpawnCount() {
        return this.getHandle().B().k;
    }

    public void setSpawnCount(int count) {
        this.getHandle().B().k = count;
    }

    public int getRequiredPlayerRange() {
        return this.getHandle().B().n;
    }

    public void setRequiredPlayerRange(int requiredPlayerRange) {
        this.getHandle().B().n = requiredPlayerRange;
    }

    public int getSpawnRange() {
        return this.getHandle().B().o;
    }

    public void setSpawnRange(int spawnRange) {
        this.getHandle().B().o = spawnRange;
    }

    @Override
    public EntityMinecartMobSpawner getHandle() {
        return (EntityMinecartMobSpawner)this.entity;
    }

    @Override
    public String toString() {
        return "CraftMinecartMobSpawner";
    }
}

