/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_21_R1.generator;

import com.google.common.base.Preconditions;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EnumCreatureType;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSettingsMobs;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenStage;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.v1_21_R1.CraftHeightMap;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBiome;
import org.bukkit.craftbukkit.v1_21_R1.generator.CraftChunkData;
import org.bukkit.craftbukkit.v1_21_R1.generator.InternalChunkGenerator;
import org.bukkit.craftbukkit.v1_21_R1.generator.OldCraftChunkData;
import org.bukkit.craftbukkit.v1_21_R1.util.RandomSourceWrapper;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.WorldInfo;

public class CustomChunkGenerator
extends InternalChunkGenerator {
    private final ChunkGenerator delegate;
    private final org.bukkit.generator.ChunkGenerator generator;
    private final WorldServer world;
    private final Random random = new Random();
    private boolean newApi;
    private boolean implementBaseHeight = true;

    public CustomChunkGenerator(WorldServer world, ChunkGenerator delegate, org.bukkit.generator.ChunkGenerator generator) {
        super(delegate.d(), delegate.d);
        this.world = world;
        this.delegate = delegate;
        this.generator = generator;
    }

    public ChunkGenerator getDelegate() {
        return this.delegate;
    }

    private static SeededRandom getSeededRandom() {
        return new SeededRandom(new LegacyRandomSource(0L));
    }

    @Override
    public WorldChunkManager d() {
        return this.delegate.d();
    }

    @Override
    public int g() {
        return this.delegate.g();
    }

    @Override
    public int f() {
        return this.delegate.f();
    }

    @Override
    public void a(IRegistryCustom iregistrycustom, ChunkGeneratorStructureState chunkgeneratorstructurestate, StructureManager structuremanager, IChunkAccess ichunkaccess, StructureTemplateManager structuretemplatemanager) {
        SeededRandom random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().e;
        int z2 = ichunkaccess.f().f;
        random.b(MathHelper.b(x2, "should-structures".hashCode(), z2) ^ this.world.C());
        if (this.generator.shouldGenerateStructures((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            super.a(iregistrycustom, chunkgeneratorstructurestate, structuremanager, ichunkaccess, structuretemplatemanager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, StructureManager structuremanager, RandomState randomstate, IChunkAccess ichunkaccess) {
        ChunkGenerator.ChunkData data;
        int z2;
        int x2;
        block15: {
            SeededRandom random = CustomChunkGenerator.getSeededRandom();
            x2 = ichunkaccess.f().e;
            z2 = ichunkaccess.f().f;
            random.b(MathHelper.b(x2, "should-surface".hashCode(), z2) ^ regionlimitedworldaccess.C());
            if (this.generator.shouldGenerateSurface((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
                this.delegate.a(regionlimitedworldaccess, structuremanager, randomstate, ichunkaccess);
            }
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateSurface((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            if (this.generator.shouldGenerateBedrock()) {
                random = CustomChunkGenerator.getSeededRandom();
                random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            }
            random = CustomChunkGenerator.getSeededRandom();
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateBedrock((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            if (this.newApi) {
                return;
            }
            this.random.setSeed((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            CustomBiomeGrid biomegrid = new CustomBiomeGrid(ichunkaccess);
            try {
                if (this.generator.isParallelCapable()) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                    break block15;
                }
                CustomChunkGenerator customChunkGenerator = this;
                synchronized (customChunkGenerator) {
                    data = this.generator.generateChunkData((World)this.world.getWorld(), this.random, x2, z2, (ChunkGenerator.BiomeGrid)biomegrid);
                }
            }
            catch (UnsupportedOperationException exception) {
                this.newApi = true;
                return;
            }
        }
        Preconditions.checkArgument((boolean)(data instanceof OldCraftChunkData), (String)"Plugins must use createChunkData(World) rather than implementing ChunkData: %s", (Object)data);
        OldCraftChunkData craftData = (OldCraftChunkData)data;
        ChunkSection[] sections = craftData.getRawChunkData();
        ChunkSection[] csect = ichunkaccess.d();
        int scnt = Math.min(csect.length, sections.length);
        for (int sec = 0; sec < scnt; ++sec) {
            if (sections[sec] == null) continue;
            ChunkSection section = sections[sec];
            ChunkSection oldSection = csect[sec];
            for (int biomeX = 0; biomeX < 4; ++biomeX) {
                for (int biomeY = 0; biomeY < 4; ++biomeY) {
                    for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                        section.setBiome(biomeX, biomeY, biomeZ, oldSection.c(biomeX, biomeY, biomeZ));
                    }
                }
            }
            csect[sec] = section;
        }
        if (craftData.getTiles() != null) {
            for (BlockPosition pos : craftData.getTiles()) {
                int tz;
                int ty;
                int tx = pos.u();
                IBlockData block = craftData.getTypeId(tx, ty = pos.v(), tz = pos.w());
                if (!block.t()) continue;
                TileEntity tile = ((ITileEntity)((Object)block.b())).a(new BlockPosition((x2 << 4) + tx, ty, (z2 << 4) + tz), block);
                ichunkaccess.a(tile);
            }
        }
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess, long seed, RandomState randomstate, BiomeManager biomemanager, StructureManager structuremanager, IChunkAccess ichunkaccess, WorldGenStage.Features worldgenstage_features) {
        SeededRandom random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().e;
        int z2 = ichunkaccess.f().f;
        random.b(MathHelper.b(x2, "should-caves".hashCode(), z2) ^ regionlimitedworldaccess.C());
        if (this.generator.shouldGenerateCaves((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            this.delegate.a(regionlimitedworldaccess, seed, randomstate, biomemanager, structuremanager, ichunkaccess, worldgenstage_features);
        }
        CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), ichunkaccess);
        random.a(seed, 0, 0);
        this.generator.generateCaves((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
        chunkData.breakLink();
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomstate, StructureManager structuremanager, IChunkAccess ichunkaccess) {
        CompletableFuture<IChunkAccess> future = null;
        SeededRandom random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().e;
        int z2 = ichunkaccess.f().f;
        random.b(MathHelper.b(x2, "should-noise".hashCode(), z2) ^ this.world.C());
        if (this.generator.shouldGenerateNoise((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            future = this.delegate.a(blender, randomstate, structuremanager, ichunkaccess);
        }
        Function<IChunkAccess, IChunkAccess> function = ichunkaccess1 -> {
            CraftChunkData chunkData = new CraftChunkData(this.world.getWorld(), (IChunkAccess)ichunkaccess1);
            random.b((long)x2 * 341873128712L + (long)z2 * 132897987541L);
            this.generator.generateNoise((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2, (ChunkGenerator.ChunkData)chunkData);
            chunkData.breakLink();
            return ichunkaccess1;
        };
        return future == null ? CompletableFuture.supplyAsync(() -> (IChunkAccess)function.apply(ichunkaccess), SystemUtils.g()) : future.thenApply(function);
    }

    @Override
    public int a(int i2, int j2, HeightMap.Type heightmap_type, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        if (this.implementBaseHeight) {
            try {
                SeededRandom random = CustomChunkGenerator.getSeededRandom();
                int xChunk = i2 >> 4;
                int zChunk = j2 >> 4;
                random.b((long)xChunk * 341873128712L + (long)zChunk * 132897987541L);
                return this.generator.getBaseHeight((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), i2, j2, CraftHeightMap.fromNMS(heightmap_type));
            }
            catch (UnsupportedOperationException exception) {
                this.implementBaseHeight = false;
            }
        }
        return this.delegate.a(i2, j2, heightmap_type, levelheightaccessor, randomstate);
    }

    @Override
    public WeightedRandomList<BiomeSettingsMobs.c> a(Holder<BiomeBase> holder, StructureManager structuremanager, EnumCreatureType enumcreaturetype, BlockPosition blockposition) {
        return this.delegate.a(holder, structuremanager, enumcreaturetype, blockposition);
    }

    @Override
    public void a(GeneratorAccessSeed generatoraccessseed, IChunkAccess ichunkaccess, StructureManager structuremanager) {
        SeededRandom random = CustomChunkGenerator.getSeededRandom();
        int x2 = ichunkaccess.f().e;
        int z2 = ichunkaccess.f().f;
        random.b(MathHelper.b(x2, "should-decoration".hashCode(), z2) ^ generatoraccessseed.C());
        super.applyBiomeDecoration(generatoraccessseed, ichunkaccess, structuremanager, this.generator.shouldGenerateDecorations((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2));
    }

    @Override
    public void a(List<String> list, RandomState randomstate, BlockPosition blockposition) {
        this.delegate.a(list, randomstate, blockposition);
    }

    @Override
    public void a(RegionLimitedWorldAccess regionlimitedworldaccess) {
        SeededRandom random = CustomChunkGenerator.getSeededRandom();
        int x2 = regionlimitedworldaccess.a().e;
        int z2 = regionlimitedworldaccess.a().f;
        random.b(MathHelper.b(x2, "should-mobs".hashCode(), z2) ^ regionlimitedworldaccess.C());
        if (this.generator.shouldGenerateMobs((WorldInfo)this.world.getWorld(), (Random)new RandomSourceWrapper.RandomWrapper(random), x2, z2)) {
            this.delegate.a(regionlimitedworldaccess);
        }
    }

    @Override
    public int a(LevelHeightAccessor levelheightaccessor) {
        return this.delegate.a(levelheightaccessor);
    }

    @Override
    public int e() {
        return this.delegate.e();
    }

    @Override
    public BlockColumn a(int i2, int j2, LevelHeightAccessor levelheightaccessor, RandomState randomstate) {
        return this.delegate.a(i2, j2, levelheightaccessor, randomstate);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return MapCodec.unit(null);
    }

    @Deprecated
    private class CustomBiomeGrid
    implements ChunkGenerator.BiomeGrid {
        private final IChunkAccess biome;

        public CustomBiomeGrid(IChunkAccess biome) {
            this.biome = biome;
        }

        public Biome getBiome(int x2, int z2) {
            return this.getBiome(x2, 0, z2);
        }

        public void setBiome(int x2, int z2, Biome bio) {
            for (int y2 = CustomChunkGenerator.this.world.getWorld().getMinHeight(); y2 < CustomChunkGenerator.this.world.getWorld().getMaxHeight(); y2 += 4) {
                this.setBiome(x2, y2, z2, bio);
            }
        }

        public Biome getBiome(int x2, int y2, int z2) {
            return CraftBiome.minecraftHolderToBukkit(this.biome.getNoiseBiome(x2 >> 2, y2 >> 2, z2 >> 2));
        }

        public void setBiome(int x2, int y2, int z2, Biome bio) {
            Preconditions.checkArgument((bio != Biome.CUSTOM ? 1 : 0) != 0, (String)"Cannot set the biome to %s", (Object)bio);
            this.biome.setBiome(x2 >> 2, y2 >> 2, z2 >> 2, CraftBiome.bukkitToMinecraftHolder(bio));
        }
    }
}

