/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.action;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ActionType {
    META("[meta]", "Handle meta for a player", "- '[meta] <set/remove/add/subtract/switch> <key> <value type> <value>'"),
    CONSOLE("[console]", "Execute a command from the console", "- '[console] <command with no slash>'"),
    PLAYER("[player]", "Execute a command for the menu viewer", "- '[player] <command with no slash>'"),
    PLAYER_COMMAND_EVENT("[commandevent]", "Fire a PlayerCommandPreprocessEvent for commands that do not use the bukkit command system", "- '[commandevent] <command with no slash>'"),
    MINI_MESSAGE("[minimessage]", "Send a message to the menu viewer using the minimessage style", "- '[minimessage] <message>'"),
    MINI_BROADCAST("[minibroadcast]", "Broadcast a message to the server using the minimessage style", "- '[minibroadcast] <message>'"),
    MESSAGE("[message]", "Send a message to the menu viewer", "- [message] <message>"),
    BROADCAST("[broadcast]", "Broadcast a message to the server", "- '[broadcast] <message>"),
    CHAT("[chat]", "Send a chat message as the player performing the action", "- '[chat] <message>"),
    OPEN_GUI_MENU("[openguimenu]", "Open a GUI menu", "- '[openguimenu] <menu-name>'"),
    OPEN_MENU("[openmenu]", "Open a GUI menu", "- '[openmenu] <menu-name>'"),
    CONNECT("[connect]", "Connect to the specified bungee server", "- '[connect] <serverName>'"),
    CLOSE("[close]", "Close the viewers open menu", "- '[close]"),
    REFRESH("[refresh]", "Refresh items in the current menu view", "- '[refresh]"),
    BROADCAST_SOUND("[broadcastsound]", "Broadcast a sound to the server", "- '[broadcastsound]"),
    BROADCAST_WORLD_SOUND("[broadcastsoundworld]", "Broadcast a sound to the player's world", "- '[broadcastsoundworld]"),
    PLAY_SOUND("[sound]", "Play a sound for a the specific player", "- '[sound]"),
    TAKE_MONEY("[takemoney]", "Take money from a player (requires Vault)", "- '[takemoney] <amount>"),
    GIVE_MONEY("[givemoney]", "Give money to a player (requires Vault)", "- '[givemoney] <amount>"),
    TAKE_EXP("[takeexp]", "Take exp points/levels from a player", "- '[takeexp] <amount>L'"),
    GIVE_EXP("[giveexp]", "Give exp points/levels to a player", "- '[giveexp] <amount>L'"),
    TAKE_PERM("[takepermission]", "Take a permission from a player (requires Vault)", "- '[takepermission] <permission>'"),
    GIVE_PERM("[givepermission]", "Give a permission to a player (requires Vault)", "- '[givepermission] <permission>'"),
    JSON_MESSAGE("[json]", "Send a json message to the menu viewer", "- '[json] {\"text\":\"message\"}'"),
    JSON_BROADCAST("[jsonbroadcast]", "Broadcast a json message to all online players", "- '[jsonbroadcast] {\"text\":\"message\"}'"),
    BROADCAST_JSON("[broadcastjson]", "Broadcast a json message to all online players", "- '[broadcastjson] {\"text\":\"message\"}'"),
    PLACEHOLDER("[placeholder]", "Parse placeholders for a player without any chat or console output", "- '[placeholder] %placeholder%'");

    private static final Map<String, ActionType> BY_NAME;
    private final String identifier;
    private final String description;
    private final String usage;

    private ActionType(@NotNull String identifier, String description, String usage) {
        this.identifier = identifier;
        this.description = description;
        this.usage = usage;
    }

    @Nullable
    public static ActionType getByName(@NotNull String name) {
        return BY_NAME.get(name.toUpperCase(Locale.ROOT));
    }

    @Nullable
    public static ActionType getByIdentifier(@NotNull String identifier) {
        return BY_NAME.values().stream().filter(e -> e.identifier.equalsIgnoreCase(identifier)).findFirst().orElse(null);
    }

    @Nullable
    public static ActionType getByStart(@NotNull String string) {
        return BY_NAME.values().stream().map(ActionType::getIdentifier).filter(string::startsWith).findFirst().map(ActionType::getByIdentifier).orElse(null);
    }

    public static String listAllActionTypes() {
        StringBuilder builder = new StringBuilder();
        for (ActionType type : BY_NAME.values()) {
            builder.append("\n").append(type.getIdentifier()).append(" - ").append(type.getDescription()).append("\n").append("Usage: ").append(type.getUsage()).append("\n");
        }
        return builder.toString();
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public String getUsage() {
        return this.usage;
    }

    static {
        BY_NAME = Arrays.stream(ActionType.values()).collect(Collectors.toMap(e -> e.name().toUpperCase(Locale.ROOT), Function.identity()));
    }
}

