/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.action;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.minimessage.MiniMessage;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.persistentmeta.PersistentMetaHandler;
import com.extendedclip.deluxemenus.utils.AdventureUtils;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.ExpUtils;
import com.extendedclip.deluxemenus.utils.SoundUtils;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;

public class ClickActionTask
extends BukkitRunnable {
    private final DeluxeMenus plugin;
    private final UUID uuid;
    private final ActionType actionType;
    private final String exec;
    private final Map<String, String> arguments;
    private final boolean parsePlaceholdersInArguments;
    private final boolean parsePlaceholdersAfterArguments;

    public ClickActionTask(@NotNull DeluxeMenus plugin, @NotNull UUID uuid, @NotNull ActionType actionType, @NotNull String exec, @NotNull Map<String, String> arguments, boolean parsePlaceholdersInArguments, boolean parsePlaceholdersAfterArguments) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.actionType = actionType;
        this.exec = exec;
        this.arguments = arguments;
        this.parsePlaceholdersInArguments = parsePlaceholdersInArguments;
        this.parsePlaceholdersAfterArguments = parsePlaceholdersAfterArguments;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        if (player == null) {
            return;
        }
        Optional<MenuHolder> holder = Menu.getMenuHolder(player);
        Player target = holder.isPresent() && holder.get().getPlaceholderPlayer() != null ? holder.get().getPlaceholderPlayer() : player;
        String executable = StringUtils.replacePlaceholdersAndArguments(this.exec, this.arguments, target, this.parsePlaceholdersInArguments, this.parsePlaceholdersAfterArguments);
        switch (this.actionType) {
            case META: {
                if (!VersionHelper.IS_PDC_VERSION || this.plugin.getPersistentMetaHandler() == null) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Meta action not supported on this server version.");
                    return;
                }
                PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().parseAndExecuteMetaActionFromString(player, executable);
                switch (result) {
                    case INVALID_SYNTAX: {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid meta action! Make sure you have the right syntax.");
                        return;
                    }
                    case NEW_VALUE_IS_DIFFERENT_TYPE: {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid meta action! New value is a different type than the old value!");
                        return;
                    }
                    case INVALID_TYPE: {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid meta action! The specified type is not supported for the specified action!");
                        return;
                    }
                    case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Invalid meta action! Existent value is a different type than the new value!");
                        return;
                    }
                }
                return;
            }
            case PLAYER: 
            case PLAYER_COMMAND_EVENT: {
                player.chat("/" + executable);
                return;
            }
            case PLACEHOLDER: {
                holder.ifPresent(it -> it.setPlaceholders(executable));
                return;
            }
            case CHAT: {
                player.chat(executable);
                return;
            }
            case CONSOLE: {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)executable);
                return;
            }
            case MINI_MESSAGE: {
                this.plugin.audiences().player(player).sendMessage((Component)MiniMessage.miniMessage().deserialize(executable));
                return;
            }
            case MINI_BROADCAST: {
                this.plugin.audiences().all().sendMessage((Component)MiniMessage.miniMessage().deserialize(executable));
                return;
            }
            case MESSAGE: {
                player.sendMessage(StringUtils.color(executable));
                return;
            }
            case BROADCAST: {
                Bukkit.broadcastMessage((String)StringUtils.color(executable));
                return;
            }
            case CLOSE: {
                Menu.closeMenu(this.plugin, player, true, true);
                return;
            }
            case OPEN_GUI_MENU: 
            case OPEN_MENU: {
                String temporaryExecutable = executable.replaceAll("\\s+", " ").replace("  ", " ");
                String[] executableParts = temporaryExecutable.split(" ", 2);
                if (executableParts.length == 0) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not find and open menu " + executable);
                    return;
                }
                String menuName = executableParts[0];
                Optional<Menu> optionalMenuToOpen = Menu.getMenuByName(menuName);
                if (optionalMenuToOpen.isEmpty()) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not find and open menu " + executable);
                    return;
                }
                Menu menuToOpen = optionalMenuToOpen.get();
                List<String> menuArgumentNames = menuToOpen.options().arguments();
                String[] passedArgumentValues = null;
                if (executableParts.length > 1) {
                    passedArgumentValues = executableParts[1].split(" ");
                }
                if (menuArgumentNames.isEmpty()) {
                    if (passedArgumentValues != null && passedArgumentValues.length > 0) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Arguments were given for menu " + menuName + " in action [openguimenu] or [openmenu], but the menu does not support arguments!");
                    }
                    if (holder.isEmpty()) {
                        menuToOpen.openMenu(player);
                        return;
                    }
                    menuToOpen.openMenu(player, holder.get().getTypedArgs(), holder.get().getPlaceholderPlayer());
                    return;
                }
                if (passedArgumentValues == null || passedArgumentValues.length == 0) {
                    if (holder.isEmpty()) {
                        menuToOpen.openMenu(player);
                        return;
                    }
                    menuToOpen.openMenu(player, holder.get().getTypedArgs(), holder.get().getPlaceholderPlayer());
                    return;
                }
                if (passedArgumentValues.length < menuArgumentNames.size()) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Not enough arguments given for menu " + menuName + " when opening using the [openguimenu] or [openmenu] action!");
                    return;
                }
                HashMap<String, String> argumentsMap = new HashMap<String, String>();
                if (holder.isPresent() && holder.get().getTypedArgs() != null) {
                    argumentsMap.putAll(holder.get().getTypedArgs());
                }
                for (int index = 0; index < menuArgumentNames.size(); ++index) {
                    String argumentName = menuArgumentNames.get(index);
                    if (passedArgumentValues.length <= index) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Not enough arguments given for menu " + menuName + " when opening using the [openguimenu] or [openmenu] action!");
                        break;
                    }
                    if (menuArgumentNames.size() == index + 1) {
                        String lastArgumentValue = String.join((CharSequence)" ", Arrays.asList(passedArgumentValues).subList(index, passedArgumentValues.length));
                        argumentsMap.put(argumentName, lastArgumentValue);
                        break;
                    }
                    argumentsMap.put(argumentName, passedArgumentValues[index]);
                }
                if (holder.isEmpty()) {
                    menuToOpen.openMenu(player, argumentsMap, null);
                    return;
                }
                menuToOpen.openMenu(player, argumentsMap, holder.get().getPlaceholderPlayer());
                return;
            }
            case CONNECT: {
                this.plugin.connect(player, executable);
                return;
            }
            case JSON_MESSAGE: {
                AdventureUtils.sendJson(this.plugin, (CommandSender)player, executable);
                return;
            }
            case JSON_BROADCAST: 
            case BROADCAST_JSON: {
                this.plugin.audiences().all().sendMessage(AdventureUtils.fromJson(executable));
                return;
            }
            case REFRESH: {
                if (holder.isEmpty()) {
                    this.plugin.debug(DebugLevel.MEDIUM, Level.WARNING, player.getName() + " does not have menu open! Nothing to refresh!");
                    return;
                }
                holder.get().refreshMenu();
                return;
            }
            case TAKE_MONEY: {
                if (this.plugin.getVault() == null || !this.plugin.getVault().hooked()) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot take money!");
                    return;
                }
                try {
                    this.plugin.getVault().takeMoney(player, Double.parseDouble(executable));
                    return;
                }
                catch (NumberFormatException exception) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for take money action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case GIVE_MONEY: {
                if (this.plugin.getVault() == null || !this.plugin.getVault().hooked()) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot give money!");
                    return;
                }
                try {
                    this.plugin.getVault().giveMoney(player, Double.parseDouble(executable));
                    return;
                }
                catch (NumberFormatException exception) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for give money action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case TAKE_EXP: 
            case GIVE_EXP: {
                String lowerCaseExecutable = executable.toLowerCase();
                try {
                    if (Integer.parseInt(lowerCaseExecutable.replaceAll("l", "")) <= 0) {
                        return;
                    }
                    if (this.actionType == ActionType.TAKE_EXP) {
                        ExpUtils.setExp(player, "-" + lowerCaseExecutable);
                        return;
                    }
                    ExpUtils.setExp(player, lowerCaseExecutable);
                    return;
                }
                catch (NumberFormatException exception) {
                    if (this.actionType == ActionType.TAKE_EXP) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for take exp action: " + executable + ", is not a valid number!");
                        return;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Amount for give exp action: " + executable + ", is not a valid number!");
                    return;
                }
            }
            case GIVE_PERM: {
                if (this.plugin.getVault() != null && this.plugin.getVault().hooked()) {
                    this.plugin.getVault().givePermission(player, executable);
                    return;
                }
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot give permission: " + executable + "!");
                return;
            }
            case TAKE_PERM: {
                if (this.plugin.getVault() != null && this.plugin.getVault().hooked()) {
                    this.plugin.getVault().takePermission(player, executable);
                    return;
                }
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Vault not hooked! Cannot take permission: " + executable + "!");
                return;
            }
            case BROADCAST_SOUND: 
            case BROADCAST_WORLD_SOUND: 
            case PLAY_SOUND: {
                Sound sound;
                float volume = 1.0f;
                float pitch = 1.0f;
                if (!executable.contains(" ")) {
                    try {
                        sound = SoundUtils.getSound(executable.toUpperCase());
                    }
                    catch (IllegalArgumentException exception) {
                        this.plugin.printStacktrace("Sound name given for sound action: " + executable + ", is not a valid sound!", exception);
                        return;
                    }
                }
                String[] parts = executable.split(" ", 3);
                try {
                    sound = SoundUtils.getSound(parts[0].toUpperCase());
                }
                catch (IllegalArgumentException exception) {
                    this.plugin.printStacktrace("Sound name given for sound action: " + parts[0] + ", is not a valid sound!", exception);
                    return;
                }
                if (parts.length == 3) {
                    try {
                        pitch = Float.parseFloat(parts[2]);
                    }
                    catch (NumberFormatException exception) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Pitch given for sound action: " + parts[2] + ", is not a valid number!");
                        this.plugin.printStacktrace("Pitch given for sound action: " + parts[2] + ", is not a valid number!", exception);
                    }
                }
                try {
                    volume = Float.parseFloat(parts[1]);
                }
                catch (NumberFormatException exception) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Volume given for sound action: " + parts[1] + ", is not a valid number!");
                    this.plugin.printStacktrace("Volume given for sound action: " + parts[1] + ", is not a valid number!", exception);
                }
                switch (this.actionType) {
                    case BROADCAST_SOUND: {
                        Player broadcastTarget;
                        Iterator iterator = Bukkit.getOnlinePlayers().iterator();
                        while (iterator.hasNext()) {
                            broadcastTarget = (Player)iterator.next();
                            broadcastTarget.playSound(broadcastTarget.getLocation(), sound, volume, pitch);
                        }
                        return;
                    }
                    case BROADCAST_WORLD_SOUND: {
                        Player broadcastTarget;
                        Iterator iterator = player.getWorld().getPlayers().iterator();
                        while (iterator.hasNext()) {
                            broadcastTarget = (Player)iterator.next();
                            broadcastTarget.playSound(broadcastTarget.getLocation(), sound, volume, pitch);
                        }
                        return;
                    }
                    case PLAY_SOUND: {
                        player.playSound(player.getLocation(), sound, volume, pitch);
                    }
                }
                return;
            }
        }
    }
}

