/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextComponent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.event.ClickEvent;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.utils.DumpUtils;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumpCommand
extends SubCommand {
    private static final String ADMIN_PERMISSION = "deluxemenus.admin";

    public DumpCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "dump";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(ADMIN_PERMISSION)) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        if (arguments.size() != 1) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_DUMP_COMMAND);
            return;
        }
        String dump = "";
        try {
            dump = DumpUtils.createDump(this.plugin, arguments.get(0));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (dump.isBlank()) {
            this.plugin.sms(sender, Messages.DUMP_FAILED);
            return;
        }
        DumpUtils.postDump(dump).whenComplete((result, error) -> {
            if (error != null) {
                this.plugin.printStacktrace("Something went wrong while trying to create and post a dump!", (Throwable)error);
                this.plugin.sms(sender, Messages.DUMP_FAILED);
                return;
            }
            TextComponent link = (TextComponent)Component.text("https://paste.helpch.at/" + result).clickEvent(ClickEvent.openUrl("https://paste.helpch.at/" + result));
            this.plugin.sms(sender, Messages.DUMP_SUCCESS.message().append(link));
        });
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(ADMIN_PERMISSION)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 2) {
            return null;
        }
        if (arguments.size() == 1) {
            if (arguments.get(0).isEmpty()) {
                return List.of(this.getName());
            }
            String firstArgument = arguments.get(0).toLowerCase();
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        String secondArgument = arguments.get(1).toLowerCase();
        ArrayList<String> completions = new ArrayList<String>(Menu.getAllMenuNames());
        completions.add("config");
        if (secondArgument.isEmpty()) {
            return completions;
        }
        return completions.stream().filter(completion -> completion.startsWith(secondArgument)).collect(Collectors.toList());
    }
}

