/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.action.ClickAction;
import com.extendedclip.deluxemenus.action.ClickActionTask;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecuteCommand
extends SubCommand {
    public ExecuteCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "execute";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        Matcher ch;
        if (!sender.isOp()) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        if (arguments.size() < 2) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_EXECUTE_COMMAND);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)arguments.get(0));
        if (target == null) {
            this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(arguments.get(1)).build()));
            return;
        }
        String executable = String.join((CharSequence)" ", arguments.subList(1, arguments.size()));
        ActionType type = ActionType.getByStart(executable);
        if (type == null) {
            this.plugin.sms(sender, Messages.WRONG_ACTION_TYPE);
            return;
        }
        executable = executable.replaceFirst(Pattern.quote(type.getIdentifier()), "").trim();
        ClickAction action = new ClickAction(type, executable);
        Matcher d = DeluxeMenusConfig.DELAY_MATCHER.matcher(executable);
        if (d.find()) {
            action.setDelay(d.group(1));
            executable = executable.replaceFirst(Pattern.quote(d.group()), "");
        }
        if ((ch = DeluxeMenusConfig.CHANCE_MATCHER.matcher(executable)).find()) {
            action.setChance(ch.group(1));
            executable = executable.replaceFirst(Pattern.quote(ch.group()), "");
        }
        action.setExecutable(executable);
        MenuHolder holder = Menu.getMenuHolder(target).orElse(new MenuHolder(this.plugin, target));
        if (!action.checkChance(holder)) {
            this.plugin.sms(sender, Messages.CHANCE_FAIL);
            return;
        }
        ClickActionTask actionTask = new ClickActionTask(this.plugin, target.getUniqueId(), action.getType(), action.getExecutable(), holder.getTypedArgs(), true, true);
        if (action.hasDelay()) {
            actionTask.runTaskLater((Plugin)this.plugin, action.getDelay(holder));
            this.plugin.sms(sender, Messages.ACTION_TO_BE_EXECUTED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(action.getDelay(holder))).build()));
            return;
        }
        actionTask.runTask((Plugin)this.plugin);
        this.plugin.sms(sender, Messages.ACTION_EXECUTED_FOR.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.isOp()) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 2) {
            return null;
        }
        if (arguments.size() == 1) {
            if (arguments.get(0).isEmpty()) {
                return List.of(this.getName());
            }
            String firstArgument = arguments.get(0).toLowerCase();
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        return this.getPlayerNameCompletion(arguments.get(1));
    }
}

