/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpCommand
extends SubCommand {
    private static final String ADMIN_PERMISSION = "deluxemenus.admin";

    public HelpCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "help";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (sender.isOp()) {
            this.plugin.sms(sender, Messages.HELP_OP);
            return;
        }
        if (sender.hasPermission(ADMIN_PERMISSION)) {
            this.plugin.sms(sender, Messages.HELP);
            return;
        }
        this.plugin.sms(sender, Messages.NO_PERMISSION);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(ADMIN_PERMISSION)) {
            return null;
        }
        if (arguments.size() > 1) {
            return null;
        }
        if (arguments.isEmpty() || arguments.get(0).isEmpty()) {
            return List.of(this.getName());
        }
        String argument = arguments.get(0).toLowerCase();
        if (!this.getName().startsWith(argument)) {
            return null;
        }
        return List.of(this.getName());
    }
}

