/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.Component;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextComponent;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.NamedTextColor;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.format.TextColor;
import com.extendedclip.deluxemenus.persistentmeta.DataAction;
import com.extendedclip.deluxemenus.persistentmeta.DataType;
import com.extendedclip.deluxemenus.persistentmeta.PersistentMetaHandler;
import com.extendedclip.deluxemenus.utils.Messages;
import com.extendedclip.deluxemenus.utils.PaginationUtils;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaCommand
extends SubCommand {
    private static final List<String> SUB_COMMANDS = List.of("list", "show", "set", "remove", "add", "subtract", "switch");

    public MetaCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "meta";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.isOp()) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        if (!VersionHelper.IS_PDC_VERSION || this.plugin.getPersistentMetaHandler() == null) {
            this.plugin.sms(sender, Messages.META_NOT_SUPPORTED);
            return;
        }
        if (arguments.size() < 2) {
            this.sendWrongUsageMessage(sender, null);
            return;
        }
        Player target = Bukkit.getPlayerExact((String)arguments.get(0));
        if (target == null) {
            this.plugin.sms(sender, Messages.PLAYER_IS_NOT_ONLINE.message().replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(arguments.get(0)).build()));
            return;
        }
        String actionName = StringUtils.replacePlaceholders(arguments.get(1), target);
        DataAction action = DataAction.getActionByName(actionName);
        if (action == null) {
            if (actionName.equalsIgnoreCase("list")) {
                this.handleListMeta(sender, target, arguments.subList(2, arguments.size()));
                return;
            }
            if (actionName.equalsIgnoreCase("show")) {
                this.handleShowMeta(sender, target, arguments.subList(2, arguments.size()));
                return;
            }
            this.sendWrongUsageMessage(sender, null);
            return;
        }
        if (arguments.size() < 3) {
            this.sendWrongUsageMessage(sender, action);
            return;
        }
        String keyName = StringUtils.replacePlaceholders(arguments.get(2), target);
        NamespacedKey namespacedKey = this.plugin.getPersistentMetaHandler().getKey(keyName);
        if (namespacedKey == null) {
            this.plugin.sms(sender, Messages.META_KEY_INVALID.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(keyName).build()));
            return;
        }
        HashMap<ContextKeys, String> context = new HashMap<ContextKeys, String>();
        context.put(ContextKeys.KEY_NAME, keyName);
        if (action == DataAction.SWITCH) {
            this.handleSwitchMeta(sender, target, namespacedKey, context);
            return;
        }
        if (arguments.size() < 4) {
            this.sendWrongUsageMessage(sender, action);
            return;
        }
        String typeName = StringUtils.replacePlaceholders(arguments.get(3), target).toUpperCase(Locale.ROOT);
        DataType<?, ?> type = DataType.getSupportedTypeByName(typeName);
        if (type == null) {
            this.plugin.sms(sender, Messages.META_TYPE_UNSUPPORTED.message().replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()));
            return;
        }
        context.put(ContextKeys.TYPE_NAME, typeName);
        if (action == DataAction.REMOVE) {
            this.handleRemoveMeta(sender, target, namespacedKey, type, context);
            return;
        }
        if (arguments.size() < 5) {
            this.sendWrongUsageMessage(sender, action);
            return;
        }
        String value = StringUtils.replacePlaceholders(String.join((CharSequence)" ", arguments.subList(4, arguments.size())), target);
        if (action == DataAction.SET) {
            this.handleSetMeta(sender, target, namespacedKey, type, value, context);
            return;
        }
        if (action == DataAction.ADD) {
            this.handleAddMeta(sender, target, namespacedKey, type, value, context);
            return;
        }
        if (action == DataAction.SUBTRACT) {
            this.handleSubtractMeta(sender, target, namespacedKey, type, value, context);
            return;
        }
        this.sendWrongUsageMessage(sender, action);
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.isOp() || !VersionHelper.IS_PDC_VERSION || this.plugin.getPersistentMetaHandler() == null) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 5) {
            return null;
        }
        if (arguments.size() == 1) {
            String firstArgument = arguments.get(0).toLowerCase();
            if (firstArgument.isEmpty()) {
                return List.of(this.getName());
            }
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        if (arguments.size() == 2) {
            return this.getPlayerNameCompletion(arguments.get(1));
        }
        if (arguments.size() == 3) {
            String thirdArgument = arguments.get(2).toLowerCase();
            if (thirdArgument.isEmpty()) {
                return SUB_COMMANDS;
            }
            return SUB_COMMANDS.stream().filter(action -> action.startsWith(thirdArgument)).collect(Collectors.toList());
        }
        if (arguments.size() == 4) {
            String action2 = arguments.get(2).toLowerCase();
            if (!action2.equalsIgnoreCase("list")) {
                return null;
            }
            String fourthArgument = arguments.get(3);
            if (fourthArgument.isEmpty()) {
                return new ArrayList<String>(DataType.getSupportedTypeNames());
            }
            return DataType.getSupportedTypeNames().stream().filter(type -> type.startsWith(fourthArgument.toUpperCase(Locale.ROOT))).collect(Collectors.toList());
        }
        if (arguments.size() == 5) {
            String actionName = arguments.get(2).toLowerCase();
            DataAction action3 = DataAction.getActionByName(actionName);
            if (actionName.equalsIgnoreCase("list") || action3 == DataAction.SWITCH) {
                return null;
            }
            String fifthArgument = arguments.get(4);
            if (fifthArgument.isEmpty()) {
                return new ArrayList<String>(DataType.getSupportedTypeNames());
            }
            return DataType.getSupportedTypeNames().stream().filter(type -> type.startsWith(fifthArgument.toUpperCase(Locale.ROOT))).collect(Collectors.toList());
        }
        return null;
    }

    private void handleListMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull List<String> arguments) {
        if (arguments.isEmpty()) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_META_LIST_COMMAND);
            return;
        }
        String typeName = arguments.get(0).toUpperCase(Locale.ROOT);
        DataType<?, ?> type = DataType.getSupportedTypeByName(typeName);
        if (type == null) {
            this.plugin.sms(sender, Messages.META_TYPE_UNSUPPORTED.message().replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()));
            return;
        }
        TreeMap metas = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        metas.putAll(this.plugin.getPersistentMetaHandler().getMetaValues(target, type));
        if (metas.isEmpty()) {
            this.plugin.sms(sender, Messages.NO_META_VALUES.message().replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
            return;
        }
        int itemsPerPage = this.plugin.getGeneralConfig().metasListPageSize();
        int itemsCount = metas.size();
        int pagesCount = PaginationUtils.getPagesCount(itemsPerPage, itemsCount);
        int page = PaginationUtils.parsePage(itemsPerPage, itemsCount, pagesCount, arguments.size() < 2 ? null : arguments.get(1));
        LinkedHashMap pageItems = new LinkedHashMap();
        int start = (page - 1) * itemsPerPage;
        int end = start + itemsPerPage;
        int index = 0;
        for (Map.Entry entry2 : metas.entrySet()) {
            if (index >= end) break;
            if (index < start) {
                ++index;
                continue;
            }
            pageItems.put((String)entry2.getKey(), entry2.getValue());
            ++index;
        }
        int pageItemsCount = pageItems.size();
        TextComponent.Builder list = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)Component.text("Page " + page + "/" + pagesCount + " - " + pageItemsCount + " pairs:", (TextColor)NamedTextColor.GOLD))).append((Component)Component.newline())).append((Component)Component.newline())).append((Component)Component.text("Key (String) - Value (" + typeName + ")", (TextColor)NamedTextColor.GRAY))).append((Component)Component.newline());
        Component pairsList = pageItems.entrySet().stream().map(entry -> (TextComponent)((TextComponent)((TextComponent)Component.text((String)entry.getKey(), (TextColor)NamedTextColor.DARK_AQUA).append(Component.text(" - ", (TextColor)NamedTextColor.GRAY))).append(Component.text(String.valueOf(entry.getValue()), (TextColor)NamedTextColor.GREEN))).append(Component.newline())).collect(Component.toComponent());
        ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)list.append((Component)Component.newline())).append(pairsList)).append((Component)Component.newline())).append((Component)Component.text("Use /dm meta list " + typeName + " <page> to view more values of this type", (TextColor)NamedTextColor.GRAY));
        this.plugin.sms(sender, (Component)list.build());
    }

    private void handleShowMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull List<String> arguments) {
        if (arguments.size() < 2) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_META_SHOW_COMMAND);
            return;
        }
        String keyName = arguments.get(0);
        NamespacedKey namespacedKey = this.plugin.getPersistentMetaHandler().getKey(keyName);
        if (namespacedKey == null) {
            this.plugin.sms(sender, Messages.META_KEY_INVALID.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(keyName).build()));
            return;
        }
        String typeName = arguments.get(1).toUpperCase(Locale.ROOT);
        DataType<?, ?> type = DataType.getSupportedTypeByName(typeName);
        if (type == null) {
            this.plugin.sms(sender, Messages.META_TYPE_UNSUPPORTED.message().replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()));
            return;
        }
        Object value = this.plugin.getPersistentMetaHandler().getMetaValue(target, namespacedKey, type);
        if (value == null) {
            this.plugin.sms(sender, Messages.NO_META_VALUE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(keyName).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
            return;
        }
        this.plugin.sms(sender, Messages.META_VALUE_FOUND.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(keyName).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(typeName).build()).replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(value)).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
    }

    private void handleSetMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull NamespacedKey namespacedKey, @NotNull DataType<?, ?> type, @NotNull String value, @NotNull Map<ContextKeys, String> context) {
        Object parsedValue = this.plugin.getPersistentMetaHandler().parseValueByType(type, value);
        if (parsedValue == null) {
            this.plugin.sms(sender, Messages.META_VALUE_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(value).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()));
            return;
        }
        PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().setMetaValue(target, namespacedKey, type, parsedValue);
        switch (result) {
            case SUCCESS: {
                this.plugin.sms(sender, Messages.META_VALUE_SET.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()).replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
            case NEW_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_VALUE_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()));
                return;
            }
            case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_EXISTENT_VALUE_WRONG_TYPE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()));
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_SET_COMMAND);
    }

    private void handleRemoveMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull NamespacedKey namespacedKey, @NotNull DataType<?, ?> type, @NotNull Map<ContextKeys, String> context) {
        PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().removeMetaValue(target, namespacedKey, type);
        switch (result) {
            case SUCCESS: {
                this.plugin.sms(sender, Messages.META_VALUE_REMOVED.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
            case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_EXISTENT_VALUE_WRONG_TYPE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()));
                return;
            }
            case VALUE_NOT_FOUND: {
                this.plugin.sms(sender, Messages.NO_META_VALUE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_REMOVE_COMMAND);
    }

    private void handleSwitchMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull NamespacedKey namespacedKey, @NotNull Map<ContextKeys, String> context) {
        PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().switchMetaValue(target, namespacedKey);
        switch (result) {
            case SUCCESS: {
                String newValue = this.plugin.getPersistentMetaHandler().getMetaValue(target, namespacedKey, DataType.BOOLEAN);
                this.plugin.sms(sender, Messages.META_VALUE_SWITCHED.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)NEW_VALUE_REPLACER_BUILDER.replacement(String.valueOf(newValue)).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
            case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_EXISTENT_VALUE_WRONG_TYPE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()));
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_SWITCH_COMMAND);
    }

    private void handleAddMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull NamespacedKey namespacedKey, @NotNull DataType<?, ?> type, @NotNull String value, @NotNull Map<ContextKeys, String> context) {
        Object parsedValue = this.plugin.getPersistentMetaHandler().parseValueByType(type, value);
        if (!(parsedValue instanceof Number)) {
            this.plugin.sms(sender, Messages.META_ADD_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(value)).build()));
            return;
        }
        PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().addMetaValue(target, namespacedKey, type, (Number)parsedValue);
        switch (result) {
            case SUCCESS: {
                Object newValue = this.plugin.getPersistentMetaHandler().getMetaValue(target, namespacedKey, type);
                this.plugin.sms(sender, Messages.META_VALUE_ADDED.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()).replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()).replaceText((TextReplacementConfig)NEW_VALUE_REPLACER_BUILDER.replacement(String.valueOf(newValue)).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
            case INVALID_TYPE: {
                this.plugin.sms(sender, Messages.META_ADD_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()));
                return;
            }
            case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_EXISTENT_VALUE_WRONG_TYPE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()));
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_ADD_COMMAND);
    }

    private void handleSubtractMeta(@NotNull CommandSender sender, @NotNull Player target, @NotNull NamespacedKey namespacedKey, @NotNull DataType<?, ?> type, @NotNull String value, @NotNull Map<ContextKeys, String> context) {
        Object parsedValue = this.plugin.getPersistentMetaHandler().parseValueByType(type, value);
        if (!(parsedValue instanceof Number)) {
            this.plugin.sms(sender, Messages.META_SUBTRACT_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(value)).build()));
            return;
        }
        PersistentMetaHandler.OperationResult result = this.plugin.getPersistentMetaHandler().subtractMetaValue(target, namespacedKey, type, (Number)parsedValue);
        switch (result) {
            case SUCCESS: {
                Object newValue = this.plugin.getPersistentMetaHandler().getMetaValue(target, namespacedKey, type);
                this.plugin.sms(sender, Messages.META_VALUE_SUBTRACTED.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()).replaceText((TextReplacementConfig)TYPE_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.TYPE_NAME, type.getComplexType().getSimpleName())).build()).replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()).replaceText((TextReplacementConfig)NEW_VALUE_REPLACER_BUILDER.replacement(String.valueOf(newValue)).build()).replaceText((TextReplacementConfig)PLAYER_REPLACER_BUILDER.replacement(target.getName()).build()));
                return;
            }
            case INVALID_TYPE: {
                this.plugin.sms(sender, Messages.META_SUBTRACT_TYPE_MISMATCH.message().replaceText((TextReplacementConfig)VALUE_REPLACER_BUILDER.replacement(String.valueOf(parsedValue)).build()));
                return;
            }
            case EXISTENT_VALUE_IS_DIFFERENT_TYPE: {
                this.plugin.sms(sender, Messages.META_EXISTENT_VALUE_WRONG_TYPE.message().replaceText((TextReplacementConfig)KEY_REPLACER_BUILDER.replacement(context.getOrDefault((Object)ContextKeys.KEY_NAME, namespacedKey.toString())).build()));
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_SUBTRACT_COMMAND);
    }

    private void sendWrongUsageMessage(@NotNull CommandSender sender, @Nullable DataAction action) {
        if (action == null) {
            this.plugin.sms(sender, Messages.WRONG_USAGE_META_COMMAND);
            return;
        }
        switch (action) {
            case SET: {
                this.plugin.sms(sender, Messages.WRONG_USAGE_META_SET_COMMAND);
                return;
            }
            case REMOVE: {
                this.plugin.sms(sender, Messages.WRONG_USAGE_META_REMOVE_COMMAND);
                return;
            }
            case ADD: {
                this.plugin.sms(sender, Messages.WRONG_USAGE_META_ADD_COMMAND);
                return;
            }
            case SUBTRACT: {
                this.plugin.sms(sender, Messages.WRONG_USAGE_META_SUBTRACT_COMMAND);
                return;
            }
            case SWITCH: {
                this.plugin.sms(sender, Messages.WRONG_USAGE_META_SWITCH_COMMAND);
                return;
            }
        }
        this.plugin.sms(sender, Messages.WRONG_USAGE_META_COMMAND);
    }

    public static enum ContextKeys {
        KEY_NAME,
        TYPE_NAME,
        VALUE;

    }
}

