/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.command.subcommand.SubCommand;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.utils.Messages;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReloadCommand
extends SubCommand {
    private static final String RELOAD_PERMISSION = "deluxemenus.reload";

    public ReloadCommand(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    @NotNull
    public String getName() {
        return "reload";
    }

    @Override
    public void execute(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(RELOAD_PERMISSION)) {
            this.plugin.sms(sender, Messages.NO_PERMISSION);
            return;
        }
        if (this.plugin.getConfiguration().checkConfig(null, "config.yml", false) == null) {
            this.plugin.sms(sender, Messages.RELOAD_FAIL);
            return;
        }
        if (!arguments.isEmpty()) {
            if (Menu.getMenuByName(arguments.get(0)).isEmpty()) {
                this.plugin.sms(sender, Messages.INVALID_MENU.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(arguments.get(0)).build()));
                return;
            }
            Menu.unload(this.plugin, arguments.get(0));
            if (this.plugin.getConfiguration().loadGUIMenu(arguments.get(0))) {
                this.plugin.sms(sender, Messages.MENU_RELOADED.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(arguments.get(0)).build()));
                return;
            }
            this.plugin.sms(sender, Messages.MENU_NOT_RELOADED.message().replaceText((TextReplacementConfig)MENU_REPLACER_BUILDER.replacement(arguments.get(0)).build()));
            return;
        }
        this.plugin.clearCaches();
        this.plugin.reloadConfig();
        this.plugin.saveConfig();
        this.plugin.reload();
        Menu.unload(this.plugin);
        this.plugin.getConfiguration().loadGUIMenus();
        this.plugin.sms(sender, Messages.RELOAD_SUCCESS);
        int gLoaded = Menu.getLoadedMenuSize();
        if (gLoaded == 1) {
            this.plugin.sms(sender, Messages.MENU_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(gLoaded)).build()));
            return;
        }
        this.plugin.sms(sender, Messages.MENUS_LOADED.message().replaceText((TextReplacementConfig)AMOUNT_REPLACER_BUILDER.replacement(String.valueOf(gLoaded)).build()));
    }

    @Override
    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull List<String> arguments) {
        if (!sender.hasPermission(RELOAD_PERMISSION)) {
            return null;
        }
        if (arguments.isEmpty()) {
            return List.of(this.getName());
        }
        if (arguments.size() > 2) {
            return null;
        }
        if (arguments.size() == 1) {
            if (arguments.get(0).isEmpty()) {
                return List.of(this.getName());
            }
            String firstArgument = arguments.get(0).toLowerCase();
            if (this.getName().startsWith(firstArgument)) {
                return List.of(this.getName());
            }
            return null;
        }
        String firstArgument = arguments.get(0).toLowerCase();
        if (!this.getName().equals(firstArgument)) {
            return null;
        }
        Set<String> menuNames = Menu.getAllMenuNames();
        if (menuNames.isEmpty()) {
            return null;
        }
        String secondArgument = arguments.get(1).toLowerCase();
        if (secondArgument.isEmpty()) {
            return List.copyOf(menuNames);
        }
        return menuNames.stream().filter(menuName -> menuName.toLowerCase().startsWith(secondArgument)).collect(Collectors.toList());
    }
}

