/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.command.subcommand;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.libs.adventure.adventure.text.TextReplacementConfig;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubCommand {
    protected static final TextReplacementConfig.Builder PLAYER_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<player>");
    protected static final TextReplacementConfig.Builder AMOUNT_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<amount>");
    protected static final TextReplacementConfig.Builder MENU_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<menu>");
    protected static final TextReplacementConfig.Builder KEY_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<key>");
    protected static final TextReplacementConfig.Builder VALUE_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<value>");
    protected static final TextReplacementConfig.Builder NEW_VALUE_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<new-value>");
    protected static final TextReplacementConfig.Builder TYPE_REPLACER_BUILDER = TextReplacementConfig.builder().matchLiteral("<type>");
    protected final DeluxeMenus plugin;

    public SubCommand(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public abstract String getName();

    public abstract void execute(@NotNull CommandSender var1, @NotNull List<String> var2);

    @Nullable
    public abstract List<String> onTabComplete(@NotNull CommandSender var1, @NotNull List<String> var2);

    protected @Nullable List<@NotNull String> getPlayerNameCompletion(@Nullable String argument) {
        List<String> onlinePlayerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
        if (onlinePlayerNames.isEmpty()) {
            return null;
        }
        if (argument == null || argument.isEmpty()) {
            return onlinePlayerNames;
        }
        return onlinePlayerNames.stream().filter(playerName -> playerName.toLowerCase().startsWith(argument.toLowerCase())).collect(Collectors.toList());
    }
}

