/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.config;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.action.ActionType;
import com.extendedclip.deluxemenus.action.ClickAction;
import com.extendedclip.deluxemenus.action.ClickActionTask;
import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.menu.options.CustomModelDataComponent;
import com.extendedclip.deluxemenus.menu.options.LoreAppendMode;
import com.extendedclip.deluxemenus.menu.options.MenuItemOptions;
import com.extendedclip.deluxemenus.menu.options.MenuOptions;
import com.extendedclip.deluxemenus.requirement.HasExpRequirement;
import com.extendedclip.deluxemenus.requirement.HasItemRequirement;
import com.extendedclip.deluxemenus.requirement.HasMetaRequirement;
import com.extendedclip.deluxemenus.requirement.HasMoneyRequirement;
import com.extendedclip.deluxemenus.requirement.HasPermissionRequirement;
import com.extendedclip.deluxemenus.requirement.HasPermissionsRequirement;
import com.extendedclip.deluxemenus.requirement.InputResultRequirement;
import com.extendedclip.deluxemenus.requirement.IsNearRequirement;
import com.extendedclip.deluxemenus.requirement.IsObjectRequirement;
import com.extendedclip.deluxemenus.requirement.JavascriptRequirement;
import com.extendedclip.deluxemenus.requirement.RegexMatchesRequirement;
import com.extendedclip.deluxemenus.requirement.Requirement;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import com.extendedclip.deluxemenus.requirement.RequirementType;
import com.extendedclip.deluxemenus.requirement.StringLengthRequirement;
import com.extendedclip.deluxemenus.requirement.wrappers.ItemWrapper;
import com.extendedclip.deluxemenus.utils.Constants;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import com.extendedclip.deluxemenus.utils.ItemUtils;
import com.extendedclip.deluxemenus.utils.LocationUtils;
import com.extendedclip.deluxemenus.utils.VersionHelper;
import com.google.common.base.Enums;
import com.google.common.primitives.Ints;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public class DeluxeMenusConfig {
    public static final List<String> VALID_MATERIALS = new ArrayList<String>();
    public static final List<String> VALID_MATERIAL_PREFIXES = new ArrayList<String>();
    public static final java.util.regex.Pattern DELAY_MATCHER = java.util.regex.Pattern.compile("<delay=([^<>]+)>", 2);
    public static final java.util.regex.Pattern CHANCE_MATCHER = java.util.regex.Pattern.compile("<chance=([^<>]+)>", 2);
    public static final java.util.regex.Pattern PLACEHOLDER_PATTERN = java.util.regex.Pattern.compile("%((?<identifier>[a-zA-Z0-9]+)_)(?<parameters>[^%]+)%");
    private static final List<InventoryType> VALID_INVENTORY_TYPES = VersionHelper.getValidInventoryTypes();
    private final String separator = File.separator;
    private final File menuDirectory;
    private final DeluxeMenus plugin;
    private final List<String> exampleMenus = Arrays.asList("basics_menu", "advanced_menu", "requirements_menu");

    public DeluxeMenusConfig(@NotNull DeluxeMenus plugin) {
        VALID_MATERIAL_PREFIXES.addAll(plugin.getItemHooks().values().stream().map(ItemHook::getPrefix).collect(Collectors.toList()));
        this.plugin = plugin;
        this.menuDirectory = new File(String.valueOf(this.plugin.getDataFolder()) + this.separator + "gui_menus");
        try {
            if (this.menuDirectory.mkdirs()) {
                plugin.debug(DebugLevel.HIGH, Level.INFO, "Individual menus directory did not exist.", "Created directory: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus");
            }
        }
        catch (SecurityException e) {
            plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Something went wrong while creating directory: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus");
        }
    }

    private static boolean isValidMaterial(@NotNull String material) {
        String lowercaseMaterial = material.toLowerCase(Locale.ROOT);
        if (VALID_MATERIALS.contains(lowercaseMaterial)) {
            return true;
        }
        if (Material.getMaterial((String)material.toUpperCase(Locale.ROOT)) != null) {
            return true;
        }
        for (String prefix : VALID_MATERIAL_PREFIXES) {
            if (!lowercaseMaterial.startsWith(prefix)) continue;
            String[] split = lowercaseMaterial.split("-");
            return split.length >= 2;
        }
        return false;
    }

    public static boolean containsPlaceholders(String text) {
        return PLACEHOLDER_PATTERN.matcher(text).find();
    }

    private List<String> getStringListFromConfig(FileConfiguration config, String path) {
        if (!config.contains(path)) {
            return Collections.emptyList();
        }
        if (config.isList(path)) {
            return config.getStringList(path);
        }
        return Collections.singletonList(config.getString(path, ""));
    }

    public boolean loadDefConfig() {
        if (this.checkConfig(null, "config.yml", true) == null) {
            return false;
        }
        FileConfiguration c = this.plugin.getConfig();
        c.options().header("DeluxeMenus " + this.plugin.getDescription().getVersion() + " main configuration file\n\nA full wiki on how to use this plugin can be found at:\nhttps://wiki.helpch.at/helpchat-plugins/deluxemenus\n");
        c.addDefault("debug", (Object)"LOW");
        c.addDefault("check_updates", (Object)true);
        c.addDefault("use_admin_commands_in_menus_list", (Object)false);
        c.addDefault("menus_list_page_size", (Object)10);
        c.options().copyDefaults(true);
        if (!c.contains("gui_menus")) {
            this.createMenuExamples(c);
        } else {
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
        }
        return true;
    }

    private void createMenuExamples(FileConfiguration c) {
        for (String name : this.exampleMenus) {
            File menuFile = new File(this.menuDirectory.getPath(), name + ".yml");
            try {
                menuFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.printStacktrace("Failed to create example menus!", e);
                continue;
            }
            this.saveResourceToFile(name + ".yml", menuFile);
            c.set("gui_menus." + name + ".file", (Object)menuFile.getName());
        }
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
    }

    private boolean saveResourceToFile(String resource, File file) {
        try {
            InputStream is = this.plugin.getResource(resource);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(buffer);
            return true;
        }
        catch (IOException | NullPointerException ex) {
            this.plugin.printStacktrace("Failed to update file: " + resource, ex);
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Failed to save default settings for:" + file.getName() + " from resource:" + resource);
            return false;
        }
    }

    public FileConfiguration checkConfig(String folder, String fileName, boolean create) {
        File directory = folder != null ? new File(String.valueOf(this.plugin.getDataFolder()) + this.separator + folder + this.separator) : new File(String.valueOf(this.plugin.getDataFolder()) + this.separator);
        try {
            if (!directory.exists()) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        File configFile = new File(directory.getPath(), fileName);
        if (create) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.printStacktrace("Failed to create file: " + fileName, e);
                return null;
            }
        }
        if (!configFile.exists()) {
            return null;
        }
        return this.checkConfig(configFile);
    }

    private FileConfiguration checkConfig(File f) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(f);
            return config;
        }
        catch (IOException e) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not read file: " + f.getName());
            this.plugin.printStacktrace("Could not read file: " + f.getName(), e);
            return null;
        }
        catch (InvalidConfigurationException e) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Detected invalid configuration in file: " + f.getName());
            this.plugin.printStacktrace("Detected invalid configuration in file: " + f.getName(), e);
            return null;
        }
    }

    public boolean loadGUIMenu(String menu) {
        if (this.checkConfig(null, "config.yml", false) == null) {
            return false;
        }
        FileConfiguration c = this.plugin.getConfig();
        if (!c.contains("gui_menus")) {
            return false;
        }
        if (!c.isConfigurationSection("gui_menus")) {
            return false;
        }
        Set keys = c.getConfigurationSection("gui_menus").getKeys(false);
        if (keys.isEmpty()) {
            return false;
        }
        if (!keys.contains(menu)) {
            return false;
        }
        if (c.contains("gui_menus." + menu + ".file")) {
            this.loadMenuFromFile(menu);
        } else {
            this.loadMenu(c, menu, true, "config");
        }
        return true;
    }

    public int loadGUIMenus() {
        if (this.checkConfig(null, "config.yml", false) == null) {
            return 0;
        }
        FileConfiguration c = this.plugin.getConfig();
        if (!c.contains("gui_menus")) {
            return 0;
        }
        if (!c.isConfigurationSection("gui_menus")) {
            return 0;
        }
        Set keys = c.getConfigurationSection("gui_menus").getKeys(false);
        if (keys.isEmpty()) {
            return 0;
        }
        for (String key : keys) {
            if (c.contains("gui_menus." + key + ".file")) {
                this.loadMenuFromFile(key);
                continue;
            }
            this.loadMenu(c, key, true, "config");
        }
        return Menu.getLoadedMenuSize();
    }

    public boolean loadMenuFromFile(String menuName) {
        FileConfiguration cfg;
        String fileName = this.plugin.getConfig().getString("gui_menus." + menuName + ".file");
        if (!fileName.endsWith(".yml")) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Filename specified for menu: " + menuName + " is not a .yml file!", "Make sure that the file name to load this menu from is specified as a .yml file!", "Skipping loading of menu: " + menuName);
            return false;
        }
        File f = new File(this.menuDirectory.getPath(), fileName);
        if (!f.exists()) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, f.getName() + " does not exist!");
            try {
                File folder = f.getParentFile();
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                f.createNewFile();
                if (!this.saveResourceToFile("default_menu.yml", f)) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to create a default menu file for menu: " + menuName, "Skipping loading menu: " + menuName);
                    return false;
                }
                this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, f.getName() + " created! Add your menu options to this file and use /dm reload to load it!");
            }
            catch (IOException e) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Could not create menu file: plugins" + this.separator + "DeluxeMenus" + this.separator + "gui_menus" + this.separator + fileName);
                return false;
            }
        }
        if ((cfg = this.checkConfig(f)) == null) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu: " + menuName + " in file: " + fileName + " not loaded.");
            return false;
        }
        if (cfg.getKeys(false).isEmpty()) {
            this.plugin.debug(DebugLevel.HIGH, Level.INFO, "Menu config: " + f.getName() + " is empty! Creating default config example...");
            this.saveResourceToFile("default_menu.yml", f);
            return false;
        }
        Path guiMenusPath = this.menuDirectory.toPath();
        Path menuPath = f.toPath();
        Path relativePath = guiMenusPath.relativize(menuPath);
        this.loadMenu(cfg, menuName, false, relativePath.toString());
        return Menu.getMenuByName(menuName).isPresent();
    }

    public void loadMenu(FileConfiguration c, String key, boolean mainConfig, @NotNull String path) {
        int updateInterval;
        RequirementList requirements;
        if (mainConfig) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu: " + key + " does not have a file specified in config.yml! Creating menus in the config.yml file is deprecated and will be removed in a future version! Please migrate your menus to individual files in the gui_menus directory! For more information see: https://wiki.helpch.at/clips-plugins/deluxemenus/external-menus");
        }
        Object pre = "gui_menus." + key + ".";
        if (!mainConfig) {
            pre = "";
        }
        if (!c.contains((String)pre + "menu_title")) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Menu title for menu: " + key + " is not present!", "Skipping menu: " + key);
            return;
        }
        String title = null;
        if (c.isString((String)pre + "menu_title")) {
            title = c.getString((String)pre + "menu_title");
        } else if (c.isList((String)pre + "menu_title")) {
            title = (String)c.getStringList((String)pre + "menu_title").get(0);
        }
        if (title == null || title.isEmpty()) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Menu title for menu: " + key + " is invalid!", "Skipping menu: " + key);
            return;
        }
        MenuOptions.MenuOptionsBuilder builder = MenuOptions.builder(key, title);
        InventoryType type = InventoryType.CHEST;
        if (c.contains((String)pre + "inventory_type")) {
            try {
                InventoryType inventoryType = InventoryType.valueOf((String)c.getString((String)pre + "inventory_type").toUpperCase());
                type = !VALID_INVENTORY_TYPES.contains(inventoryType) ? InventoryType.CHEST : inventoryType;
            }
            catch (Exception ex) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Inventory type for menu: " + key + " is invalid!", "Valid Inventory types: " + Arrays.toString(VALID_INVENTORY_TYPES.toArray()), "Defaulting to CHEST inventory type.");
            }
        }
        builder.type(type);
        ArrayList<String> openCommands = new ArrayList<String>();
        if (c.contains((String)pre + "open_command")) {
            if (c.isString((String)pre + "open_command") && !c.getString((String)pre + "open_command").isEmpty()) {
                String cmd = c.getString((String)pre + "open_command");
                if (cmd == null) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "open_command specified for menu: " + key + " is null!", "Skipping menu: " + key);
                    return;
                }
                if (Menu.isMenuCommand(cmd)) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "open_command specified for menu: " + key + " already exists for another menu!", "Skipping menu: " + key);
                    return;
                }
                openCommands.add(cmd.toLowerCase());
            } else if (c.isList((String)pre + "open_command") && !c.getStringList((String)pre + "open_command").isEmpty()) {
                List cmds = c.getStringList((String)pre + "open_command");
                for (String cmd : cmds) {
                    if (Menu.isMenuCommand(cmd)) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "command: " + cmd + " specified for menu: " + key + " already exists for another menu!", "Skipping command: " + cmd + " in menu: " + key);
                        continue;
                    }
                    openCommands.add(cmd.toLowerCase());
                }
            }
        }
        if (!openCommands.isEmpty()) {
            builder.commands(openCommands);
            builder.registerCommands(c.getBoolean((String)pre + "register_command", false));
        }
        ArrayList<String> argumentNames = new ArrayList<String>();
        ArrayList<RequirementList> argumentRequirements = new ArrayList<RequirementList>();
        if (c.contains((String)pre + "args")) {
            if (c.isConfigurationSection((String)pre + "args")) {
                Set mapList = c.getConfigurationSection((String)pre + "args").getKeys(false);
                this.debug("found args");
                for (String arg : mapList) {
                    this.debug("arg: " + arg);
                    if (c.contains((String)pre + "args." + arg + ".requirements")) {
                        this.debug("arg has requirements: " + arg);
                        argumentRequirements.add(this.getRequirements(c, (String)pre + "args." + arg));
                    }
                    argumentNames.add(arg);
                }
            } else if (c.isList((String)pre + "args")) {
                argumentNames.addAll(c.getStringList((String)pre + "args"));
            } else if (c.isString((String)pre + "args")) {
                argumentNames.add(c.getString((String)pre + "args"));
            }
        }
        builder.arguments(argumentNames);
        builder.argumentRequirements(argumentRequirements);
        builder.argumentsUsageMessage(c.getString((String)pre + "args_usage_message", null));
        int size = 54;
        if (type == InventoryType.CHEST) {
            if (!c.contains((String)pre + "size")) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Menu size for menu: " + key + " is not present!", "Using default size of 54");
            } else {
                size = c.getInt((String)pre + "size");
                if ((size + 1) % 9 == 0) {
                    ++size;
                }
                if ((size - 1) % 9 == 0) {
                    --size;
                }
                if (size < 9) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.INFO, "Menu size for menu: " + key + " is lower than 9", "Defaulting to 9.");
                    size = 9;
                }
                if (size > 54) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu size for menu: " + key + " is higher than 54", "Defaulting to 54.");
                    size = 54;
                }
                if (size % 9 != 0) {
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Menu size for menu: " + key + " is not a multiple of 9", "Defaulting to 54.");
                    size = 54;
                }
            }
        } else {
            size = type.getDefaultSize();
            this.plugin.debug(DebugLevel.LOWEST, Level.INFO, "TYPE IS: " + String.valueOf(type) + ". Setting size to:" + type.getDefaultSize());
        }
        builder.size(size);
        if (c.contains((String)pre + "open_requirement") && (requirements = this.getRequirements(c, (String)pre + "open_requirement")) != null && requirements.getRequirements() != null) {
            builder.openRequirements(requirements);
        }
        if (c.contains((String)pre + "open_commands")) {
            builder.openHandler(this.getClickHandler(c, (String)pre + "open_commands"));
        }
        if (c.contains((String)pre + "close_commands")) {
            builder.closeHandler(this.getClickHandler(c, (String)pre + "close_commands"));
        }
        builder.updateInterval((updateInterval = c.getInt((String)pre + "update_interval", 10)) > 0 ? updateInterval : 10);
        Map<Integer, TreeMap<Integer, MenuItem>> items = this.loadMenuItems(c, key, mainConfig);
        if (items == null || items.isEmpty()) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.SEVERE, "Failed to load menu items for menu: " + key, "Skipping menu: " + key);
            return;
        }
        builder.parsePlaceholdersInArguments(c.getBoolean((String)pre + "arguments_support_placeholders", false));
        builder.parsePlaceholdersAfterArguments(c.getBoolean((String)pre + "parse_placeholders_after_arguments", false));
        new Menu(this.plugin, builder.build(), items, path);
    }

    private Map<Integer, TreeMap<Integer, MenuItem>> loadMenuItems(FileConfiguration c, String name, boolean mainConfig) {
        Object itemsPath = "gui_menus." + name + ".items";
        if (!mainConfig) {
            itemsPath = "items";
        }
        if (!c.contains((String)itemsPath) || !c.isConfigurationSection((String)itemsPath)) {
            return null;
        }
        Set itemKeys = c.getConfigurationSection((String)itemsPath).getKeys(false);
        if (itemKeys.isEmpty()) {
            return null;
        }
        HashMap<Integer, TreeMap<Integer, MenuItem>> menuItems = new HashMap<Integer, TreeMap<Integer, MenuItem>>();
        for (String key : itemKeys) {
            String[] metaParts;
            ConfigurationSection modelDataComponent;
            String currentPath = (String)itemsPath + "." + key + ".";
            if (!c.contains(currentPath + "material")) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Material for item: " + key + " in menu: " + name + " is not present!", "Skipping item: " + key);
                continue;
            }
            String material = c.getString(currentPath + "material");
            String lowercaseMaterial = material.toLowerCase(Locale.ROOT);
            if (!DeluxeMenusConfig.isValidMaterial(lowercaseMaterial)) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Material for item: " + key + " in menu: " + name + " is not valid!", "Skipping item: " + key);
                continue;
            }
            this.checkForDeprecatedItemOptions(c.getConfigurationSection(currentPath), name);
            MenuItemOptions.MenuItemOptionsBuilder builder = MenuItemOptions.builder().material(material).baseColor(Optional.ofNullable(c.getString(currentPath + "base_color")).map(String::toUpperCase).map(DyeColor::valueOf).orElse(null)).slot(c.getInt(currentPath + "slot", 0)).amount(c.getInt(currentPath + "amount", -1)).dynamicAmount(c.getString(currentPath + "dynamic_amount", null)).customModelData(c.getString(currentPath + "model_data", null)).lightLevel(c.getString(currentPath + "light_level", null)).displayName(c.getString(currentPath + "display_name")).lore(c.getStringList(currentPath + "lore")).hasLore(c.contains(currentPath + "lore")).rgb(c.getString(currentPath + "rgb", null)).unbreakable(c.getBoolean(currentPath + "unbreakable", false)).updatePlaceholders(c.getBoolean(currentPath + "update", false)).hideAttributes(c.getBoolean(currentPath + "hide_attributes", false)).hideUnbreakable(c.getBoolean(currentPath + "hide_unbreakable", false)).hideEnchants(c.getBoolean(currentPath + "hide_enchantments", false)).nbtString(c.getString(currentPath + "nbt_string", null)).nbtByte(c.getString(currentPath + "nbt_byte", null)).nbtShort(c.getString(currentPath + "nbt_short", null)).nbtInt(c.getString(currentPath + "nbt_int", null)).nbtStrings(c.getStringList(currentPath + "nbt_strings")).nbtBytes(c.getStringList(currentPath + "nbt_bytes")).nbtShorts(c.getStringList(currentPath + "nbt_shorts")).nbtInts(c.getStringList(currentPath + "nbt_ints")).priority(c.getInt(currentPath + "priority", 1)).hideTooltip(c.getString(currentPath + "hide_tooltip", null)).enchantmentGlintOverride(c.getString(currentPath + "enchantment_glint_override", null)).rarity(c.getString(currentPath + "rarity", null)).tooltipStyle(c.getString(currentPath + "tooltip_style", null)).itemModel(c.getString(currentPath + "item_model", null));
            if (c.contains(currentPath + "model_data_component") && c.isConfigurationSection(currentPath + "model_data_component") && (modelDataComponent = c.getConfigurationSection(currentPath + "model_data_component")) != null) {
                builder.customModelDataComponent(CustomModelDataComponent.builder().colors(modelDataComponent.getStringList("colors")).flags(modelDataComponent.getStringList("flags")).floats(modelDataComponent.getStringList("floats")).strings(modelDataComponent.getStringList("strings")));
            }
            if (c.contains(currentPath + "lore_append_mode")) {
                String loreAppendMode = c.getString(currentPath + "lore_append_mode", "OVERRIDE").toUpperCase();
                try {
                    builder.loreAppendMode(LoreAppendMode.valueOf(loreAppendMode));
                }
                catch (IllegalArgumentException | NullPointerException ignored) {
                    builder.loreAppendMode(LoreAppendMode.OVERRIDE);
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Lore append mode: " + loreAppendMode + " for item: " + key + " in menu: " + name + " is not a valid lore append mode!");
                }
            }
            if (c.contains(currentPath + "item_flags")) {
                ArrayList<ItemFlag> itemFlags = new ArrayList<ItemFlag>();
                for (String flagAsString : this.getStringListFromConfig(c, currentPath + "item_flags")) {
                    ItemFlag flag = (ItemFlag)Enums.getIfPresent(ItemFlag.class, (String)flagAsString.toUpperCase()).orNull();
                    if (flag == null) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Item flag: " + flagAsString + " for item: " + key + " in menu: " + name + " is not a valid item flag!");
                        continue;
                    }
                    itemFlags.add(flag);
                }
                builder.itemFlags(itemFlags);
            }
            this.addDamageOptionToBuilder(c, currentPath, key, name, builder);
            if (VersionHelper.HAS_ARMOR_TRIMS) {
                builder.trimMaterial(c.getString(currentPath + "trim_material", null));
                builder.trimPattern(c.getString(currentPath + "trim_pattern", null));
            }
            if (c.contains(currentPath + "banner_meta") && c.isList(currentPath + "banner_meta")) {
                ArrayList<Pattern> bannerMeta = new ArrayList<Pattern>();
                for (String e : c.getStringList(currentPath + "banner_meta")) {
                    PatternType type;
                    DyeColor color;
                    if (!e.contains(";")) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                        continue;
                    }
                    metaParts = e.split(";", 2);
                    if (metaParts.length != 2) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                        continue;
                    }
                    try {
                        color = DyeColor.valueOf((String)metaParts[0].toUpperCase());
                        type = PatternType.valueOf((String)metaParts[1].toUpperCase());
                    }
                    catch (IllegalArgumentException exception) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Banner Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                        this.plugin.printStacktrace("Banner Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!", exception);
                        continue;
                    }
                    bannerMeta.add(new Pattern(color, type));
                }
                if (!bannerMeta.isEmpty()) {
                    builder.bannerMeta(bannerMeta);
                }
            }
            if (c.contains(currentPath + "potion_effects") && c.isList(currentPath + "potion_effects")) {
                ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
                for (String e : c.getStringList(currentPath + "potion_effects")) {
                    try {
                        if (!e.contains(";")) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        metaParts = e.split(";", 3);
                        if (metaParts.length != 3) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        PotionEffectType type = PotionEffectType.getByName((String)metaParts[0]);
                        int duration = Integer.parseInt(metaParts[1]);
                        int amplifier = Integer.parseInt(metaParts[2]);
                        if (type == null) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        potionEffects.add(type.createEffect(duration, amplifier));
                    }
                    catch (Exception ex) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Potion Meta for item: " + key + ", meta entry: " + e + " is invalid! Skipping this entry!");
                    }
                }
                if (!potionEffects.isEmpty()) {
                    builder.potionEffects(potionEffects);
                }
            }
            this.addEnchantmentsOptionToBuilder(c, currentPath, key, name, builder);
            if (c.contains(currentPath + "view_requirement")) {
                builder.viewRequirements(this.getRequirements(c, currentPath + "view_requirement"));
            }
            if (c.contains(currentPath + "click_commands")) {
                builder.clickHandler(this.getClickHandler(c, currentPath + "click_commands"));
                if (c.contains(currentPath + "click_requirement")) {
                    builder.clickRequirements(this.getRequirements(c, currentPath + "click_requirement"));
                }
            }
            if (c.contains(currentPath + "left_click_commands")) {
                builder.leftClickHandler(this.getClickHandler(c, currentPath + "left_click_commands"));
                if (c.contains(currentPath + "left_click_requirement")) {
                    builder.leftClickRequirements(this.getRequirements(c, currentPath + "left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "right_click_commands")) {
                builder.rightClickHandler(this.getClickHandler(c, currentPath + "right_click_commands"));
                if (c.contains(currentPath + "right_click_requirement")) {
                    builder.rightClickRequirements(this.getRequirements(c, currentPath + "right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_left_click_commands")) {
                builder.shiftLeftClickHandler(this.getClickHandler(c, currentPath + "shift_left_click_commands"));
                if (c.contains(currentPath + "shift_left_click_requirement")) {
                    builder.shiftLeftClickRequirements(this.getRequirements(c, currentPath + "shift_left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_right_click_commands")) {
                builder.shiftRightClickHandler(this.getClickHandler(c, currentPath + "shift_right_click_commands"));
                if (c.contains(currentPath + "shift_right_click_requirement")) {
                    builder.shiftRightClickRequirements(this.getRequirements(c, currentPath + "shift_right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "middle_click_commands")) {
                builder.middleClickHandler(this.getClickHandler(c, currentPath + "middle_click_commands"));
                if (c.contains(currentPath + "middle_click_requirement")) {
                    builder.middleClickRequirements(this.getRequirements(c, currentPath + "middle_click_requirement"));
                }
            }
            ArrayList<Integer> slots = new ArrayList<Integer>();
            if (c.contains(currentPath + "slots") && c.isList(currentPath + "slots")) {
                List confSlots = c.getStringList(currentPath + "slots");
                for (String slot : confSlots) {
                    String[] values = slot.split("-", 2);
                    if (values.length == 2) {
                        for (int i = Integer.parseInt(values[0]); i <= Integer.parseInt(values[1]); ++i) {
                            slots.add(i);
                        }
                        continue;
                    }
                    slots.add(Integer.parseInt(slot));
                }
            } else {
                slots.add(c.getInt(currentPath + "slot", 0));
            }
            MenuItem menuItem = new MenuItem(this.plugin, builder.build());
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                TreeMap slotPriorityMap;
                int slot = (Integer)iterator.next();
                if (!menuItems.containsKey(slot) || menuItems.get(slot) == null) {
                    slotPriorityMap = new TreeMap();
                    menuItems.put(slot, slotPriorityMap);
                } else {
                    slotPriorityMap = (TreeMap)menuItems.get(slot);
                }
                slotPriorityMap.put(menuItem.options().priority(), new MenuItem(this.plugin, menuItem.options().asBuilder().slot(slot).build()));
            }
        }
        return menuItems;
    }

    /*
     * Unable to fully structure code
     */
    private RequirementList getRequirements(FileConfiguration c, String path) {
        this.debug(new String[]{"requirement path: " + path});
        requirements = new ArrayList<Requirement>();
        if (!c.contains(path + ".requirements")) {
            this.debug(new String[]{"requirements list was not found"});
            return null;
        }
        this.debug(new String[]{"found requirements list"});
        for (String key : c.getConfigurationSection(path + ".requirements").getKeys(false)) {
            this.debug(new String[]{"requirement: " + key + " from requirements list"});
            rPath = path + ".requirements." + key;
            if (!c.contains(rPath + ".type")) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"No type set for requirement: " + key + " for path: " + rPath});
                continue;
            }
            stringType = c.getString(rPath + ".type");
            type = RequirementType.getType(stringType);
            if (type == null) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Requirement type '" + stringType + "' at path '" + rPath + "' is not valid!"});
                continue;
            }
            this.debug(new String[]{"Requirement type: " + type.name()});
            req = null;
            switch (2.$SwitchMap$com$extendedclip$deluxemenus$requirement$RequirementType[type.ordinal()]) {
                case 1: 
                case 2: {
                    wrapper = new ItemWrapper();
                    if (!c.contains(rPath + ".material")) ** GOTO lbl33
                    materialName = c.getString(rPath + ".material");
                    try {
                        if (DeluxeMenusConfig.containsPlaceholders(materialName) || this.plugin.getItemHooks().values().stream().filter((Predicate<ItemHook>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getRequirements$0(java.lang.String com.extendedclip.deluxemenus.hooks.ItemHook ), (Lcom/extendedclip/deluxemenus/hooks/ItemHook;)Z)((String)materialName)).findFirst().orElse(null) != null) ** GOTO lbl35
                        Material.valueOf((String)materialName.toUpperCase());
                        ** GOTO lbl35
                    }
                    catch (Exception ex) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"has item requirement at path: " + rPath + " does not specify a valid Material name!"});
                        break;
                    }
lbl33:
                    // 1 sources

                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"has item requirement at path: " + rPath + " does not contain a material: entry!"});
                    break;
lbl35:
                    // 2 sources

                    wrapper.setMaterial(materialName);
                    wrapper.setAmount(c.getInt(rPath + ".amount", 1));
                    wrapper.hasData(c.contains(rPath + ".data") != false && c.isInt(rPath + ".data") != false);
                    wrapper.setData((short)c.getInt(rPath + ".data", 0));
                    if (c.isString(rPath + ".name")) {
                        wrapper.setName(c.getString(rPath + ".name"));
                    }
                    if (c.isString(rPath + ".lore")) {
                        wrapper.setLore(c.getString(rPath + ".lore"));
                    }
                    if (c.isList(rPath + ".lore")) {
                        wrapper.setLoreList(c.getStringList(rPath + ".lore"));
                    }
                    wrapper.setStrict(c.getBoolean(rPath + ".strict", false));
                    wrapper.setArmor(c.getBoolean(rPath + ".armor", false));
                    wrapper.setOffhand(c.getBoolean(rPath + ".offhand", false));
                    if (c.contains(rPath + ".model_data") && c.isInt(rPath + ".model_data")) {
                        wrapper.setCustomData(c.getInt(rPath + ".model_data"));
                    } else {
                        wrapper.setCustomData(c.getInt(rPath + ".modeldata", 0));
                    }
                    if (c.contains(rPath + ".model_data_component") && c.isConfigurationSection(rPath + ".model_data_component") && (modelDataComponent = c.getConfigurationSection(rPath + ".model_data_component")) != null) {
                        wrapper.setCustomModelDataComponent(CustomModelDataComponent.builder().colors(modelDataComponent.getStringList("colors")).flags(modelDataComponent.getStringList("flags")).floats(modelDataComponent.getStringList("floats")).strings(modelDataComponent.getStringList("strings")));
                    }
                    if (c.contains(rPath + ".name_contains")) {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name_contains"));
                    } else {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name-contains", false));
                    }
                    if (c.contains(rPath + ".name_ignorecase")) {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name_ignorecase"));
                    } else {
                        wrapper.setNameContains(c.getBoolean(rPath + ".name-ignorecase", false));
                    }
                    if (c.contains(rPath + ".lore_contains")) {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore_contains"));
                    } else {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore-contains", false));
                    }
                    if (c.contains(rPath + ".lore_ignorecase")) {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore_ignorecase"));
                    } else {
                        wrapper.setLoreContains(c.getBoolean(rPath + ".lore-ignorecase", false));
                    }
                    invert = type == RequirementType.DOES_NOT_HAVE_ITEM;
                    req = new HasItemRequirement(this.plugin, wrapper, invert);
                    break;
                }
                case 3: 
                case 4: {
                    if (c.contains(rPath + ".permission")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_PERMISSION;
                        req = new HasPermissionRequirement(c.getString(rPath + ".permission"), invert);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permission requirement at path: " + rPath + " does not contain a permission: entry"});
                    break;
                }
                case 5: 
                case 6: {
                    if (c.contains(rPath + ".permissions")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_PERMISSIONS;
                        minimum = -1;
                        if (c.contains(rPath + ".minimum") && (minimum = c.getInt(rPath + ".minimum")) < 1) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permissions requirement at path: " + rPath + " has a minimum lower than 1. All permissions will be checked"});
                            minimum = -1;
                        }
                        if ((permissions = c.getStringList(rPath + ".permissions")).isEmpty()) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permissions requirement at path: " + rPath + " has no permissions to check. Ignoring..."});
                            break;
                        }
                        if (minimum > permissions.size()) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permissions requirement at path: " + rPath + " has a minimum higher than the amount of permissions. Using " + permissions.size() + " instead"});
                            minimum = permissions.size();
                        }
                        req = new HasPermissionsRequirement(permissions, minimum, invert);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Permissions requirement at path: " + rPath + " does not contain permissions: entry"});
                    break;
                }
                case 7: {
                    if (c.contains(rPath + ".expression")) {
                        req = new JavascriptRequirement(this.plugin, c.getString(rPath + ".expression"));
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Javascript requirement at path: " + rPath + " does not contain an expression: entry"});
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".output")) {
                        req = new InputResultRequirement(type, c.getString(rPath + ".input"), c.getString(rPath + ".output"));
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Requirement at path: " + rPath + " does not contain the input: and/or the output: entries"});
                    break;
                }
                case 20: 
                case 21: {
                    if (c.contains(rPath + ".amount") || c.contains(rPath + ".placeholder")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_MONEY;
                        req = new HasMoneyRequirement(this.plugin, c.getDouble(rPath + ".amount"), invert, c.getString(rPath + ".placeholder", null));
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Money requirement at path: " + rPath + " does not contain an amount: entry"});
                    break;
                }
                case 22: 
                case 23: {
                    if (c.contains(rPath + ".amount")) {
                        if (!DeluxeMenusConfig.containsPlaceholders(c.getString(rPath + ".amount")) && !c.isInt(rPath + ".amount")) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Value at path: " + rPath + ".amount is not a placeholder or a number"});
                            break;
                        }
                        invert = type == RequirementType.DOES_NOT_HAVE_EXP;
                        req = new HasExpRequirement(this.plugin, c.getString(rPath + ".amount"), invert, c.getBoolean(rPath + ".level"));
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Exp requirement at path: " + rPath + " does not contain an amount: entry"});
                    break;
                }
                case 24: 
                case 25: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".regex")) {
                        p = java.util.regex.Pattern.compile(c.getString(rPath + ".regex"));
                        invert = type == RequirementType.REGEX_DOES_NOT_MATCH;
                        req = new RegexMatchesRequirement(p, c.getString(rPath + ".input"), invert);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Regex requirement at path: " + rPath + " does not contain a input: or regex: entry"});
                    break;
                }
                case 26: 
                case 27: {
                    if (c.contains(rPath + ".location") && c.contains(rPath + ".distance")) {
                        invert = type == RequirementType.IS_NOT_NEAR;
                        loc = LocationUtils.deserializeLocation(c.getString(rPath + ".location"));
                        if (loc == null) {
                            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"requirement at path: " + rPath + " has an invalid location. Valid Format is: <world>,<x>,<y>,<z>"});
                        }
                        req = new IsNearRequirement(loc, c.getInt(rPath + ".distance"), invert);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Is Near requirement at path: " + rPath + " does not contain a location: or distance: entry"});
                    break;
                }
                case 28: 
                case 29: {
                    if (!VersionHelper.IS_PDC_VERSION) {
                        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Meta requirement is not available for your server version!"});
                        break;
                    }
                    if (c.contains(rPath + ".key") && c.contains(rPath + ".meta_type") && c.contains(rPath + ".value")) {
                        metaKey = c.getString(rPath + ".key");
                        invert = type == RequirementType.DOES_NOT_HAVE_META;
                        req = new HasMetaRequirement(this.plugin, metaKey, c.getString(rPath + ".meta_type").toUpperCase(), c.getString(rPath + ".value"), invert);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"Has Meta requirement at path: " + rPath + " does not contain the key:, meta_type: and/or value: entries!"});
                    break;
                }
                case 30: {
                    if (c.contains(rPath + ".input") && (c.contains(rPath + ".min") || c.contains(rPath + ".max"))) {
                        min = c.getInt(rPath + ".min", 0);
                        max = null;
                        if (c.contains(rPath + ".max")) {
                            max = c.getInt(rPath + ".max");
                        }
                        req = new StringLengthRequirement(c.getString(rPath + ".input"), min, max);
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"String length requirement at path: " + rPath + " does not contain an input: or one of (min: or max:)"});
                    break;
                }
                case 31: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".object")) {
                        req = new IsObjectRequirement(c.getString(rPath + ".input"), c.getString(rPath + ".object"));
                        break;
                    }
                    this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, new String[]{"String length requirement at path: " + rPath + " does not contain an input: or object:"});
                    break;
                }
            }
            if (req == null) continue;
            requirementSuccessHandler = null;
            requirementDenyHandler = null;
            if (c.contains(rPath + ".success_commands")) {
                this.debug(new String[]{"Requirement has success commands"});
                requirementSuccessHandler = this.getClickHandler(c, rPath + ".success_commands");
            }
            if (c.contains(rPath + ".deny_commands")) {
                this.debug(new String[]{"Requirement has deny commands"});
                requirementDenyHandler = this.getClickHandler(c, rPath + ".deny_commands");
            }
            req.setOptional(c.getBoolean(rPath + ".optional", false));
            req.setSuccessHandler(requirementSuccessHandler);
            req.setDenyHandler(requirementDenyHandler);
            requirements.add(req);
        }
        if (requirements.isEmpty()) {
            return null;
        }
        list = new RequirementList(requirements);
        if (c.contains(path + ".deny_commands")) {
            this.debug(new String[]{"global deny handler found"});
            list.setDenyHandler(this.getClickHandler(c, path + ".deny_commands"));
        }
        list.setStopAtSuccess(c.getBoolean(path + ".stop_at_success", false));
        if (c.contains(path + ".minimum_requirements")) {
            list.setMinimumRequirements(c.getInt(path + ".minimum_requirements"));
        } else {
            required = 0;
            for (Requirement req : requirements) {
                if (req.isOptional()) continue;
                required = required++;
            }
            list.setMinimumRequirements(required);
        }
        return list;
    }

    private ClickHandler getClickHandler(FileConfiguration c, String configPath) {
        List commands = c.getStringList(configPath);
        if (commands.isEmpty()) {
            return null;
        }
        final ArrayList<ClickAction> actions = new ArrayList<ClickAction>();
        for (String command : commands) {
            Matcher ch;
            ActionType type;
            if (command == null || command.isEmpty() || (type = ActionType.getByStart(command)) == null) continue;
            if ((command = command.replaceFirst(java.util.regex.Pattern.quote(type.getIdentifier()), "")).startsWith(" ")) {
                command = command.trim();
            }
            ClickAction action = new ClickAction(type, command);
            Matcher d = DELAY_MATCHER.matcher(command);
            if (d.find()) {
                action.setDelay(d.group(1));
                command = command.replaceFirst(java.util.regex.Pattern.quote(d.group()), "");
            }
            if ((ch = CHANCE_MATCHER.matcher(command)).find()) {
                action.setChance(ch.group(1));
                command = command.replaceFirst(java.util.regex.Pattern.quote(ch.group()), "");
            }
            action.setExecutable(command);
            actions.add(action);
        }
        ClickHandler handler = null;
        if (!actions.isEmpty()) {
            handler = new ClickHandler(){

                @Override
                public void onClick(@NotNull MenuHolder holder) {
                    for (ClickAction action : actions) {
                        if (!action.checkChance(holder)) continue;
                        ClickActionTask actionTask = new ClickActionTask(DeluxeMenusConfig.this.plugin, holder.getViewer().getUniqueId(), action.getType(), action.getExecutable(), holder.getTypedArgs(), holder.parsePlaceholdersInArguments(), holder.parsePlaceholdersAfterArguments());
                        if (action.hasDelay()) {
                            actionTask.runTaskLater((Plugin)DeluxeMenusConfig.this.plugin, action.getDelay(holder));
                            continue;
                        }
                        actionTask.runTask((Plugin)DeluxeMenusConfig.this.plugin);
                    }
                }
            };
        }
        return handler;
    }

    private void checkForDeprecatedItemOptions(ConfigurationSection config, String menuName) {
        BiConsumer<String, ItemFlag> oldItemFlagOptionCheck = (option, itemFlag) -> {
            if (!config.contains(option)) {
                return;
            }
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, String.format("Option '%s' of item '%s' in menu '%s' is deprecated and will be removed in the future. Replace it with item_flags: [%s].", option, config.getName(), menuName, itemFlag));
        };
        oldItemFlagOptionCheck.accept("hide_attributes", ItemFlag.HIDE_ATTRIBUTES);
        oldItemFlagOptionCheck.accept("hide_enchantments", ItemFlag.HIDE_ENCHANTS);
        oldItemFlagOptionCheck.accept("hide_unbreakable", ItemFlag.HIDE_UNBREAKABLE);
    }

    public void debug(String ... messages) {
        this.plugin.debug(DebugLevel.LOWEST, Level.INFO, messages);
    }

    @NotNull
    public DebugLevel debugLevel() {
        String stringLevel = this.plugin.getConfig().getString("debug", "HIGHEST");
        if (stringLevel.equalsIgnoreCase("true")) {
            stringLevel = "LOWEST";
            this.plugin.getConfig().set("debug", (Object)"LOWEST");
        } else if (stringLevel.equalsIgnoreCase("false")) {
            stringLevel = "HIGHEST";
            this.plugin.getConfig().set("debug", (Object)"HIGHEST");
        }
        DebugLevel debugLevel = DebugLevel.getByName(stringLevel);
        return debugLevel == null ? DebugLevel.LOW : debugLevel;
    }

    public File getMenuDirector() {
        return this.menuDirectory;
    }

    public void addEnchantmentsOptionToBuilder(FileConfiguration c, String currentPath, String itemKey, String menuName, MenuItemOptions.MenuItemOptionsBuilder builder) {
        if (!c.contains(currentPath + "enchantments")) {
            return;
        }
        List configEnchantments = c.getStringList(currentPath + "enchantments");
        HashMap<Enchantment, Integer> parsedEnchantments = new HashMap<Enchantment, Integer>();
        for (String configEnchantment : configEnchantments) {
            Integer level;
            if (configEnchantment == null || !configEnchantment.contains(";")) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment format '" + configEnchantment + "' is incorrect for item " + itemKey + " in GUI " + menuName + "!", "Correct format: - '<Enchantment name>;<level>");
                continue;
            }
            String[] parts = configEnchantment.split(";", 2);
            if (parts.length != 2 || parts[0] == null || parts[1] == null) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment format '" + configEnchantment + "' is incorrect for item " + itemKey + " in GUI " + menuName + "!", "Correct format: - '<Enchantment name>;<level>");
                continue;
            }
            Enchantment enchantment = Enchantment.getByName((String)parts[0].strip().toUpperCase());
            if (enchantment == null) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment '" + parts[0].strip() + "' for item " + itemKey + " in menu " + menuName + " is not a valid enchantment name!");
            }
            if ((level = Ints.tryParse((String)parts[1].strip())) == null) {
                level = 1;
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Enchantment level '" + parts[1].strip() + "' is incorrect for item " + itemKey + " in menu " + menuName + "!");
            }
            parsedEnchantments.put(enchantment, level);
        }
        builder.enchantments(parsedEnchantments);
    }

    public void addDamageOptionToBuilder(FileConfiguration c, String currentPath, String itemKey, String menuName, MenuItemOptions.MenuItemOptionsBuilder builder) {
        boolean damageOptionIsPresent = false;
        String damageValue = null;
        String key = "damage";
        if (c.contains(currentPath + key)) {
            damageOptionIsPresent = true;
            damageValue = c.getString(currentPath + key, "");
        }
        if (c.contains(currentPath + (key = "data"))) {
            if (!damageOptionIsPresent) {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Found 'data' option for item: " + itemKey + " in menu: " + menuName + ". This option is deprecated and will be removed soon. Please use 'damage' instead.");
                damageValue = c.getString(currentPath + key, "");
            } else {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Found 'data' and 'damage' options for item: " + itemKey + " in menu: " + menuName + ". 'data' option is deprecated and will be ignored. Using 'damage' instead.");
            }
        }
        if (damageValue == null) {
            return;
        }
        if (damageOptionIsPresent) {
            key = "damage";
        }
        if (!ItemUtils.isPlaceholderOption(damageValue) && Ints.tryParse((String)damageValue) == null) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Found invalid value for '" + key + "' option for item: " + itemKey + " in menu: " + menuName + ".", "The correct formats for '" + key + "' are:", "  -> <number>", "  -> placeholder-<placeholder>", "Ignoring the invalid value.");
            return;
        }
        String[] parts = damageValue.split("-", 2);
        if (parts.length >= 2 && !DeluxeMenusConfig.containsPlaceholders(parts[1])) {
            this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Could not find placeholder for '" + key + "' option for item: " + itemKey + " in menu: " + menuName + ".", "Ignoring the invalid value.");
            return;
        }
        builder.damage(parts.length == 1 ? parts[0] : parts[1]);
    }

    private static /* synthetic */ boolean lambda$getRequirements$0(String materialName, ItemHook x) {
        return materialName.toLowerCase().startsWith(x.getPrefix());
    }

    static {
        VALID_MATERIALS.addAll(Constants.PLAYER_ITEMS);
        VALID_MATERIALS.add("water_bottle");
        VALID_MATERIAL_PREFIXES.add("placeholder-");
    }
}

