/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.utils.SkullUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BaseHeadHook
implements ItemHook,
SimpleCache {
    private final DeluxeMenus plugin;
    private final Map<String, ItemStack> cache = new ConcurrentHashMap<String, ItemStack>();

    public BaseHeadHook(@NotNull DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    @Override
    public ItemStack getItem(String ... arguments) {
        if (arguments.length == 0) {
            return this.plugin.getHead().clone();
        }
        try {
            return this.cache.computeIfAbsent(arguments[0], value -> SkullUtils.getSkullByBase64EncodedTextureUrl(this.plugin, value)).clone();
        }
        catch (Exception exception) {
            this.plugin.printStacktrace("Something went wrong while trying to get base64 head: " + arguments[0], exception);
            return this.plugin.getHead().clone();
        }
    }

    @Override
    public boolean itemMatchesIdentifiers(@NotNull ItemStack item, String ... arguments) {
        if (arguments.length == 0) {
            return false;
        }
        String itemTexture = SkullUtils.getTextureFromSkull(this.plugin, item);
        String texture = SkullUtils.decodeSkinUrl(arguments[0]);
        if (itemTexture == null || texture == null) {
            return false;
        }
        texture = texture.substring("https://textures.minecraft.net/texture/".length() - 1);
        return texture.equals(itemTexture);
    }

    @Override
    public String getPrefix() {
        return "basehead-";
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

