/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.listener.Listener;
import com.extendedclip.deluxemenus.utils.SkullUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class NamedHeadHook
extends Listener
implements ItemHook,
SimpleCache {
    private final Map<String, ItemStack> cache = new ConcurrentHashMap<String, ItemStack>();

    public NamedHeadHook(@NotNull DeluxeMenus plugin) {
        super(plugin);
    }

    @Override
    public ItemStack getItem(String ... arguments) {
        if (arguments.length == 0) {
            return this.plugin.getHead().clone();
        }
        try {
            return this.cache.computeIfAbsent(arguments[0], value -> SkullUtils.getSkullByName(this.plugin, value)).clone();
        }
        catch (Exception exception) {
            this.plugin.printStacktrace("Something went wrong while trying to get a head by name: " + arguments[0], exception);
            return this.plugin.getHead().clone();
        }
    }

    @Override
    public boolean itemMatchesIdentifiers(@NotNull ItemStack item, String ... arguments) {
        if (arguments.length == 0) {
            return false;
        }
        return arguments[0].equalsIgnoreCase(SkullUtils.getSkullOwner(item));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.cache.remove(event.getPlayer().getName());
    }

    @Override
    public String getPrefix() {
        return "head-";
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }
}

