/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.hooks;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.cache.SimpleCache;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.valeriishymchuk.simpleitemgenerator.api.SimpleItemGenerator;

public class SimpleItemGeneratorHook
implements ItemHook,
SimpleCache {
    private final Map<String, ItemStack> cache = new ConcurrentHashMap<String, ItemStack>();
    private final DeluxeMenus plugin;

    public SimpleItemGeneratorHook(DeluxeMenus plugin) {
        this.plugin = plugin;
    }

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @Override
    public ItemStack getItem(@NotNull Player holder, String ... arguments) {
        if (arguments.length == 0) {
            return this.errorItem("Item arguments are absent.", new Object[0]);
        }
        ItemStack item = this.cache.computeIfAbsent(arguments[0], id -> SimpleItemGenerator.get().bakeItem(id, holder).orElse(null));
        return item == null ? this.errorItem("Item %s wasn't found by SimpleItemGenerator.", arguments[0]) : item.clone();
    }

    private ItemStack errorItem(String error, Object ... args) {
        ItemStack item = new ItemStack(Material.STONE, 1);
        this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, String.format(error, args));
        return item;
    }

    @Override
    public boolean itemMatchesIdentifiers(@NotNull ItemStack item, String ... arguments) {
        if (arguments.length == 0) {
            return false;
        }
        return SimpleItemGenerator.get().getCustomItemKey(item).map(s -> arguments[0].equals(s)).orElse(false);
    }

    @Override
    public String getPrefix() {
        return "simpleitemgenerator-";
    }
}

