/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.menu.options.MenuOptions;
import com.extendedclip.deluxemenus.utils.StringUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class MenuHolder
implements InventoryHolder {
    private final DeluxeMenus plugin;
    private final Player viewer;
    private Player placeholderPlayer;
    private String menuName;
    private Set<MenuItem> activeItems;
    private BukkitTask updateTask = null;
    private Inventory inventory;
    private boolean updating;
    private boolean parsePlaceholdersInArguments;
    private boolean parsePlaceholdersAfterArguments;
    private Map<String, String> typedArgs;

    public MenuHolder(@NotNull DeluxeMenus plugin, @NotNull Player viewer) {
        this.plugin = plugin;
        this.viewer = viewer;
    }

    public MenuHolder(@NotNull DeluxeMenus plugin, @NotNull Player viewer, @NotNull String menuName, @NotNull @NotNull Set<@NotNull MenuItem> activeItems, @NotNull Inventory inventory) {
        this.plugin = plugin;
        this.viewer = viewer;
        this.menuName = menuName;
        this.activeItems = activeItems;
        this.inventory = inventory;
    }

    public String getViewerName() {
        return this.viewer.getName();
    }

    public BukkitTask getUpdateTask() {
        return this.updateTask;
    }

    public Player getViewer() {
        return this.viewer;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public Set<MenuItem> getActiveItems() {
        return this.activeItems;
    }

    public void setActiveItems(Set<MenuItem> items) {
        this.activeItems = items;
    }

    public MenuHolder getHolder() {
        return this;
    }

    public MenuItem getItem(int slot) {
        for (MenuItem item : this.activeItems) {
            if (item.options().slot() != slot) continue;
            return item;
        }
        return null;
    }

    public Optional<Menu> getMenu() {
        return Menu.getMenuByName(this.menuName);
    }

    @NotNull
    public String setPlaceholdersAndArguments(@NotNull String string) {
        if (this.parsePlaceholdersAfterArguments) {
            return this.setPlaceholders(this.setArguments(string));
        }
        return this.setArguments(this.setPlaceholders(string));
    }

    @NotNull
    public String setPlaceholders(@NotNull String string) {
        Player player;
        Player player2 = player = this.placeholderPlayer != null ? this.placeholderPlayer : this.getViewer();
        if (player == null) {
            return string;
        }
        return StringUtils.replacePlaceholders(string, player);
    }

    @NotNull
    public String setArguments(@NotNull String string) {
        Player player = this.placeholderPlayer != null ? this.placeholderPlayer : this.getViewer();
        return StringUtils.replaceArguments(string, this.typedArgs, player, this.parsePlaceholdersInArguments);
    }

    public void refreshMenu() {
        Optional<Menu> optionalMenu = this.getMenu();
        if (optionalMenu.isEmpty()) {
            return;
        }
        Menu menu = optionalMenu.get();
        if (menu.getMenuItems().isEmpty()) {
            return;
        }
        this.setUpdating(true);
        this.stopPlaceholderUpdate();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            HashSet<MenuItem> active = new HashSet<MenuItem>();
            for (int i = 0; i < this.getInventory().getSize(); ++i) {
                TreeMap<Integer, MenuItem> e = menu.getMenuItems().get(i);
                if (e == null) {
                    this.getInventory().setItem(i, null);
                    continue;
                }
                boolean m = false;
                for (MenuItem item : e.values()) {
                    if (item.options().viewRequirements().isPresent()) {
                        if (!item.options().viewRequirements().get().evaluate(this)) continue;
                        m = true;
                        active.add(item);
                        break;
                    }
                    m = true;
                    active.add(item);
                    break;
                }
                if (m) continue;
                this.getInventory().setItem(i, null);
            }
            if (active.isEmpty()) {
                Menu.closeMenu(this.plugin, this.getViewer(), true);
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                boolean update = false;
                for (MenuItem item : active) {
                    ItemStack iStack = item.getItemStack(this);
                    int slot = item.options().slot();
                    if (slot >= menu.options().size()) continue;
                    if (item.options().updatePlaceholders()) {
                        update = true;
                    }
                    this.getInventory().setItem(item.options().slot(), iStack);
                }
                this.setActiveItems(active);
                if (update) {
                    this.startUpdatePlaceholdersTask();
                }
                this.setUpdating(false);
            });
        });
    }

    public void stopPlaceholderUpdate() {
        if (this.updateTask != null) {
            try {
                this.updateTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateTask = null;
        }
    }

    public void startUpdatePlaceholdersTask() {
        if (this.updateTask != null) {
            this.stopPlaceholderUpdate();
        }
        this.updateTask = new BukkitRunnable(){

            public void run() {
                if (MenuHolder.this.updating) {
                    return;
                }
                Set<MenuItem> items = MenuHolder.this.getActiveItems();
                if (items == null) {
                    return;
                }
                for (MenuItem item : items) {
                    ItemStack i;
                    if (!item.options().updatePlaceholders() || (i = MenuHolder.this.inventory.getItem(item.options().slot())) == null) continue;
                    int amt = i.getAmount();
                    if (item.options().dynamicAmount().isPresent()) {
                        try {
                            amt = Integer.parseInt(MenuHolder.this.setPlaceholdersAndArguments(item.options().dynamicAmount().get()));
                            if (amt <= 0) {
                                amt = 1;
                            }
                        }
                        catch (Exception exception) {
                            MenuHolder.this.plugin.printStacktrace("Something went wrong while updating item in slot " + item.options().slot() + ". Invalid dynamic amount: " + MenuHolder.this.setPlaceholdersAndArguments(item.options().dynamicAmount().get()), exception);
                        }
                    }
                    ItemMeta meta = i.getItemMeta();
                    if (item.options().displayNameHasPlaceholders() && item.options().displayName().isPresent()) {
                        meta.setDisplayName(StringUtils.color(MenuHolder.this.setPlaceholdersAndArguments(item.options().displayName().get())));
                    }
                    if (item.options().loreHasPlaceholders()) {
                        meta.setLore(item.getMenuItemLore(MenuHolder.this.getHolder(), item.options().lore()));
                    }
                    i.setItemMeta(meta);
                    i.setAmount(amt);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 20L, 20L * (long)Menu.getMenuByName(this.menuName).map(Menu::options).map(MenuOptions::updateInterval).orElse(10).intValue());
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory i) {
        this.inventory = i;
    }

    public Map<String, String> getTypedArgs() {
        return this.typedArgs;
    }

    public void setTypedArgs(Map<String, String> typedArgs) {
        this.typedArgs = typedArgs;
    }

    public void parsePlaceholdersInArguments(boolean parsePlaceholdersInArguments) {
        this.parsePlaceholdersInArguments = parsePlaceholdersInArguments;
    }

    public void parsePlaceholdersAfterArguments(boolean parsePlaceholdersAfterArguments) {
        this.parsePlaceholdersAfterArguments = parsePlaceholdersAfterArguments;
    }

    public boolean parsePlaceholdersInArguments() {
        return this.parsePlaceholdersInArguments;
    }

    public boolean parsePlaceholdersAfterArguments() {
        return this.parsePlaceholdersAfterArguments;
    }

    public void setPlaceholderPlayer(Player placeholderPlayer) {
        this.placeholderPlayer = placeholderPlayer;
    }

    public Player getPlaceholderPlayer() {
        return this.placeholderPlayer;
    }

    @NotNull
    public DeluxeMenus getPlugin() {
        return this.plugin;
    }
}

