/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.command;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.utils.DebugLevel;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RegistrableMenuCommand
extends Command {
    private static final String FALLBACK_PREFIX = "DeluxeMenus".toLowerCase(Locale.ROOT).trim();
    private static CommandMap commandMap = null;
    private final DeluxeMenus plugin;
    private Menu menu;
    private boolean registered = false;
    private boolean unregistered = false;

    public RegistrableMenuCommand(@NotNull DeluxeMenus plugin, @NotNull Menu menu) {
        super(menu.options().commands().isEmpty() ? menu.options().name() : menu.options().commands().get(0));
        this.plugin = plugin;
        this.menu = menu;
        if (menu.options().commands().size() > 1) {
            this.setAliases(menu.options().commands().subList(1, menu.options().commands().size()));
        }
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] typedArgs) {
        if (this.unregistered) {
            throw new IllegalStateException("This command was unregistered!");
        }
        if (!(sender instanceof Player)) {
            Msg.msg((CommandSender)sender, (String[])new String[]{"Menus can only be opened by players!"});
            return true;
        }
        HashMap<String, String> argMap = null;
        if (!this.menu.options().arguments().isEmpty()) {
            this.plugin.debug(DebugLevel.LOWEST, Level.INFO, "has args");
            if (typedArgs.length < this.menu.options().arguments().size()) {
                if (this.menu.options().argumentsUsageMessage().isPresent()) {
                    Msg.msg((CommandSender)sender, (String[])new String[]{this.menu.options().argumentsUsageMessage().get()});
                }
                return true;
            }
            argMap = new HashMap<String, String>();
            int index = 0;
            for (String arg : this.menu.options().arguments()) {
                if (index + 1 == this.menu.options().arguments().size()) {
                    String last = String.join((CharSequence)" ", Arrays.asList(typedArgs).subList(index, typedArgs.length));
                    this.plugin.debug(DebugLevel.LOWEST, Level.INFO, "arg: " + arg + " => " + last);
                    argMap.put(arg, last);
                } else {
                    argMap.put(arg, typedArgs[index]);
                    this.plugin.debug(DebugLevel.LOWEST, Level.INFO, "arg: " + arg + " => " + typedArgs[index]);
                }
                ++index;
            }
        }
        Player player = (Player)sender;
        this.plugin.debug(DebugLevel.LOWEST, Level.INFO, "opening menu: " + this.menu.options().name());
        this.menu.openMenu(player, argMap, null);
        return true;
    }

    public void register() {
        boolean registered;
        if (this.registered) {
            throw new IllegalStateException("This command was already registered!");
        }
        this.registered = true;
        if (commandMap == null) {
            try {
                Field f = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                f.setAccessible(true);
                commandMap = (CommandMap)f.get(Bukkit.getServer());
            }
            catch (Exception exception) {
                this.plugin.printStacktrace("Something went wrong while trying to register command: " + this.getName(), exception);
                return;
            }
        }
        if (registered = commandMap.register(FALLBACK_PREFIX, (Command)this)) {
            this.plugin.debug(DebugLevel.LOW, Level.INFO, "Registered command: " + this.getName() + " for menu: " + this.menu.options().name());
        }
    }

    public void unregister() {
        if (!this.registered) {
            throw new IllegalStateException("This command was not registered!");
        }
        if (this.unregistered) {
            throw new IllegalStateException("This command was already unregistered!");
        }
        this.unregistered = true;
        if (commandMap == null) {
            this.menu = null;
            return;
        }
        try {
            Field cMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            cMap.setAccessible(true);
            Field knownCommands = SimpleCommandMap.class.getDeclaredField("knownCommands");
            knownCommands.setAccessible(true);
            Map knownCommandsMap = (Map)knownCommands.get(cMap.get(Bukkit.getServer()));
            knownCommandsMap.remove(this.getName());
            knownCommandsMap.remove(FALLBACK_PREFIX + ":" + this.getName());
            for (String alias : this.getAliases()) {
                knownCommandsMap.remove(alias);
                knownCommandsMap.remove(FALLBACK_PREFIX + ":" + alias);
            }
            boolean unregistered = this.unregister((CommandMap)cMap.get(Bukkit.getServer()));
            this.unregister(commandMap);
            if (unregistered) {
                this.plugin.debug(DebugLevel.HIGH, Level.INFO, "Successfully unregistered command: " + this.getName());
            } else {
                this.plugin.debug(DebugLevel.HIGHEST, Level.WARNING, "Failed to unregister command: " + this.getName());
            }
        }
        catch (Exception exception) {
            this.plugin.printStacktrace("Something went wrong while trying to unregister command: " + this.getName(), exception);
        }
        this.menu = null;
    }

    public boolean registered() {
        return this.registered;
    }
}

