/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.options;

import java.util.Locale;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public enum HeadType {
    NAMED("namedhead", "head-"),
    TEXTURE("texture", "texture-"),
    HDB("hdb", "hdb-"),
    BASE64("basehead", "basehead-");

    private static final HeadType[] VALUES;
    private final String hookName;
    private final String prefix;

    private HeadType(String hookName, String prefix) {
        this.hookName = hookName;
        this.prefix = prefix;
    }

    public String getHookName() {
        return this.hookName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static Optional<HeadType> parseHeadType(@NotNull String string) {
        for (HeadType type : VALUES) {
            if (!string.startsWith(type.getPrefix().toLowerCase(Locale.ROOT))) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<HeadType> getHeadType(@NotNull String string) {
        for (HeadType type : VALUES) {
            if (!type.getPrefix().equalsIgnoreCase(string)) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    static {
        VALUES = HeadType.values();
    }
}

