/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.options;

import com.extendedclip.deluxemenus.action.ClickHandler;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.menu.options.CustomModelDataComponent;
import com.extendedclip.deluxemenus.menu.options.HeadType;
import com.extendedclip.deluxemenus.menu.options.LoreAppendMode;
import com.extendedclip.deluxemenus.requirement.RequirementList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.potion.PotionEffect;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuItemOptions {
    private final String material;
    private final String damage;
    private final int amount;
    private final String customModelData;
    private final CustomModelDataComponent customModelDataComponent;
    private final String dynamicAmount;
    private final String lightLevel;
    private final String displayName;
    private final List<String> lore;
    private final DyeColor baseColor;
    private HeadType headType;
    private final String rgb;
    private final String trimMaterial;
    private final String trimPattern;
    private final String hideTooltip;
    private final String enchantmentGlintOverride;
    private final String rarity;
    private final String tooltipStyle;
    private final String itemModel;
    private final Map<Enchantment, Integer> enchantments;
    private final List<PotionEffect> potionEffects;
    private final List<Pattern> bannerMeta;
    private final Set<ItemFlag> itemFlags = new HashSet<ItemFlag>();
    private final boolean unbreakable;
    private final boolean displayNameHasPlaceholders;
    private final boolean loreHasPlaceholders;
    private final boolean hasLore;
    private final LoreAppendMode loreAppendMode;
    private final String nbtString;
    private final String nbtByte;
    private final String nbtShort;
    private final String nbtInt;
    private final List<String> nbtStrings;
    private final List<String> nbtBytes;
    private final List<String> nbtShorts;
    private final List<String> nbtInts;
    private final int slot;
    private final int priority;
    private final boolean updatePlaceholders;
    private final ClickHandler clickHandler;
    private final ClickHandler leftClickHandler;
    private final ClickHandler rightClickHandler;
    private final ClickHandler shiftLeftClickHandler;
    private final ClickHandler shiftRightClickHandler;
    private final ClickHandler middleClickHandler;
    private final RequirementList viewRequirements;
    private final RequirementList clickRequirements;
    private final RequirementList leftClickRequirements;
    private final RequirementList rightClickRequirements;
    private final RequirementList shiftLeftClickRequirements;
    private final RequirementList shiftRightClickRequirements;
    private final RequirementList middleClickRequirements;

    private MenuItemOptions(@NotNull MenuItemOptionsBuilder builder) {
        this.material = builder.material;
        this.damage = builder.damage;
        this.amount = builder.amount;
        this.customModelData = builder.customModelData;
        this.customModelDataComponent = builder.customModelDataComponent;
        this.dynamicAmount = builder.dynamicAmount;
        this.lightLevel = builder.lightLevel;
        this.displayName = builder.displayName;
        this.lore = builder.lore;
        this.hasLore = builder.hasLore;
        this.loreAppendMode = builder.loreAppendMode;
        this.baseColor = builder.baseColor;
        this.headType = builder.headType;
        this.rgb = builder.rgb;
        this.trimMaterial = builder.trimMaterial;
        this.trimPattern = builder.trimPattern;
        this.hideTooltip = builder.hideTooltip;
        this.enchantmentGlintOverride = builder.enchantmentGlintOverride;
        this.rarity = builder.rarity;
        this.tooltipStyle = builder.tooltipStyle;
        this.itemModel = builder.itemModel;
        this.enchantments = builder.enchantments;
        this.potionEffects = builder.potionEffects;
        this.bannerMeta = builder.bannerMeta;
        this.itemFlags.addAll(builder.itemFlags);
        this.unbreakable = builder.unbreakable;
        this.displayNameHasPlaceholders = builder.displayNameHasPlaceholders;
        this.loreHasPlaceholders = builder.loreHasPlaceholders;
        this.nbtString = builder.nbtString;
        this.nbtByte = builder.nbtByte;
        this.nbtShort = builder.nbtShort;
        this.nbtInt = builder.nbtInt;
        this.nbtStrings = builder.nbtStrings;
        this.nbtBytes = builder.nbtBytes;
        this.nbtShorts = builder.nbtShorts;
        this.nbtInts = builder.nbtInts;
        this.slot = builder.slot;
        this.priority = builder.priority;
        this.updatePlaceholders = builder.updatePlaceholders;
        this.clickHandler = builder.clickHandler;
        this.leftClickHandler = builder.leftClickHandler;
        this.rightClickHandler = builder.rightClickHandler;
        this.shiftLeftClickHandler = builder.shiftLeftClickHandler;
        this.shiftRightClickHandler = builder.shiftRightClickHandler;
        this.middleClickHandler = builder.middleClickHandler;
        this.viewRequirements = builder.viewRequirements;
        this.clickRequirements = builder.clickRequirements;
        this.leftClickRequirements = builder.leftClickRequirements;
        this.rightClickRequirements = builder.rightClickRequirements;
        this.shiftLeftClickRequirements = builder.shiftLeftClickRequirements;
        this.shiftRightClickRequirements = builder.shiftRightClickRequirements;
        this.middleClickRequirements = builder.middleClickRequirements;
    }

    @NotNull
    public static MenuItemOptionsBuilder builder() {
        return new MenuItemOptionsBuilder();
    }

    @NotNull
    public String material() {
        return this.material;
    }

    @NotNull
    public Optional<String> damage() {
        return Optional.ofNullable(this.damage);
    }

    public int amount() {
        return this.amount;
    }

    @NotNull
    public Optional<String> customModelData() {
        return Optional.ofNullable(this.customModelData);
    }

    @NotNull
    public Optional<CustomModelDataComponent> customModelDataComponent() {
        return Optional.ofNullable(this.customModelDataComponent);
    }

    @NotNull
    public Optional<String> dynamicAmount() {
        return Optional.ofNullable(this.dynamicAmount);
    }

    @NotNull
    public Optional<String> lightLevel() {
        return Optional.ofNullable(this.lightLevel);
    }

    @NotNull
    public Optional<String> displayName() {
        return Optional.ofNullable(this.displayName);
    }

    @NotNull
    public List<String> lore() {
        return this.lore;
    }

    @NotNull
    public Optional<DyeColor> baseColor() {
        return Optional.ofNullable(this.baseColor);
    }

    public void headType(@Nullable HeadType headType) {
        this.headType = headType;
    }

    @NotNull
    public Optional<HeadType> headType() {
        return Optional.ofNullable(this.headType);
    }

    @NotNull
    public Optional<String> rgb() {
        return Optional.ofNullable(this.rgb);
    }

    @NotNull
    public Optional<String> trimMaterial() {
        return Optional.ofNullable(this.trimMaterial);
    }

    @NotNull
    public Optional<String> trimPattern() {
        return Optional.ofNullable(this.trimPattern);
    }

    @NotNull
    public Optional<String> hideTooltip() {
        return Optional.ofNullable(this.hideTooltip);
    }

    @NotNull
    public Optional<String> enchantmentGlintOverride() {
        return Optional.ofNullable(this.enchantmentGlintOverride);
    }

    @NotNull
    public Optional<String> rarity() {
        return Optional.ofNullable(this.rarity);
    }

    @NotNull
    public Optional<String> tooltipStyle() {
        return Optional.ofNullable(this.tooltipStyle);
    }

    @NotNull
    public Optional<String> itemModel() {
        return Optional.ofNullable(this.itemModel);
    }

    @NotNull
    public Map<Enchantment, Integer> enchantments() {
        return this.enchantments;
    }

    @NotNull
    public List<PotionEffect> potionEffects() {
        return this.potionEffects;
    }

    @NotNull
    public List<Pattern> bannerMeta() {
        return this.bannerMeta;
    }

    @NotNull
    public Set<ItemFlag> itemFlags() {
        return this.itemFlags;
    }

    public boolean unbreakable() {
        return this.unbreakable;
    }

    public boolean displayNameHasPlaceholders() {
        return this.displayNameHasPlaceholders;
    }

    public boolean loreHasPlaceholders() {
        return this.loreHasPlaceholders;
    }

    public boolean hasLore() {
        return this.hasLore;
    }

    @NotNull
    public Optional<LoreAppendMode> loreAppendMode() {
        return Optional.ofNullable(this.loreAppendMode);
    }

    @NotNull
    public Optional<String> nbtString() {
        return Optional.ofNullable(this.nbtString);
    }

    @NotNull
    public Optional<String> nbtByte() {
        return Optional.ofNullable(this.nbtByte);
    }

    @NotNull
    public Optional<String> nbtShort() {
        return Optional.ofNullable(this.nbtShort);
    }

    @NotNull
    public Optional<String> nbtInt() {
        return Optional.ofNullable(this.nbtInt);
    }

    @NotNull
    public List<String> nbtStrings() {
        return this.nbtStrings;
    }

    @NotNull
    public List<String> nbtBytes() {
        return this.nbtBytes;
    }

    @NotNull
    public List<String> nbtShorts() {
        return this.nbtShorts;
    }

    @NotNull
    public List<String> nbtInts() {
        return this.nbtInts;
    }

    public int slot() {
        return this.slot;
    }

    public int priority() {
        return this.priority;
    }

    public boolean updatePlaceholders() {
        return this.updatePlaceholders;
    }

    @NotNull
    public Optional<ClickHandler> clickHandler() {
        return Optional.ofNullable(this.clickHandler);
    }

    @NotNull
    public Optional<ClickHandler> leftClickHandler() {
        return Optional.ofNullable(this.leftClickHandler);
    }

    @NotNull
    public Optional<ClickHandler> rightClickHandler() {
        return Optional.ofNullable(this.rightClickHandler);
    }

    @NotNull
    public Optional<ClickHandler> shiftLeftClickHandler() {
        return Optional.ofNullable(this.shiftLeftClickHandler);
    }

    @NotNull
    public Optional<ClickHandler> shiftRightClickHandler() {
        return Optional.ofNullable(this.shiftRightClickHandler);
    }

    @NotNull
    public Optional<ClickHandler> middleClickHandler() {
        return Optional.ofNullable(this.middleClickHandler);
    }

    @NotNull
    public Optional<RequirementList> viewRequirements() {
        return Optional.ofNullable(this.viewRequirements);
    }

    @NotNull
    public Optional<RequirementList> clickRequirements() {
        return Optional.ofNullable(this.clickRequirements);
    }

    @NotNull
    public Optional<RequirementList> leftClickRequirements() {
        return Optional.ofNullable(this.leftClickRequirements);
    }

    @NotNull
    public Optional<RequirementList> rightClickRequirements() {
        return Optional.ofNullable(this.rightClickRequirements);
    }

    @NotNull
    public Optional<RequirementList> shiftLeftClickRequirements() {
        return Optional.ofNullable(this.shiftLeftClickRequirements);
    }

    @NotNull
    public Optional<RequirementList> shiftRightClickRequirements() {
        return Optional.ofNullable(this.shiftRightClickRequirements);
    }

    @NotNull
    public Optional<RequirementList> middleClickRequirements() {
        return Optional.ofNullable(this.middleClickRequirements);
    }

    @NotNull
    public MenuItemOptionsBuilder asBuilder() {
        return MenuItemOptions.builder().material(this.material).damage(this.damage).amount(this.amount).customModelData(this.customModelData).customModelDataComponent(this.customModelDataComponent).dynamicAmount(this.dynamicAmount).lightLevel(this.lightLevel).displayName(this.displayName).lore(this.lore).hasLore(this.hasLore).loreAppendMode(this.loreAppendMode).baseColor(this.baseColor).headType(this.headType).rgb(this.rgb).trimMaterial(this.trimMaterial).trimPattern(this.trimPattern).hideTooltip(this.hideTooltip).enchantmentGlintOverride(this.enchantmentGlintOverride).rarity(this.rarity).tooltipStyle(this.tooltipStyle).itemModel(this.itemModel).enchantments(this.enchantments).potionEffects(this.potionEffects).bannerMeta(this.bannerMeta).itemFlags(this.itemFlags).unbreakable(this.unbreakable).nbtString(this.nbtString).nbtByte(this.nbtByte).nbtShort(this.nbtShort).nbtInt(this.nbtInt).nbtStrings(this.nbtStrings).nbtBytes(this.nbtBytes).nbtShorts(this.nbtShorts).nbtInts(this.nbtInts).slot(this.slot).priority(this.priority).updatePlaceholders(this.updatePlaceholders).clickHandler(this.clickHandler).leftClickHandler(this.leftClickHandler).rightClickHandler(this.rightClickHandler).shiftLeftClickHandler(this.shiftLeftClickHandler).shiftRightClickHandler(this.shiftRightClickHandler).middleClickHandler(this.middleClickHandler).viewRequirements(this.viewRequirements).clickRequirements(this.clickRequirements).leftClickRequirements(this.leftClickRequirements).rightClickRequirements(this.rightClickRequirements).shiftLeftClickRequirements(this.shiftLeftClickRequirements).shiftRightClickRequirements(this.shiftRightClickRequirements).middleClickRequirements(this.middleClickRequirements);
    }

    public static class MenuItemOptionsBuilder {
        private String material;
        private String damage;
        private int amount;
        private String customModelData;
        private CustomModelDataComponent customModelDataComponent;
        private String dynamicAmount;
        private String lightLevel;
        private String displayName;
        private List<String> lore = Collections.emptyList();
        private DyeColor baseColor;
        private HeadType headType;
        private String rgb;
        private String trimMaterial;
        private String trimPattern;
        private String hideTooltip;
        private String enchantmentGlintOverride;
        private String rarity;
        private String tooltipStyle;
        private String itemModel;
        private Map<Enchantment, Integer> enchantments = Collections.emptyMap();
        private List<PotionEffect> potionEffects = Collections.emptyList();
        private List<Pattern> bannerMeta = Collections.emptyList();
        private final Set<ItemFlag> itemFlags = new HashSet<ItemFlag>();
        private boolean unbreakable;
        private boolean displayNameHasPlaceholders;
        private boolean loreHasPlaceholders;
        private boolean hasLore;
        private LoreAppendMode loreAppendMode;
        private String nbtString;
        private String nbtByte;
        private String nbtShort;
        private String nbtInt;
        private List<String> nbtStrings = Collections.emptyList();
        private List<String> nbtBytes = Collections.emptyList();
        private List<String> nbtShorts = Collections.emptyList();
        private List<String> nbtInts = Collections.emptyList();
        private int slot;
        private int priority;
        private boolean updatePlaceholders;
        private ClickHandler clickHandler;
        private ClickHandler leftClickHandler;
        private ClickHandler rightClickHandler;
        private ClickHandler shiftLeftClickHandler;
        private ClickHandler shiftRightClickHandler;
        private ClickHandler middleClickHandler;
        private RequirementList viewRequirements;
        private RequirementList clickRequirements;
        private RequirementList leftClickRequirements;
        private RequirementList rightClickRequirements;
        private RequirementList shiftLeftClickRequirements;
        private RequirementList shiftRightClickRequirements;
        private RequirementList middleClickRequirements;

        private MenuItemOptionsBuilder() {
        }

        public MenuItemOptionsBuilder material(@NotNull String configMaterial) {
            this.material = configMaterial;
            return this;
        }

        public MenuItemOptionsBuilder damage(@Nullable String configDamage) {
            this.damage = configDamage;
            return this;
        }

        public MenuItemOptionsBuilder amount(int configAmount) {
            this.amount = configAmount;
            return this;
        }

        public MenuItemOptionsBuilder customModelData(@Nullable String customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public MenuItemOptionsBuilder customModelDataComponent(@Nullable CustomModelDataComponent customModelDataComponent) {
            this.customModelDataComponent = customModelDataComponent;
            return this;
        }

        public MenuItemOptionsBuilder dynamicAmount(@Nullable String configDynamicAmount) {
            this.dynamicAmount = configDynamicAmount;
            return this;
        }

        public MenuItemOptionsBuilder lightLevel(@Nullable String lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public MenuItemOptionsBuilder displayName(@Nullable String configDisplayName) {
            this.displayName = configDisplayName;
            if (this.displayName != null) {
                this.displayNameHasPlaceholders = DeluxeMenusConfig.containsPlaceholders(this.displayName);
            }
            return this;
        }

        public MenuItemOptionsBuilder lore(@NotNull List<String> configLore) {
            this.lore = configLore;
            this.loreHasPlaceholders = configLore.stream().anyMatch(DeluxeMenusConfig::containsPlaceholders);
            return this;
        }

        public MenuItemOptionsBuilder baseColor(@Nullable DyeColor configBaseColor) {
            this.baseColor = configBaseColor;
            return this;
        }

        public MenuItemOptionsBuilder headType(@Nullable HeadType headType) {
            this.headType = headType;
            return this;
        }

        public MenuItemOptionsBuilder rgb(@Nullable String rgb) {
            this.rgb = rgb;
            return this;
        }

        public MenuItemOptionsBuilder trimMaterial(@Nullable String trimMaterial) {
            this.trimMaterial = trimMaterial;
            return this;
        }

        public MenuItemOptionsBuilder trimPattern(@Nullable String trimPattern) {
            this.trimPattern = trimPattern;
            return this;
        }

        public MenuItemOptionsBuilder hideTooltip(@Nullable String hideTooltip) {
            this.hideTooltip = hideTooltip;
            return this;
        }

        public MenuItemOptionsBuilder enchantmentGlintOverride(@Nullable String enchantmentGlintOverride) {
            this.enchantmentGlintOverride = enchantmentGlintOverride;
            return this;
        }

        public MenuItemOptionsBuilder rarity(@Nullable String rarity) {
            this.rarity = rarity;
            return this;
        }

        public MenuItemOptionsBuilder tooltipStyle(@Nullable String tooltipStyle) {
            this.tooltipStyle = tooltipStyle;
            return this;
        }

        public MenuItemOptionsBuilder itemModel(@Nullable String itemModel) {
            this.itemModel = itemModel;
            return this;
        }

        public MenuItemOptionsBuilder enchantments(@NotNull Map<Enchantment, Integer> enchantments) {
            this.enchantments = enchantments;
            return this;
        }

        public MenuItemOptionsBuilder potionEffects(@NotNull List<PotionEffect> potionEffects) {
            this.potionEffects = potionEffects;
            return this;
        }

        public MenuItemOptionsBuilder bannerMeta(@NotNull List<Pattern> bannerMeta) {
            this.bannerMeta = bannerMeta;
            return this;
        }

        public MenuItemOptionsBuilder itemFlags(@NotNull Collection<ItemFlag> itemFlags) {
            this.itemFlags.addAll(itemFlags);
            return this;
        }

        public MenuItemOptionsBuilder unbreakable(boolean unbreakable) {
            this.unbreakable = unbreakable;
            return this;
        }

        @Deprecated
        public MenuItemOptionsBuilder hideAttributes(boolean hideAttributes) {
            if (hideAttributes) {
                this.itemFlags.add(ItemFlag.HIDE_ATTRIBUTES);
            }
            return this;
        }

        @Deprecated
        public MenuItemOptionsBuilder hideEnchants(boolean hideEnchants) {
            if (hideEnchants) {
                this.itemFlags.add(ItemFlag.HIDE_ENCHANTS);
            }
            return this;
        }

        @Deprecated
        public MenuItemOptionsBuilder hideUnbreakable(boolean hideUnbreakable) {
            if (hideUnbreakable) {
                this.itemFlags.add(ItemFlag.HIDE_UNBREAKABLE);
            }
            return this;
        }

        public MenuItemOptionsBuilder nbtString(@Nullable String nbtString) {
            this.nbtString = nbtString;
            return this;
        }

        public MenuItemOptionsBuilder nbtByte(@Nullable String nbtByte) {
            this.nbtByte = nbtByte;
            return this;
        }

        public MenuItemOptionsBuilder nbtShort(@Nullable String nbtShort) {
            this.nbtShort = nbtShort;
            return this;
        }

        public MenuItemOptionsBuilder nbtInt(@Nullable String nbtInt) {
            this.nbtInt = nbtInt;
            return this;
        }

        public MenuItemOptionsBuilder nbtStrings(@NotNull List<String> nbtStrings) {
            this.nbtStrings = nbtStrings;
            return this;
        }

        public MenuItemOptionsBuilder nbtBytes(@NotNull List<String> nbtBytes) {
            this.nbtBytes = nbtBytes;
            return this;
        }

        public MenuItemOptionsBuilder nbtShorts(@NotNull List<String> nbtShorts) {
            this.nbtShorts = nbtShorts;
            return this;
        }

        public MenuItemOptionsBuilder nbtInts(@NotNull List<String> nbtInts) {
            this.nbtInts = nbtInts;
            return this;
        }

        public MenuItemOptionsBuilder slot(int slot) {
            this.slot = slot;
            return this;
        }

        public MenuItemOptionsBuilder priority(int priority) {
            this.priority = priority;
            return this;
        }

        public MenuItemOptionsBuilder updatePlaceholders(boolean updatePlaceholders) {
            this.updatePlaceholders = updatePlaceholders;
            return this;
        }

        public MenuItemOptionsBuilder hasLore(boolean hasLore) {
            this.hasLore = hasLore;
            return this;
        }

        public MenuItemOptionsBuilder loreAppendMode(LoreAppendMode loreAppendMode) {
            this.loreAppendMode = loreAppendMode;
            return this;
        }

        public MenuItemOptionsBuilder clickHandler(@Nullable ClickHandler clickHandler) {
            this.clickHandler = clickHandler;
            return this;
        }

        public MenuItemOptionsBuilder leftClickHandler(@Nullable ClickHandler leftClickHandler) {
            this.leftClickHandler = leftClickHandler;
            return this;
        }

        public MenuItemOptionsBuilder rightClickHandler(@Nullable ClickHandler rightClickHandler) {
            this.rightClickHandler = rightClickHandler;
            return this;
        }

        public MenuItemOptionsBuilder shiftLeftClickHandler(@Nullable ClickHandler shiftLeftClickHandler) {
            this.shiftLeftClickHandler = shiftLeftClickHandler;
            return this;
        }

        public MenuItemOptionsBuilder shiftRightClickHandler(@Nullable ClickHandler shiftRightClickHandler) {
            this.shiftRightClickHandler = shiftRightClickHandler;
            return this;
        }

        public MenuItemOptionsBuilder middleClickHandler(@Nullable ClickHandler middleClickHandler) {
            this.middleClickHandler = middleClickHandler;
            return this;
        }

        public MenuItemOptionsBuilder viewRequirements(@Nullable RequirementList viewRequirements) {
            this.viewRequirements = viewRequirements;
            return this;
        }

        public MenuItemOptionsBuilder clickRequirements(@Nullable RequirementList clickRequirements) {
            this.clickRequirements = clickRequirements;
            return this;
        }

        public MenuItemOptionsBuilder leftClickRequirements(@Nullable RequirementList leftClickRequirements) {
            this.leftClickRequirements = leftClickRequirements;
            return this;
        }

        public MenuItemOptionsBuilder rightClickRequirements(@Nullable RequirementList rightClickRequirements) {
            this.rightClickRequirements = rightClickRequirements;
            return this;
        }

        public MenuItemOptionsBuilder shiftLeftClickRequirements(@Nullable RequirementList shiftLeftClickRequirements) {
            this.shiftLeftClickRequirements = shiftLeftClickRequirements;
            return this;
        }

        public MenuItemOptionsBuilder shiftRightClickRequirements(@Nullable RequirementList shiftRightClickRequirements) {
            this.shiftRightClickRequirements = shiftRightClickRequirements;
            return this;
        }

        public MenuItemOptionsBuilder middleClickRequirements(@Nullable RequirementList middleClickRequirements) {
            this.middleClickRequirements = middleClickRequirements;
            return this;
        }

        public MenuItemOptions build() {
            return new MenuItemOptions(this);
        }
    }
}

