/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.nbt;

import com.extendedclip.deluxemenus.utils.VersionHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public final class NbtProvider {
    private static boolean NBT_HOOKED;
    private static Method getStringMethod;
    private static Method setStringMethod;
    private static Method setBooleanMethod;
    private static Method setByteMethod;
    private static Method setShortMethod;
    private static Method setIntMethod;
    private static Method removeTagMethod;
    private static Method hasTagMethod;
    private static Method getTagMethod;
    private static Method setTagMethod;
    private static Method containsMethod;
    private static Method asNMSCopyMethod;
    private static Method asBukkitCopyMethod;
    private static Constructor<?> nbtCompoundConstructor;

    public static boolean isAvailable() {
        return NBT_HOOKED;
    }

    public static ItemStack setString(ItemStack itemStack, String key, String value) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.setString(itemCompound, key, value);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    public static ItemStack setBoolean(ItemStack itemStack, String key, boolean value) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return itemStack;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.setBoolean(itemCompound, key, value);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    public static String getString(ItemStack itemStack, String key) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        return NbtProvider.getString(itemCompound, key);
    }

    public static ItemStack setByte(ItemStack itemStack, String key, byte value) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.setByte(itemCompound, key, value);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    public static ItemStack setShort(ItemStack itemStack, String key, short value) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.setShort(itemCompound, key, value);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    public static ItemStack setInt(ItemStack itemStack, String key, int value) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.setInt(itemCompound, key, value);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    public static boolean hasKey(ItemStack itemStack, String key) {
        if (itemStack == null) {
            return false;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        try {
            return (Boolean)containsMethod.invoke(itemCompound, key);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public static ItemStack removeKey(ItemStack itemStack, String key) {
        if (itemStack == null) {
            return null;
        }
        if (itemStack.getType() == Material.AIR) {
            return null;
        }
        Object nmsItemStack = NbtProvider.asNMSCopy(itemStack);
        if (!NbtProvider.hasTag(nmsItemStack)) {
            return itemStack;
        }
        Object itemCompound = NbtProvider.hasTag(nmsItemStack) ? NbtProvider.getTag(nmsItemStack) : NbtProvider.newNBTTagCompound();
        NbtProvider.removeTag(itemCompound, key);
        NbtProvider.setTag(nmsItemStack, itemCompound);
        return NbtProvider.asBukkitCopy(nmsItemStack);
    }

    private static void setString(Object itemCompound, String key, String value) {
        try {
            setStringMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void setBoolean(Object itemCompound, String key, boolean value) {
        try {
            setBooleanMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void setByte(Object itemCompound, String key, byte value) {
        try {
            setByteMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void setShort(Object itemCompound, String key, short value) {
        try {
            setShortMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void setInt(Object itemCompound, String key, int value) {
        try {
            setIntMethod.invoke(itemCompound, key, value);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static String getString(Object itemCompound, String key) {
        try {
            return (String)getStringMethod.invoke(itemCompound, key);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static boolean hasTag(Object nmsItemStack) {
        try {
            return (Boolean)hasTagMethod.invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public static Object getTag(Object nmsItemStack) {
        try {
            return getTagMethod.invoke(nmsItemStack, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static void setTag(Object nmsItemStack, Object itemCompound) {
        try {
            setTagMethod.invoke(nmsItemStack, itemCompound);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static void removeTag(Object nmsItemStack, Object itemCompound) {
        try {
            removeTagMethod.invoke(nmsItemStack, itemCompound);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static Object newNBTTagCompound() {
        try {
            return nbtCompoundConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack itemStack) {
        try {
            return asNMSCopyMethod.invoke(null, itemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    public static ItemStack asBukkitCopy(Object nmsItemStack) {
        try {
            return (ItemStack)asBukkitCopyMethod.invoke(null, nmsItemStack);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    static {
        try {
            Class<?> compoundClass = VersionHelper.getNMSClass("nbt", "NBTTagCompound");
            Class<?> itemStackClass = VersionHelper.getNMSClass("world.item", "ItemStack");
            Class<?> inventoryClass = VersionHelper.getCraftClass("inventory.CraftItemStack");
            containsMethod = compoundClass.getMethod(VersionConstants.CONTAINS_METHOD_NAME, String.class);
            getStringMethod = compoundClass.getMethod(VersionConstants.GET_STRING_METHOD_NAME, String.class);
            setStringMethod = compoundClass.getMethod(VersionConstants.SET_STRING_METHOD_NAME, String.class, String.class);
            setBooleanMethod = compoundClass.getMethod(VersionConstants.SET_BOOLEAN_METHOD_NAME, String.class, Boolean.TYPE);
            setByteMethod = compoundClass.getMethod(VersionConstants.SET_BYTE_METHOD_NAME, String.class, Byte.TYPE);
            setShortMethod = compoundClass.getMethod(VersionConstants.SET_SHORT_METHOD_NAME, String.class, Short.TYPE);
            setIntMethod = compoundClass.getMethod(VersionConstants.SET_INTEGER_METHOD_NAME, String.class, Integer.TYPE);
            removeTagMethod = compoundClass.getMethod(VersionConstants.REMOVE_TAG_METHOD_NAME, String.class);
            hasTagMethod = itemStackClass.getMethod(VersionConstants.HAS_TAG_METHOD_NAME, new Class[0]);
            getTagMethod = itemStackClass.getMethod(VersionConstants.GET_TAG_METHOD_NAME, new Class[0]);
            setTagMethod = itemStackClass.getMethod(VersionConstants.SET_TAG_METHOD_NAME, compoundClass);
            nbtCompoundConstructor = compoundClass.getDeclaredConstructor(new Class[0]);
            asNMSCopyMethod = inventoryClass.getMethod("asNMSCopy", ItemStack.class);
            asBukkitCopyMethod = inventoryClass.getMethod("asBukkitCopy", itemStackClass);
            NBT_HOOKED = true;
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            NBT_HOOKED = false;
        }
    }

    private static class VersionConstants {
        private static final String CONTAINS_METHOD_NAME = VersionConstants.containsMethodName();
        private static final String GET_STRING_METHOD_NAME = VersionConstants.getStringMethodName();
        private static final String SET_STRING_METHOD_NAME = VersionConstants.setStringMethodName();
        private static final String SET_BOOLEAN_METHOD_NAME = VersionConstants.setBooleanMethodName();
        private static final String SET_BYTE_METHOD_NAME = VersionConstants.setByteMethodName();
        private static final String SET_SHORT_METHOD_NAME = VersionConstants.setShortMethodName();
        private static final String SET_INTEGER_METHOD_NAME = VersionConstants.setIntegerMethodName();
        private static final String REMOVE_TAG_METHOD_NAME = VersionConstants.removeTagMethodName();
        private static final String HAS_TAG_METHOD_NAME = VersionConstants.hasTagMethodName();
        private static final String GET_TAG_METHOD_NAME = VersionConstants.getTagMethodName();
        private static final String SET_TAG_METHOD_NAME = VersionConstants.setTagMethodName();

        private VersionConstants() {
        }

        private static String getStringMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "l";
            }
            return "getString";
        }

        private static String setStringMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "a";
            }
            return "setString";
        }

        private static String setBooleanMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "a";
            }
            return "setBoolean";
        }

        private static String setByteMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "a";
            }
            return "setByte";
        }

        private static String setShortMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "a";
            }
            return "setShort";
        }

        private static String setIntegerMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "a";
            }
            return "setInt";
        }

        private static String hasTagMethodName() {
            if (VersionHelper.CURRENT_VERSION >= 1200) {
                return "u";
            }
            if (VersionHelper.CURRENT_VERSION >= 1190) {
                return "t";
            }
            if (VersionHelper.CURRENT_VERSION == 1182) {
                return "s";
            }
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "r";
            }
            return "hasTag";
        }

        private static String getTagMethodName() {
            if (VersionHelper.CURRENT_VERSION >= 1200) {
                return "v";
            }
            if (VersionHelper.CURRENT_VERSION >= 1190) {
                return "u";
            }
            if (VersionHelper.CURRENT_VERSION == 1182) {
                return "t";
            }
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "s";
            }
            return "getTag";
        }

        private static String containsMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "e";
            }
            return "hasKey";
        }

        private static String setTagMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "c";
            }
            return "setTag";
        }

        private static String removeTagMethodName() {
            if (VersionHelper.HAS_OBFUSCATED_NAMES) {
                return "r";
            }
            return "remove";
        }
    }
}

