/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.persistentmeta;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataType<P, C> {
    public static final DataType<Double, Double> DOUBLE = new DataType("DOUBLE", PersistentDataType.DOUBLE, value -> true);
    public static final DataType<Long, Long> INTEGER = new DataType("INTEGER", PersistentDataType.LONG, value -> true);
    public static final DataType<Long, Long> LONG = new DataType("LONG", PersistentDataType.LONG, value -> true);
    public static final DataType<String, String> STRING = new DataType("STRING", PersistentDataType.STRING, value -> true);
    public static final DataType<String, String> BOOLEAN = new DataType("BOOLEAN", PersistentDataType.STRING, value -> "true".equalsIgnoreCase((String)value) || "false".equalsIgnoreCase((String)value));
    private static final List<DataType<?, ?>> SUPPORTED_TYPES = List.of(DOUBLE, INTEGER, LONG, STRING, BOOLEAN);
    private final String name;
    private final PersistentDataType<P, C> pdType;
    private final Function<Object, Boolean> checker;

    private DataType(@NotNull String name, @NotNull PersistentDataType<P, C> pdType, @NotNull @NotNull Function<@NotNull Object, @NotNull Boolean> checker) {
        this.name = name;
        this.pdType = pdType;
        this.checker = checker;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PersistentDataType<P, C> getPDType() {
        return this.pdType;
    }

    @NotNull
    public Class<C> getComplexType() {
        return this.pdType.getComplexType();
    }

    @NotNull
    public Class<P> getPrimitiveType() {
        return this.pdType.getPrimitiveType();
    }

    public boolean isSupported(@Nullable Object value) {
        return this.getComplexType().isInstance(value) && this.checker.apply(value) != false;
    }

    @Nullable
    public static DataType<?, ?> getSupportedTypeByName(@NotNull String name) {
        return SUPPORTED_TYPES.stream().filter(type -> type.name.equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @NotNull
    public static Set<String> getSupportedTypeNames() {
        return SUPPORTED_TYPES.stream().map(DataType::getName).collect(Collectors.toSet());
    }

    @NotNull
    public static List<DataType<?, ?>> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }
}

